/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.util.ArrayList;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.MonitorProvider;
import org.opends.server.core.DirectoryServer;
import org.opends.server.replication.plugin.ReplicationDomain;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationMonitor
extends MonitorProvider<MonitorProviderCfg> {
    private ReplicationDomain domain;

    public ReplicationMonitor(ReplicationDomain domain) {
        super("Replication monitor " + domain.getBaseDN().toString());
        this.domain = domain;
    }

    @Override
    public void initializeMonitorProvider(MonitorProviderCfg configuration) {
    }

    @Override
    public String getMonitorInstanceName() {
        return "Replication plugin " + this.domain.getBaseDN().toString();
    }

    public ArrayList<Attribute> getMonitorData() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Attribute attr = Attributes.create("base-dn", this.domain.getBaseDN().toString());
        attributes.add(attr);
        attr = Attributes.create("connected-to", this.domain.getReplicationServer());
        attributes.add(attr);
        this.addMonitorData(attributes, "lost-connections", this.domain.getNumLostConnections());
        this.addMonitorData(attributes, "received-updates", this.domain.getNumRcvdUpdates());
        this.addMonitorData(attributes, "sent-updates", this.domain.getNumSentUpdates());
        this.addMonitorData(attributes, "pending-updates", this.domain.getPendingUpdatesCount());
        this.addMonitorData(attributes, "replayed-updates", this.domain.getNumProcessedUpdates());
        this.addMonitorData(attributes, "replayed-updates-ok", this.domain.getNumReplayedPostOpCalled());
        this.addMonitorData(attributes, "resolved-modify-conflicts", this.domain.getNumResolvedModifyConflicts());
        this.addMonitorData(attributes, "resolved-naming-conflicts", this.domain.getNumResolvedNamingConflicts());
        this.addMonitorData(attributes, "unresolved-naming-conflicts", this.domain.getNumUnresolvedNamingConflicts());
        this.addMonitorData(attributes, "server-id", this.domain.getServerId());
        this.addMonitorData(attributes, "max-rcv-window", this.domain.getMaxRcvWindow());
        this.addMonitorData(attributes, "current-rcv-window", this.domain.getCurrentRcvWindow());
        this.addMonitorData(attributes, "max-send-window", this.domain.getMaxSendWindow());
        this.addMonitorData(attributes, "current-send-window", this.domain.getCurrentSendWindow());
        String ATTR_SERVER_STATE = "server-state";
        AttributeType type = DirectoryServer.getDefaultAttributeType("server-state");
        AttributeBuilder builder = new AttributeBuilder(type, "server-state");
        for (String str : this.domain.getServerState().toStringSet()) {
            builder.add(new AttributeValue(type, str));
        }
        attributes.add(builder.toAttribute());
        attributes.add(Attributes.create("ssl-encryption", String.valueOf(this.domain.isSessionEncrypted())));
        attributes.add(Attributes.create("generation-id", String.valueOf(this.domain.getGenerationId())));
        return attributes;
    }

    private void addMonitorData(ArrayList<Attribute> attributes, String name, int value) {
        AttributeType type = DirectoryServer.getDefaultAttributeType(name);
        attributes.add(Attributes.create(type, new AttributeValue(type, String.valueOf(value))));
    }

    @Override
    public long getUpdateInterval() {
        return 0L;
    }

    @Override
    public void updateMonitorData() {
    }
}

