/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.ModifyOperationBasis;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.ModifyCommonMsg;
import org.opends.server.replication.protocol.ModifyContext;
import org.opends.server.replication.protocol.OperationContext;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.DN;
import org.opends.server.types.LDAPException;
import org.opends.server.types.Modification;
import org.opends.server.types.RawModification;
import org.opends.server.types.operation.PostOperationModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyMsg
extends ModifyCommonMsg {
    public ModifyMsg(PostOperationModifyOperation op) {
        super((OperationContext)op.getAttachment("replicationContext"), op.getRawEntryDN().stringValue());
        this.encodedMods = this.modsToByte(op.getModifications());
    }

    public ModifyMsg(ChangeNumber changeNumber, DN dn, List<Modification> mods, String entryuuid) {
        super(new ModifyContext(changeNumber, entryuuid), dn.toNormalizedString());
        this.encodedMods = this.modsToByte(mods);
    }

    public ModifyMsg(byte[] in) throws DataFormatException, UnsupportedEncodingException {
        byte[] allowedPduTypes = new byte[]{22, 1};
        int pos = this.decodeHeader(allowedPduTypes, in);
        int length = in.length - pos - 1;
        this.encodedMods = new byte[length];
        try {
            System.arraycopy(in, pos, this.encodedMods, 0, length);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DataFormatException(e.getMessage());
        }
        catch (ArrayStoreException e) {
            throw new DataFormatException(e.getMessage());
        }
        catch (NullPointerException e) {
            throw new DataFormatException(e.getMessage());
        }
    }

    @Override
    public byte[] getBytes() throws UnsupportedEncodingException {
        byte[] encodedMsg = this.encodeHeader((byte)22, this.encodedMods.length + 1);
        int pos = encodedMsg.length - (this.encodedMods.length + 1);
        this.addByteArray(this.encodedMods, encodedMsg, pos);
        return encodedMsg;
    }

    @Override
    public AbstractOperation createOperation(InternalClientConnection connection, String newDn) throws LDAPException, ASN1Exception, DataFormatException {
        if (newDn == null) {
            newDn = this.getDn();
        }
        ArrayList<ASN1Element> mods = null;
        mods = ASN1Element.decodeElements(this.encodedMods);
        ArrayList<RawModification> ldapmods = new ArrayList<RawModification>(mods.size());
        for (ASN1Element elem : mods) {
            ldapmods.add(LDAPModification.decode(elem));
        }
        ModifyOperationBasis mod = new ModifyOperationBasis((ClientConnection)connection, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), null, new ASN1OctetString(newDn), ldapmods);
        ModifyContext ctx = new ModifyContext(this.getChangeNumber(), this.getUniqueId());
        mod.setAttachment("replicationContext", ctx);
        return mod;
    }

    public String toString() {
        if (this.protocolVersion == 1) {
            return "ModifyMsg content: \nprotocolVersion: " + this.protocolVersion + "\ndn: " + this.dn + "\nchangeNumber: " + this.changeNumber + "\nuniqueId: " + this.uniqueId + "\nassuredFlag: " + this.assuredFlag;
        }
        if (this.protocolVersion == 2) {
            return "ModifyMsg content: \nprotocolVersion: " + this.protocolVersion + "\ndn: " + this.dn + "\nchangeNumber: " + this.changeNumber + "\nuniqueId: " + this.uniqueId + "\nassuredFlag: " + this.assuredFlag + "\nassuredMode: " + (Object)((Object)this.assuredMode) + "\nsafeDataLevel: " + this.safeDataLevel;
        }
        return "!!! Unknown version: " + this.protocolVersion + "!!!";
    }

    @Override
    public int size() {
        return this.encodedMods.length + 100;
    }

    @Override
    public byte[] getBytes_V1() throws UnsupportedEncodingException {
        byte[] encodedMsg = this.encodeHeader_V1((byte)1, this.encodedMods.length + 1);
        int pos = encodedMsg.length - (this.encodedMods.length + 1);
        this.addByteArray(this.encodedMods, encodedMsg, pos);
        return encodedMsg;
    }
}

