/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DeadlockException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ReplicationMessages;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.server.ReplicationDB;
import org.opends.server.replication.server.ReplicationDbEnv;
import org.opends.server.replication.server.ReplicationIterator;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.types.Attribute;
import org.opends.server.types.Attributes;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbHandler
implements Runnable {
    private final LinkedList<UpdateMsg> msgQueue = new LinkedList();
    int queueHimark = 5000;
    int queueLowmark = 4000;
    int queueHimarkBytes = 100 * this.queueHimark;
    int queueLowmarkBytes = 100 * this.queueLowmark;
    int queueByteSize = 0;
    private ReplicationDB db;
    private ChangeNumber firstChange = null;
    private ChangeNumber lastChange = null;
    private short serverId;
    private DN baseDn;
    private DbMonitorProvider dbMonitor = new DbMonitorProvider();
    private boolean shutdown = false;
    private boolean done = false;
    private DirectoryThread thread = null;
    private final Object flushLock = new Object();
    private ReplicationServer replicationServer;
    private static final int DEADLOCK_RETRIES = 10;
    private long trimage;

    public DbHandler(short id, DN baseDn, ReplicationServer replicationServer, ReplicationDbEnv dbenv, int queueSize) throws DatabaseException {
        this.replicationServer = replicationServer;
        this.serverId = id;
        this.baseDn = baseDn;
        this.trimage = replicationServer.getTrimage();
        this.queueHimark = queueSize;
        this.queueLowmark = queueSize * 4 / 5;
        this.queueHimarkBytes = 100 * this.queueHimark;
        this.queueLowmarkBytes = 100 * this.queueLowmark;
        this.db = new ReplicationDB(id, baseDn, replicationServer, dbenv);
        this.firstChange = this.db.readFirstChange();
        this.lastChange = this.db.readLastChange();
        this.thread = new DirectoryThread(this, "Replication Server db for DS " + id + " and " + baseDn + " in RS " + replicationServer.getServerId());
        this.thread.start();
        DirectoryServer.deregisterMonitorProvider(this.dbMonitor.getMonitorInstanceName());
        DirectoryServer.registerMonitorProvider(this.dbMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(UpdateMsg update) {
        LinkedList<UpdateMsg> linkedList = this.msgQueue;
        synchronized (linkedList) {
            int size = this.msgQueue.size();
            while (size > this.queueHimark || this.queueByteSize > this.queueHimarkBytes) {
                try {
                    this.msgQueue.wait(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                size = this.msgQueue.size();
            }
            this.queueByteSize += update.size();
            this.msgQueue.add(update);
            if (this.lastChange == null || this.lastChange.older(update.getChangeNumber()).booleanValue()) {
                this.lastChange = update.getChangeNumber();
            }
            if (this.firstChange == null) {
                this.firstChange = update.getChangeNumber();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<UpdateMsg> getChanges(int number) {
        LinkedList<UpdateMsg> changes = new LinkedList<UpdateMsg>();
        LinkedList<UpdateMsg> linkedList = this.msgQueue;
        synchronized (linkedList) {
            int size = this.msgQueue.size();
            for (int current = 0; current < number && current < size; ++current) {
                UpdateMsg msg = this.msgQueue.get(current);
                changes.add(msg);
            }
        }
        return changes;
    }

    public ChangeNumber getFirstChange() {
        return this.firstChange;
    }

    public ChangeNumber getLastChange() {
        return this.lastChange;
    }

    public long getChangesCount() {
        try {
            return this.lastChange.getSeqnum() - this.firstChange.getSeqnum() + 1;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationIterator generateIterator(ChangeNumber changeNumber) throws DatabaseException, Exception {
        ChangeNumber recentChangeNumber = null;
        if (changeNumber == null) {
            this.flush();
        }
        LinkedList<UpdateMsg> linkedList = this.msgQueue;
        synchronized (linkedList) {
            try {
                UpdateMsg msg = this.msgQueue.getFirst();
                recentChangeNumber = msg.getChangeNumber();
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
        }
        if (recentChangeNumber != null && changeNumber != null && (recentChangeNumber.getTimeSec() - changeNumber.getTimeSec() < 2L || recentChangeNumber.getSeqnum() - changeNumber.getSeqnum() < 20)) {
            this.flush();
        }
        ReplicationIterator it = new ReplicationIterator(this.serverId, this.db, changeNumber);
        return it;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearQueue(int number) {
        LinkedList<UpdateMsg> linkedList = this.msgQueue;
        synchronized (linkedList) {
            for (int current = 0; current < number && !this.msgQueue.isEmpty(); ++current) {
                UpdateMsg msg = this.msgQueue.remove();
                this.queueByteSize -= msg.size();
            }
            if (this.msgQueue.size() < this.queueLowmark && this.queueByteSize < this.queueLowmarkBytes) {
                this.msgQueue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        DbHandler dbHandler = this;
        synchronized (dbHandler) {
            this.notifyAll();
        }
        dbHandler = this;
        synchronized (dbHandler) {
            while (!this.done) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
        }
        while (this.msgQueue.size() != 0) {
            this.flush();
        }
        this.db.shutdown();
        DirectoryServer.deregisterMonitorProvider(this.dbMonitor.getMonitorInstanceName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DbHandler dbHandler;
        while (!this.shutdown) {
            try {
                this.flush();
                this.trim();
                dbHandler = this;
                synchronized (dbHandler) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            catch (Exception end) {
                MessageBuilder mb = new MessageBuilder();
                mb.append(ReplicationMessages.ERR_EXCEPTION_CHANGELOG_TRIM_FLUSH.get());
                mb.append(StaticUtils.stackTraceToSingleLineString(end));
                ErrorLogger.logError(mb.toMessage());
                if (this.replicationServer == null) break;
                this.replicationServer.shutdown();
                break;
            }
        }
        this.flush();
        dbHandler = this;
        synchronized (dbHandler) {
            this.done = true;
            this.notifyAll();
        }
    }

    private void trim() throws DatabaseException, Exception {
        if (this.trimage == 0L) {
            return;
        }
        int size = 0;
        boolean finished = false;
        boolean done = false;
        ChangeNumber trimDate = new ChangeNumber(TimeThread.getTime() - this.trimage, 0, 0);
        int tries = 0;
        while (tries++ < 10 && !done) {
            ReplicationDB.ReplServerDBCursor cursor = this.db.openDeleteCursor();
            try {
                while (size < 5000 && !finished) {
                    ChangeNumber changeNumber = cursor.nextChangeNumber();
                    if (changeNumber != null) {
                        if (!changeNumber.equals(this.lastChange) && changeNumber.older(trimDate).booleanValue()) {
                            ++size;
                            cursor.delete();
                            continue;
                        }
                        this.firstChange = changeNumber;
                        finished = true;
                        continue;
                    }
                    finished = true;
                }
                cursor.close();
                done = true;
            }
            catch (DeadlockException e) {
                cursor.abort();
                if (tries != 10) continue;
                this.shutdown = true;
                throw e;
            }
            catch (DatabaseException e) {
                this.shutdown = true;
                cursor.abort();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() {
        int size;
        int chunksize = 500 < this.queueHimark ? 500 : this.queueHimark;
        do {
            Object object = this.flushLock;
            synchronized (object) {
                List<UpdateMsg> changes = this.getChanges(chunksize);
                if (changes == null || (size = changes.size()) == 0) {
                    return;
                }
                this.db.addEntries(changes);
                this.clearQueue(changes.size());
            }
        } while (size >= chunksize);
    }

    public String toString() {
        return this.baseDn + " " + this.serverId + " " + this.firstChange + " " + this.lastChange;
    }

    public void setPurgeDelay(long delay) {
        this.trimage = delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws DatabaseException, Exception {
        Object object = this.flushLock;
        synchronized (object) {
            this.msgQueue.clear();
            this.queueByteSize = 0;
        }
        this.db.clear();
        this.firstChange = this.db.readFirstChange();
        this.lastChange = this.db.readLastChange();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DbMonitorProvider
    extends MonitorProvider<MonitorProviderCfg> {
        private DbMonitorProvider() {
            super("ReplicationServer Database");
        }

        public ArrayList<Attribute> getMonitorData() {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            attributes.add(Attributes.create("replicationServer-database", String.valueOf(DbHandler.this.serverId)));
            attributes.add(Attributes.create("base-dn", DbHandler.this.baseDn.toString()));
            if (DbHandler.this.firstChange != null) {
                Date firstTime = new Date(DbHandler.this.firstChange.getTime());
                attributes.add(Attributes.create("first-change", DbHandler.this.firstChange.toString() + " " + firstTime.toString()));
            }
            if (DbHandler.this.lastChange != null) {
                Date lastTime = new Date(DbHandler.this.lastChange.getTime());
                attributes.add(Attributes.create("last-change", DbHandler.this.lastChange.toString() + " " + lastTime.toString()));
            }
            attributes.add(Attributes.create("queue-size", String.valueOf(DbHandler.this.msgQueue.size())));
            attributes.add(Attributes.create("queue-size-bytes", String.valueOf(DbHandler.this.queueByteSize)));
            return attributes;
        }

        @Override
        public String getMonitorInstanceName() {
            return "ReplicationServer database " + DbHandler.this.baseDn.toString() + " " + String.valueOf(DbHandler.this.serverId);
        }

        @Override
        public long getUpdateInterval() {
            return 0L;
        }

        @Override
        public void initializeMonitorProvider(MonitorProviderCfg configuration) throws ConfigException, InitializationException {
        }

        @Override
        public void updateMonitorData() {
        }
    }
}

