/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.servicetag;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.servicetag.SwordFishIDParser;
import org.opends.server.types.DebugLogLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwordFishIdConfiguration {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static SwordFishIdConfiguration service = null;
    private Set<SwordFishIDParser> parsers = new HashSet<SwordFishIDParser>();
    private String FILE_PATTERN = "opends.uuids";
    private File[] listProperties;

    private SwordFishIdConfiguration() {
        String confDir = DirectoryServer.getInstanceRoot() + File.separatorChar + "config" + File.separatorChar + "servicetag";
        File config = new File(confDir);
        if (!config.exists() || !config.isDirectory()) {
            return;
        }
        if (config.isDirectory()) {
            this.listProperties = config.listFiles();
            for (int i = 0; i < this.listProperties.length; ++i) {
                try {
                    if (!this.listProperties[i].getAbsolutePath().contains(this.FILE_PATTERN)) continue;
                    this.parsers.add(new SwordFishIDParser(this.listProperties[i].toURI().toURL()));
                    continue;
                }
                catch (Throwable t) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.WARNING, t);
                }
            }
        }
    }

    public static SwordFishIdConfiguration getService() {
        if (service == null) {
            service = new SwordFishIdConfiguration();
        }
        return service;
    }

    public Set<SwordFishIDParser> getParsers() {
        return this.parsers;
    }

    public File[] getPropertiesFiles() {
        return this.listProperties;
    }
}

