/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import org.opends.messages.Message;
import org.opends.server.types.DN;
import org.opends.server.types.OpenDsException;

public class LDAPConnectionException
extends OpenDsException {
    private static final long serialVersionUID = 3135563348838654570L;
    private final int resultCode;
    private final DN matchedDN;
    private final Message errorMessage;

    public LDAPConnectionException(Message message) {
        super(message);
        this.resultCode = -1;
        this.matchedDN = null;
        this.errorMessage = null;
    }

    public LDAPConnectionException(Message message, int resultCode, Message errorMessage) {
        super(message);
        this.resultCode = resultCode;
        this.errorMessage = errorMessage;
        this.matchedDN = null;
    }

    public LDAPConnectionException(Message message, Throwable cause) {
        super(message, cause);
        this.resultCode = -1;
        this.matchedDN = null;
        this.errorMessage = null;
    }

    public LDAPConnectionException(Message message, int resultCode, Message errorMessage, Throwable cause) {
        super(message, cause);
        this.resultCode = resultCode;
        this.errorMessage = errorMessage;
        this.matchedDN = null;
    }

    public LDAPConnectionException(Message message, int resultCode, Message errorMessage, DN matchedDN, Throwable cause) {
        super(message, cause);
        this.resultCode = resultCode;
        this.errorMessage = errorMessage;
        this.matchedDN = matchedDN;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public Message getErrorMessage() {
        return this.errorMessage;
    }

    public DN getMatchedDN() {
        return this.matchedDN;
    }
}

