/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.AddRequestProtocolOp;
import org.opends.server.protocols.ldap.DeleteRequestProtocolOp;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.protocols.ldap.ModifyDNRequestProtocolOp;
import org.opends.server.protocols.ldap.ModifyRequestProtocolOp;
import org.opends.server.protocols.ldap.SearchResultEntryProtocolOp;
import org.opends.server.tools.LDAPConnection;
import org.opends.server.tools.LDAPConnectionException;
import org.opends.server.tools.LDAPConnectionOptions;
import org.opends.server.tools.LDAPModifyOptions;
import org.opends.server.tools.LDAPToolUtils;
import org.opends.server.tools.SSLConnectionFactory;
import org.opends.server.types.Attribute;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.NullOutputStream;
import org.opends.server.types.RawAttribute;
import org.opends.server.types.RawModification;
import org.opends.server.util.AddChangeRecordEntry;
import org.opends.server.util.ChangeOperationType;
import org.opends.server.util.EmbeddedUtils;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.ModifyChangeRecordEntry;
import org.opends.server.util.ModifyDNChangeRecordEntry;
import org.opends.server.util.PasswordReader;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

public class LDAPModify {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CLASS_NAME = "org.opends.server.tools.LDAPModify";
    private AtomicInteger nextMessageID;
    private PrintStream err;
    private PrintStream out;
    private String fileName = null;

    public LDAPModify(String fileName, AtomicInteger nextMessageID, PrintStream out, PrintStream err) {
        this.fileName = fileName == null ? "Console" : fileName;
        this.nextMessageID = nextMessageID;
        this.out = out;
        this.err = err;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void readAndExecute(LDAPConnection connection, String fileNameValue, LDAPModifyOptions modifyOptions) throws IOException, LDAPException {
        controls = modifyOptions.getControls();
        try {
            is = System.in;
            if (fileNameValue != null) {
                is = new FileInputStream(fileNameValue);
            }
            importConfig = new LDIFImportConfig(is);
            reader = new LDIFReader(importConfig);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                LDAPModify.TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            message = ToolMessages.ERR_LDIF_FILE_CANNOT_OPEN_FOR_READ.get(fileNameValue, e.getLocalizedMessage());
            throw new IOException(message.toString());
        }
        block31: while (true) {
            entry = null;
            try {
                entry = reader.readChangeRecord(modifyOptions.getDefaultAdd());
            }
            catch (LDIFException le) {
                if (DebugLogger.debugEnabled()) {
                    LDAPModify.TRACER.debugCaught(DebugLogLevel.ERROR, le);
                }
                if (!modifyOptions.continueOnError()) {
                    block52: {
                        try {
                            reader.close();
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) break block52;
                            LDAPModify.TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                    message = ToolMessages.ERR_LDIF_FILE_INVALID_LDIF_ENTRY.get(le.getLineNumber(), this.fileName, String.valueOf(le));
                    throw new IOException(message.toString());
                }
                message = ToolMessages.ERR_LDIF_FILE_INVALID_LDIF_ENTRY.get(le.getLineNumber(), this.fileName, String.valueOf(le));
                this.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                continue;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    LDAPModify.TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                if (!modifyOptions.continueOnError()) {
                    block53: {
                        try {
                            reader.close();
                        }
                        catch (Exception e2) {
                            if (!DebugLogger.debugEnabled()) break block53;
                            LDAPModify.TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                        }
                    }
                    message = ToolMessages.ERR_LDIF_FILE_READ_ERROR.get(this.fileName, String.valueOf(e));
                    throw new IOException(message.toString());
                }
                message = ToolMessages.ERR_LDIF_FILE_READ_ERROR.get(this.fileName, String.valueOf(e));
                this.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                continue;
            }
            if (entry == null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break;
                    LDAPModify.TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                break;
            }
            protocolOp /* !! */  = null;
            asn1OctetStr = new ASN1OctetString(entry.getDN().toString());
            operationType = "";
            msgID = false;
            switch (1.$SwitchMap$org$opends$server$util$ChangeOperationType[entry.getChangeOperationType().ordinal()]) {
                case 1: {
                    operationType = "ADD";
                    addEntry = (AddChangeRecordEntry)entry;
                    attrs = addEntry.getAttributes();
                    attributes = new ArrayList<RawAttribute>(attrs.size());
                    for (Attribute a : attrs) {
                        attributes.add(new LDAPAttribute(a));
                    }
                    protocolOp /* !! */  = new AddRequestProtocolOp(asn1OctetStr, attributes);
                    this.out.println(ToolMessages.INFO_PROCESSING_OPERATION.get(operationType, String.valueOf(asn1OctetStr)));
                    break;
                }
                case 2: {
                    operationType = "DELETE";
                    protocolOp /* !! */  = new DeleteRequestProtocolOp(asn1OctetStr);
                    this.out.println(ToolMessages.INFO_PROCESSING_OPERATION.get(operationType, String.valueOf(asn1OctetStr)));
                    break;
                }
                case 3: {
                    operationType = "MODIFY";
                    modEntry = (ModifyChangeRecordEntry)entry;
                    mods = new ArrayList<RawModification>(modEntry.getModifications());
                    protocolOp /* !! */  = new ModifyRequestProtocolOp(asn1OctetStr, mods);
                    this.out.println(ToolMessages.INFO_PROCESSING_OPERATION.get(operationType, String.valueOf(asn1OctetStr)));
                    break;
                }
                case 4: {
                    operationType = "MODIFY DN";
                    modDNEntry = (ModifyDNChangeRecordEntry)entry;
                    protocolOp /* !! */  = modDNEntry.getNewSuperiorDN() != null ? new ModifyDNRequestProtocolOp(asn1OctetStr, new ASN1OctetString(modDNEntry.getNewRDN().toString()), modDNEntry.deleteOldRDN(), new ASN1OctetString(modDNEntry.getNewSuperiorDN().toString())) : new ModifyDNRequestProtocolOp(asn1OctetStr, new ASN1OctetString(modDNEntry.getNewRDN().toString()), modDNEntry.deleteOldRDN());
                    this.out.println(ToolMessages.INFO_PROCESSING_OPERATION.get(operationType, String.valueOf(asn1OctetStr)));
                    break;
                }
            }
            if (modifyOptions.showOperations()) continue;
            responseMessage = null;
            try {
                message = new LDAPMessage(this.nextMessageID.getAndIncrement(), protocolOp /* !! */ , controls);
                connection.getLDAPWriter().writeMessage(message);
                responseMessage = connection.getLDAPReader().readMessage();
            }
            catch (ASN1Exception ae) {
                if (DebugLogger.debugEnabled()) {
                    LDAPModify.TRACER.debugCaught(DebugLogLevel.ERROR, ae);
                }
                message = ToolMessages.INFO_OPERATION_FAILED.get(operationType);
                this.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                this.err.println(StaticUtils.wrapText(ae.getMessage(), ServerConstants.MAX_LINE_WIDTH));
                if (!modifyOptions.continueOnError()) {
                    throw new IOException(ae.getMessage());
                }
                return;
            }
            resultCode = 0;
            errorMessage = null;
            matchedDN = null;
            referralURLs = null;
            switch (1.$SwitchMap$org$opends$server$util$ChangeOperationType[entry.getChangeOperationType().ordinal()]) {
                case 1: {
                    addOp = responseMessage.getAddResponseProtocolOp();
                    resultCode = addOp.getResultCode();
                    errorMessage = addOp.getErrorMessage();
                    matchedDN = addOp.getMatchedDN();
                    referralURLs = addOp.getReferralURLs();
                    break;
                }
                case 2: {
                    delOp = responseMessage.getDeleteResponseProtocolOp();
                    resultCode = delOp.getResultCode();
                    errorMessage = delOp.getErrorMessage();
                    matchedDN = delOp.getMatchedDN();
                    referralURLs = delOp.getReferralURLs();
                    break;
                }
                case 3: {
                    modOp = responseMessage.getModifyResponseProtocolOp();
                    resultCode = modOp.getResultCode();
                    errorMessage = modOp.getErrorMessage();
                    matchedDN = modOp.getMatchedDN();
                    referralURLs = modOp.getReferralURLs();
                    break;
                }
                case 4: {
                    modDNOp = responseMessage.getModifyDNResponseProtocolOp();
                    resultCode = modDNOp.getResultCode();
                    errorMessage = modDNOp.getErrorMessage();
                    matchedDN = modDNOp.getMatchedDN();
                    referralURLs = modDNOp.getReferralURLs();
                    break;
                }
            }
            if (resultCode != 0 && resultCode != 10) {
                msg = ToolMessages.INFO_OPERATION_FAILED.get(operationType);
                if (!modifyOptions.continueOnError()) {
                    throw new LDAPException(resultCode, errorMessage, msg, matchedDN, null);
                }
                LDAPToolUtils.printErrorMessage(this.err, msg, resultCode, errorMessage, matchedDN);
            } else {
                msg = ToolMessages.INFO_OPERATION_SUCCESSFUL.get(operationType, String.valueOf(asn1OctetStr));
                this.out.println(msg);
                if (errorMessage != null) {
                    this.out.println(StaticUtils.wrapText(errorMessage, ServerConstants.MAX_LINE_WIDTH));
                }
                if (referralURLs != null) {
                    this.out.println(referralURLs);
                }
            }
            i$ = responseMessage.getControls().iterator();
            while (true) {
                if (i$.hasNext()) ** break;
                continue block31;
                c = i$.next();
                oid = c.getOID();
                if (oid.equals("1.3.6.1.1.13.1")) {
                    controlValue = c.getValue();
                    if (controlValue == null) {
                        this.err.println(StaticUtils.wrapText(ToolMessages.ERR_LDAPMODIFY_PREREAD_NO_VALUE.get(), ServerConstants.MAX_LINE_WIDTH));
                        continue;
                    }
                    try {
                        valueBytes = controlValue.value();
                        valueElement = ASN1Element.decode(valueBytes);
                        searchEntry = SearchResultEntryProtocolOp.decodeSearchEntry(valueElement);
                    }
                    catch (ASN1Exception ae) {
                        this.err.println(StaticUtils.wrapText(ToolMessages.ERR_LDAPMODIFY_PREREAD_CANNOT_DECODE_VALUE.get(ae.getMessage()), ServerConstants.MAX_LINE_WIDTH));
                        continue;
                    }
                    catch (LDAPException le) {
                        this.err.println(StaticUtils.wrapText(ToolMessages.ERR_LDAPMODIFY_PREREAD_CANNOT_DECODE_VALUE.get(le.getMessage()), ServerConstants.MAX_LINE_WIDTH));
                        continue;
                    }
                    buffer = new StringBuilder();
                    searchEntry.toLDIF(buffer, 78);
                    this.out.println(ToolMessages.INFO_LDAPMODIFY_PREREAD_ENTRY.get());
                    this.out.println(buffer);
                    continue;
                }
                if (oid.equals("1.3.6.1.1.13.2")) {
                    controlValue = c.getValue();
                    if (controlValue == null) {
                        this.err.println(StaticUtils.wrapText(ToolMessages.ERR_LDAPMODIFY_POSTREAD_NO_VALUE.get(), ServerConstants.MAX_LINE_WIDTH));
                        continue;
                    }
                    try {
                        valueBytes = controlValue.value();
                        valueElement = ASN1Element.decode(valueBytes);
                        searchEntry = SearchResultEntryProtocolOp.decodeSearchEntry(valueElement);
                    }
                    catch (ASN1Exception ae) {
                        this.err.println(StaticUtils.wrapText(ToolMessages.ERR_LDAPMODIFY_POSTREAD_CANNOT_DECODE_VALUE.get(ae.getMessage()), ServerConstants.MAX_LINE_WIDTH));
                        continue;
                    }
                    catch (LDAPException le) {
                        this.err.println(StaticUtils.wrapText(ToolMessages.ERR_LDAPMODIFY_POSTREAD_CANNOT_DECODE_VALUE.get(le.getMessage()), ServerConstants.MAX_LINE_WIDTH));
                        continue;
                    }
                    buffer = new StringBuilder();
                    searchEntry.toLDIF(buffer, 78);
                    this.out.println(ToolMessages.INFO_LDAPMODIFY_POSTREAD_ENTRY.get());
                    this.out.println(buffer);
                    continue;
                }
                if (!oid.equals("1.3.6.1.4.1.42.2.27.9.5.9")) continue;
                controlValue = c.getValue();
                this.out.println(ToolMessages.INFO_CHANGE_NUMBER_CONTROL_RESULT.get(operationType, String.valueOf(controlValue)));
            }
            break;
        }
    }

    public static void main(String[] args) {
        int retCode = LDAPModify.mainModify(args, true, System.out, System.err);
        if (retCode != 0) {
            System.exit(StaticUtils.filterExitCode(retCode));
        }
    }

    public static int mainModify(String[] args) {
        return LDAPModify.mainModify(args, true, System.out, System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int mainModify(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        LDAPControl c;
        ASN1OctetString controlValue;
        StringTokenizer tokenizer;
        ArrayList<ASN1Element> attrElements;
        String valueStr;
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        LDAPConnectionOptions connectionOptions = new LDAPConnectionOptions();
        LDAPModifyOptions modifyOptions = new LDAPModifyOptions();
        LDAPConnection connection = null;
        BooleanArgument continueOnError = null;
        BooleanArgument defaultAdd = null;
        BooleanArgument noop = null;
        BooleanArgument reportAuthzID = null;
        BooleanArgument saslExternal = null;
        BooleanArgument showUsage = null;
        BooleanArgument startTLS = null;
        BooleanArgument trustAll = null;
        BooleanArgument useSSL = null;
        BooleanArgument verbose = null;
        FileBasedArgument bindPasswordFile = null;
        FileBasedArgument keyStorePasswordFile = null;
        FileBasedArgument trustStorePasswordFile = null;
        IntegerArgument port = null;
        IntegerArgument version = null;
        StringArgument assertionFilter = null;
        StringArgument bindDN = null;
        StringArgument bindPassword = null;
        StringArgument certNickname = null;
        StringArgument controlStr = null;
        StringArgument encodingStr = null;
        StringArgument filename = null;
        StringArgument hostName = null;
        StringArgument keyStorePath = null;
        StringArgument keyStorePassword = null;
        StringArgument postReadAttributes = null;
        StringArgument preReadAttributes = null;
        StringArgument proxyAuthzID = null;
        StringArgument saslOptions = null;
        StringArgument trustStorePath = null;
        StringArgument trustStorePassword = null;
        StringArgument propertiesFileArgument = null;
        BooleanArgument noPropertiesFileArgument = null;
        Message toolDescription = ToolMessages.INFO_LDAPMODIFY_TOOL_DESCRIPTION.get();
        ArgumentParser argParser = new ArgumentParser(CLASS_NAME, toolDescription, false);
        try {
            propertiesFileArgument = new StringArgument("propertiesFilePath", null, "propertiesFilePath", false, false, true, ToolMessages.INFO_PROP_FILE_PATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_PROP_FILE_PATH.get());
            argParser.addArgument(propertiesFileArgument);
            argParser.setFilePropertiesArgument(propertiesFileArgument);
            noPropertiesFileArgument = new BooleanArgument("noPropertiesFileArgument", null, "noPropertiesFile", ToolMessages.INFO_DESCRIPTION_NO_PROP_FILE.get());
            argParser.addArgument(noPropertiesFileArgument);
            argParser.setNoPropertiesFileArgument(noPropertiesFileArgument);
            hostName = new StringArgument("host", Character.valueOf('h'), "hostname", false, false, true, ToolMessages.INFO_HOST_PLACEHOLDER.get(), "localhost", null, ToolMessages.INFO_DESCRIPTION_HOST.get());
            hostName.setPropertyName("hostname");
            argParser.addArgument(hostName);
            port = new IntegerArgument("port", Character.valueOf('p'), "port", false, false, true, ToolMessages.INFO_PORT_PLACEHOLDER.get(), 389, null, ToolMessages.INFO_DESCRIPTION_PORT.get());
            port.setPropertyName("port");
            argParser.addArgument(port);
            useSSL = new BooleanArgument("useSSL", Character.valueOf('Z'), "useSSL", ToolMessages.INFO_DESCRIPTION_USE_SSL.get());
            useSSL.setPropertyName("useSSL");
            argParser.addArgument(useSSL);
            startTLS = new BooleanArgument("startTLS", Character.valueOf('q'), "useStartTLS", ToolMessages.INFO_DESCRIPTION_START_TLS.get());
            startTLS.setPropertyName("useStartTLS");
            argParser.addArgument(startTLS);
            bindDN = new StringArgument("bindDN", Character.valueOf('D'), "bindDN", false, false, true, ToolMessages.INFO_BINDDN_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_BINDDN.get());
            bindDN.setPropertyName("bindDN");
            argParser.addArgument(bindDN);
            bindPassword = new StringArgument("bindPassword", Character.valueOf('w'), "bindPassword", false, false, true, ToolMessages.INFO_BINDPWD_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_BINDPASSWORD.get());
            bindPassword.setPropertyName("bindPassword");
            argParser.addArgument(bindPassword);
            bindPasswordFile = new FileBasedArgument("bindPasswordFile", Character.valueOf('j'), "bindPasswordFile", false, false, ToolMessages.INFO_BINDPWD_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_BINDPASSWORDFILE.get());
            bindPasswordFile.setPropertyName("bindPasswordFile");
            argParser.addArgument(bindPasswordFile);
            defaultAdd = new BooleanArgument("defaultAdd", Character.valueOf('a'), "defaultAdd", ToolMessages.INFO_MODIFY_DESCRIPTION_DEFAULT_ADD.get());
            argParser.addArgument(defaultAdd);
            filename = new StringArgument("filename", Character.valueOf('f'), "filename", false, false, true, ToolMessages.INFO_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDAPMODIFY_DESCRIPTION_FILENAME.get());
            filename.setPropertyName("filename");
            argParser.addArgument(filename);
            saslExternal = new BooleanArgument("useSASLExternal", Character.valueOf('r'), "useSASLExternal", ToolMessages.INFO_DESCRIPTION_USE_SASL_EXTERNAL.get());
            saslExternal.setPropertyName("useSASLExternal");
            argParser.addArgument(saslExternal);
            saslOptions = new StringArgument("saslOption", Character.valueOf('o'), "saslOption", false, true, true, ToolMessages.INFO_SASL_OPTION_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_SASL_PROPERTIES.get());
            saslOptions.setPropertyName("saslOption");
            argParser.addArgument(saslOptions);
            trustAll = new BooleanArgument("trustAll", Character.valueOf('X'), "trustAll", ToolMessages.INFO_DESCRIPTION_TRUSTALL.get());
            trustAll.setPropertyName("trustAll");
            argParser.addArgument(trustAll);
            keyStorePath = new StringArgument("keyStorePath", Character.valueOf('K'), "keyStorePath", false, false, true, ToolMessages.INFO_KEYSTOREPATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_KEYSTOREPATH.get());
            keyStorePath.setPropertyName("keyStorePath");
            argParser.addArgument(keyStorePath);
            keyStorePassword = new StringArgument("keyStorePassword", Character.valueOf('W'), "keyStorePassword", false, false, true, ToolMessages.INFO_KEYSTORE_PWD_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_KEYSTOREPASSWORD.get());
            keyStorePassword.setPropertyName("keyStorePassword");
            argParser.addArgument(keyStorePassword);
            keyStorePasswordFile = new FileBasedArgument("keystorepasswordfile", Character.valueOf('u'), "keyStorePasswordFile", false, false, ToolMessages.INFO_KEYSTORE_PWD_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_KEYSTOREPASSWORD_FILE.get());
            keyStorePasswordFile.setPropertyName("keyStorePasswordFile");
            argParser.addArgument(keyStorePasswordFile);
            certNickname = new StringArgument("certnickname", Character.valueOf('N'), "certNickname", false, false, true, ToolMessages.INFO_NICKNAME_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_CERT_NICKNAME.get());
            certNickname.setPropertyName("certNickname");
            argParser.addArgument(certNickname);
            trustStorePath = new StringArgument("trustStorePath", Character.valueOf('P'), "trustStorePath", false, false, true, ToolMessages.INFO_TRUSTSTOREPATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_TRUSTSTOREPATH.get());
            trustStorePath.setPropertyName("trustStorePath");
            argParser.addArgument(trustStorePath);
            trustStorePassword = new StringArgument("trustStorePassword", null, "trustStorePassword", false, false, true, ToolMessages.INFO_TRUSTSTORE_PWD_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_TRUSTSTOREPASSWORD.get());
            trustStorePassword.setPropertyName("trustStorePassword");
            argParser.addArgument(trustStorePassword);
            trustStorePasswordFile = new FileBasedArgument("truststorepasswordfile", Character.valueOf('U'), "trustStorePasswordFile", false, false, ToolMessages.INFO_TRUSTSTORE_PWD_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_TRUSTSTOREPASSWORD_FILE.get());
            trustStorePasswordFile.setPropertyName("trustStorePasswordFile");
            argParser.addArgument(trustStorePasswordFile);
            proxyAuthzID = new StringArgument("proxy_authzid", Character.valueOf('Y'), "proxyAs", false, false, true, ToolMessages.INFO_PROXYAUTHID_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_PROXY_AUTHZID.get());
            proxyAuthzID.setPropertyName("proxyAs");
            argParser.addArgument(proxyAuthzID);
            reportAuthzID = new BooleanArgument("reportauthzid", Character.valueOf('E'), "reportAuthzID", ToolMessages.INFO_DESCRIPTION_REPORT_AUTHZID.get());
            reportAuthzID.setPropertyName("reportAuthzID");
            argParser.addArgument(reportAuthzID);
            assertionFilter = new StringArgument("assertionfilter", null, "assertionFilter", false, false, true, ToolMessages.INFO_ASSERTION_FILTER_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_ASSERTION_FILTER.get());
            assertionFilter.setPropertyName("assertionFilter");
            argParser.addArgument(assertionFilter);
            preReadAttributes = new StringArgument("prereadattrs", null, "preReadAttributes", false, false, true, ToolMessages.INFO_ATTRIBUTE_LIST_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_PREREAD_ATTRS.get());
            preReadAttributes.setPropertyName("preReadAttributes");
            argParser.addArgument(preReadAttributes);
            postReadAttributes = new StringArgument("postreadattrs", null, "postReadAttributes", false, false, true, ToolMessages.INFO_ATTRIBUTE_LIST_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_POSTREAD_ATTRS.get());
            postReadAttributes.setPropertyName("postReadAttributes");
            argParser.addArgument(postReadAttributes);
            controlStr = new StringArgument("control", Character.valueOf('J'), "control", false, true, true, ToolMessages.INFO_LDAP_CONTROL_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_CONTROLS.get());
            controlStr.setPropertyName("control");
            argParser.addArgument(controlStr);
            version = new IntegerArgument("version", Character.valueOf('V'), "ldapVersion", false, false, true, ToolMessages.INFO_PROTOCOL_VERSION_PLACEHOLDER.get(), 3, null, ToolMessages.INFO_DESCRIPTION_VERSION.get());
            version.setPropertyName("ldapVersion");
            argParser.addArgument(version);
            encodingStr = new StringArgument("encoding", Character.valueOf('i'), "encoding", false, false, true, ToolMessages.INFO_ENCODING_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_ENCODING.get());
            encodingStr.setPropertyName("encoding");
            argParser.addArgument(encodingStr);
            continueOnError = new BooleanArgument("continueOnError", Character.valueOf('c'), "continueOnError", ToolMessages.INFO_DESCRIPTION_CONTINUE_ON_ERROR.get());
            continueOnError.setPropertyName("continueOnError");
            argParser.addArgument(continueOnError);
            noop = new BooleanArgument("no-op", Character.valueOf('n'), "dry-run", ToolMessages.INFO_DESCRIPTION_NOOP.get());
            noop.setPropertyName("dry-run");
            argParser.addArgument(noop);
            verbose = new BooleanArgument("verbose", Character.valueOf('v'), "verbose", ToolMessages.INFO_DESCRIPTION_VERBOSE.get());
            verbose.setPropertyName("verbose");
            argParser.addArgument(verbose);
            showUsage = new BooleanArgument("showUsage", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_SHOWUSAGE.get());
            argParser.addArgument(showUsage);
            argParser.setUsageArgument(showUsage, out);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 1;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        if (bindPassword.isPresent() && bindPasswordFile.isPresent()) {
            Message message = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(bindPassword.getLongIdentifier(), bindPasswordFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        String hostNameValue = hostName.getValue();
        int portNumber = 389;
        try {
            portNumber = port.getIntValue();
        }
        catch (ArgumentException ae) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ae);
            }
            err.println(StaticUtils.wrapText(ae.getMessage(), ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            int versionNumber = version.getIntValue();
            if (versionNumber != 2 && versionNumber != 3) {
                err.println(StaticUtils.wrapText(ToolMessages.ERR_DESCRIPTION_INVALID_VERSION.get(String.valueOf(versionNumber)), ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            connectionOptions.setVersionNumber(versionNumber);
        }
        catch (ArgumentException ae) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ae);
            }
            err.println(StaticUtils.wrapText(ae.getMessage(), ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        String bindDNValue = bindDN.getValue();
        String fileNameValue = filename.getValue();
        String bindPasswordValue = bindPassword.getValue();
        if (bindPasswordValue != null && bindPasswordValue.equals("-")) {
            try {
                out.print(ToolMessages.INFO_LDAPAUTH_PASSWORD_PROMPT.get(bindDNValue));
                char[] pwChars = PasswordReader.readPassword();
                bindPasswordValue = new String(pwChars);
            }
            catch (Exception ex) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ex);
                }
                err.println(StaticUtils.wrapText(ex.getMessage(), ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        } else if (bindPasswordValue == null) {
            bindPasswordValue = bindPasswordFile.getValue();
        }
        String keyStorePathValue = keyStorePath.getValue();
        String trustStorePathValue = trustStorePath.getValue();
        String keyStorePasswordValue = null;
        if (keyStorePassword.isPresent()) {
            keyStorePasswordValue = keyStorePassword.getValue();
        } else if (keyStorePasswordFile.isPresent()) {
            keyStorePasswordValue = keyStorePasswordFile.getValue();
        }
        String trustStorePasswordValue = null;
        if (trustStorePassword.isPresent()) {
            trustStorePasswordValue = trustStorePassword.getValue();
        } else if (trustStorePasswordFile.isPresent()) {
            trustStorePasswordValue = trustStorePasswordFile.getValue();
        }
        modifyOptions.setShowOperations(noop.isPresent());
        modifyOptions.setVerbose(verbose.isPresent());
        modifyOptions.setContinueOnError(continueOnError.isPresent());
        modifyOptions.setEncoding(encodingStr.getValue());
        modifyOptions.setDefaultAdd(defaultAdd.isPresent());
        if (controlStr.isPresent()) {
            for (String ctrlString : controlStr.getValues()) {
                LDAPControl ctrl = LDAPToolUtils.getControl(ctrlString, err);
                if (ctrl == null) {
                    Message message = ToolMessages.ERR_TOOL_INVALID_CONTROL_STRING.get(ctrlString);
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    err.println(argParser.getUsage());
                    return 1;
                }
                modifyOptions.getControls().add(ctrl);
            }
        }
        if (proxyAuthzID.isPresent()) {
            ASN1OctetString proxyValue = new ASN1OctetString(proxyAuthzID.getValue());
            LDAPControl proxyControl = new LDAPControl("2.16.840.1.113730.3.4.18", true, proxyValue);
            modifyOptions.getControls().add(proxyControl);
        }
        if (assertionFilter.isPresent()) {
            String filterString = assertionFilter.getValue();
            try {
                LDAPFilter filter = LDAPFilter.decode(filterString);
                LDAPControl assertionControl = new LDAPControl("1.3.6.1.1.12", true, new ASN1OctetString(filter.encode().encode()));
                modifyOptions.getControls().add(assertionControl);
            }
            catch (LDAPException le) {
                Message message = ToolMessages.ERR_LDAP_ASSERTION_INVALID_FILTER.get(le.getMessage());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        if (preReadAttributes.isPresent()) {
            valueStr = preReadAttributes.getValue();
            attrElements = new ArrayList<ASN1Element>();
            tokenizer = new StringTokenizer(valueStr, ", ");
            while (tokenizer.hasMoreTokens()) {
                attrElements.add(new ASN1OctetString(tokenizer.nextToken()));
            }
            controlValue = new ASN1OctetString(new ASN1Sequence(attrElements).encode());
            c = new LDAPControl("1.3.6.1.1.13.1", true, controlValue);
            modifyOptions.getControls().add(c);
        }
        if (postReadAttributes.isPresent()) {
            valueStr = postReadAttributes.getValue();
            attrElements = new ArrayList();
            tokenizer = new StringTokenizer(valueStr, ", ");
            while (tokenizer.hasMoreTokens()) {
                attrElements.add(new ASN1OctetString(tokenizer.nextToken()));
            }
            controlValue = new ASN1OctetString(new ASN1Sequence(attrElements).encode());
            c = new LDAPControl("1.3.6.1.1.13.2", true, controlValue);
            modifyOptions.getControls().add(c);
        }
        connectionOptions.setSASLExternal(saslExternal.isPresent());
        if (saslOptions.isPresent()) {
            LinkedList<String> values = saslOptions.getValues();
            for (String saslOption : values) {
                boolean val;
                if (!(saslOption.startsWith("mech=") ? !(val = connectionOptions.setSASLMechanism(saslOption)) : !(val = connectionOptions.addSASLProperty(saslOption)))) continue;
                return 1;
            }
        }
        connectionOptions.setUseSSL(useSSL.isPresent());
        connectionOptions.setStartTLS(startTLS.isPresent());
        connectionOptions.setReportAuthzID(reportAuthzID.isPresent());
        if (connectionOptions.useSASLExternal()) {
            Message message;
            if (!connectionOptions.useSSL() && !connectionOptions.useStartTLS()) {
                message = ToolMessages.ERR_TOOL_SASLEXTERNAL_NEEDS_SSL_OR_TLS.get();
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            if (keyStorePathValue == null) {
                message = ToolMessages.ERR_TOOL_SASLEXTERNAL_NEEDS_KEYSTORE.get();
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        connectionOptions.setVerbose(verbose.isPresent());
        LDAPModify ldapModify = null;
        try {
            if (initializeServer) {
                EmbeddedUtils.initializeForClientUse();
            }
            SSLConnectionFactory sslConnectionFactory = null;
            if (connectionOptions.useSSL() || connectionOptions.useStartTLS()) {
                String clientAlias = certNickname.isPresent() ? certNickname.getValue() : null;
                sslConnectionFactory = new SSLConnectionFactory();
                sslConnectionFactory.init(trustAll.isPresent(), keyStorePathValue, keyStorePasswordValue, clientAlias, trustStorePathValue, trustStorePasswordValue);
                connectionOptions.setSSLConnectionFactory(sslConnectionFactory);
            }
            AtomicInteger nextMessageID = new AtomicInteger(1);
            connection = new LDAPConnection(hostNameValue, portNumber, connectionOptions, out, err);
            connection.connectToHost(bindDNValue, bindPasswordValue, nextMessageID);
            ldapModify = new LDAPModify(fileNameValue, nextMessageID, out, err);
            ldapModify.readAndExecute(connection, fileNameValue, modifyOptions);
        }
        catch (LDAPException le) {
            int code;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, le);
            }
            LDAPToolUtils.printErrorMessage(err, le.getMessageObject(), le.getResultCode(), le.getErrorMessage(), le.getMatchedDN());
            int n = code = le.getResultCode();
            return n;
        }
        catch (LDAPConnectionException lce) {
            int code;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, lce);
            }
            LDAPToolUtils.printErrorMessage(err, lce.getMessageObject(), lce.getResultCode(), lce.getErrorMessage(), lce.getMatchedDN());
            int n = code = lce.getResultCode();
            return n;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            err.println(StaticUtils.wrapText(e.getMessage(), ServerConstants.MAX_LINE_WIDTH));
            int n = 1;
            return n;
        }
        finally {
            if (connection != null) {
                if (ldapModify == null) {
                    connection.close(null);
                } else {
                    connection.close(ldapModify.nextMessageID);
                }
            }
        }
        return 0;
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$opends$server$util$ChangeOperationType;

        static {
            $SwitchMap$org$opends$server$util$ChangeOperationType = new int[ChangeOperationType.values().length];
            try {
                1.$SwitchMap$org$opends$server$util$ChangeOperationType[ChangeOperationType.ADD.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$opends$server$util$ChangeOperationType[ChangeOperationType.DELETE.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$opends$server$util$ChangeOperationType[ChangeOperationType.MODIFY.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$opends$server$util$ChangeOperationType[ChangeOperationType.MODIFY_DN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

