/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.Collection;
import java.util.Collections;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Attributes {
    public static Attribute create(AttributeType attributeType, AttributeValue value) {
        return Attributes.create(attributeType, attributeType.getNameOrOID(), value);
    }

    public static Attribute create(AttributeType attributeType, String valueString) {
        return Attributes.create(attributeType, attributeType.getNameOrOID(), valueString);
    }

    public static Attribute create(AttributeType attributeType, String name, AttributeValue value) {
        return AttributeBuilder.create(attributeType, name, Collections.singleton(value));
    }

    public static Attribute create(AttributeType attributeType, String name, String valueString) {
        AttributeValue value = new AttributeValue(attributeType, valueString);
        return Attributes.create(attributeType, name, value);
    }

    public static Attribute create(String attributeName, String valueString) {
        return Attributes.create(Attributes.getAttributeType(attributeName), attributeName, valueString);
    }

    public static Attribute create(String attributeName, String firstValueString, String ... otherValueStrings) {
        AttributeBuilder builder = new AttributeBuilder(attributeName);
        builder.add(firstValueString);
        for (String value : otherValueStrings) {
            builder.add(value);
        }
        return builder.toAttribute();
    }

    public static Attribute empty(Attribute attribute) {
        return new AttributeBuilder(attribute, true).toAttribute();
    }

    public static Attribute empty(AttributeType attributeType) {
        return Attributes.empty(attributeType, attributeType.getNameOrOID());
    }

    public static Attribute empty(AttributeType attributeType, String name) {
        return AttributeBuilder.create(attributeType, name, Collections.<AttributeValue>emptySet());
    }

    public static Attribute empty(String attributeName) {
        return Attributes.empty(Attributes.getAttributeType(attributeName), attributeName);
    }

    public static Attribute merge(Attribute a1, Attribute a2) {
        return Attributes.merge(a1, a2, null);
    }

    public static Attribute merge(Attribute a1, Attribute a2, Collection<AttributeValue> duplicateValues) {
        AttributeBuilder builder = new AttributeBuilder(a1);
        for (AttributeValue av : a2) {
            if (builder.add(av) || duplicateValues == null) continue;
            duplicateValues.add(av);
        }
        return builder.toAttribute();
    }

    public static Attribute subtract(Attribute a1, Attribute a2) {
        return Attributes.subtract(a1, a2, null);
    }

    public static Attribute subtract(Attribute a1, Attribute a2, Collection<AttributeValue> missingValues) {
        AttributeBuilder builder = new AttributeBuilder(a1);
        for (AttributeValue av : a2) {
            if (builder.remove(av) || missingValues == null) continue;
            missingValues.add(av);
        }
        return builder.toAttribute();
    }

    private static AttributeType getAttributeType(String attributeName) {
        String lc = StaticUtils.toLowerCase(attributeName);
        AttributeType type = DirectoryServer.getAttributeType(lc);
        if (type == null) {
            type = DirectoryServer.getDefaultAttributeType(attributeName);
        }
        return type;
    }
}

