/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public enum IndexType {
    PRESENCE("presence"),
    EQUALITY("equality"),
    SUBSTRING("substring"),
    SUBINITIAL("subinitial"),
    SUBANY("subany"),
    SUBFINAL("subfinal"),
    GREATER_OR_EQUAL("greater-or-equal"),
    LESS_OR_EQUAL("less-or-equal"),
    APPROXIMATE("approximate");

    private final String indexName;

    private IndexType(String indexName) {
        this.indexName = indexName;
    }

    public static IndexType forName(String indexName) {
        String lowerName = StaticUtils.toLowerCase(indexName);
        if (lowerName.equals("presence") || lowerName.equals("pres")) {
            return PRESENCE;
        }
        if (lowerName.equals("equality") || lowerName.equals("eq")) {
            return EQUALITY;
        }
        if (lowerName.equals("substring") || lowerName.equals("sub")) {
            return SUBSTRING;
        }
        if (lowerName.equals("subinitial")) {
            return SUBINITIAL;
        }
        if (lowerName.equals("subany")) {
            return SUBANY;
        }
        if (lowerName.equals("subfinal")) {
            return SUBFINAL;
        }
        if (lowerName.equals("greater-or-equal") || lowerName.equals("greaterorequal") || lowerName.equals("greater-than-or-equal-to") || lowerName.equals("greaterthanorequalto")) {
            return GREATER_OR_EQUAL;
        }
        if (lowerName.equals("less-or-equal") || lowerName.equals("lessorequal") || lowerName.equals("less-than-or-equal-to") || lowerName.equals("lessthanorequalto")) {
            return LESS_OR_EQUAL;
        }
        if (lowerName.equals("approximate") || lowerName.equals("approx")) {
            return APPROXIMATE;
        }
        return null;
    }

    public String toString() {
        return this.indexName;
    }
}

