/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.opends.messages.Message;
import org.opends.messages.UtilityMessages;
import org.opends.server.util.cli.CLIException;
import org.opends.server.util.cli.ConsoleApplication;
import org.opends.server.util.cli.HelpCallback;
import org.opends.server.util.cli.Menu;
import org.opends.server.util.cli.MenuCallback;
import org.opends.server.util.cli.MenuResult;
import org.opends.server.util.cli.ValidationCallback;
import org.opends.server.util.table.TableBuilder;
import org.opends.server.util.table.TablePrinter;
import org.opends.server.util.table.TextTablePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MenuBuilder<T> {
    private int threshold = -1;
    private boolean allowMultiSelect = false;
    private final ConsoleApplication app;
    private final List<MenuCallback<T>> charCallbacks = new ArrayList<MenuCallback<T>>();
    private final List<Message> charKeys = new ArrayList<Message>();
    private final List<Message> charSynopsis = new ArrayList<Message>();
    private final List<Message> columnHeadings = new ArrayList<Message>();
    private final List<Integer> columnWidths = new ArrayList<Integer>();
    private MenuCallback<T> defaultCallback = null;
    private Message defaultDescription = null;
    private final List<MenuCallback<T>> numericCallbacks = new ArrayList<MenuCallback<T>>();
    private final List<List<Message>> numericFields = new ArrayList<List<Message>>();
    private Message title = null;
    private Message prompt = null;
    private int nMaxTries = -1;

    public MenuBuilder(ConsoleApplication app) {
        this.app = app;
    }

    public void addBackOption(boolean isDefault) {
        this.addCharOption(UtilityMessages.INFO_MENU_OPTION_BACK_KEY.get(), UtilityMessages.INFO_MENU_OPTION_BACK.get(), MenuResult.cancel());
        if (isDefault) {
            this.setDefault(UtilityMessages.INFO_MENU_OPTION_BACK_KEY.get(), MenuResult.cancel());
        }
    }

    public void addCancelOption(boolean isDefault) {
        this.addCharOption(UtilityMessages.INFO_MENU_OPTION_CANCEL_KEY.get(), UtilityMessages.INFO_MENU_OPTION_CANCEL.get(), MenuResult.cancel());
        if (isDefault) {
            this.setDefault(UtilityMessages.INFO_MENU_OPTION_CANCEL_KEY.get(), MenuResult.cancel());
        }
    }

    public void addCharOption(Message c, Message description, MenuCallback<T> callback) {
        this.charKeys.add(c);
        this.charSynopsis.add(description);
        this.charCallbacks.add(callback);
    }

    public void addCharOption(Message c, Message description, MenuResult<T> result) {
        this.addCharOption(c, description, new ResultCallback(result));
    }

    public void addHelpOption(final HelpCallback callback) {
        MenuCallback wrapper = new MenuCallback<T>(){

            @Override
            public MenuResult<T> invoke(ConsoleApplication app) throws CLIException {
                app.println();
                callback.display(app);
                return MenuResult.again();
            }
        };
        this.addCharOption(UtilityMessages.INFO_MENU_OPTION_HELP_KEY.get(), UtilityMessages.INFO_MENU_OPTION_HELP.get(), wrapper);
    }

    public int addNumberedOption(Message description, MenuCallback<T> callback, Message ... extraFields) {
        ArrayList<Message> fields = new ArrayList<Message>();
        fields.add(description);
        if (extraFields != null) {
            fields.addAll(Arrays.asList(extraFields));
        }
        this.numericFields.add(fields);
        this.numericCallbacks.add(callback);
        return this.numericCallbacks.size();
    }

    public int addNumberedOption(Message description, MenuResult<T> result, Message ... extraFields) {
        return this.addNumberedOption(description, new ResultCallback(result), extraFields);
    }

    public void addQuitOption() {
        this.addCharOption(UtilityMessages.INFO_MENU_OPTION_QUIT_KEY.get(), UtilityMessages.INFO_MENU_OPTION_QUIT.get(), MenuResult.quit());
    }

    public void setAllowMultiSelect(boolean allowMultiSelect) {
        this.allowMultiSelect = allowMultiSelect;
    }

    public void setColumnHeadings(Message ... headings) {
        this.columnHeadings.clear();
        if (headings != null) {
            this.columnHeadings.addAll(Arrays.asList(headings));
        }
    }

    public void setColumnWidths(Integer ... widths) {
        this.columnWidths.clear();
        if (widths != null) {
            this.columnWidths.addAll(Arrays.asList(widths));
        }
    }

    public void setDefault(Message description, MenuCallback<T> callback) {
        this.defaultCallback = callback;
        this.defaultDescription = description;
    }

    public void setDefault(Message description, MenuResult<T> result) {
        this.setDefault(description, new ResultCallback(result));
    }

    public void setMultipleColumnThreshold(int threshold) {
        this.threshold = threshold;
    }

    public void setPrompt(Message prompt) {
        this.prompt = prompt;
    }

    public void setTitle(Message title) {
        this.title = title;
    }

    public Menu<T> toMenu() {
        int sz;
        TableBuilder nbuilder = new TableBuilder();
        HashMap<String, MenuCallback<T>> callbacks = new HashMap<String, MenuCallback<T>>();
        boolean useMultipleColumns = false;
        if (this.threshold >= 0 && this.numericCallbacks.size() >= this.threshold) {
            useMultipleColumns = true;
        }
        if (!this.columnHeadings.isEmpty()) {
            nbuilder.appendHeading();
            for (Message heading : this.columnHeadings) {
                if (heading != null) {
                    nbuilder.appendHeading(heading);
                    continue;
                }
                nbuilder.appendHeading();
            }
            if (useMultipleColumns) {
                nbuilder.appendHeading();
                for (Message heading : this.columnHeadings) {
                    if (heading != null) {
                        nbuilder.appendHeading(heading);
                        continue;
                    }
                    nbuilder.appendHeading();
                }
            }
        }
        int rows = sz = this.numericCallbacks.size();
        if (useMultipleColumns) {
            rows /= 2;
            rows += sz % 2;
        }
        int i = 0;
        int j = rows;
        while (i < rows) {
            nbuilder.startRow();
            nbuilder.appendCell(UtilityMessages.INFO_MENU_NUMERIC_OPTION.get(i + 1));
            for (Message field : this.numericFields.get(i)) {
                if (field != null) {
                    nbuilder.appendCell(field);
                    continue;
                }
                nbuilder.appendCell();
            }
            callbacks.put(String.valueOf(i + 1), this.numericCallbacks.get(i));
            if (useMultipleColumns && j < sz) {
                nbuilder.appendCell(UtilityMessages.INFO_MENU_NUMERIC_OPTION.get(j + 1));
                for (Message field : this.numericFields.get(j)) {
                    if (field != null) {
                        nbuilder.appendCell(field);
                        continue;
                    }
                    nbuilder.appendCell();
                }
                callbacks.put(String.valueOf(j + 1), this.numericCallbacks.get(j));
            }
            ++i;
            ++j;
        }
        TableBuilder cbuilder = new TableBuilder();
        for (int i2 = 0; i2 < this.charCallbacks.size(); ++i2) {
            char c = this.charKeys.get(i2).charAt(0);
            Message option = UtilityMessages.INFO_MENU_CHAR_OPTION.get(Character.valueOf(c));
            cbuilder.startRow();
            cbuilder.appendCell(option);
            cbuilder.appendCell(this.charSynopsis.get(i2));
            callbacks.put(String.valueOf(c), this.charCallbacks.get(i2));
        }
        TextTablePrinter printer = new TextTablePrinter(this.app.getErrorStream());
        if (this.columnHeadings.isEmpty()) {
            printer.setDisplayHeadings(false);
        } else {
            printer.setDisplayHeadings(true);
            printer.setHeadingSeparatorStartColumn(1);
        }
        printer.setIndentWidth(4);
        if (this.columnWidths.isEmpty()) {
            printer.setColumnWidth(1, 0);
            if (useMultipleColumns) {
                printer.setColumnWidth(3, 0);
            }
        } else {
            for (int i3 = 0; i3 < this.columnWidths.size(); ++i3) {
                Integer j2 = this.columnWidths.get(i3);
                if (j2 == null) continue;
                printer.setColumnWidth(i3 + 1, j2);
                if (!useMultipleColumns) continue;
                printer.setColumnWidth(i3 + 2 + this.columnWidths.size(), j2);
            }
        }
        return new MenuImpl(this.app, this.title, this.prompt, nbuilder, cbuilder, printer, callbacks, this.allowMultiSelect, this.defaultCallback, this.defaultDescription, this.nMaxTries);
    }

    public void setMaxTries(int nTries) {
        this.nMaxTries = nTries;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ResultCallback<T>
    implements MenuCallback<T> {
        private final MenuResult<T> result;

        private ResultCallback(MenuResult<T> result) {
            this.result = result;
        }

        @Override
        public MenuResult<T> invoke(ConsoleApplication app) throws CLIException {
            return this.result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MenuImpl<T>
    implements Menu<T> {
        private final boolean allowMultiSelect;
        private final ConsoleApplication app;
        private final Map<String, MenuCallback<T>> callbacks;
        private final TableBuilder cbuilder;
        private final MenuCallback<T> defaultCallback;
        private final Message defaultDescription;
        private final TableBuilder nbuilder;
        private final TablePrinter printer;
        private final Message prompt;
        private final Message title;
        private int nMaxTries;

        private MenuImpl(ConsoleApplication app, Message title, Message prompt, TableBuilder ntable, TableBuilder ctable, TablePrinter printer, Map<String, MenuCallback<T>> callbacks, boolean allowMultiSelect, MenuCallback<T> defaultCallback, Message defaultDescription, int nMaxTries) {
            this.app = app;
            this.title = title;
            this.prompt = prompt;
            this.nbuilder = ntable;
            this.cbuilder = ctable;
            this.printer = printer;
            this.callbacks = callbacks;
            this.allowMultiSelect = allowMultiSelect;
            this.defaultCallback = defaultCallback;
            this.defaultDescription = defaultDescription;
            this.nMaxTries = nMaxTries;
        }

        @Override
        public MenuResult<T> run() throws CLIException {
            ValidationCallback validator = new ValidationCallback<MenuCallback<T>>(){

                @Override
                public MenuCallback<T> validate(ConsoleApplication app, String input) {
                    String ninput = input.trim();
                    if (ninput.length() == 0) {
                        if (MenuImpl.this.defaultCallback != null) {
                            return MenuImpl.this.defaultCallback;
                        }
                        if (MenuImpl.this.allowMultiSelect) {
                            app.println();
                            app.println(UtilityMessages.ERR_MENU_BAD_CHOICE_MULTI.get());
                            app.println();
                            return null;
                        }
                        app.println();
                        app.println(UtilityMessages.ERR_MENU_BAD_CHOICE_SINGLE.get());
                        app.println();
                        return null;
                    }
                    if (MenuImpl.this.allowMultiSelect) {
                        ArrayList cl = new ArrayList();
                        String[] arr$ = ninput.split(",");
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$; ++i$) {
                            HashSet<String> choices = new HashSet<String>();
                            String value = arr$[i$];
                            String nvalue = value.trim();
                            if (choices.contains(nvalue)) {
                                app.println();
                                app.println(UtilityMessages.ERR_MENU_BAD_CHOICE_MULTI_DUPE.get(value));
                                app.println();
                                return null;
                            }
                            if (!MenuImpl.this.callbacks.containsKey(nvalue)) {
                                app.println();
                                app.println(UtilityMessages.ERR_MENU_BAD_CHOICE_MULTI.get());
                                app.println();
                                return null;
                            }
                            cl.add(MenuImpl.this.callbacks.get(nvalue));
                            choices.add(nvalue);
                        }
                        return new CompositeCallback(cl);
                    }
                    if (!MenuImpl.this.callbacks.containsKey(ninput)) {
                        app.println();
                        app.println(UtilityMessages.ERR_MENU_BAD_CHOICE_SINGLE.get());
                        app.println();
                        return null;
                    }
                    return (MenuCallback)MenuImpl.this.callbacks.get(ninput);
                }
            };
            Message promptMsg = this.allowMultiSelect ? (this.defaultDescription != null ? UtilityMessages.INFO_MENU_PROMPT_MULTI_DEFAULT.get(this.defaultDescription) : UtilityMessages.INFO_MENU_PROMPT_MULTI.get()) : (this.defaultDescription != null ? UtilityMessages.INFO_MENU_PROMPT_SINGLE_DEFAULT.get(this.defaultDescription) : UtilityMessages.INFO_MENU_PROMPT_SINGLE.get());
            while (true) {
                MenuCallback choice;
                MenuResult result;
                if (this.title != null) {
                    this.app.println(this.title);
                    this.app.println();
                }
                if (this.prompt != null) {
                    this.app.println(this.prompt);
                    this.app.println();
                }
                if (this.nbuilder.getTableHeight() > 0) {
                    this.nbuilder.print(this.printer);
                    this.app.println();
                }
                if (this.cbuilder.getTableHeight() > 0) {
                    TextTablePrinter cprinter = new TextTablePrinter(this.app.getErrorStream());
                    cprinter.setDisplayHeadings(false);
                    int sz = String.valueOf(this.nbuilder.getTableHeight()).length() + 1;
                    cprinter.setIndentWidth(4);
                    cprinter.setColumnWidth(0, sz);
                    cprinter.setColumnWidth(1, 0);
                    this.cbuilder.print(cprinter);
                    this.app.println();
                }
                if (!(result = (choice = this.nMaxTries != -1 ? (MenuCallback)this.app.readValidatedInput(promptMsg, validator, this.nMaxTries) : (MenuCallback)this.app.readValidatedInput(promptMsg, validator)).invoke(this.app)).isAgain()) {
                    return result;
                }
                this.app.println();
                this.app.println();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CompositeCallback<T>
    implements MenuCallback<T> {
        private final Collection<MenuCallback<T>> callbacks;

        public CompositeCallback(Collection<MenuCallback<T>> callbacks) {
            this.callbacks = callbacks;
        }

        @Override
        public MenuResult<T> invoke(ConsoleApplication app) throws CLIException {
            ArrayList<T> values = new ArrayList<T>();
            for (MenuCallback<T> callback : this.callbacks) {
                MenuResult<T> result = callback.invoke(app);
                if (!result.isSuccess()) {
                    return result;
                }
                values.addAll(result.getValues());
            }
            return MenuResult.success(values);
        }
    }
}

