/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.workflowelement.localbackend;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.std.server.PasswordValidatorCfg;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.Backend;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.api.PasswordValidator;
import org.opends.server.controls.LDAPAssertionRequestControl;
import org.opends.server.controls.LDAPPostReadRequestControl;
import org.opends.server.controls.LDAPPostReadResponseControl;
import org.opends.server.controls.PasswordPolicyErrorType;
import org.opends.server.controls.PasswordPolicyResponseControl;
import org.opends.server.controls.ProxiedAuthV1Control;
import org.opends.server.controls.ProxiedAuthV2Control;
import org.opends.server.core.AccessControlConfigManager;
import org.opends.server.core.AddOperation;
import org.opends.server.core.AddOperationWrapper;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordPolicy;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.schema.AuthPasswordSyntax;
import org.opends.server.schema.UserPasswordSyntax;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Attributes;
import org.opends.server.types.ByteString;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LDAPException;
import org.opends.server.types.LockManager;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.Privilege;
import org.opends.server.types.RDN;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.operation.PostOperationAddOperation;
import org.opends.server.types.operation.PostResponseAddOperation;
import org.opends.server.types.operation.PostSynchronizationAddOperation;
import org.opends.server.types.operation.PreOperationAddOperation;
import org.opends.server.util.TimeThread;
import org.opends.server.workflowelement.localbackend.LocalBackendWorkflowElement;

public class LocalBackendAddOperation
extends AddOperationWrapper
implements PreOperationAddOperation,
PostOperationAddOperation,
PostResponseAddOperation,
PostSynchronizationAddOperation {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private Backend backend;
    private boolean noOp;
    private DN entryDN;
    private Entry entry;
    LDAPPostReadRequestControl postReadRequest;
    private Map<ObjectClass, String> objectClasses;
    private Map<AttributeType, List<Attribute>> operationalAttributes;
    private Map<AttributeType, List<Attribute>> userAttributes;

    public LocalBackendAddOperation(AddOperation add) {
        super(add);
        LocalBackendWorkflowElement.attachLocalOperation(add, this);
    }

    public final Entry getEntryToAdd() {
        return this.entry;
    }

    /*
     * Exception decompiling
     */
    void processLocalAdd(LocalBackendWorkflowElement wfe) throws CanceledOperationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 63[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Lock lockParent(DN parentDN) throws DirectoryException {
        Lock parentLock = null;
        if (parentDN == null) {
            if (DirectoryServer.isNamingContext(this.entryDN)) {
                return null;
            }
            if (!this.entryDN.isNullDN()) throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, CoreMessages.ERR_ADD_ENTRY_NOT_SUFFIX.get(String.valueOf(this.entryDN)));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_ADD_CANNOT_ADD_ROOT_DSE.get());
        }
        for (int i = 0; i < 3 && (parentLock = LockManager.lockRead(parentDN)) == null; ++i) {
        }
        if (parentLock != null) return parentLock;
        throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), CoreMessages.ERR_ADD_CANNOT_LOCK_PARENT.get(String.valueOf(this.entryDN), String.valueOf(parentDN)));
    }

    private void addRDNAttributesIfNecessary() throws DirectoryException {
        RDN rdn = this.entryDN.getRDN();
        int numAVAs = rdn.getNumValues();
        for (int i = 0; i < numAVAs; ++i) {
            AttributeBuilder builder;
            Attribute a;
            int j;
            boolean found;
            List<Attribute> attrList;
            AttributeType t = rdn.getAttributeType(i);
            AttributeValue v = rdn.getAttributeValue(i);
            String n = rdn.getAttributeName(i);
            if (t.isOperational()) {
                attrList = this.operationalAttributes.get(t);
                if (attrList == null) {
                    if (this.isSynchronizationOperation() || DirectoryServer.addMissingRDNAttributes()) {
                        attrList = new ArrayList<Attribute>();
                        attrList.add(Attributes.create(t, n, v));
                        this.operationalAttributes.put(t, attrList);
                        continue;
                    }
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_ADD_MISSING_RDN_ATTRIBUTE.get(String.valueOf(this.entryDN), n));
                }
                found = false;
                for (j = 0; j < attrList.size(); ++j) {
                    a = attrList.get(j);
                    if (a.hasOptions()) continue;
                    if (!a.contains(v)) {
                        builder = new AttributeBuilder(a);
                        builder.add(v);
                        attrList.set(j, builder.toAttribute());
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                if (this.isSynchronizationOperation() || DirectoryServer.addMissingRDNAttributes()) {
                    attrList.add(Attributes.create(t, n, v));
                    continue;
                }
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_ADD_MISSING_RDN_ATTRIBUTE.get(String.valueOf(this.entryDN), n));
            }
            attrList = this.userAttributes.get(t);
            if (attrList == null) {
                if (this.isSynchronizationOperation() || DirectoryServer.addMissingRDNAttributes()) {
                    attrList = new ArrayList<Attribute>();
                    attrList.add(Attributes.create(t, n, v));
                    this.userAttributes.put(t, attrList);
                    continue;
                }
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_ADD_MISSING_RDN_ATTRIBUTE.get(String.valueOf(this.entryDN), n));
            }
            found = false;
            for (j = 0; j < attrList.size(); ++j) {
                a = attrList.get(j);
                if (a.hasOptions()) continue;
                if (!a.contains(v)) {
                    builder = new AttributeBuilder(a);
                    builder.add(v);
                    attrList.set(j, builder.toAttribute());
                }
                found = true;
                break;
            }
            if (found) continue;
            if (this.isSynchronizationOperation() || DirectoryServer.addMissingRDNAttributes()) {
                attrList.add(Attributes.create(t, n, v));
                continue;
            }
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_ADD_MISSING_RDN_ATTRIBUTE.get(String.valueOf(this.entryDN), n));
        }
    }

    public final void addObjectClassChain(ObjectClass objectClass) {
        Map<ObjectClass, String> objectClasses = this.getObjectClasses();
        if (objectClasses != null) {
            ObjectClass superiorClass;
            if (!objectClasses.containsKey(objectClass)) {
                objectClasses.put(objectClass, objectClass.getNameOrOID());
            }
            if ((superiorClass = objectClass.getSuperiorClass()) != null && !objectClasses.containsKey(superiorClass)) {
                this.addObjectClassChain(superiorClass);
            }
        }
    }

    public final void handlePasswordPolicy() throws DirectoryException {
        AttributeType passwordAttribute;
        List<Attribute> attrList;
        Attribute a;
        Iterator<AttributeValue> iterator;
        PasswordPolicy passwordPolicy = null;
        List<Attribute> pwAttrList = this.entry.getAttribute("ds-pwp-password-policy-dn");
        if (pwAttrList != null && !pwAttrList.isEmpty() && (iterator = (a = pwAttrList.get(0)).iterator()).hasNext()) {
            DN policyDN;
            try {
                policyDN = DN.decode(iterator.next().getValue());
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, CoreMessages.ERR_ADD_INVALID_PWPOLICY_DN_SYNTAX.get(String.valueOf(this.entryDN), de.getMessageObject()));
            }
            passwordPolicy = DirectoryServer.getPasswordPolicy(policyDN);
            if (passwordPolicy == null) {
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_ADD_NO_SUCH_PWPOLICY.get(String.valueOf(this.entryDN), String.valueOf(policyDN)));
            }
        }
        if (passwordPolicy == null) {
            passwordPolicy = DirectoryServer.getDefaultPasswordPolicy();
        }
        if ((attrList = this.entry.getAttribute(passwordAttribute = passwordPolicy.getPasswordAttribute())) == null || attrList.isEmpty()) {
            return;
        }
        if (attrList.size() > 1) {
            Message message = CoreMessages.ERR_PWPOLICY_ATTRIBUTE_OPTIONS_NOT_ALLOWED.get(passwordAttribute.getNameOrOID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        Attribute passwordAttr = attrList.get(0);
        if (passwordAttr.hasOptions()) {
            Message message = CoreMessages.ERR_PWPOLICY_ATTRIBUTE_OPTIONS_NOT_ALLOWED.get(passwordAttribute.getNameOrOID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        if (passwordAttr.isEmpty()) {
            return;
        }
        if (!passwordPolicy.allowMultiplePasswordValues() && passwordAttr.size() > 1) {
            this.addPWPolicyControl(PasswordPolicyErrorType.PASSWORD_MOD_NOT_ALLOWED);
            Message message = CoreMessages.ERR_PWPOLICY_MULTIPLE_PW_VALUES_NOT_ALLOWED.get(passwordAttribute.getNameOrOID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        CopyOnWriteArrayList<PasswordStorageScheme<?>> defaultStorageSchemes = passwordPolicy.getDefaultStorageSchemes();
        AttributeBuilder builder = new AttributeBuilder(passwordAttr, true);
        builder.setInitialCapacity(defaultStorageSchemes.size());
        for (AttributeValue v : passwordAttr) {
            ByteString encodedValue;
            Message message;
            ByteString value = v.getValue();
            if (passwordPolicy.usesAuthPasswordSyntax()) {
                if (AuthPasswordSyntax.isEncoded(value)) {
                    if (passwordPolicy.allowPreEncodedPasswords()) {
                        builder.add(v);
                        continue;
                    }
                    this.addPWPolicyControl(PasswordPolicyErrorType.INSUFFICIENT_PASSWORD_QUALITY);
                    message = CoreMessages.ERR_PWPOLICY_PREENCODED_NOT_ALLOWED.get(passwordAttribute.getNameOrOID());
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
                }
            } else if (UserPasswordSyntax.isEncoded(value)) {
                if (passwordPolicy.allowPreEncodedPasswords()) {
                    builder.add(v);
                    continue;
                }
                this.addPWPolicyControl(PasswordPolicyErrorType.INSUFFICIENT_PASSWORD_QUALITY);
                message = CoreMessages.ERR_PWPOLICY_PREENCODED_NOT_ALLOWED.get(passwordAttribute.getNameOrOID());
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
            if (!passwordPolicy.skipValidationForAdministrators()) {
                HashSet<ByteString> currentPasswords = new HashSet<ByteString>(0);
                MessageBuilder invalidReason = new MessageBuilder();
                for (PasswordValidator<? extends PasswordValidatorCfg> validator : passwordPolicy.getPasswordValidators().values()) {
                    if (validator.passwordIsAcceptable(value, currentPasswords, this, this.entry, invalidReason)) continue;
                    this.addPWPolicyControl(PasswordPolicyErrorType.INSUFFICIENT_PASSWORD_QUALITY);
                    Message message2 = CoreMessages.ERR_PWPOLICY_VALIDATION_FAILED.get(passwordAttribute.getNameOrOID(), String.valueOf(invalidReason));
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message2);
                }
            }
            if (passwordPolicy.usesAuthPasswordSyntax()) {
                for (PasswordStorageScheme<?> s : defaultStorageSchemes) {
                    encodedValue = s.encodeAuthPassword(value);
                    builder.add(new AttributeValue(passwordAttribute, encodedValue));
                }
                continue;
            }
            for (PasswordStorageScheme<?> s : defaultStorageSchemes) {
                encodedValue = s.encodePasswordWithScheme(value);
                builder.add(new AttributeValue(passwordAttribute, encodedValue));
            }
        }
        this.entry.replaceAttribute(builder.toAttribute());
        ArrayList<Attribute> changedTimeList = new ArrayList<Attribute>(1);
        Attribute changedTime = Attributes.create("pwdChangedTime", TimeThread.getGeneralizedTime());
        changedTimeList.add(changedTime);
        this.entry.putAttribute(changedTime.getAttributeType(), changedTimeList);
        if (passwordPolicy.forceChangeOnAdd()) {
            this.addPWPolicyControl(PasswordPolicyErrorType.CHANGE_AFTER_RESET);
            ArrayList<Attribute> resetList = new ArrayList<Attribute>(1);
            Attribute reset = Attributes.create("pwdReset", "TRUE");
            resetList.add(reset);
            this.entry.putAttribute(reset.getAttributeType(), resetList);
        }
    }

    private void addPWPolicyControl(PasswordPolicyErrorType errorType) {
        for (Control c : this.getRequestControls()) {
            if (!c.getOID().equals("1.3.6.1.4.1.42.2.27.8.5.1")) continue;
            this.addResponseControl(new PasswordPolicyResponseControl(null, 0, errorType));
        }
    }

    private void checkSchema(Entry parentEntry) throws DirectoryException {
        MessageBuilder invalidReason = new MessageBuilder();
        if (!this.entry.conformsToSchema(parentEntry, true, true, true, invalidReason)) {
            throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, invalidReason.toMessage());
        }
        switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
            case REJECT: {
                AttributeSyntax syntax;
                invalidReason = new MessageBuilder();
                for (List list : this.userAttributes.values()) {
                    for (Attribute a : list) {
                        syntax = a.getAttributeType().getSyntax();
                        if (syntax == null) continue;
                        for (AttributeValue v : a) {
                            if (syntax.valueIsAcceptable(v.getValue(), invalidReason)) continue;
                            Message message = CoreMessages.WARN_ADD_OP_INVALID_SYNTAX.get(String.valueOf(this.entryDN), String.valueOf(v.getStringValue()), String.valueOf(a.getName()), String.valueOf(invalidReason));
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                        }
                    }
                }
                for (List list : this.operationalAttributes.values()) {
                    for (Attribute a : list) {
                        syntax = a.getAttributeType().getSyntax();
                        if (syntax == null) continue;
                        for (AttributeValue v : a) {
                            if (syntax.valueIsAcceptable(v.getValue(), invalidReason)) continue;
                            Message message = CoreMessages.WARN_ADD_OP_INVALID_SYNTAX.get(String.valueOf(this.entryDN), String.valueOf(v.getStringValue()), String.valueOf(a.getName()), String.valueOf(invalidReason));
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                        }
                    }
                }
                break;
            }
            case WARN: {
                AttributeSyntax syntax;
                invalidReason = new MessageBuilder();
                for (List list : this.userAttributes.values()) {
                    for (Attribute a : list) {
                        syntax = a.getAttributeType().getSyntax();
                        if (syntax == null) continue;
                        for (AttributeValue v : a) {
                            if (syntax.valueIsAcceptable(v.getValue(), invalidReason)) continue;
                            ErrorLogger.logError(CoreMessages.WARN_ADD_OP_INVALID_SYNTAX.get(String.valueOf(this.entryDN), String.valueOf(v.getStringValue()), String.valueOf(a.getName()), String.valueOf(invalidReason)));
                        }
                    }
                }
                for (List list : this.operationalAttributes.values()) {
                    for (Attribute a : list) {
                        syntax = a.getAttributeType().getSyntax();
                        if (syntax == null) continue;
                        for (AttributeValue v : a) {
                            if (syntax.valueIsAcceptable(v.getValue(), invalidReason)) continue;
                            ErrorLogger.logError(CoreMessages.WARN_ADD_OP_INVALID_SYNTAX.get(String.valueOf(this.entryDN), String.valueOf(v.getStringValue()), String.valueOf(a.getName()), String.valueOf(invalidReason)));
                        }
                    }
                }
                break;
            }
        }
        for (AttributeType attributeType : this.userAttributes.keySet()) {
            if (!attributeType.isObsolete()) continue;
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.WARN_ADD_ATTR_IS_OBSOLETE.get(String.valueOf(this.entryDN), attributeType.getNameOrOID()));
        }
        for (AttributeType attributeType : this.operationalAttributes.keySet()) {
            if (!attributeType.isObsolete()) continue;
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.WARN_ADD_ATTR_IS_OBSOLETE.get(String.valueOf(this.entryDN), attributeType.getNameOrOID()));
        }
        for (ObjectClass objectClass : this.objectClasses.keySet()) {
            if (!objectClass.isObsolete()) continue;
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.WARN_ADD_OC_IS_OBSOLETE.get(String.valueOf(this.entryDN), objectClass.getNameOrOID()));
        }
    }

    private void processControls(DN parentDN) throws DirectoryException {
        List<Control> requestControls = this.getRequestControls();
        if (requestControls != null && !requestControls.isEmpty()) {
            for (int i = 0; i < requestControls.size(); ++i) {
                Entry authorizationEntry;
                Control proxyControl;
                Control c = requestControls.get(i);
                String oid = c.getOID();
                if (!AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(parentDN, this, c)) {
                    throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, CoreMessages.ERR_CONTROL_INSUFFICIENT_ACCESS_RIGHTS.get(oid));
                }
                if (oid.equals("1.3.6.1.1.12")) {
                    LDAPAssertionRequestControl assertControl;
                    if (c instanceof LDAPAssertionRequestControl) {
                        assertControl = (LDAPAssertionRequestControl)c;
                    } else {
                        try {
                            assertControl = LDAPAssertionRequestControl.decodeControl(c);
                            requestControls.set(i, assertControl);
                        }
                        catch (LDAPException le) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, le);
                            }
                            throw new DirectoryException(ResultCode.valueOf(le.getResultCode()), le.getMessageObject());
                        }
                    }
                    try {
                        SearchFilter filter = assertControl.getSearchFilter();
                        if (filter.matchesEntry(this.entry)) continue;
                        throw new DirectoryException(ResultCode.ASSERTION_FAILED, CoreMessages.ERR_ADD_ASSERTION_FAILED.get(String.valueOf(this.entryDN)));
                    }
                    catch (DirectoryException de) {
                        if (de.getResultCode() == ResultCode.ASSERTION_FAILED) {
                            throw de;
                        }
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        throw new DirectoryException(ResultCode.PROTOCOL_ERROR, CoreMessages.ERR_ADD_CANNOT_PROCESS_ASSERTION_FILTER.get(String.valueOf(this.entryDN), de.getMessageObject()));
                    }
                }
                if (oid.equals("1.3.6.1.4.1.4203.1.10.2")) {
                    this.noOp = true;
                    continue;
                }
                if (oid.equals("1.3.6.1.1.13.2")) {
                    if (c instanceof LDAPPostReadRequestControl) {
                        this.postReadRequest = (LDAPPostReadRequestControl)c;
                        continue;
                    }
                    try {
                        this.postReadRequest = LDAPPostReadRequestControl.decodeControl(c);
                        requestControls.set(i, this.postReadRequest);
                        continue;
                    }
                    catch (LDAPException le) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, le);
                        }
                        throw new DirectoryException(ResultCode.valueOf(le.getResultCode()), le.getMessageObject());
                    }
                }
                if (oid.equals("2.16.840.1.113730.3.4.12")) {
                    if (!this.getClientConnection().hasPrivilege(Privilege.PROXIED_AUTH, this)) {
                        throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, CoreMessages.ERR_PROXYAUTH_INSUFFICIENT_PRIVILEGES.get());
                    }
                    if (c instanceof ProxiedAuthV1Control) {
                        proxyControl = (ProxiedAuthV1Control)c;
                    } else {
                        try {
                            proxyControl = ProxiedAuthV1Control.decodeControl(c);
                        }
                        catch (LDAPException le) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, le);
                            }
                            throw new DirectoryException(ResultCode.valueOf(le.getResultCode()), le.getMessageObject());
                        }
                    }
                    authorizationEntry = ((ProxiedAuthV1Control)proxyControl).getAuthorizationEntry();
                    this.setAuthorizationEntry(authorizationEntry);
                    if (authorizationEntry == null) {
                        this.setProxiedAuthorizationDN(DN.nullDN());
                        continue;
                    }
                    this.setProxiedAuthorizationDN(authorizationEntry.getDN());
                    continue;
                }
                if (oid.equals("2.16.840.1.113730.3.4.18")) {
                    if (!this.getClientConnection().hasPrivilege(Privilege.PROXIED_AUTH, this)) {
                        throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, CoreMessages.ERR_PROXYAUTH_INSUFFICIENT_PRIVILEGES.get());
                    }
                    if (c instanceof ProxiedAuthV2Control) {
                        proxyControl = (ProxiedAuthV2Control)c;
                    } else {
                        try {
                            proxyControl = ProxiedAuthV2Control.decodeControl(c);
                        }
                        catch (LDAPException le) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, le);
                            }
                            throw new DirectoryException(ResultCode.valueOf(le.getResultCode()), le.getMessageObject());
                        }
                    }
                    authorizationEntry = ((ProxiedAuthV2Control)proxyControl).getAuthorizationEntry();
                    this.setAuthorizationEntry(authorizationEntry);
                    if (authorizationEntry == null) {
                        this.setProxiedAuthorizationDN(DN.nullDN());
                        continue;
                    }
                    this.setProxiedAuthorizationDN(authorizationEntry.getDN());
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.42.2.27.8.5.1") || !c.isCritical() || this.backend != null && this.backend.supportsControl(oid)) continue;
                throw new DirectoryException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, CoreMessages.ERR_ADD_UNSUPPORTED_CRITICAL_CONTROL.get(String.valueOf(this.entryDN), oid));
            }
        }
    }

    private void addPostReadResponse() {
        AttributeType attrType;
        Iterator<AttributeType> iterator;
        Entry addedEntry = this.entry.duplicate(true);
        if (!this.postReadRequest.allowsAttribute(DirectoryServer.getObjectClassAttributeType())) {
            addedEntry.removeAttribute(DirectoryServer.getObjectClassAttributeType());
        }
        if (!this.postReadRequest.returnAllUserAttributes()) {
            iterator = addedEntry.getUserAttributes().keySet().iterator();
            while (iterator.hasNext()) {
                attrType = iterator.next();
                if (this.postReadRequest.allowsAttribute(attrType)) continue;
                iterator.remove();
            }
        }
        if (!this.postReadRequest.returnAllOperationalAttributes()) {
            iterator = addedEntry.getOperationalAttributes().keySet().iterator();
            while (iterator.hasNext()) {
                attrType = iterator.next();
                if (this.postReadRequest.allowsAttribute(attrType)) continue;
                iterator.remove();
            }
        }
        SearchResultEntry searchEntry = new SearchResultEntry(addedEntry);
        LDAPPostReadResponseControl responseControl = new LDAPPostReadResponseControl(this.postReadRequest.getOID(), this.postReadRequest.isCritical(), searchEntry);
        this.addResponseControl(responseControl);
    }
}

