/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.ReplicaDescriptor;
import org.opends.admin.ads.SuffixDescriptor;
import org.opends.admin.ads.TopologyCacheException;
import org.opends.admin.ads.TopologyCacheFilter;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.quicksetup.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerDescriptor {
    private Map<ADSContext.ServerProperty, Object> adsProperties = new HashMap<ADSContext.ServerProperty, Object>();
    private Set<ReplicaDescriptor> replicas = new HashSet<ReplicaDescriptor>();
    private Map<ServerProperty, Object> serverProperties = new HashMap<ServerProperty, Object>();
    private TopologyCacheException lastException;

    private ServerDescriptor() {
    }

    public Set<ReplicaDescriptor> getReplicas() {
        HashSet<ReplicaDescriptor> copy = new HashSet<ReplicaDescriptor>();
        copy.addAll(this.replicas);
        return copy;
    }

    public void setReplicas(Set<ReplicaDescriptor> replicas) {
        this.replicas.clear();
        this.replicas.addAll(replicas);
    }

    public Map<ADSContext.ServerProperty, Object> getAdsProperties() {
        return this.adsProperties;
    }

    public Map<ServerProperty, Object> getServerProperties() {
        return this.serverProperties;
    }

    public boolean isRegistered() {
        return !this.adsProperties.isEmpty();
    }

    public boolean isReplicationServer() {
        return Boolean.TRUE.equals(this.serverProperties.get((Object)ServerProperty.IS_REPLICATION_SERVER));
    }

    public String getReplicationServerHostPort() {
        String hostPort = null;
        if (this.isReplicationServer()) {
            hostPort = this.getHostName().toLowerCase() + ":" + this.getReplicationServerPort();
        }
        return hostPort;
    }

    public int getReplicationServerId() {
        int port = -1;
        if (this.isReplicationServer()) {
            port = (Integer)this.serverProperties.get((Object)ServerProperty.REPLICATION_SERVER_ID);
        }
        return port;
    }

    public int getReplicationServerPort() {
        int port = -1;
        if (this.isReplicationServer()) {
            port = (Integer)this.serverProperties.get((Object)ServerProperty.REPLICATION_SERVER_PORT);
        }
        return port;
    }

    public boolean isReplicationSecure() {
        boolean isReplicationSecure = this.isReplicationServer() ? Boolean.TRUE.equals(this.serverProperties.get((Object)ServerProperty.IS_REPLICATION_SECURE)) : false;
        return isReplicationSecure;
    }

    public void setAdsProperties(Map<ADSContext.ServerProperty, Object> adsProperties) {
        this.adsProperties = adsProperties;
    }

    public String getHostName() {
        String host = (String)this.serverProperties.get((Object)ServerProperty.HOST_NAME);
        if (host == null) {
            host = (String)this.adsProperties.get((Object)ADSContext.ServerProperty.HOST_NAME);
        }
        return host;
    }

    public String getLDAPURL() {
        String ldapUrl = null;
        String host = this.getHostName();
        int port = -1;
        if (!this.serverProperties.isEmpty()) {
            ArrayList s = (ArrayList)this.serverProperties.get((Object)ServerProperty.LDAP_ENABLED);
            ArrayList p = (ArrayList)this.serverProperties.get((Object)ServerProperty.LDAP_PORT);
            if (s != null) {
                for (int i = 0; i < s.size(); ++i) {
                    if (!Boolean.TRUE.equals(s.get(i))) continue;
                    port = (Integer)p.get(i);
                    break;
                }
            }
        }
        if (port != -1) {
            ldapUrl = ConnectionUtils.getLDAPUrl(host, port, false);
        }
        return ldapUrl;
    }

    public String getLDAPsURL() {
        String ldapsUrl = null;
        String host = this.getHostName();
        int port = -1;
        if (!this.serverProperties.isEmpty()) {
            ArrayList s = (ArrayList)this.serverProperties.get((Object)ServerProperty.LDAPS_ENABLED);
            ArrayList p = (ArrayList)this.serverProperties.get((Object)ServerProperty.LDAPS_PORT);
            if (s != null) {
                for (int i = 0; i < s.size(); ++i) {
                    if (!Boolean.TRUE.equals(s.get(i))) continue;
                    port = (Integer)p.get(i);
                    break;
                }
            }
        }
        if (port != -1) {
            ldapsUrl = ConnectionUtils.getLDAPUrl(host, port, true);
        }
        return ldapsUrl;
    }

    public String getAdminConnectorURL() {
        String adminConnectorUrl = null;
        String host = this.getHostName();
        int port = -1;
        if (!this.serverProperties.isEmpty()) {
            ArrayList s = (ArrayList)this.serverProperties.get((Object)ServerProperty.ADMIN_ENABLED);
            ArrayList p = (ArrayList)this.serverProperties.get((Object)ServerProperty.ADMIN_PORT);
            if (s != null) {
                for (int i = 0; i < s.size(); ++i) {
                    if (!Boolean.TRUE.equals(s.get(i))) continue;
                    port = (Integer)p.get(i);
                    break;
                }
            }
        }
        if (port != -1) {
            adminConnectorUrl = ConnectionUtils.getLDAPUrl(host, port, true);
        }
        return adminConnectorUrl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getHostPort(boolean securePreferred) {
        String host = this.getHostName();
        int port = -1;
        if (!this.serverProperties.isEmpty()) {
            int i;
            ArrayList s = (ArrayList)this.serverProperties.get((Object)ServerProperty.LDAP_ENABLED);
            ArrayList p = (ArrayList)this.serverProperties.get((Object)ServerProperty.LDAP_PORT);
            if (s != null) {
                for (i = 0; i < s.size(); ++i) {
                    if (!Boolean.TRUE.equals(s.get(i))) continue;
                    port = (Integer)p.get(i);
                    break;
                }
            }
            if (!securePreferred) return host + ":" + port;
            s = (ArrayList)this.serverProperties.get((Object)ServerProperty.ADMIN_ENABLED);
            p = (ArrayList)this.serverProperties.get((Object)ServerProperty.ADMIN_PORT);
            if (s == null) return host + ":" + port;
            for (i = 0; i < s.size(); ++i) {
                if (!Boolean.TRUE.equals(s.get(i))) continue;
                port = (Integer)p.get(i);
                return host + ":" + port;
            }
            return host + ":" + port;
        }
        Object v = this.adsProperties.get((Object)ADSContext.ServerProperty.ADMIN_ENABLED);
        boolean secure = securePreferred && "true".equalsIgnoreCase(String.valueOf(v));
        try {
            if (secure) {
                port = Integer.parseInt((String)this.adsProperties.get((Object)ADSContext.ServerProperty.ADMIN_PORT));
                return host + ":" + port;
            }
            port = Integer.parseInt((String)this.adsProperties.get((Object)ADSContext.ServerProperty.LDAP_PORT));
            return host + ":" + port;
        }
        catch (Throwable t) {
            // empty catch block
        }
        return host + ":" + port;
    }

    public String getId() {
        StringBuilder buf = new StringBuilder();
        if (this.serverProperties.size() > 0) {
            ServerProperty[] props;
            buf.append(this.serverProperties.get((Object)ServerProperty.HOST_NAME));
            for (ServerProperty prop : props = new ServerProperty[]{ServerProperty.LDAP_PORT, ServerProperty.LDAPS_PORT, ServerProperty.ADMIN_PORT, ServerProperty.LDAP_ENABLED, ServerProperty.LDAPS_ENABLED, ServerProperty.ADMIN_ENABLED}) {
                ArrayList s = (ArrayList)this.serverProperties.get((Object)prop);
                for (Object o : s) {
                    buf.append(":").append(o);
                }
            }
        } else {
            ADSContext.ServerProperty[] props = new ADSContext.ServerProperty[]{ADSContext.ServerProperty.HOST_NAME, ADSContext.ServerProperty.LDAP_PORT, ADSContext.ServerProperty.LDAPS_PORT, ADSContext.ServerProperty.ADMIN_PORT, ADSContext.ServerProperty.LDAP_ENABLED, ADSContext.ServerProperty.LDAPS_ENABLED, ADSContext.ServerProperty.ADMIN_ENABLED};
            for (int i = 0; i < props.length; ++i) {
                if (i != 0) {
                    buf.append(":");
                }
                buf.append(this.adsProperties.get((Object)props[i]));
            }
        }
        return buf.toString();
    }

    public byte[] getInstancePublicKeyCertificate() {
        return (byte[])this.serverProperties.get((Object)ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE);
    }

    public String getSchemaReplicationID() {
        return (String)this.serverProperties.get((Object)ServerProperty.SCHEMA_GENERATION_ID);
    }

    public TopologyCacheException getLastException() {
        return this.lastException;
    }

    public void setLastException(TopologyCacheException lastException) {
        this.lastException = lastException;
    }

    public void updateAdsPropertiesWithServerProperties() {
        this.adsProperties.put(ADSContext.ServerProperty.HOST_NAME, this.getHostName());
        ServerProperty[][] sProps = new ServerProperty[][]{{ServerProperty.LDAP_ENABLED, ServerProperty.LDAP_PORT}, {ServerProperty.LDAPS_ENABLED, ServerProperty.LDAPS_PORT}, {ServerProperty.ADMIN_ENABLED, ServerProperty.ADMIN_PORT}, {ServerProperty.JMX_ENABLED, ServerProperty.JMX_PORT}, {ServerProperty.JMXS_ENABLED, ServerProperty.JMXS_PORT}};
        ADSContext.ServerProperty[][] adsProps = new ADSContext.ServerProperty[][]{{ADSContext.ServerProperty.LDAP_ENABLED, ADSContext.ServerProperty.LDAP_PORT}, {ADSContext.ServerProperty.LDAPS_ENABLED, ADSContext.ServerProperty.LDAPS_PORT}, {ADSContext.ServerProperty.ADMIN_ENABLED, ADSContext.ServerProperty.ADMIN_PORT}, {ADSContext.ServerProperty.JMX_ENABLED, ADSContext.ServerProperty.JMX_PORT}, {ADSContext.ServerProperty.JMXS_ENABLED, ADSContext.ServerProperty.JMXS_PORT}};
        for (int i = 0; i < sProps.length; ++i) {
            ArrayList s = (ArrayList)this.serverProperties.get((Object)sProps[i][0]);
            ArrayList p = (ArrayList)this.serverProperties.get((Object)sProps[i][1]);
            if (s == null) continue;
            int port = -1;
            for (int j = 0; j < s.size(); ++j) {
                if (!Boolean.TRUE.equals(s.get(j))) continue;
                port = (Integer)p.get(j);
                break;
            }
            if (port == -1) {
                this.adsProperties.put(adsProps[i][0], "false");
                if (p.size() > 0) {
                    port = (Integer)p.iterator().next();
                }
            } else {
                this.adsProperties.put(adsProps[i][0], "true");
            }
            this.adsProperties.put(adsProps[i][1], String.valueOf(port));
        }
        ArrayList array = (ArrayList)this.serverProperties.get((Object)ServerProperty.STARTTLS_ENABLED);
        boolean startTLSEnabled = false;
        if (array != null && !array.isEmpty()) {
            startTLSEnabled = Boolean.TRUE.equals(array.get(array.size() - 1));
        }
        this.adsProperties.put(ADSContext.ServerProperty.STARTTLS_ENABLED, startTLSEnabled ? "true" : "false");
        this.adsProperties.put(ADSContext.ServerProperty.ID, this.getHostPort(true));
        this.adsProperties.put(ADSContext.ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE, this.getInstancePublicKeyCertificate());
    }

    public static ServerDescriptor createStandalone(Map<ADSContext.ServerProperty, Object> adsProperties) {
        ServerDescriptor desc = new ServerDescriptor();
        desc.setAdsProperties(adsProperties);
        return desc;
    }

    public static ServerDescriptor createStandalone(InitialLdapContext ctx, TopologyCacheFilter filter) throws NamingException {
        ServerDescriptor desc = new ServerDescriptor();
        ServerDescriptor.updateLdapConfiguration(desc, ctx, filter);
        ServerDescriptor.updateAdminConnectorConfiguration(desc, ctx, filter);
        ServerDescriptor.updateJmxConfiguration(desc, ctx, filter);
        ServerDescriptor.updateReplicas(desc, ctx, filter);
        ServerDescriptor.updateReplication(desc, ctx, filter);
        ServerDescriptor.updatePublicKeyCertificate(desc, ctx, filter);
        ServerDescriptor.updateMiscellaneous(desc, ctx, filter);
        desc.serverProperties.put(ServerProperty.HOST_NAME, ConnectionUtils.getHostName(ctx));
        return desc;
    }

    private static void updateLdapConfiguration(ServerDescriptor desc, InitialLdapContext ctx, TopologyCacheFilter cacheFilter) throws NamingException {
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(new String[]{"ds-cfg-enabled", "ds-cfg-listen-address", "ds-cfg-listen-port", "ds-cfg-use-ssl", "ds-cfg-allow-start-tls", "objectclass"});
        String filter = "(objectclass=ds-cfg-ldap-connection-handler)";
        LdapName jndiName = new LdapName("cn=config");
        NamingEnumeration<SearchResult> listeners = ctx.search((Name)jndiName, filter, ctls);
        ArrayList<Integer> ldapPorts = new ArrayList<Integer>();
        ArrayList<Integer> ldapsPorts = new ArrayList<Integer>();
        ArrayList<Boolean> ldapEnabled = new ArrayList<Boolean>();
        ArrayList<Boolean> ldapsEnabled = new ArrayList<Boolean>();
        ArrayList<Boolean> startTLSEnabled = new ArrayList<Boolean>();
        desc.serverProperties.put(ServerProperty.LDAP_PORT, ldapPorts);
        desc.serverProperties.put(ServerProperty.LDAPS_PORT, ldapsPorts);
        desc.serverProperties.put(ServerProperty.LDAP_ENABLED, ldapEnabled);
        desc.serverProperties.put(ServerProperty.LDAPS_ENABLED, ldapsEnabled);
        desc.serverProperties.put(ServerProperty.STARTTLS_ENABLED, startTLSEnabled);
        while (listeners.hasMore()) {
            SearchResult sr = listeners.next();
            String port = ServerDescriptor.getFirstValue(sr, "ds-cfg-listen-port");
            boolean isSecure = "true".equalsIgnoreCase(ServerDescriptor.getFirstValue(sr, "ds-cfg-use-ssl"));
            boolean enabled = "true".equalsIgnoreCase(ServerDescriptor.getFirstValue(sr, "ds-cfg-enabled"));
            if (isSecure) {
                ldapsPorts.add(new Integer(port));
                ldapsEnabled.add(enabled);
                continue;
            }
            ldapPorts.add(new Integer(port));
            ldapEnabled.add(enabled);
            enabled = "true".equalsIgnoreCase(ServerDescriptor.getFirstValue(sr, "ds-cfg-allow-start-tls"));
            startTLSEnabled.add(enabled);
        }
    }

    private static void updateAdminConnectorConfiguration(ServerDescriptor desc, InitialLdapContext ctx, TopologyCacheFilter cacheFilter) throws NamingException {
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(new String[]{"ds-cfg-listen-port", "objectclass"});
        String filter = "(objectclass=ds-cfg-administration-connector)";
        LdapName jndiName = new LdapName("cn=config");
        NamingEnumeration<SearchResult> listeners = ctx.search((Name)jndiName, filter, ctls);
        Integer adminConnectorPort = null;
        if (listeners.hasMore()) {
            SearchResult sr = listeners.next();
            String port = ServerDescriptor.getFirstValue(sr, "ds-cfg-listen-port");
            adminConnectorPort = new Integer(port);
        }
        ArrayList<Integer> adminPorts = new ArrayList<Integer>();
        ArrayList<Boolean> adminEnabled = new ArrayList<Boolean>();
        if (adminConnectorPort != null) {
            adminPorts.add(adminConnectorPort);
            adminEnabled.add(Boolean.TRUE);
        }
        desc.serverProperties.put(ServerProperty.ADMIN_PORT, adminPorts);
        desc.serverProperties.put(ServerProperty.ADMIN_ENABLED, adminEnabled);
    }

    private static void updateJmxConfiguration(ServerDescriptor desc, InitialLdapContext ctx, TopologyCacheFilter cacheFilter) throws NamingException {
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(new String[]{"ds-cfg-enabled", "ds-cfg-listen-address", "ds-cfg-listen-port", "ds-cfg-use-ssl", "objectclass"});
        String filter = "(objectclass=ds-cfg-jmx-connection-handler)";
        LdapName jndiName = new LdapName("cn=config");
        NamingEnumeration<SearchResult> listeners = ctx.search((Name)jndiName, filter, ctls);
        ArrayList<Integer> jmxPorts = new ArrayList<Integer>();
        ArrayList<Integer> jmxsPorts = new ArrayList<Integer>();
        ArrayList<Boolean> jmxEnabled = new ArrayList<Boolean>();
        ArrayList<Boolean> jmxsEnabled = new ArrayList<Boolean>();
        desc.serverProperties.put(ServerProperty.JMX_PORT, jmxPorts);
        desc.serverProperties.put(ServerProperty.JMXS_PORT, jmxsPorts);
        desc.serverProperties.put(ServerProperty.JMX_ENABLED, jmxEnabled);
        desc.serverProperties.put(ServerProperty.JMXS_ENABLED, jmxsEnabled);
        while (listeners.hasMore()) {
            SearchResult sr = listeners.next();
            String port = ServerDescriptor.getFirstValue(sr, "ds-cfg-listen-port");
            boolean isSecure = "true".equalsIgnoreCase(ServerDescriptor.getFirstValue(sr, "ds-cfg-use-ssl"));
            boolean enabled = "true".equalsIgnoreCase(ServerDescriptor.getFirstValue(sr, "ds-cfg-enabled"));
            if (isSecure) {
                jmxsPorts.add(new Integer(port));
                jmxsEnabled.add(enabled);
                continue;
            }
            jmxPorts.add(new Integer(port));
            jmxEnabled.add(enabled);
        }
    }

    private static void updateReplicas(ServerDescriptor desc, InitialLdapContext ctx, TopologyCacheFilter cacheFilter) throws NamingException {
        if (!cacheFilter.searchBaseDNInformation()) {
            return;
        }
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(new String[]{"ds-cfg-base-dn", "ds-cfg-backend-id"});
        String filter = "(objectclass=ds-cfg-backend)";
        LdapName jndiName = new LdapName("cn=config");
        NamingEnumeration<SearchResult> databases = ctx.search((Name)jndiName, filter, ctls);
        while (databases.hasMore()) {
            SearchResult sr = databases.next();
            String id = ServerDescriptor.getFirstValue(sr, "ds-cfg-backend-id");
            if (ServerDescriptor.isConfigBackend(id) && !ServerDescriptor.isSchemaBackend(id)) continue;
            Set<String> baseDns = ServerDescriptor.getValues(sr, "ds-cfg-base-dn");
            Set<String> entries = cacheFilter.searchMonitoringInformation() ? ServerDescriptor.getBaseDNEntryCount(ctx, id) : new HashSet<String>();
            Set<ReplicaDescriptor> replicas = desc.getReplicas();
            for (String baseDn : baseDns) {
                boolean addReplica = cacheFilter.searchAllBaseDNs();
                if (!addReplica) {
                    String dn;
                    Iterator<String> i$ = cacheFilter.getBaseDNsToSearch().iterator();
                    while (i$.hasNext() && !(addReplica = Utils.areDnsEqual(dn = i$.next(), baseDn))) {
                    }
                }
                if (!addReplica) continue;
                SuffixDescriptor suffix = new SuffixDescriptor();
                suffix.setDN(baseDn);
                ReplicaDescriptor replica = new ReplicaDescriptor();
                replica.setServer(desc);
                replicas.add(replica);
                HashSet<ReplicaDescriptor> r = new HashSet<ReplicaDescriptor>();
                r.add(replica);
                suffix.setReplicas(r);
                replica.setSuffix(suffix);
                int nEntries = -1;
                for (String s : entries) {
                    String dn;
                    int index = s.indexOf(" ");
                    if (index == -1 || !Utils.areDnsEqual(baseDn, dn = s.substring(index + 1))) continue;
                    try {
                        nEntries = Integer.parseInt(s.substring(0, index));
                    }
                    catch (Throwable t) {}
                    break;
                }
                replica.setEntries(nEntries);
            }
            desc.setReplicas(replicas);
        }
    }

    private static void updateReplication(ServerDescriptor desc, InitialLdapContext ctx, TopologyCacheFilter cacheFilter) throws NamingException {
        SearchResult sr;
        NamingEnumeration<SearchResult> syncProviders;
        boolean replicationEnabled = false;
        boolean oneDomainReplicated = false;
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(0);
        ctls.setReturningAttributes(new String[]{"ds-cfg-enabled"});
        String filter = "(objectclass=ds-cfg-synchronization-provider)";
        LdapName jndiName = new LdapName("cn=Multimaster Synchronization,cn=Synchronization Providers,cn=config");
        try {
            syncProviders = ctx.search((Name)jndiName, filter, ctls);
            while (syncProviders.hasMore()) {
                sr = syncProviders.next();
                if (!"true".equalsIgnoreCase(ServerDescriptor.getFirstValue(sr, "ds-cfg-enabled"))) continue;
                replicationEnabled = true;
            }
        }
        catch (NameNotFoundException nse) {
            // empty catch block
        }
        desc.serverProperties.put(ServerProperty.IS_REPLICATION_ENABLED, replicationEnabled ? Boolean.TRUE : Boolean.FALSE);
        if (cacheFilter.searchBaseDNInformation()) {
            ctls = new SearchControls();
            ctls.setSearchScope(2);
            ctls.setReturningAttributes(new String[]{"ds-cfg-base-dn", "ds-cfg-replication-server", "ds-cfg-server-id"});
            filter = "(objectclass=ds-cfg-replication-domain)";
            jndiName = new LdapName("cn=Multimaster Synchronization,cn=Synchronization Providers,cn=config");
            try {
                syncProviders = ctx.search((Name)jndiName, filter, ctls);
                while (syncProviders.hasMore()) {
                    sr = syncProviders.next();
                    int id = Integer.parseInt(ServerDescriptor.getFirstValue(sr, "ds-cfg-server-id"));
                    Set<String> replicationServers = ServerDescriptor.getValues(sr, "ds-cfg-replication-server");
                    Set<String> dns = ServerDescriptor.getValues(sr, "ds-cfg-base-dn");
                    oneDomainReplicated = dns.size() > 0;
                    for (String dn : dns) {
                        for (ReplicaDescriptor replica : desc.getReplicas()) {
                            if (!ServerDescriptor.areDnsEqual(replica.getSuffix().getDN(), dn)) continue;
                            replica.setReplicationId(id);
                            LinkedHashSet<String> repServers = new LinkedHashSet<String>();
                            for (String s : replicationServers) {
                                repServers.add(s.toLowerCase());
                            }
                            replica.setReplicationServers(repServers);
                        }
                    }
                }
            }
            catch (NameNotFoundException nse) {
                // empty catch block
            }
        }
        ctls = new SearchControls();
        ctls.setSearchScope(0);
        ctls.setReturningAttributes(new String[]{"ds-cfg-replication-port", "ds-cfg-replication-server", "ds-cfg-replication-server-id"});
        filter = "(objectclass=ds-cfg-replication-server)";
        jndiName = new LdapName("cn=Replication Server,cn=Multimaster Synchronization,cn=Synchronization Providers,cn=config");
        desc.serverProperties.put(ServerProperty.IS_REPLICATION_SERVER, Boolean.FALSE);
        try {
            NamingEnumeration<SearchResult> entries = ctx.search((Name)jndiName, filter, ctls);
            while (entries.hasMore()) {
                sr = entries.next();
                desc.serverProperties.put(ServerProperty.IS_REPLICATION_SERVER, Boolean.TRUE);
                String v = ServerDescriptor.getFirstValue(sr, "ds-cfg-replication-port");
                desc.serverProperties.put(ServerProperty.REPLICATION_SERVER_PORT, Integer.parseInt(v));
                v = ServerDescriptor.getFirstValue(sr, "ds-cfg-replication-server-id");
                desc.serverProperties.put(ServerProperty.REPLICATION_SERVER_ID, Integer.parseInt(v));
                Set<String> values = ServerDescriptor.getValues(sr, "ds-cfg-replication-server");
                LinkedHashSet<String> repServers = new LinkedHashSet<String>();
                for (String s : values) {
                    repServers.add(s.toLowerCase());
                }
                desc.serverProperties.put(ServerProperty.EXTERNAL_REPLICATION_SERVERS, repServers);
            }
        }
        catch (NameNotFoundException nse) {
            // empty catch block
        }
        if (cacheFilter.searchMonitoringInformation()) {
            ctls = new SearchControls();
            ctls.setSearchScope(1);
            ctls.setReturningAttributes(new String[]{"approx-older-change-not-synchronized-millis", "missing-changes", "base-dn", "server-id"});
            filter = "(missing-changes=*)";
            jndiName = new LdapName("cn=monitor");
            if (oneDomainReplicated) {
                try {
                    NamingEnumeration<SearchResult> monitorEntries = ctx.search((Name)jndiName, filter, ctls);
                    while (monitorEntries.hasMore()) {
                        sr = monitorEntries.next();
                        String dn = ServerDescriptor.getFirstValue(sr, "base-dn");
                        int replicaId = -1;
                        try {
                            replicaId = new Integer(ServerDescriptor.getFirstValue(sr, "server-id"));
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        for (ReplicaDescriptor replica : desc.getReplicas()) {
                            if (!Utils.areDnsEqual(dn, replica.getSuffix().getDN()) || !replica.isReplicated() || replica.getReplicationId() != replicaId) continue;
                            try {
                                replica.setAgeOfOldestMissingChange(new Long(ServerDescriptor.getFirstValue(sr, "approx-older-change-not-synchronized-millis")));
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                            try {
                                replica.setMissingChanges(new Integer(ServerDescriptor.getFirstValue(sr, "missing-changes")));
                            }
                            catch (Throwable t) {}
                        }
                    }
                }
                catch (NameNotFoundException nse) {
                    // empty catch block
                }
            }
        }
        boolean replicationSecure = false;
        if (replicationEnabled) {
            ctls = new SearchControls();
            ctls.setSearchScope(0);
            ctls.setReturningAttributes(new String[]{"ds-cfg-ssl-encryption"});
            filter = "(objectclass=ds-cfg-crypto-manager)";
            jndiName = new LdapName("cn=Crypto Manager,cn=config");
            NamingEnumeration<SearchResult> entries = ctx.search((Name)jndiName, filter, ctls);
            while (entries.hasMore()) {
                SearchResult sr2 = entries.next();
                String v = ServerDescriptor.getFirstValue(sr2, "ds-cfg-ssl-encryption");
                replicationSecure = "true".equalsIgnoreCase(v);
            }
        }
        desc.serverProperties.put(ServerProperty.IS_REPLICATION_SECURE, replicationSecure ? Boolean.TRUE : Boolean.FALSE);
    }

    private static void updatePublicKeyCertificate(ServerDescriptor desc, InitialLdapContext ctx, TopologyCacheFilter filter) throws NamingException {
        String dnStr = "ds-cfg-key-id=ads-certificate,cn=ads-truststore";
        LdapName dn = new LdapName("ds-cfg-key-id=ads-certificate,cn=ads-truststore");
        for (int i = 0; i < 2; ++i) {
            try {
                SearchControls searchControls = new SearchControls();
                searchControls.setSearchScope(0);
                String[] attrIDs = new String[]{"ds-cfg-public-key-certificate;binary"};
                searchControls.setReturningAttributes(attrIDs);
                SearchResult certEntry = ctx.search((Name)dn, "(objectclass=ds-cfg-instance-key)", searchControls).next();
                Attribute certAttr = certEntry.getAttributes().get(attrIDs[0]);
                if (null == certAttr) break;
                desc.serverProperties.put(ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE, certAttr.get());
                break;
            }
            catch (NameNotFoundException x) {
                if (0 != i) {
                    throw x;
                }
                BasicAttributes attrs = new BasicAttributes();
                BasicAttribute oc = new BasicAttribute("objectclass");
                oc.add("top");
                oc.add("ds-cfg-self-signed-cert-request");
                attrs.put(oc);
                ctx.createSubcontext(dn, (Attributes)attrs).close();
                continue;
            }
        }
    }

    private static void updateMiscellaneous(ServerDescriptor desc, InitialLdapContext ctx, TopologyCacheFilter cacheFilter) throws NamingException {
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(0);
        ctls.setReturningAttributes(new String[]{"ds-sync-generation-id"});
        String filter = "|(objectclass=*)(objectclass=ldapsubentry)";
        LdapName jndiName = new LdapName("cn=schema");
        NamingEnumeration<SearchResult> listeners = ctx.search((Name)jndiName, filter, ctls);
        while (listeners.hasMore()) {
            SearchResult sr = listeners.next();
            desc.serverProperties.put(ServerProperty.SCHEMA_GENERATION_ID, ServerDescriptor.getFirstValue(sr, "ds-sync-generation-id"));
        }
    }

    public static void seedAdsTrustStore(InitialLdapContext ctx, Map<String, byte[]> keyEntryMap) throws NamingException {
        String truststoreDnStr = "cn=ads-truststore";
        BasicAttribute oc = new BasicAttribute("objectclass");
        oc.add("top");
        oc.add("ds-cfg-instance-key");
        for (Map.Entry<String, byte[]> keyEntry : keyEntryMap.entrySet()) {
            BasicAttributes keyAttrs = new BasicAttributes();
            keyAttrs.put(oc);
            BasicAttribute rdnAttr = new BasicAttribute(ADSContext.ServerProperty.INSTANCE_KEY_ID.getAttributeName(), keyEntry.getKey());
            keyAttrs.put(rdnAttr);
            keyAttrs.put(new BasicAttribute(ADSContext.ServerProperty.INSTANCE_PUBLIC_KEY_CERTIFICATE.getAttributeName() + ";binary", keyEntry.getValue()));
            LdapName keyDn = new LdapName(rdnAttr.getID() + "=" + Rdn.escapeValue(rdnAttr.get()) + "," + "cn=ads-truststore");
            try {
                ctx.createSubcontext(keyDn, (Attributes)keyAttrs).close();
            }
            catch (NameAlreadyBoundException x) {
                ctx.destroySubcontext(keyDn);
                ctx.createSubcontext(keyDn, (Attributes)keyAttrs).close();
            }
        }
    }

    private static Set<String> getBaseDNEntryCount(InitialLdapContext ctx, String backendID) throws NamingException {
        LinkedHashSet<String> v = new LinkedHashSet<String>();
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(1);
        ctls.setReturningAttributes(new String[]{"ds-base-dn-entry-count"});
        String filter = "(ds-backend-id=" + backendID + ")";
        LdapName jndiName = new LdapName("cn=monitor");
        NamingEnumeration<SearchResult> listeners = ctx.search((Name)jndiName, filter, ctls);
        while (listeners.hasMore()) {
            SearchResult sr = listeners.next();
            v.addAll(ServerDescriptor.getValues(sr, "ds-base-dn-entry-count"));
        }
        return v;
    }

    private static String getFirstValue(SearchResult entry, String attrName) throws NamingException {
        return ConnectionUtils.getFirstValue(entry, attrName);
    }

    private static Set<String> getValues(SearchResult entry, String attrName) throws NamingException {
        return ConnectionUtils.getValues(entry, attrName);
    }

    private static boolean isConfigBackend(String id) {
        return "tasks".equalsIgnoreCase(id) || "schema".equalsIgnoreCase(id) || "config".equalsIgnoreCase(id) || "monitor".equalsIgnoreCase(id) || "backup".equalsIgnoreCase(id) || "ads-truststore".equalsIgnoreCase(id);
    }

    private static boolean isSchemaBackend(String id) {
        return "schema".equalsIgnoreCase(id);
    }

    private static boolean areDnsEqual(String dn1, String dn2) {
        boolean areDnsEqual = false;
        try {
            LdapName name1 = new LdapName(dn1);
            LdapName name2 = new LdapName(dn2);
            areDnsEqual = name1.equals(name2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return areDnsEqual;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ServerProperty {
        HOST_NAME,
        LDAP_PORT,
        LDAPS_PORT,
        ADMIN_PORT,
        LDAP_ENABLED,
        LDAPS_ENABLED,
        ADMIN_ENABLED,
        STARTTLS_ENABLED,
        JMX_PORT,
        JMXS_PORT,
        JMX_ENABLED,
        JMXS_ENABLED,
        REPLICATION_SERVER_PORT,
        IS_REPLICATION_SERVER,
        IS_REPLICATION_ENABLED,
        IS_REPLICATION_SECURE,
        EXTERNAL_REPLICATION_SERVERS,
        REPLICATION_SERVER_ID,
        INSTANCE_PUBLIC_KEY_CERTIFICATE,
        SCHEMA_GENERATION_ID;

    }
}

