/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.event;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;

public class ScrollPaneBorderListener
extends ComponentAdapter {
    private JScrollPane scroll;
    private Border emptyBorder = new EmptyBorder(0, 0, 0, 0);
    private Border etchedBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, ColorAndFontConstants.defaultBorderColor);

    public ScrollPaneBorderListener(JScrollPane scroll, boolean addTopBorder) {
        this.scroll = scroll;
        scroll.getHorizontalScrollBar().addComponentListener(this);
        scroll.getVerticalScrollBar().addComponentListener(this);
        if (addTopBorder) {
            this.etchedBorder = BorderFactory.createMatteBorder(1, 0, 1, 0, ColorAndFontConstants.defaultBorderColor);
        }
    }

    public ScrollPaneBorderListener(JScrollPane scroll) {
        this(scroll, false);
    }

    public void componentShown(ComponentEvent ev) {
        this.updateBorder();
    }

    public void componentHidden(ComponentEvent ev) {
        this.updateBorder();
    }

    public void updateBorder() {
        boolean displayBorder;
        boolean bl = displayBorder = this.scroll.getVerticalScrollBar().isVisible() || this.scroll.getHorizontalScrollBar().isVisible();
        if (displayBorder) {
            this.scroll.setBorder(this.etchedBorder);
        } else {
            this.scroll.setBorder(this.emptyBorder);
        }
    }
}

