/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.naming.ldap.InitialLdapContext;
import javax.swing.SwingUtilities;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.BaseDNDescriptor;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.util.ConfigReader;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.client.ldap.JNDIDirContextAdaptor;
import org.opends.server.admin.client.ldap.LDAPManagementContext;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.client.LocalDBBackendCfgClient;
import org.opends.server.admin.std.client.ReplicationDomainCfgClient;
import org.opends.server.admin.std.client.ReplicationSynchronizationProviderCfgClient;
import org.opends.server.admin.std.client.RootCfgClient;
import org.opends.server.admin.std.server.ReplicationDomainCfg;
import org.opends.server.admin.std.server.ReplicationSynchronizationProviderCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.DNConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.types.DN;
import org.opends.server.types.OpenDsException;
import org.opends.server.util.cli.CommandBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteBaseDNAndBackendTask
extends Task {
    private Set<String> backendSet;
    private Map<String, Set<BaseDNDescriptor>> baseDNsToDelete = new HashMap<String, Set<BaseDNDescriptor>>();
    private ArrayList<BackendDescriptor> backendsToDelete = new ArrayList();

    public DeleteBaseDNAndBackendTask(ControlPanelInfo info, ProgressDialog dlg, Collection<BackendDescriptor> backendsToDelete, Collection<BaseDNDescriptor> baseDNsToDelete) {
        super(info, dlg);
        this.backendSet = new HashSet<String>();
        for (BackendDescriptor backend : backendsToDelete) {
            this.backendSet.add(backend.getBackendID());
        }
        for (BaseDNDescriptor baseDN : baseDNsToDelete) {
            this.backendSet.add(baseDN.getBackend().getBackendID());
        }
        for (BaseDNDescriptor baseDN : baseDNsToDelete) {
            String backendID = baseDN.getBackend().getBackendID();
            Set<BaseDNDescriptor> set = this.baseDNsToDelete.get(backendID);
            if (set == null) {
                set = new HashSet<BaseDNDescriptor>();
                this.baseDNsToDelete.put(backendID, set);
            }
            set.add(baseDN);
        }
        ArrayList<String> indirectBackendsToDelete = new ArrayList<String>();
        for (Set<BaseDNDescriptor> set : this.baseDNsToDelete.values()) {
            BackendDescriptor backend = set.iterator().next().getBackend();
            if (set.size() != backend.getBaseDns().size()) continue;
            indirectBackendsToDelete.add(backend.getBackendID());
            this.backendsToDelete.add(backend);
        }
        for (String backendID : indirectBackendsToDelete) {
            this.baseDNsToDelete.remove(backendID);
        }
        this.backendsToDelete.addAll(backendsToDelete);
    }

    @Override
    public Task.Type getType() {
        if (this.baseDNsToDelete.size() > 0) {
            return Task.Type.DELETE_BASEDN;
        }
        return Task.Type.DELETE_BACKEND;
    }

    @Override
    public Set<String> getBackends() {
        return this.backendSet;
    }

    @Override
    public Message getTaskDescription() {
        StringBuilder sb = new StringBuilder();
        if (this.baseDNsToDelete.size() > 0) {
            ArrayList<String> dns = new ArrayList<String>();
            for (Set<BaseDNDescriptor> set : this.baseDNsToDelete.values()) {
                for (BaseDNDescriptor baseDN : set) {
                    dns.add(baseDN.getDn().toString());
                }
            }
            if (dns.size() == 1) {
                String dn = (String)dns.iterator().next();
                sb.append(AdminToolMessages.INFO_CTRL_PANEL_DELETE_BASE_DN_DESCRIPTION.get(dn));
            } else {
                ArrayList<String> quotedDns = new ArrayList<String>();
                for (String dn : dns) {
                    quotedDns.add("'" + dn + "'");
                }
                sb.append(AdminToolMessages.INFO_CTRL_PANEL_DELETE_BASE_DNS_DESCRIPTION.get(Utilities.getStringFromCollection(quotedDns, ", ")));
            }
        }
        if (this.backendsToDelete.size() > 0) {
            if (sb.length() > 0) {
                sb.append("  ");
            }
            if (this.backendsToDelete.size() == 1) {
                sb.append(AdminToolMessages.INFO_CTRL_PANEL_DELETE_BACKEND_DESCRIPTION.get(this.backendsToDelete.iterator().next().getBackendID()));
            } else {
                ArrayList<String> ids = new ArrayList<String>();
                for (BackendDescriptor backend : this.backendsToDelete) {
                    ids.add(backend.getBackendID());
                }
                sb.append(AdminToolMessages.INFO_CTRL_PANEL_DELETE_BACKENDS_DESCRIPTION.get(Utilities.getStringFromCollection(ids, ", ")));
            }
        }
        return Message.raw(sb.toString(), new Object[0]);
    }

    @Override
    public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
        boolean canLaunch = true;
        if (this.state == Task.State.RUNNING) {
            TreeSet<String> backends = new TreeSet<String>(taskToBeLaunched.getBackends());
            backends.retainAll(this.getBackends());
            if (backends.size() > 0) {
                incompatibilityReasons.add(this.getIncompatibilityMessage(this, taskToBeLaunched));
                canLaunch = false;
            }
        }
        return canLaunch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConfiguration() throws OpenDsException {
        boolean configHandlerUpdated = false;
        final int totalNumber = this.baseDNsToDelete.size() + this.backendsToDelete.size();
        int numberDeleted = 0;
        try {
            int fNumberDeleted;
            if (!this.isServerRunning()) {
                configHandlerUpdated = true;
                this.getInfo().stopPooling();
                if (this.getInfo().mustDeregisterConfig()) {
                    DirectoryServer.deregisterBaseDN(DN.decode("cn=config"));
                }
                DirectoryServer.getInstance().initializeConfiguration(ConfigFileHandler.class.getName(), ConfigReader.configFile);
                this.getInfo().setMustDeregisterConfig(true);
            }
            boolean isFirst = true;
            for (final Set<BaseDNDescriptor> baseDNs : this.baseDNsToDelete.values()) {
                if (!isFirst) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DeleteBaseDNAndBackendTask.this.getProgressDialog().appendProgressHtml("<br><br>");
                        }
                    });
                }
                isFirst = false;
                for (BaseDNDescriptor baseDN : baseDNs) {
                    this.disableReplicationIfRequired(baseDN);
                }
                if (this.isServerRunning()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            StringBuilder sb = new StringBuilder();
                            sb.append(DeleteBaseDNAndBackendTask.this.getConfigCommandLinePath(baseDNs));
                            List<String> args = DeleteBaseDNAndBackendTask.this.getObfuscatedCommandLineArguments(DeleteBaseDNAndBackendTask.this.getDSConfigCommandLineArguments(baseDNs));
                            args.removeAll(DeleteBaseDNAndBackendTask.this.getConfigCommandLineArguments());
                            for (String arg : args) {
                                sb.append(" " + CommandBuilder.escapeValue(arg));
                            }
                            DeleteBaseDNAndBackendTask.this.getProgressDialog().appendProgressHtml(Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_DELETE_BASE_DN.get() + "<br><b>" + sb.toString() + "</b><br><br>", ColorAndFontConstants.progressFont));
                        }
                    });
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (baseDNs.size() == 1) {
                            String dn = ((BaseDNDescriptor)baseDNs.iterator().next()).getDn().toString();
                            DeleteBaseDNAndBackendTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_CTRL_PANEL_DELETING_BASE_DN.get(dn), ColorAndFontConstants.progressFont));
                        } else {
                            ArrayList<String> dns = new ArrayList<String>();
                            for (BaseDNDescriptor baseDN : baseDNs) {
                                dns.add("'" + baseDN.getDn().toString() + "'");
                            }
                            DeleteBaseDNAndBackendTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_CTRL_PANEL_DELETING_BASE_DNS.get(Utilities.getStringFromCollection(dns, ", ")), ColorAndFontConstants.progressFont));
                        }
                    }
                });
                if (this.isServerRunning()) {
                    this.deleteBaseDNs(this.getInfo().getDirContext(), baseDNs);
                } else {
                    this.deleteBaseDNs(baseDNs);
                }
                fNumberDeleted = ++numberDeleted;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DeleteBaseDNAndBackendTask.this.getProgressDialog().getProgressBar().setIndeterminate(false);
                        DeleteBaseDNAndBackendTask.this.getProgressDialog().getProgressBar().setValue(fNumberDeleted * 100 / totalNumber);
                        DeleteBaseDNAndBackendTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressDone(ColorAndFontConstants.progressFont));
                    }
                });
            }
            for (final BackendDescriptor backend : this.backendsToDelete) {
                if (!isFirst) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DeleteBaseDNAndBackendTask.this.getProgressDialog().appendProgressHtml("<br><br>");
                        }
                    });
                }
                for (BaseDNDescriptor baseDN : backend.getBaseDns()) {
                    this.disableReplicationIfRequired(baseDN);
                }
                isFirst = false;
                if (this.isServerRunning()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            StringBuilder sb = new StringBuilder();
                            sb.append(DeleteBaseDNAndBackendTask.this.getConfigCommandLinePath(backend));
                            List<String> args = DeleteBaseDNAndBackendTask.this.getObfuscatedCommandLineArguments(DeleteBaseDNAndBackendTask.this.getDSConfigCommandLineArguments(backend));
                            args.removeAll(DeleteBaseDNAndBackendTask.this.getConfigCommandLineArguments());
                            for (String arg : args) {
                                sb.append(" " + CommandBuilder.escapeValue(arg));
                            }
                            DeleteBaseDNAndBackendTask.this.getProgressDialog().appendProgressHtml(Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_DELETE_BACKEND.get() + "<br><b>" + sb.toString() + "</b><br><br>", ColorAndFontConstants.progressFont));
                        }
                    });
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DeleteBaseDNAndBackendTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_CTRL_PANEL_DELETING_BACKEND.get(backend.getBackendID()), ColorAndFontConstants.progressFont));
                    }
                });
                if (this.isServerRunning()) {
                    this.deleteBackend(this.getInfo().getDirContext(), backend);
                } else {
                    this.deleteBackend(backend);
                }
                fNumberDeleted = ++numberDeleted;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DeleteBaseDNAndBackendTask.this.getProgressDialog().getProgressBar().setIndeterminate(false);
                        DeleteBaseDNAndBackendTask.this.getProgressDialog().getProgressBar().setValue(fNumberDeleted * 100 / totalNumber);
                        DeleteBaseDNAndBackendTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressDone(ColorAndFontConstants.progressFont));
                    }
                });
            }
        }
        finally {
            if (configHandlerUpdated) {
                DirectoryServer.getInstance().initializeConfiguration(ConfigReader.configClassName, ConfigReader.configFile);
                this.getInfo().startPooling(20000L);
            }
        }
    }

    private String getDN(BackendDescriptor backend) {
        return Utilities.getRDNString("ds-cfg-backend-id", backend.getBackendID()) + ",cn=Backends,cn=config";
    }

    private void deleteBaseDNs(Set<BaseDNDescriptor> baseDNs) throws OpenDsException {
        BackendDescriptor backend = baseDNs.iterator().next().getBackend();
        TreeSet<DN> oldBaseDNs = new TreeSet<DN>();
        for (BaseDNDescriptor baseDN : backend.getBaseDns()) {
            oldBaseDNs.add(baseDN.getDn());
        }
        LinkedList<DN> newBaseDNs = new LinkedList<DN>();
        newBaseDNs.addAll(oldBaseDNs);
        ArrayList<DN> dnsToRemove = new ArrayList<DN>();
        for (BaseDNDescriptor baseDN : baseDNs) {
            dnsToRemove.add(baseDN.getDn());
        }
        newBaseDNs.removeAll(dnsToRemove);
        String backendName = backend.getBackendID();
        String dn = Utilities.getRDNString("ds-cfg-backend-id", backendName) + ",cn=Backends,cn=config";
        ConfigEntry configEntry = DirectoryServer.getConfigHandler().getConfigEntry(DN.decode(dn));
        DNConfigAttribute baseDNAttr = new DNConfigAttribute("ds-cfg-base-dn", ConfigMessages.INFO_CONFIG_BACKEND_ATTR_DESCRIPTION_BASE_DNS.get(), true, true, false, newBaseDNs);
        configEntry.putConfigAttribute(baseDNAttr);
        DirectoryServer.getConfigHandler().writeUpdatedConfig();
    }

    private void deleteBaseDNs(InitialLdapContext ctx, Set<BaseDNDescriptor> baseDNs) throws OpenDsException {
        ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
        RootCfgClient root = mCtx.getRootConfiguration();
        LocalDBBackendCfgClient backend = (LocalDBBackendCfgClient)root.getBackend(baseDNs.iterator().next().getBackend().getBackendID());
        SortedSet<DN> oldBaseDNs = backend.getBaseDN();
        TreeSet<DN> newBaseDNs = new TreeSet<DN>();
        newBaseDNs.addAll(oldBaseDNs);
        ArrayList<DN> dnsToRemove = new ArrayList<DN>();
        for (BaseDNDescriptor baseDN : baseDNs) {
            dnsToRemove.add(baseDN.getDn());
        }
        newBaseDNs.removeAll(dnsToRemove);
        backend.setBaseDN(newBaseDNs);
        backend.commit();
    }

    private void deleteBackend(BackendDescriptor backend) throws OpenDsException {
        String dn = this.getDN(backend);
        Utilities.deleteConfigSubtree(DirectoryServer.getConfigHandler(), DN.decode(dn));
    }

    private void deleteBackend(InitialLdapContext ctx, BackendDescriptor backend) throws OpenDsException {
        ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
        RootCfgClient root = mCtx.getRootConfiguration();
        root.removeBackend(backend.getBackendID());
        root.commit();
    }

    @Override
    protected String getCommandLinePath() {
        return null;
    }

    protected ArrayList<String> getCommandLineArguments() {
        return new ArrayList<String>();
    }

    private String getConfigCommandLinePath(BackendDescriptor backend) {
        if (this.isServerRunning()) {
            return this.getCommandLinePath("dsconfig");
        }
        return null;
    }

    private String getConfigCommandLinePath(Set<BaseDNDescriptor> baseDNs) {
        if (this.isServerRunning()) {
            return this.getCommandLinePath("dsconfig");
        }
        return null;
    }

    @Override
    public void runTask() {
        this.state = Task.State.RUNNING;
        this.lastException = null;
        try {
            this.updateConfiguration();
            this.state = Task.State.FINISHED_SUCCESSFULLY;
        }
        catch (Throwable t) {
            this.lastException = t;
            this.state = Task.State.FINISHED_WITH_ERROR;
        }
    }

    private ArrayList<String> getDSConfigCommandLineArguments(Set<BaseDNDescriptor> baseDNs) {
        ArrayList<String> args = new ArrayList<String>();
        if (this.isServerRunning()) {
            args.add("set-backend-prop");
            args.add("--backend-name");
            args.add(baseDNs.iterator().next().getBackend().getBackendID());
            args.add("--remove");
            for (BaseDNDescriptor baseDN : baseDNs) {
                args.add("base-dn:" + baseDN.getDn().toString());
            }
            args.addAll(this.getConnectionCommandLineArguments());
            args.add("--no-prompt");
        }
        return args;
    }

    private ArrayList<String> getDSConfigCommandLineArguments(BackendDescriptor backend) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("delete-backend");
        args.add("--backend-name");
        args.add(backend.getBackendID());
        args.addAll(this.getConnectionCommandLineArguments());
        args.add("--no-prompt");
        return args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableReplicationIfRequired(BaseDNDescriptor baseDN) throws OpenDsException {
        block12: {
            String[] domainName;
            block11: {
                if (baseDN.getType() != BaseDNDescriptor.Type.REPLICATED) break block12;
                domainName = new String[]{null};
                try {
                    String[] domains;
                    if (this.isServerRunning()) {
                        String[] domains2;
                        InitialLdapContext ctx = this.getInfo().getDirContext();
                        ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
                        RootCfgClient root = mCtx.getRootConfiguration();
                        ReplicationSynchronizationProviderCfgClient sync = null;
                        try {
                            sync = (ReplicationSynchronizationProviderCfgClient)root.getSynchronizationProvider("Multimaster Synchronization");
                        }
                        catch (OpenDsException oe) {
                            // empty catch block
                        }
                        if (sync == null || (domains2 = sync.listReplicationDomains()) == null) break block11;
                        for (int i = 0; i < domains2.length; ++i) {
                            ReplicationDomainCfgClient domain = sync.getReplicationDomain(domains2[i]);
                            DN dn = domain.getBaseDN();
                            if (!dn.equals(baseDN.getDn())) continue;
                            domainName[0] = domains2[i];
                            sync.removeReplicationDomain(domains2[i]);
                            sync.commit();
                            break block11;
                        }
                        break block11;
                    }
                    RootCfg root = ServerManagementContext.getInstance().getRootConfiguration();
                    ReplicationSynchronizationProviderCfg sync = null;
                    try {
                        sync = (ReplicationSynchronizationProviderCfg)root.getSynchronizationProvider("Multimaster Synchronization");
                    }
                    catch (OpenDsException oe) {
                        // empty catch block
                    }
                    if (sync == null || (domains = sync.listReplicationDomains()) == null) break block11;
                    for (int i = 0; i < domains.length; ++i) {
                        ReplicationDomainCfg domain = sync.getReplicationDomain(domains[i]);
                        DN dn = domain.getBaseDN();
                        if (!dn.equals(baseDN.getDn())) continue;
                        domainName[0] = domains[i];
                        DN entryDN = domain.dn();
                        Utilities.deleteConfigSubtree(DirectoryServer.getConfigHandler(), entryDN);
                        break;
                    }
                }
                catch (Throwable throwable) {
                    if (this.isServerRunning() && domainName[0] != null) {
                        SwingUtilities.invokeLater(new Runnable(baseDN, domainName){
                            final /* synthetic */ BaseDNDescriptor val$baseDN;
                            final /* synthetic */ String[] val$domainName;
                            {
                                this.val$baseDN = baseDNDescriptor;
                                this.val$domainName = stringArray;
                            }

                            public void run() {
                                StringBuilder sb = new StringBuilder();
                                sb.append(DeleteBaseDNAndBackendTask.this.getConfigCommandLinePath(this.val$baseDN.getBackend()));
                                List<String> args = DeleteBaseDNAndBackendTask.this.getObfuscatedCommandLineArguments(DeleteBaseDNAndBackendTask.this.getCommandLineArgumentsToDisableReplication(this.val$domainName[0]));
                                args.removeAll(DeleteBaseDNAndBackendTask.this.getConfigCommandLineArguments());
                                args.add(DeleteBaseDNAndBackendTask.this.getNoPropertiesFileArgument());
                                for (String arg : args) {
                                    sb.append(" " + CommandBuilder.escapeValue(arg));
                                }
                                DeleteBaseDNAndBackendTask.this.getProgressDialog().appendProgressHtml(Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_DELETE_DOMAIN.get(this.val$baseDN.getDn().toString()) + "<br><b>" + sb.toString() + "</b><br><br>", ColorAndFontConstants.progressFont));
                            }
                        });
                    }
                    SwingUtilities.invokeLater(new Runnable(baseDN){
                        final /* synthetic */ BaseDNDescriptor val$baseDN;
                        {
                            this.val$baseDN = baseDNDescriptor;
                        }

                        public void run() {
                            DeleteBaseDNAndBackendTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_CTRL_PANEL_DELETING_DOMAIN.get(this.val$baseDN.getDn().toString()), ColorAndFontConstants.progressFont));
                        }
                    });
                    throw throwable;
                }
            }
            if (this.isServerRunning() && domainName[0] != null) {
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DeleteBaseDNAndBackendTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressDone(ColorAndFontConstants.progressFont));
                }
            });
        }
    }

    private ArrayList<String> getCommandLineArgumentsToDisableReplication(String domainName) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("delete-replication-domain");
        args.add("--provider-name");
        args.add("Multimaster Synchronization");
        args.add("--domain-name");
        args.add(domainName);
        args.addAll(this.getConnectionCommandLineArguments());
        args.add("--no-prompt");
        return args;
    }
}

