/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.guitools.controlpanel.browser.BrowserController;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.BaseDNDescriptor;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.CustomSearchResult;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.nodes.BasicNode;
import org.opends.guitools.controlpanel.ui.nodes.BrowserNodeInfo;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.util.cli.CommandBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteEntryTask
extends Task {
    private Set<String> backendSet = new HashSet<String>();
    private DN lastDn;
    private int nDeleted = 0;
    private int nToDelete = -1;
    private BrowserController controller;
    private TreePath[] paths;
    private long lastProgressTime;
    private boolean equivalentCommandWithControlPrinted = false;
    private boolean equivalentCommandWithoutControlPrinted = false;
    private boolean useAdminCtx;

    public DeleteEntryTask(ControlPanelInfo info, ProgressDialog dlg, TreePath[] paths, BrowserController controller) {
        super(info, dlg);
        this.controller = controller;
        this.paths = paths;
        TreeSet<DN> entries = new TreeSet<DN>();
        boolean canPrecalculateNumberOfEntries = true;
        this.nToDelete = paths.length;
        for (TreePath path : paths) {
            BasicNode node = (BasicNode)path.getLastPathComponent();
            try {
                DN dn = DN.decode(node.getDN());
                entries.add(dn);
            }
            catch (DirectoryException de) {
                throw new IllegalStateException("Unexpected error parsing dn: " + node.getDN(), de);
            }
        }
        for (BackendDescriptor backend : info.getServerDescriptor().getBackends()) {
            block4: for (BaseDNDescriptor baseDN : backend.getBaseDns()) {
                for (DN dn : entries) {
                    if (!dn.isDescendantOf(baseDN.getDn())) continue;
                    this.backendSet.add(backend.getBackendID());
                    continue block4;
                }
            }
        }
        if (!canPrecalculateNumberOfEntries) {
            this.nToDelete = -1;
        }
    }

    @Override
    public Task.Type getType() {
        return Task.Type.DELETE_ENTRY;
    }

    @Override
    public Set<String> getBackends() {
        return this.backendSet;
    }

    @Override
    public Message getTaskDescription() {
        return AdminToolMessages.INFO_CTRL_PANEL_DELETE_ENTRY_TASK_DESCRIPTION.get();
    }

    @Override
    protected String getCommandLinePath() {
        return null;
    }

    protected ArrayList<String> getCommandLineArguments() {
        return new ArrayList<String>();
    }

    @Override
    public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
        boolean canLaunch = true;
        if (!this.isServerRunning() && this.state == Task.State.RUNNING) {
            TreeSet<String> backends = new TreeSet<String>(taskToBeLaunched.getBackends());
            backends.retainAll(this.getBackends());
            if (backends.size() > 0) {
                incompatibilityReasons.add(this.getIncompatibilityMessage(this, taskToBeLaunched));
                canLaunch = false;
            }
        }
        return canLaunch;
    }

    @Override
    public boolean regenerateDescriptor() {
        return false;
    }

    @Override
    public void runTask() {
        this.state = Task.State.RUNNING;
        this.lastException = null;
        ArrayList<DN> alreadyDeleted = new ArrayList<DN>();
        ArrayList<BrowserNodeInfo> toNotify = new ArrayList<BrowserNodeInfo>();
        try {
            for (TreePath path : this.paths) {
                BasicNode node = (BasicNode)path.getLastPathComponent();
                try {
                    DN dn = DN.decode(node.getDN());
                    boolean isDnDeleted = false;
                    for (DN deletedDn : alreadyDeleted) {
                        if (!dn.isDescendantOf(deletedDn)) continue;
                        isDnDeleted = true;
                        break;
                    }
                    if (isDnDeleted) continue;
                    InitialLdapContext ctx = this.controller.findConnectionForDisplayedEntry(node);
                    this.useAdminCtx = this.controller.isConfigurationNode(node);
                    if (node.getNumSubOrdinates() > 0) {
                        this.deleteSubtreeWithControl(ctx, dn, path, toNotify);
                    } else {
                        this.deleteSubtreeRecursively(ctx, dn, path, toNotify);
                    }
                    alreadyDeleted.add(dn);
                }
                catch (DirectoryException de) {
                    throw new IllegalStateException("Unexpected error parsing dn: " + node.getDN(), de);
                }
            }
            if (toNotify.size() > 0) {
                final ArrayList fToNotify = new ArrayList(toNotify);
                toNotify.clear();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DeleteEntryTask.this.notifyEntriesDeleted(fToNotify);
                    }
                });
            }
            this.state = Task.State.FINISHED_SUCCESSFULLY;
        }
        catch (Throwable t) {
            this.lastException = t;
            this.state = Task.State.FINISHED_WITH_ERROR;
        }
        if (this.nDeleted > 1) {
            this.getProgressDialog().appendProgressHtml(Utilities.applyFont("<br>" + AdminToolMessages.INFO_CTRL_PANEL_ENTRIES_DELETED.get(this.nDeleted), ColorAndFontConstants.progressFont));
        }
    }

    private void notifyEntriesDeleted(Collection<BrowserNodeInfo> deletedNodes) {
        TreePath pathToSelect = null;
        for (BrowserNodeInfo nodeInfo : deletedNodes) {
            TreePath parentPath = this.controller.notifyEntryDeleted(nodeInfo);
            if (pathToSelect != null) {
                if (parentPath.getPathCount() >= pathToSelect.getPathCount()) continue;
                pathToSelect = parentPath;
                continue;
            }
            pathToSelect = parentPath;
        }
        if (pathToSelect != null) {
            TreePath selectedPath = this.controller.getTree().getSelectionPath();
            if (selectedPath == null) {
                this.controller.getTree().setSelectionPath(pathToSelect);
            } else if (!selectedPath.equals(pathToSelect) && pathToSelect.getPathCount() < selectedPath.getPathCount()) {
                this.controller.getTree().setSelectionPath(pathToSelect);
            }
        }
    }

    private void deleteSubtreeRecursively(InitialLdapContext ctx, DN dnToRemove, TreePath path, ArrayList<BrowserNodeInfo> toNotify) throws NamingException, DirectoryException {
        boolean displayProgress;
        this.lastDn = dnToRemove;
        long t = System.currentTimeMillis();
        boolean bl = displayProgress = (this.nDeleted % 20 == 0 || t - this.lastProgressTime > 5000L) && this.nToDelete > 0 && this.nToDelete > this.nDeleted;
        if (displayProgress) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (!DeleteEntryTask.this.equivalentCommandWithoutControlPrinted) {
                        DeleteEntryTask.this.printEquivalentCommandToDelete(DeleteEntryTask.this.lastDn, false);
                        DeleteEntryTask.this.equivalentCommandWithoutControlPrinted = true;
                    }
                    DeleteEntryTask.this.getProgressDialog().setSummary(Message.raw(Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_DELETING_ENTRY_SUMMARY.get(DeleteEntryTask.this.lastDn.toString()).toString(), ColorAndFontConstants.defaultFont), new Object[0]));
                }
            });
        }
        try {
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(1);
            String filter = "(|(objectClass=*)(objectclass=ldapsubentry))";
            ctls.setReturningAttributes(new String[]{"dn"});
            NamingEnumeration<SearchResult> entryDNs = ctx.search(Utilities.getJNDIName(dnToRemove.toString()), filter, ctls);
            DN entryDNFound = dnToRemove;
            while (entryDNs.hasMore()) {
                SearchResult sr = entryDNs.next();
                if (sr.getName().equals("")) continue;
                CustomSearchResult res = new CustomSearchResult(sr, dnToRemove.toString());
                entryDNFound = DN.decode(res.getDN());
                this.deleteSubtreeRecursively(ctx, entryDNFound, null, toNotify);
            }
        }
        catch (NameNotFoundException nnfe) {
            // empty catch block
        }
        try {
            ctx.destroySubcontext(Utilities.getJNDIName(dnToRemove.toString()));
            if (path != null) {
                toNotify.add(this.controller.getNodeInfoFromPath(path));
            }
            ++this.nDeleted;
            if (displayProgress) {
                ArrayList<BrowserNodeInfo> fToNotify;
                this.lastProgressTime = t;
                if (toNotify.size() > 0) {
                    fToNotify = new ArrayList<BrowserNodeInfo>(toNotify);
                    toNotify.clear();
                } else {
                    fToNotify = null;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DeleteEntryTask.this.getProgressDialog().getProgressBar().setIndeterminate(false);
                        DeleteEntryTask.this.getProgressDialog().getProgressBar().setValue(100 * DeleteEntryTask.this.nDeleted / DeleteEntryTask.this.nToDelete);
                        if (fToNotify != null) {
                            DeleteEntryTask.this.notifyEntriesDeleted(fToNotify);
                        }
                    }
                });
            }
        }
        catch (NameNotFoundException nnfe) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSubtreeWithControl(InitialLdapContext ctx, DN dn, TreePath path, ArrayList<BrowserNodeInfo> toNotify) throws NamingException {
        ArrayList<BrowserNodeInfo> fToNotify;
        this.lastDn = dn;
        long t = System.currentTimeMillis();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!DeleteEntryTask.this.equivalentCommandWithControlPrinted) {
                    DeleteEntryTask.this.printEquivalentCommandToDelete(DeleteEntryTask.this.lastDn, true);
                    DeleteEntryTask.this.equivalentCommandWithControlPrinted = true;
                }
                DeleteEntryTask.this.getProgressDialog().setSummary(Message.raw(Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_DELETING_ENTRY_SUMMARY.get(DeleteEntryTask.this.lastDn.toString()).toString(), ColorAndFontConstants.defaultFont), new Object[0]));
            }
        });
        InitialContext ctx1 = null;
        try {
            ctx1 = ConnectionUtils.cloneInitialLdapContext(ctx, ConnectionUtils.getDefaultLDAPTimeout(), this.getInfo().getTrustManager(), null);
            Control[] ctls = new Control[]{new BasicControl(Utilities.SUBTREE_CTRL_OID)};
            ((InitialLdapContext)ctx1).setRequestControls(ctls);
            ctx1.destroySubcontext(Utilities.getJNDIName(dn.toString()));
        }
        finally {
            try {
                ctx1.close();
            }
            catch (Throwable th) {}
        }
        ++this.nDeleted;
        this.lastProgressTime = t;
        if (path != null) {
            toNotify.add(this.controller.getNodeInfoFromPath(path));
        }
        if (toNotify.size() > 0) {
            fToNotify = new ArrayList<BrowserNodeInfo>(toNotify);
            toNotify.clear();
        } else {
            fToNotify = null;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DeleteEntryTask.this.getProgressDialog().getProgressBar().setIndeterminate(false);
                DeleteEntryTask.this.getProgressDialog().getProgressBar().setValue(100 * DeleteEntryTask.this.nDeleted / DeleteEntryTask.this.nToDelete);
                if (fToNotify != null) {
                    DeleteEntryTask.this.notifyEntriesDeleted(fToNotify);
                }
            }
        });
    }

    private void printEquivalentCommandToDelete(DN dn, boolean usingControl) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getCommandLinePath("ldapdelete"));
        args.addAll(this.getObfuscatedCommandLineArguments(this.getConnectionCommandLineArguments(this.useAdminCtx, true)));
        args.add(this.getNoPropertiesFileArgument());
        if (usingControl) {
            args.add("-J");
            args.add(Utilities.SUBTREE_CTRL_OID);
        }
        args.add(dn.toString());
        StringBuilder sb = new StringBuilder();
        for (String arg : args) {
            sb.append(" " + CommandBuilder.escapeValue(arg));
        }
        this.getProgressDialog().appendProgressHtml(Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_DELETE_ENTRY.get(dn.toString()) + "<br><b>" + sb.toString() + "</b><br><br>", ColorAndFontConstants.progressFont));
    }
}

