/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.InitialLdapContext;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.opends.guitools.controlpanel.browser.BrowserController;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.BaseDNDescriptor;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.nodes.BasicNode;
import org.opends.guitools.controlpanel.ui.nodes.BrowserNodeInfo;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.types.DN;
import org.opends.server.types.OpenDsException;
import org.opends.server.util.cli.CommandBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResetUserPasswordTask
extends Task {
    private Set<String> backendSet = new HashSet<String>();
    private BasicNode node;
    private char[] newPassword;
    private BrowserController controller;
    private DN dn;
    private boolean useAdminCtx;

    public ResetUserPasswordTask(ControlPanelInfo info, ProgressDialog dlg, BasicNode node, BrowserController controller, char[] pwd) {
        super(info, dlg);
        this.node = node;
        this.newPassword = pwd;
        this.controller = controller;
        try {
            this.dn = DN.decode(node.getDN());
            for (BackendDescriptor backend : info.getServerDescriptor().getBackends()) {
                for (BaseDNDescriptor baseDN : backend.getBaseDns()) {
                    if (!this.dn.isDescendantOf(baseDN.getDn())) continue;
                    this.backendSet.add(backend.getBackendID());
                }
            }
        }
        catch (OpenDsException ode) {
            throw new IllegalStateException("Could not parse DN: " + node.getDN(), ode);
        }
    }

    @Override
    public Task.Type getType() {
        return Task.Type.MODIFY_ENTRY;
    }

    @Override
    public Set<String> getBackends() {
        return this.backendSet;
    }

    @Override
    public Message getTaskDescription() {
        return AdminToolMessages.INFO_CTRL_PANEL_RESET_USER_PASSWORD_TASK_DESCRIPTION.get(this.node.getDN());
    }

    @Override
    public boolean regenerateDescriptor() {
        return false;
    }

    @Override
    protected String getCommandLinePath() {
        return null;
    }

    protected ArrayList<String> getCommandLineArguments() {
        return new ArrayList<String>();
    }

    @Override
    public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
        boolean canLaunch = true;
        if (!this.isServerRunning() && this.state == Task.State.RUNNING) {
            TreeSet<String> backends = new TreeSet<String>(taskToBeLaunched.getBackends());
            backends.retainAll(this.getBackends());
            if (backends.size() > 0) {
                incompatibilityReasons.add(this.getIncompatibilityMessage(this, taskToBeLaunched));
                canLaunch = false;
            }
        }
        return canLaunch;
    }

    @Override
    public void runTask() {
        this.state = Task.State.RUNNING;
        this.lastException = null;
        try {
            this.useAdminCtx = this.controller.isConfigurationNode(this.node);
            InitialLdapContext ctx = this.controller.findConnectionForDisplayedEntry(this.node);
            BasicAttribute attr = new BasicAttribute("userpassword");
            attr.add(new String(this.newPassword));
            ModificationItem mod = new ModificationItem(2, attr);
            ModificationItem[] mods = new ModificationItem[]{mod};
            ArrayList<ModificationItem> modifications = new ArrayList<ModificationItem>();
            modifications.add(mod);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ResetUserPasswordTask.this.printEquivalentCommand(ResetUserPasswordTask.this.dn, ResetUserPasswordTask.this.newPassword, ResetUserPasswordTask.this.useAdminCtx);
                    ResetUserPasswordTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_CTRL_PANEL_RESETTING_USER_PASSWORD.get(ResetUserPasswordTask.this.node.getDN()), ColorAndFontConstants.progressFont));
                }
            });
            ctx.modifyAttributes(Utilities.getJNDIName(this.node.getDN()), mods);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ResetUserPasswordTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressDone(ColorAndFontConstants.progressFont));
                    TreePath treePath = new TreePath(ResetUserPasswordTask.this.controller.getTreeModel().getPathToRoot(ResetUserPasswordTask.this.node));
                    if (treePath != null) {
                        BrowserNodeInfo nodeInfo = ResetUserPasswordTask.this.controller.getNodeInfoFromPath(treePath);
                        if (nodeInfo != null) {
                            ResetUserPasswordTask.this.controller.notifyEntryChanged(nodeInfo);
                        }
                        ResetUserPasswordTask.this.controller.getTree().removeSelectionPath(treePath);
                        ResetUserPasswordTask.this.controller.getTree().setSelectionPath(treePath);
                    }
                }
            });
            this.state = Task.State.FINISHED_SUCCESSFULLY;
        }
        catch (Throwable t) {
            this.lastException = t;
            this.state = Task.State.FINISHED_WITH_ERROR;
        }
    }

    private void printEquivalentCommand(DN dn, char[] newPassword, boolean useAdminCtx) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getCommandLinePath("ldappasswordmodify"));
        args.add("--authzID");
        args.add("dn:" + dn);
        args.add("--newPassword");
        args.add("********");
        args.addAll(this.getObfuscatedCommandLineArguments(this.getConnectionCommandLineArguments(useAdminCtx, true)));
        args.add(this.getNoPropertiesFileArgument());
        StringBuilder sb = new StringBuilder();
        for (String arg : args) {
            sb.append(" " + CommandBuilder.escapeValue(arg));
        }
        this.getProgressDialog().appendProgressHtml(Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_RESET_PASSWORD.get().toString() + "<br><b>" + sb.toString() + "</b><br><br>", ColorAndFontConstants.progressFont));
    }
}

