/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.guitools.controlpanel.browser.BrowserController;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.BaseDNDescriptor;
import org.opends.guitools.controlpanel.datamodel.CategorizedComboBoxElement;
import org.opends.guitools.controlpanel.datamodel.ConfigReadException;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.IndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.event.BrowserEvent;
import org.opends.guitools.controlpanel.event.BrowserEventListener;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.ui.BaseDNPanel;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.components.FilterTextField;
import org.opends.guitools.controlpanel.ui.components.TreePanel;
import org.opends.guitools.controlpanel.ui.nodes.BasicNode;
import org.opends.guitools.controlpanel.ui.renderer.CustomListCellRenderer;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.UserDataCertificateException;
import org.opends.quicksetup.ui.CertificateDialog;
import org.opends.quicksetup.util.UIKeyStore;
import org.opends.quicksetup.util.Utils;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.LDAPException;
import org.opends.server.types.SearchFilter;

public abstract class AbstractBrowseEntriesPanel
extends StatusGenericPanel {
    private JComboBox baseDNs;
    protected JComboBox filterAttribute;
    protected FilterTextField filter;
    private JButton applyButton;
    private JButton okButton;
    private JButton cancelButton;
    private JButton closeButton;
    private JLabel lBaseDN;
    private JLabel lFilter;
    private JLabel lLimit;
    private JLabel lNumberOfEntries;
    private JLabel lNoMatchFound;
    private InitialLdapContext createdUserDataCtx;
    protected TreePanel treePane;
    protected BrowserController controller;
    private NumberOfEntriesUpdater numberEntriesUpdater;
    private BaseDNPanel otherBaseDNPanel;
    private GenericDialog otherBaseDNDlg;
    private boolean firstTimeDisplayed = true;
    private Object lastSelectedBaseDN = null;
    private boolean ignoreBaseDNEvents = false;
    protected static final Message LDAP_FILTER = AdminToolMessages.INFO_CTRL_PANEL_LDAP_FILTER.get();
    protected static final Message USER_FILTER = AdminToolMessages.INFO_CTRL_PANEL_USERS_FILTER.get();
    protected static final Message GROUP_FILTER = AdminToolMessages.INFO_CTRL_PANEL_GROUPS_FILTER.get();
    private final Message OTHER_BASE_DN = AdminToolMessages.INFO_CTRL_PANEL_OTHER_BASE_DN.get();
    private ArrayList<DN> otherBaseDns = new ArrayList();
    private static final String ALL_BASE_DNS = "All Base DNs";
    private static final int MAX_NUMBER_ENTRIES = 5000;
    private static final int MAX_NUMBER_OTHER_BASE_DNS = 10;
    private final String[] CONTAINER_CLASSES = new String[]{"organization", "organizationalUnit"};
    private static final Logger LOG = Logger.getLogger(AbstractBrowseEntriesPanel.class.getName());
    static final String[] systemIndexes = new String[]{"aci", "dn2id", "ds-sync-hist", "entryUUID", "id2children", "id2subtree"};

    public AbstractBrowseEntriesPanel() {
        this.createLayout();
    }

    public boolean requiresBorder() {
        return false;
    }

    public boolean requiresScroll() {
        return false;
    }

    public boolean callConfigurationChangedInBackground() {
        return true;
    }

    public void setInfo(ControlPanelInfo info) {
        if (this.controller == null) {
            this.createBrowserController(info);
        }
        super.setInfo(info);
        this.treePane.setInfo(info);
    }

    public final GenericDialog.ButtonType getButtonType() {
        return GenericDialog.ButtonType.NO_BUTTON;
    }

    protected abstract GenericDialog.ButtonType getBrowseButtonType();

    public void toBeDisplayed(boolean visible) {
        super.toBeDisplayed(visible);
        ((GenericDialog)Utilities.getParentDialog(this)).getRootPane().setDefaultButton(null);
    }

    protected void setEnabledOK(boolean enable) {
        this.okButton.setEnabled(enable);
    }

    protected void setEnabledCancel(boolean enable) {
        this.cancelButton.setEnabled(enable);
    }

    private void createLayout() {
        this.setBackground(ColorAndFontConstants.greyBackground);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 7;
        this.addErrorPane(gbc);
        Message title = AdminToolMessages.INFO_CTRL_PANEL_SERVER_NOT_RUNNING_SUMMARY.get();
        MessageBuilder mb = new MessageBuilder();
        mb.append(AdminToolMessages.INFO_CTRL_PANEL_SERVER_NOT_RUNNING_DETAILS.get());
        mb.append("<br><br>");
        mb.append(this.getStartServerHTML());
        Message details = mb.toMessage();
        this.updateErrorPane(this.errorPane, title, ColorAndFontConstants.errorTitleFont, details, ColorAndFontConstants.defaultFont);
        this.errorPane.setVisible(true);
        this.errorPane.setFocusable(true);
        gbc.insets = new Insets(10, 10, 0, 10);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        this.lBaseDN = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_BASE_DN_LABEL.get());
        gbc.gridx = 0;
        gbc.fill = 2;
        gbc.insets.right = 0;
        this.add((Component)this.lBaseDN, gbc);
        gbc.insets.left = 5;
        this.baseDNs = Utilities.createComboBox();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement("dc=dn to be displayed");
        this.baseDNs.setModel(model);
        this.baseDNs.setRenderer(new CustomComboBoxCellRenderer(this.baseDNs));
        this.baseDNs.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                if (AbstractBrowseEntriesPanel.this.ignoreBaseDNEvents || ev.getStateChange() != 1) {
                    return;
                }
                Object o = AbstractBrowseEntriesPanel.this.baseDNs.getSelectedItem();
                if (AbstractBrowseEntriesPanel.this.isCategory(o)) {
                    if (AbstractBrowseEntriesPanel.this.lastSelectedBaseDN == null) {
                        for (int i = 0; i < AbstractBrowseEntriesPanel.this.baseDNs.getModel().getSize(); ++i) {
                            Object item = AbstractBrowseEntriesPanel.this.baseDNs.getModel().getElementAt(i);
                            if (!(item instanceof CategorizedComboBoxElement) || AbstractBrowseEntriesPanel.this.isCategory(item)) continue;
                            AbstractBrowseEntriesPanel.this.lastSelectedBaseDN = item;
                            break;
                        }
                        if (AbstractBrowseEntriesPanel.this.lastSelectedBaseDN != null) {
                            AbstractBrowseEntriesPanel.this.baseDNs.setSelectedItem(AbstractBrowseEntriesPanel.this.lastSelectedBaseDN);
                        }
                    } else {
                        AbstractBrowseEntriesPanel.this.ignoreBaseDNEvents = true;
                        AbstractBrowseEntriesPanel.this.baseDNs.setSelectedItem(AbstractBrowseEntriesPanel.this.lastSelectedBaseDN);
                        AbstractBrowseEntriesPanel.this.ignoreBaseDNEvents = false;
                    }
                } else if ("----------".equals(o)) {
                    AbstractBrowseEntriesPanel.this.ignoreBaseDNEvents = true;
                    AbstractBrowseEntriesPanel.this.baseDNs.setSelectedItem(AbstractBrowseEntriesPanel.this.lastSelectedBaseDN);
                    AbstractBrowseEntriesPanel.this.ignoreBaseDNEvents = false;
                } else if (!AbstractBrowseEntriesPanel.this.OTHER_BASE_DN.equals(o)) {
                    AbstractBrowseEntriesPanel.this.lastSelectedBaseDN = o;
                    if (AbstractBrowseEntriesPanel.this.lastSelectedBaseDN != null) {
                        AbstractBrowseEntriesPanel.this.applyButtonClicked();
                    }
                } else {
                    if (AbstractBrowseEntriesPanel.this.otherBaseDNDlg == null) {
                        AbstractBrowseEntriesPanel.this.otherBaseDNPanel = new BaseDNPanel();
                        AbstractBrowseEntriesPanel.this.otherBaseDNDlg = new GenericDialog(Utilities.getFrame(AbstractBrowseEntriesPanel.this), AbstractBrowseEntriesPanel.this.otherBaseDNPanel);
                        AbstractBrowseEntriesPanel.this.otherBaseDNDlg.setModal(true);
                        Utilities.centerGoldenMean(AbstractBrowseEntriesPanel.this.otherBaseDNDlg, Utilities.getParentDialog(AbstractBrowseEntriesPanel.this));
                    }
                    AbstractBrowseEntriesPanel.this.otherBaseDNDlg.setVisible(true);
                    String newBaseDn = AbstractBrowseEntriesPanel.this.otherBaseDNPanel.getBaseDn();
                    DefaultComboBoxModel model = (DefaultComboBoxModel)AbstractBrowseEntriesPanel.this.baseDNs.getModel();
                    if (newBaseDn != null) {
                        CategorizedComboBoxElement newElement = null;
                        try {
                            DN dn = DN.decode(newBaseDn);
                            newElement = new CategorizedComboBoxElement(Utilities.unescapeUtf8(dn.toString()), CategorizedComboBoxElement.Type.REGULAR);
                            if (!AbstractBrowseEntriesPanel.this.otherBaseDns.contains(dn)) {
                                AbstractBrowseEntriesPanel.this.otherBaseDns.add(0, dn);
                                if (AbstractBrowseEntriesPanel.this.otherBaseDns.size() > 10) {
                                    AbstractBrowseEntriesPanel.this.ignoreBaseDNEvents = true;
                                    for (int i = AbstractBrowseEntriesPanel.this.otherBaseDns.size() - 1; i >= 10; --i) {
                                        DN dnToRemove = (DN)AbstractBrowseEntriesPanel.this.otherBaseDns.get(i);
                                        AbstractBrowseEntriesPanel.this.otherBaseDns.remove(i);
                                        CategorizedComboBoxElement elementToRemove = new CategorizedComboBoxElement(Utilities.unescapeUtf8(dnToRemove.toString()), CategorizedComboBoxElement.Type.REGULAR);
                                        model.removeElement(elementToRemove);
                                    }
                                    AbstractBrowseEntriesPanel.this.ignoreBaseDNEvents = false;
                                }
                            }
                            if (model.getIndexOf(newElement) == -1) {
                                int index = model.getIndexOf("----------");
                                model.insertElementAt(newElement, index + 1);
                                if (AbstractBrowseEntriesPanel.this.otherBaseDns.size() == 1) {
                                    model.insertElementAt("----------", index + 2);
                                }
                            }
                        }
                        catch (Throwable t) {
                            throw new IllegalStateException("Unexpected error decoding dn " + newBaseDn, t);
                        }
                        if (newElement != null) {
                            model.setSelectedItem(newElement);
                        }
                    } else if (AbstractBrowseEntriesPanel.this.lastSelectedBaseDN != null) {
                        AbstractBrowseEntriesPanel.this.ignoreBaseDNEvents = true;
                        model.setSelectedItem(AbstractBrowseEntriesPanel.this.lastSelectedBaseDN);
                        AbstractBrowseEntriesPanel.this.ignoreBaseDNEvents = false;
                    }
                }
            }
        });
        ++gbc.gridx;
        this.add((Component)this.baseDNs, gbc);
        ++gbc.gridx;
        gbc.fill = 3;
        gbc.insets.left = 10;
        this.add((Component)new JSeparator(1), gbc);
        gbc.fill = 2;
        this.lFilter = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_FILTER_LABEL.get());
        ++gbc.gridx;
        this.add((Component)this.lFilter, gbc);
        this.filterAttribute = Utilities.createComboBox();
        this.filterAttribute.setModel(new DefaultComboBoxModel<Object>(new Object[]{USER_FILTER, GROUP_FILTER, "----------", "attributetobedisplayed", "----------", LDAP_FILTER}));
        this.filterAttribute.setRenderer(new CustomListCellRenderer(this.filterAttribute));
        this.filterAttribute.addItemListener(new StatusGenericPanel.IgnoreItemListener(this, this.filterAttribute));
        ++gbc.gridx;
        gbc.insets.left = 5;
        this.add((Component)this.filterAttribute, gbc);
        this.filter = new FilterTextField();
        this.filter.setToolTipText(AdminToolMessages.INFO_CTRL_PANEL_SUBSTRING_SEARCH_INLINE_HELP.get().toString());
        this.filter.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10 && AbstractBrowseEntriesPanel.this.applyButton.isEnabled()) {
                    AbstractBrowseEntriesPanel.this.filter.displayRefreshIcon(true);
                    AbstractBrowseEntriesPanel.this.applyButtonClicked();
                }
            }
        });
        this.filter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                AbstractBrowseEntriesPanel.this.filter.displayRefreshIcon(true);
                AbstractBrowseEntriesPanel.this.applyButtonClicked();
            }
        });
        gbc.weightx = 1.0;
        ++gbc.gridx;
        this.add((Component)this.filter, gbc);
        gbc.insets.top = 10;
        this.applyButton = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_APPLY_BUTTON_LABEL.get());
        gbc.insets.right = 10;
        ++gbc.gridx;
        gbc.weightx = 0.0;
        this.add((Component)this.applyButton, gbc);
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                AbstractBrowseEntriesPanel.this.applyButtonClicked();
            }
        });
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 7;
        this.add(this.createMainPanel(), gbc);
        ++gbc.gridy;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.createButtonsPanel(), gbc);
    }

    private JPanel createButtonsPanel() {
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridwidth = 1;
        gbc.gridy = 0;
        this.lLimit = Utilities.createDefaultLabel();
        Utilities.setWarningLabel(this.lLimit, AdminToolMessages.INFO_CTRL_PANEL_MAXIMUM_CHILDREN_DISPLAYED.get(5000));
        gbc.weighty = 0.0;
        ++gbc.gridy;
        this.lLimit.setVisible(false);
        this.lNumberOfEntries = Utilities.createDefaultLabel();
        gbc.insets = new Insets(10, 10, 10, 10);
        buttonsPanel.add((Component)this.lNumberOfEntries, gbc);
        buttonsPanel.add((Component)this.lLimit, gbc);
        gbc.weightx = 1.0;
        ++gbc.gridx;
        buttonsPanel.add(Box.createHorizontalGlue(), gbc);
        buttonsPanel.setOpaque(true);
        buttonsPanel.setBackground(ColorAndFontConstants.greyBackground);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        if (this.getBrowseButtonType() == GenericDialog.ButtonType.CLOSE) {
            this.closeButton = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_CLOSE_BUTTON_LABEL.get());
            this.closeButton.setOpaque(false);
            buttonsPanel.add((Component)this.closeButton, gbc);
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    AbstractBrowseEntriesPanel.this.closeClicked();
                }
            });
        } else if (this.getBrowseButtonType() == GenericDialog.ButtonType.OK) {
            this.okButton = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_OK_BUTTON_LABEL.get());
            this.okButton.setOpaque(false);
            buttonsPanel.add((Component)this.okButton, gbc);
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    AbstractBrowseEntriesPanel.this.okClicked();
                }
            });
        }
        if (this.getBrowseButtonType() == GenericDialog.ButtonType.OK_CANCEL) {
            this.okButton = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_OK_BUTTON_LABEL.get());
            this.okButton.setOpaque(false);
            gbc.insets.right = 0;
            buttonsPanel.add((Component)this.okButton, gbc);
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    AbstractBrowseEntriesPanel.this.okClicked();
                }
            });
            this.cancelButton = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_CANCEL_BUTTON_LABEL.get());
            this.cancelButton.setOpaque(false);
            gbc.insets.right = 10;
            gbc.insets.left = 5;
            ++gbc.gridx;
            buttonsPanel.add((Component)this.cancelButton, gbc);
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    AbstractBrowseEntriesPanel.this.cancelClicked();
                }
            });
        }
        buttonsPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, ColorAndFontConstants.defaultBorderColor));
        return buttonsPanel;
    }

    public Component getPreferredFocusComponent() {
        return this.baseDNs;
    }

    public void cancelClicked() {
        this.setPrimaryValid(this.lBaseDN);
        this.setSecondaryValid(this.lFilter);
        super.cancelClicked();
    }

    protected void applyButtonClicked() {
        ArrayList<Message> errors = new ArrayList<Message>();
        this.setPrimaryValid(this.lFilter);
        String s = this.getBaseDN();
        boolean displayAll = false;
        if (s != null) {
            displayAll = s.equals(ALL_BASE_DNS);
            if (!displayAll) {
                try {
                    DN.decode(s);
                }
                catch (Throwable t) {
                    errors.add(AdminToolMessages.INFO_CTRL_PANEL_INVALID_DN_DETAILS.get(s, t.toString()));
                }
            }
        } else {
            errors.add(AdminToolMessages.INFO_CTRL_PANEL_NO_BASE_DN_SELECTED.get());
        }
        String filterValue = this.getFilter();
        try {
            LDAPFilter.decode(filterValue);
        }
        catch (LDAPException le) {
            errors.add(AdminToolMessages.INFO_CTRL_PANEL_INVALID_FILTER_DETAILS.get(le.getMessageObject().toString()));
            this.setPrimaryInvalid(this.lFilter);
        }
        if (errors.size() == 0) {
            this.lLimit.setVisible(false);
            this.lNumberOfEntries.setVisible(true);
            this.controller.removeAllUnderRoot();
            this.controller.setFilter(filterValue);
            this.controller.setAutomaticExpand(!filterValue.equals("(|(objectClass=*)(objectClass=ldapsubentry))"));
            if (this.controller.getConfigurationConnection() != null) {
                BasicNode rootNode;
                this.treePane.getTree().setRootVisible(displayAll);
                this.treePane.getTree().setShowsRootHandles(!displayAll);
                boolean isBaseDN = false;
                for (BackendDescriptor backend : this.getInfo().getServerDescriptor().getBackends()) {
                    for (BaseDNDescriptor baseDN : backend.getBaseDns()) {
                        String dn = Utilities.unescapeUtf8(baseDN.getDn().toString());
                        if (displayAll) {
                            this.controller.addSuffix(dn, null);
                            continue;
                        }
                        if (!s.equals(dn)) continue;
                        this.controller.addSuffix(dn, null);
                        isBaseDN = true;
                    }
                }
                if (!isBaseDN && !displayAll && this.controller.findChildNode(rootNode = (BasicNode)this.controller.getTree().getModel().getRoot(), s) == -1) {
                    this.controller.addNodeUnderRoot(s);
                }
            } else {
                this.controller.getTree().setRootVisible(false);
                this.controller.removeAllUnderRoot();
            }
        } else {
            this.displayErrorDialog(errors);
        }
    }

    private String getFilter() {
        String returnValue;
        String s = this.filter.getText();
        if (s.length() == 0) {
            returnValue = "(|(objectClass=*)(objectClass=ldapsubentry))";
        } else {
            Object attr = this.filterAttribute.getSelectedItem();
            if (LDAP_FILTER.equals(attr)) {
                returnValue = (s = s.trim()).length() == 0 ? "(|(objectClass=*)(objectClass=ldapsubentry))" : s;
            } else if (USER_FILTER.equals(attr)) {
                returnValue = s.equals("*") ? "(objectClass=person)" : "(&(objectClass=person)(|(cn=" + s + ")(sn=" + s + ")(uid=" + s + ")))";
            } else if (GROUP_FILTER.equals(attr)) {
                returnValue = s.equals("*") ? "(|(objectClass=groupOfUniqueNames)(objectClass=groupOfURLs))" : "(&(|(objectClass=groupOfUniqueNames)(objectClass=groupOfURLs))(cn=" + s + "))";
            } else if (attr != null) {
                try {
                    LDAPFilter ldapFilter = new LDAPFilter(SearchFilter.createFilterFromString("(" + attr + "=" + s + ")"));
                    returnValue = ldapFilter.toString();
                }
                catch (DirectoryException de) {
                    AttributeType attrType = this.getInfo().getServerDescriptor().getSchema().getAttributeType(attr.toString().toLowerCase());
                    LDAPFilter ldapFilter = new LDAPFilter(SearchFilter.createEqualityFilter(attrType, new AttributeValue(attrType, s)));
                    returnValue = ldapFilter.toString();
                }
            } else {
                returnValue = "(|(objectClass=*)(objectClass=ldapsubentry))";
            }
        }
        return returnValue;
    }

    protected abstract Component createMainPanel();

    public void configurationChanged(ConfigurationChangeEvent ev) {
        ServerDescriptor desc = ev.getNewDescriptor();
        this.updateCombos(desc);
        this.updateBrowserControllerAndErrorPane(desc);
    }

    protected JComponent createTreePane() {
        this.treePane = new TreePanel();
        this.lNoMatchFound = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_NO_MATCHES_FOUND_LABEL.get());
        this.lNoMatchFound.setVisible(false);
        JTree tree = this.treePane.getTree();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("myserver.mydomain.com:389");
        DefaultTreeModel model = new DefaultTreeModel(root);
        tree.setModel(model);
        tree.setShowsRootHandles(false);
        tree.expandPath(new TreePath(root));
        JPanel p = new JPanel(new GridBagLayout());
        p.setBackground(ColorAndFontConstants.background);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        Utilities.setBorder(this.treePane, new EmptyBorder(10, 0, 10, 0));
        p.add((Component)this.treePane, gbc);
        gbc.fill = 2;
        Utilities.setBorder(this.lNoMatchFound, new EmptyBorder(15, 15, 15, 15));
        p.add((Component)this.lNoMatchFound, gbc);
        if (this.getInfo() != null && this.controller == null) {
            this.createBrowserController(this.getInfo());
        }
        this.numberEntriesUpdater = new NumberOfEntriesUpdater();
        this.numberEntriesUpdater.start();
        return p;
    }

    protected void createBrowserController(ControlPanelInfo info) {
        this.controller = new BrowserController(this.treePane.getTree(), info.getConnectionPool(), info.getIconPool());
        this.controller.setContainerClasses(this.CONTAINER_CLASSES);
        this.controller.setShowContainerOnly(false);
        this.controller.setMaxChildren(5000);
        this.controller.addBrowserEventListener(new BrowserEventListener(){

            public void processBrowserEvent(BrowserEvent ev) {
                if (ev.getType() == BrowserEvent.Type.SIZE_LIMIT_REACHED) {
                    AbstractBrowseEntriesPanel.this.lLimit.setVisible(true);
                    AbstractBrowseEntriesPanel.this.lNumberOfEntries.setVisible(false);
                }
            }
        });
        this.controller.getTreeModel().addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent e) {
            }

            public void treeNodesInserted(TreeModelEvent e) {
                AbstractBrowseEntriesPanel.this.checkRootNode();
            }

            public void treeNodesRemoved(TreeModelEvent e) {
                AbstractBrowseEntriesPanel.this.checkRootNode();
            }

            public void treeStructureChanged(TreeModelEvent e) {
                AbstractBrowseEntriesPanel.this.checkRootNode();
            }
        });
    }

    private static boolean displayIndex(String name) {
        boolean displayIndex = true;
        for (String systemIndex : systemIndexes) {
            if (!systemIndex.equalsIgnoreCase(name)) continue;
            displayIndex = false;
            break;
        }
        return displayIndex;
    }

    private void updateCombos(ServerDescriptor desc) {
        boolean changed;
        final TreeSet<String> newElements = new TreeSet<String>();
        for (BackendDescriptor backend : desc.getBackends()) {
            for (IndexDescriptor index : backend.getIndexes()) {
                String indexName = index.getName();
                if (!AbstractBrowseEntriesPanel.displayIndex(indexName)) continue;
                newElements.add(indexName);
            }
        }
        final DefaultComboBoxModel model = (DefaultComboBoxModel)this.filterAttribute.getModel();
        boolean bl = changed = newElements.size() != model.getSize() - 2;
        if (!changed) {
            int i = 0;
            for (String newElement : newElements) {
                boolean bl2 = changed = !newElement.equals(model.getElementAt(i));
                if (changed) break;
                ++i;
            }
        }
        if (changed) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Object selected = AbstractBrowseEntriesPanel.this.filterAttribute.getSelectedItem();
                    model.removeAllElements();
                    model.addElement(USER_FILTER);
                    model.addElement(GROUP_FILTER);
                    model.addElement("----------");
                    for (String newElement : newElements) {
                        model.addElement(newElement);
                    }
                    if (newElements.size() > 0) {
                        model.addElement("----------");
                    }
                    model.addElement(LDAP_FILTER);
                    if (selected != null) {
                        if (model.getIndexOf(selected) != -1) {
                            model.setSelectedItem(selected);
                        } else {
                            model.setSelectedItem(model.getElementAt(0));
                        }
                    }
                }
            });
        }
        LinkedHashSet<Object> baseDNNewElements = new LinkedHashSet<Object>();
        TreeSet<String> backendIDs = new TreeSet<String>();
        HashMap hmBaseDNs = new HashMap();
        boolean allAdded = false;
        HashMap<String, BaseDNDescriptor> hmBaseDNWithEntries = new HashMap<String, BaseDNDescriptor>();
        BaseDNDescriptor baseDNWithEntries = null;
        for (BackendDescriptor backend : desc.getBackends()) {
            String string;
            if (!this.displayBackend(backend)) continue;
            String backendID = backend.getBackendID();
            backendIDs.add(backendID);
            TreeSet<String> baseDNs = new TreeSet<String>();
            for (BaseDNDescriptor baseDNDescriptor : backend.getBaseDns()) {
                try {
                    baseDNs.add(Utilities.unescapeUtf8(baseDNDescriptor.getDn().toString()));
                }
                catch (Throwable t) {
                    throw new IllegalStateException("Unexpected error: " + t, t);
                }
                if (baseDNDescriptor.getEntries() <= 0) continue;
                hmBaseDNWithEntries.put(Utilities.unescapeUtf8(baseDNDescriptor.getDn().toString()), baseDNDescriptor);
            }
            hmBaseDNs.put(backendID, baseDNs);
            if (!backendID.equalsIgnoreCase("userRoot")) continue;
            Iterator i$ = baseDNs.iterator();
            while (i$.hasNext() && (baseDNWithEntries = (BaseDNDescriptor)hmBaseDNWithEntries.get(string = (String)i$.next())) == null) {
            }
        }
        if (!allAdded) {
            baseDNNewElements.add(new CategorizedComboBoxElement(ALL_BASE_DNS, CategorizedComboBoxElement.Type.REGULAR));
            allAdded = true;
        }
        for (String backendID : backendIDs) {
            baseDNNewElements.add(new CategorizedComboBoxElement(backendID, CategorizedComboBoxElement.Type.CATEGORY));
            SortedSet baseDNs = (SortedSet)hmBaseDNs.get(backendID);
            for (String baseDN : baseDNs) {
                baseDNNewElements.add(new CategorizedComboBoxElement(baseDN, CategorizedComboBoxElement.Type.REGULAR));
                if (baseDNWithEntries != null) continue;
                baseDNWithEntries = (BaseDNDescriptor)hmBaseDNWithEntries.get(baseDN);
            }
        }
        for (DN dn : this.otherBaseDns) {
            if (allAdded) {
                baseDNNewElements.add("----------");
            }
            baseDNNewElements.add(new CategorizedComboBoxElement(Utilities.unescapeUtf8(dn.toString()), CategorizedComboBoxElement.Type.REGULAR));
        }
        if (allAdded) {
            baseDNNewElements.add("----------");
            baseDNNewElements.add(this.OTHER_BASE_DN);
        }
        if (this.firstTimeDisplayed && baseDNWithEntries != null) {
            this.ignoreBaseDNEvents = true;
        }
        this.updateComboBoxModel(baseDNNewElements, (DefaultComboBoxModel)this.baseDNs.getModel());
        if (this.firstTimeDisplayed && baseDNWithEntries != null) {
            final CategorizedComboBoxElement toSelect = new CategorizedComboBoxElement(Utilities.unescapeUtf8(baseDNWithEntries.getDn().toString()), CategorizedComboBoxElement.Type.REGULAR);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AbstractBrowseEntriesPanel.this.ignoreBaseDNEvents = true;
                    AbstractBrowseEntriesPanel.this.baseDNs.setSelectedItem(toSelect);
                    AbstractBrowseEntriesPanel.this.ignoreBaseDNEvents = false;
                }
            });
        }
        if (this.getInfo().getServerDescriptor().isAuthenticated()) {
            this.firstTimeDisplayed = false;
        }
    }

    private void updateBrowserControllerAndErrorPane(ServerDescriptor desc) {
        MessageBuilder mb;
        boolean displayNodes = false;
        boolean displayErrorPane = false;
        Message errorTitle = Message.EMPTY;
        Message errorDetails = Message.EMPTY;
        ServerDescriptor.ServerStatus status = desc.getStatus();
        if (status == ServerDescriptor.ServerStatus.STARTED) {
            if (!desc.isAuthenticated()) {
                mb = new MessageBuilder();
                mb.append(AdminToolMessages.INFO_CTRL_PANEL_AUTHENTICATION_REQUIRED_TO_BROWSE_SUMMARY.get());
                mb.append("<br><br>" + this.getAuthenticateHTML());
                errorDetails = mb.toMessage();
                errorTitle = AdminToolMessages.INFO_CTRL_PANEL_AUTHENTICATION_REQUIRED_SUMMARY.get();
                displayErrorPane = true;
            } else {
                try {
                    boolean setConnection;
                    InitialLdapContext ctx = this.getInfo().getDirContext();
                    InitialLdapContext ctx1 = this.controller.getConfigurationConnection();
                    boolean bl = setConnection = ctx != ctx1;
                    if (setConnection) {
                        if (this.getInfo().getUserDataDirContext() == null) {
                            InitialLdapContext ctxUserData = this.createUserDataDirContext(ConnectionUtils.getBindDN(ctx), ConnectionUtils.getBindPassword(ctx));
                            this.getInfo().setUserDataDirContext(ctxUserData);
                        }
                        final NamingException[] fNe = new NamingException[]{null};
                        Runnable runnable = new Runnable(){

                            public void run() {
                                try {
                                    AbstractBrowseEntriesPanel.this.controller.setConnections(AbstractBrowseEntriesPanel.this.getInfo().getDirContext(), AbstractBrowseEntriesPanel.this.getInfo().getUserDataDirContext());
                                    AbstractBrowseEntriesPanel.this.applyButtonClicked();
                                }
                                catch (NamingException ne) {
                                    fNe[0] = ne;
                                }
                            }
                        };
                        if (!SwingUtilities.isEventDispatchThread()) {
                            try {
                                SwingUtilities.invokeAndWait(runnable);
                            }
                            catch (Throwable t) {}
                        } else {
                            runnable.run();
                        }
                        if (fNe[0] != null) {
                            throw fNe[0];
                        }
                    }
                    displayNodes = true;
                }
                catch (NamingException ne) {
                    errorTitle = AdminToolMessages.INFO_CTRL_PANEL_ERROR_CONNECT_BROWSE_DETAILS.get();
                    errorDetails = AdminToolMessages.INFO_CTRL_PANEL_ERROR_CONNECT_BROWSE_SUMMARY.get(ne.toString());
                    displayErrorPane = true;
                }
                catch (ConfigReadException cre) {
                    errorTitle = AdminToolMessages.INFO_CTRL_PANEL_ERROR_CONNECT_BROWSE_DETAILS.get();
                    errorDetails = AdminToolMessages.INFO_CTRL_PANEL_ERROR_CONNECT_BROWSE_SUMMARY.get(cre.getMessageObject().toString());
                    displayErrorPane = true;
                }
            }
        } else {
            errorTitle = AdminToolMessages.INFO_CTRL_PANEL_SERVER_NOT_RUNNING_SUMMARY.get();
            mb = new MessageBuilder();
            mb.append(AdminToolMessages.INFO_CTRL_PANEL_AUTHENTICATION_SERVER_MUST_RUN_TO_BROWSE_SUMMARY.get());
            mb.append("<br><br>");
            mb.append(this.getStartServerHTML());
            errorDetails = mb.toMessage();
            displayErrorPane = true;
        }
        final boolean fDisplayNodes = displayNodes;
        final boolean fDisplayErrorPane = displayErrorPane;
        final Message fErrorTitle = errorTitle;
        final Message fErrorDetails = errorDetails;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AbstractBrowseEntriesPanel.this.applyButton.setEnabled(!fDisplayErrorPane);
                AbstractBrowseEntriesPanel.this.errorPane.setVisible(fDisplayErrorPane);
                if (fDisplayErrorPane) {
                    AbstractBrowseEntriesPanel.this.updateErrorPane(AbstractBrowseEntriesPanel.this.errorPane, fErrorTitle, ColorAndFontConstants.errorTitleFont, fErrorDetails, ColorAndFontConstants.defaultFont);
                } else if (fDisplayNodes) {
                    String s = AbstractBrowseEntriesPanel.this.getBaseDN();
                    DN theDN = null;
                    boolean displayAll = false;
                    if (s != null && !(displayAll = s.equals(AbstractBrowseEntriesPanel.ALL_BASE_DNS))) {
                        try {
                            theDN = DN.decode(s);
                        }
                        catch (Throwable t) {
                            s = null;
                        }
                    }
                    AbstractBrowseEntriesPanel.this.treePane.getTree().setRootVisible(displayAll);
                    AbstractBrowseEntriesPanel.this.treePane.getTree().setShowsRootHandles(!displayAll);
                    if (s != null) {
                        boolean isBaseDN = false;
                        for (BackendDescriptor backend : AbstractBrowseEntriesPanel.this.getInfo().getServerDescriptor().getBackends()) {
                            BasicNode rootNode;
                            for (BaseDNDescriptor baseDN : backend.getBaseDns()) {
                                String dn = Utilities.unescapeUtf8(baseDN.getDn().toString());
                                if (theDN != null && baseDN.getDn().equals(theDN)) {
                                    isBaseDN = true;
                                }
                                if (baseDN.getEntries() <= 0 || AbstractBrowseEntriesPanel.this.controller.hasSuffix(dn)) continue;
                                if (displayAll) {
                                    AbstractBrowseEntriesPanel.this.controller.addSuffix(dn, null);
                                    continue;
                                }
                                if (!s.equals(dn)) continue;
                                AbstractBrowseEntriesPanel.this.controller.addSuffix(dn, null);
                            }
                            if (isBaseDN || displayAll || AbstractBrowseEntriesPanel.this.controller.findChildNode(rootNode = (BasicNode)AbstractBrowseEntriesPanel.this.controller.getTree().getModel().getRoot(), s) != -1) continue;
                            AbstractBrowseEntriesPanel.this.controller.addNodeUnderRoot(s);
                        }
                    }
                }
                if (!fDisplayNodes) {
                    AbstractBrowseEntriesPanel.this.controller.removeAllUnderRoot();
                    AbstractBrowseEntriesPanel.this.treePane.getTree().setRootVisible(false);
                }
            }
        });
    }

    private String getBaseDN() {
        Object o = this.baseDNs.getSelectedItem();
        String dn = o instanceof String ? (String)o : (o instanceof CategorizedComboBoxElement ? ((CategorizedComboBoxElement)o).getValue().toString() : null);
        if (dn != null) {
            if (dn.trim().length() == 0) {
                dn = ALL_BASE_DNS;
            } else if (this.OTHER_BASE_DN.equals(dn)) {
                dn = null;
            }
        } else {
            dn = null;
        }
        return dn;
    }

    private InitialLdapContext createUserDataDirContext(final String bindDN, final String bindPassword) throws NamingException, ConfigReadException {
        block13: {
            this.createdUserDataCtx = null;
            try {
                this.createdUserDataCtx = Utilities.getUserDataDirContext(this.getInfo(), bindDN, bindPassword);
            }
            catch (NamingException ne) {
                if (Utils.isCertificateException(ne)) {
                    int p;
                    String h;
                    ApplicationTrustManager.Cause cause = this.getInfo().getTrustManager().getLastRefusedCause();
                    LOG.log(Level.INFO, "Certificate exception cause: " + (Object)((Object)cause));
                    UserDataCertificateException.Type excType = null;
                    if (cause == ApplicationTrustManager.Cause.NOT_TRUSTED) {
                        excType = UserDataCertificateException.Type.NOT_TRUSTED;
                    } else if (cause == ApplicationTrustManager.Cause.HOST_NAME_MISMATCH) {
                        excType = UserDataCertificateException.Type.HOST_NAME_MISMATCH;
                    }
                    if (excType == null) break block13;
                    try {
                        URI uri = new URI(this.getInfo().getAdminConnectorURL());
                        h = uri.getHost();
                        p = uri.getPort();
                    }
                    catch (Throwable t) {
                        LOG.log(Level.WARNING, "Error parsing ldap url of ldap url.", t);
                        h = QuickSetupMessages.INFO_NOT_AVAILABLE_LABEL.get().toString();
                        p = -1;
                    }
                    final UserDataCertificateException udce = new UserDataCertificateException(null, QuickSetupMessages.INFO_CERTIFICATE_EXCEPTION.get(h, String.valueOf(p)), ne, h, p, this.getInfo().getTrustManager().getLastRefusedChain(), this.getInfo().getTrustManager().getLastRefusedAuthType(), excType);
                    if (SwingUtilities.isEventDispatchThread()) {
                        this.handleCertificateException(udce, bindDN, bindPassword);
                    }
                    final ConfigReadException[] fcre = new ConfigReadException[]{null};
                    final NamingException[] fne = new NamingException[]{null};
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                try {
                                    AbstractBrowseEntriesPanel.this.handleCertificateException(udce, bindDN, bindPassword);
                                }
                                catch (ConfigReadException cre) {
                                    fcre[0] = cre;
                                }
                                catch (NamingException ne) {
                                    fne[0] = ne;
                                }
                            }
                        });
                    }
                    catch (Throwable t) {
                        throw new IllegalArgumentException("Unexpected error: " + t, t);
                    }
                    if (fcre[0] != null) {
                        throw fcre[0];
                    }
                    if (fne[0] != null) {
                        throw fne[0];
                    }
                }
                throw ne;
            }
        }
        return this.createdUserDataCtx;
    }

    private void handleCertificateException(UserDataCertificateException ce, String bindDN, String bindPassword) throws NamingException, ConfigReadException {
        X509Certificate[] chain;
        CertificateDialog dlg = new CertificateDialog(null, ce);
        dlg.pack();
        Utilities.centerGoldenMean(dlg, Utilities.getParentDialog(this));
        dlg.setVisible(true);
        if (dlg.getUserAnswer() != CertificateDialog.ReturnType.NOT_ACCEPTED) {
            chain = ce.getChain();
            String authType = ce.getAuthType();
            String host = ce.getHost();
            if (chain != null && authType != null && host != null) {
                LOG.log(Level.INFO, "Accepting certificate presented by host " + host);
                this.getInfo().getTrustManager().acceptCertificate(chain, authType, host);
                this.createdUserDataCtx = this.createUserDataDirContext(bindDN, bindPassword);
            } else {
                if (chain == null) {
                    LOG.log(Level.WARNING, "The chain is null for the UserDataCertificateException");
                }
                if (authType == null) {
                    LOG.log(Level.WARNING, "The auth type is null for the UserDataCertificateException");
                }
                if (host == null) {
                    LOG.log(Level.WARNING, "The host is null for the UserDataCertificateException");
                }
            }
        }
        if (dlg.getUserAnswer() == CertificateDialog.ReturnType.ACCEPTED_PERMANENTLY && (chain = ce.getChain()) != null) {
            try {
                UIKeyStore.acceptCertificate(chain);
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Error accepting certificate: " + t, t);
            }
        }
    }

    private void checkRootNode() {
        boolean visible;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.controller.getTreeModel().getRoot();
        boolean bl = visible = root.getChildCount() > 0;
        if (visible != this.treePane.isVisible()) {
            this.treePane.setVisible(visible);
            this.lNoMatchFound.setVisible(!visible);
            this.lNumberOfEntries.setVisible(visible);
        }
        this.numberEntriesUpdater.recalculate();
    }

    protected class NumberOfEntriesUpdater
    extends Thread
    implements Runnable {
        private boolean recalculate;

        public void recalculate() {
            this.recalculate = true;
        }

        public void run() {
            while (true) {
                boolean mustDisplayRefreshIcon;
                try {
                    Thread.sleep(400L);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (this.recalculate) {
                    this.recalculate = false;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            int nEntries = 0;
                            if (AbstractBrowseEntriesPanel.this.controller.getTree().isRootVisible()) {
                                ++nEntries;
                            }
                            DefaultMutableTreeNode root = (DefaultMutableTreeNode)AbstractBrowseEntriesPanel.this.controller.getTreeModel().getRoot();
                            AbstractBrowseEntriesPanel.this.lNumberOfEntries.setText("Number of entries: " + (nEntries += NumberOfEntriesUpdater.this.getChildren(root)));
                        }
                    });
                }
                if (AbstractBrowseEntriesPanel.this.controller == null || (mustDisplayRefreshIcon = AbstractBrowseEntriesPanel.this.controller.getQueueSize() > 0) == AbstractBrowseEntriesPanel.this.filter.isRefreshIconDisplayed()) continue;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AbstractBrowseEntriesPanel.this.filter.displayRefreshIcon(mustDisplayRefreshIcon);
                    }
                });
            }
        }

        private int getChildren(DefaultMutableTreeNode node) {
            int nEntries = 0;
            if (!node.isLeaf()) {
                Enumeration<TreeNode> en = node.children();
                while (en.hasMoreElements()) {
                    ++nEntries;
                    nEntries += this.getChildren((DefaultMutableTreeNode)en.nextElement());
                }
            }
            return nEntries;
        }
    }

    class CustomComboBoxCellRenderer
    extends CustomListCellRenderer {
        private Message ALL_BASE_DNS_STRING;

        CustomComboBoxCellRenderer(JComboBox combo) {
            super(combo);
            this.ALL_BASE_DNS_STRING = AdminToolMessages.INFO_CTRL_PANEL_ALL_BASE_DNS.get();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            CategorizedComboBoxElement element;
            String name;
            Component comp = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof CategorizedComboBoxElement && AbstractBrowseEntriesPanel.ALL_BASE_DNS.equals(name = this.getStringValue(element = (CategorizedComboBoxElement)value))) {
                ((JLabel)comp).setText(this.ALL_BASE_DNS_STRING.toString());
            }
            comp.setFont(this.defaultFont);
            return comp;
        }
    }
}

