/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.event.ScrollPaneBorderListener;
import org.opends.guitools.controlpanel.task.DeleteSchemaElementsTask;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.StandardObjectClassPanel;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.Schema;

public class CustomObjectClassPanel
extends StandardObjectClassPanel {
    private static final long serialVersionUID = 2105520588901380L;
    private JButton delete;
    private ObjectClass objectClass;
    private String ocName;
    private ScrollPaneBorderListener scrollListener;

    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_CUSTOM_OBJECTCLASS_TITLE.get();
    }

    protected void createLayout() {
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        p.setOpaque(false);
        p.setBorder(this.PANEL_BORDER);
        super.createBasicLayout(p, gbc);
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        JScrollPane scroll = Utilities.createBorderLessScrollBar(p);
        this.scrollListener = new ScrollPaneBorderListener(scroll);
        this.add((Component)scroll, gbc);
        ++gbc.gridy;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.delete = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_DELETE_OBJECTCLASS_BUTTON.get());
        this.delete.setOpaque(false);
        this.add((Component)this.delete, gbc);
        this.delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                CustomObjectClassPanel.this.deleteObjectclass();
            }
        });
    }

    public void configurationChanged(final ConfigurationChangeEvent ev) {
        this.updateErrorPaneIfAuthRequired(ev.getNewDescriptor(), AdminToolMessages.INFO_CTRL_PANEL_AUTHENTICATION_REQUIRED_FOR_OBJECTCLASS_DELETE.get());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CustomObjectClassPanel.this.delete.setEnabled(!CustomObjectClassPanel.this.authenticationRequired(ev.getNewDescriptor()));
            }
        });
    }

    public void update(ObjectClass oc, Schema schema) {
        super.update(oc, schema);
        this.objectClass = oc;
        if (this.objectClass != null) {
            this.ocName = this.objectClass.getNameOrOID();
        }
        this.scrollListener.updateBorder();
    }

    private void deleteObjectclass() {
        ArrayList<Message> errors = new ArrayList<Message>();
        ProgressDialog dlg = new ProgressDialog((Component)Utilities.getParentDialog(this), AdminToolMessages.INFO_CTRL_PANEL_DELETE_OBJECTCLASS_TITLE.get(), this.getInfo());
        ArrayList<ObjectClass> ocsToDelete = new ArrayList<ObjectClass>();
        ocsToDelete.add(this.objectClass);
        ArrayList<AttributeType> attrsToDelete = new ArrayList<AttributeType>();
        DeleteSchemaElementsTask newTask = new DeleteSchemaElementsTask(this.getInfo(), dlg, ocsToDelete, attrsToDelete);
        for (Task task : this.getInfo().getTasks()) {
            task.canLaunch(newTask, errors);
        }
        Schema schema = this.getInfo().getServerDescriptor().getSchema();
        if (schema != null) {
            ArrayList<String> childClasses = new ArrayList<String>();
            for (ObjectClass o : schema.getObjectClasses().values()) {
                if (!this.objectClass.equals(o.getSuperiorClass())) continue;
                childClasses.add(o.getNameOrOID());
            }
            if (!childClasses.isEmpty()) {
                errors.add(AdminToolMessages.ERR_CANNOT_DELETE_PARENT_OBJECTCLASS.get(this.ocName, Utilities.getStringFromCollection(childClasses, ", "), this.ocName));
            }
        }
        if (errors.size() == 0) {
            Message confirmationMessage = AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_DELETE_OBJECTCLASS_DETAILS.get(this.ocName);
            if (this.displayConfirmationDialog(AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_REQUIRED_SUMMARY.get(), confirmationMessage)) {
                this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_DELETING_OBJECTCLASS_SUMMARY.get(this.ocName), AdminToolMessages.INFO_CTRL_PANEL_DELETING_OBJECTCLASS_COMPLETE.get(), AdminToolMessages.INFO_CTRL_PANEL_DELETING_OBJECTCLASS_SUCCESSFUL.get(this.ocName), AdminToolMessages.ERR_CTRL_PANEL_DELETING_OBJECTCLASS_ERROR_SUMMARY.get(), AdminToolMessages.ERR_CTRL_PANEL_DELETING_OBJECTCLASS_ERROR_DETAILS.get(this.ocName), null, dlg);
                dlg.setVisible(true);
            }
        } else {
            this.displayErrorDialog(errors);
        }
    }
}

