/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.BackupDescriptor;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.event.BackupCreatedEvent;
import org.opends.guitools.controlpanel.event.BackupCreatedListener;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.BackupListPanel;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.tools.RestoreDB;

public class RestorePanel
extends BackupListPanel
implements BackupCreatedListener {
    private static final long serialVersionUID = -205585323128518051L;
    private ListSelectionListener listener;

    public RestorePanel() {
        this.createLayout();
    }

    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_RESTORE_PANEL_TITLE.get();
    }

    public void backupCreated(BackupCreatedEvent ev) {
        boolean refreshList = false;
        File f = new File(this.parentDirectory.getText());
        File fBackup = ev.getBackupDescriptor().getPath();
        if (fBackup.equals(f)) {
            refreshList = true;
        } else if ((f = f.getParentFile()) != null) {
            refreshList = fBackup.equals(f);
        }
        if (refreshList && this.isVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RestorePanel.this.refreshList();
                }
            });
        }
    }

    public void setInfo(ControlPanelInfo info) {
        super.setInfo(info);
        info.addBackupCreatedListener(this);
    }

    public void toBeDisplayed(boolean visible) {
        if (visible) {
            this.listener.valueChanged(null);
        }
    }

    public void configurationChanged(ConfigurationChangeEvent ev) {
        super.configurationChanged(ev);
        this.updateErrorPaneAndOKButtonIfAuthRequired(this.getInfo().getServerDescriptor(), AdminToolMessages.INFO_CTRL_PANEL_AUTHENTICATION_REQUIRED_FOR_RESTORE.get());
    }

    protected void verifyBackupClicked() {
        LinkedHashSet<Message> errors = new LinkedHashSet<Message>();
        ProgressDialog dlg = new ProgressDialog((Component)Utilities.getParentDialog(this), AdminToolMessages.INFO_CTRL_PANEL_VERIFY_BACKUP_TITLE.get(), this.getInfo());
        RestoreTask newTask = new RestoreTask(this.getInfo(), dlg, true);
        for (Task task : this.getInfo().getTasks()) {
            task.canLaunch(newTask, errors);
        }
        if (errors.isEmpty()) {
            BackupDescriptor backup = this.getSelectedBackup();
            this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_VERIFYING_BACKUP_SUMMARY.get(backup.getID()), AdminToolMessages.INFO_CTRL_PANEL_VERIFYING_BACKUP_SUCCESSFUL_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_VERIFYING_BACKUP_SUCCESSFUL_DETAILS.get(), AdminToolMessages.ERR_CTRL_PANEL_VERIFYING_BACKUP_ERROR_SUMMARY.get(), null, AdminToolMessages.ERR_CTRL_PANEL_VERIFYING_BACKUP_ERROR_DETAILS, dlg);
            dlg.setVisible(true);
        } else {
            this.displayErrorDialog(errors);
        }
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        this.addErrorPane(gbc);
        super.createLayout(gbc);
        this.listener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent ev) {
                BackupDescriptor backup = RestorePanel.this.getSelectedBackup();
                RestorePanel.this.setEnabledOK(backup != null && !RestorePanel.this.errorPane.isVisible());
            }
        };
        this.backupList.getSelectionModel().addListSelectionListener(this.listener);
    }

    protected void checkOKButtonEnable() {
        this.listener.valueChanged(null);
    }

    public void okClicked() {
        boolean selected;
        this.setPrimaryValid(this.lPath);
        this.setPrimaryValid(this.lAvailableBackups);
        LinkedHashSet<Message> errors = new LinkedHashSet<Message>();
        BackupDescriptor backup = this.getSelectedBackup();
        boolean bl = selected = this.backupList.isVisible() && backup != null;
        if (!selected) {
            if (this.backupList.getRowCount() == 0) {
                this.setPrimaryInvalid(this.lPath);
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_NO_PARENT_BACKUP_TO_VERIFY.get());
            } else {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_REQUIRED_BACKUP_TO_VERIFY.get());
            }
            this.setPrimaryInvalid(this.lAvailableBackups);
        }
        if (errors.isEmpty()) {
            ProgressDialog progressDialog = new ProgressDialog((Component)Utilities.getParentDialog(this), this.getTitle(), this.getInfo());
            RestoreTask newTask = new RestoreTask(this.getInfo(), progressDialog, false);
            for (Task task : this.getInfo().getTasks()) {
                task.canLaunch(newTask, errors);
            }
            boolean confirmed = true;
            if (errors.isEmpty()) {
                confirmed = this.displayConfirmationDialog(AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_REQUIRED_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_CONFIRM_RESTORE_DETAILS.get());
            }
            if (errors.isEmpty() && confirmed) {
                this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_RESTORING_SUMMARY.get(backup.getID()), AdminToolMessages.INFO_CTRL_PANEL_RESTORING_SUCCESSFUL_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_RESTORING_SUCCESSFUL_DETAILS.get(), AdminToolMessages.ERR_CTRL_PANEL_RESTORING_ERROR_SUMMARY.get(), null, AdminToolMessages.ERR_CTRL_PANEL_RESTORING_ERROR_DETAILS, progressDialog);
                progressDialog.setVisible(true);
                Utilities.getParentDialog(this).setVisible(false);
            }
        }
        if (errors.size() > 0) {
            this.displayErrorDialog(errors);
        }
    }

    public void cancelClicked() {
        this.setPrimaryValid(this.lPath);
        this.setPrimaryValid(this.lAvailableBackups);
        super.cancelClicked();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RestoreTask
    extends Task {
        private Set<String> backendSet;
        private String dir;
        private String backupID;
        private boolean verify;

        public RestoreTask(ControlPanelInfo info, ProgressDialog dlg, boolean verify) {
            super(info, dlg);
            this.verify = verify;
            BackupDescriptor backup = RestorePanel.this.getSelectedBackup();
            this.dir = backup.getPath().getAbsolutePath();
            this.backupID = backup.getID();
            this.backendSet = new HashSet<String>();
            for (BackendDescriptor backend : info.getServerDescriptor().getBackends()) {
                if (backend.isConfigBackend()) continue;
                this.backendSet.add(backend.getBackendID());
            }
        }

        @Override
        public Task.Type getType() {
            return Task.Type.RESTORE;
        }

        @Override
        public Message getTaskDescription() {
            if (this.verify) {
                return AdminToolMessages.INFO_CTRL_PANEL_VERIFY_TASK_DESCRIPTION.get(this.backupID, this.dir);
            }
            return AdminToolMessages.INFO_CTRL_PANEL_RESTORE_TASK_DESCRIPTION.get(this.backupID, this.dir);
        }

        @Override
        public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
            boolean canLaunch = true;
            if (this.state == Task.State.RUNNING) {
                TreeSet<String> backends = new TreeSet<String>(taskToBeLaunched.getBackends());
                backends.retainAll(this.getBackends());
                if (backends.size() > 0) {
                    incompatibilityReasons.add(this.getIncompatibilityMessage(this, taskToBeLaunched));
                    canLaunch = false;
                }
            }
            return canLaunch;
        }

        @Override
        public void runTask() {
            this.state = Task.State.RUNNING;
            this.lastException = null;
            try {
                List arguments = this.getCommandLineArguments();
                String[] args = new String[((ArrayList)arguments).size()];
                ((ArrayList)arguments).toArray(args);
                this.returnCode = this.isServerRunning() ? Integer.valueOf(RestoreDB.mainRestoreDB(args, false, this.outPrintStream, this.errorPrintStream)) : Integer.valueOf(this.executeCommandLine(this.getCommandLinePath(), args));
                if (this.returnCode != 0) {
                    this.state = Task.State.FINISHED_WITH_ERROR;
                } else {
                    if (!this.verify) {
                        for (String backend : this.getBackends()) {
                            this.getInfo().unregisterModifiedIndexesInBackend(backend);
                        }
                    }
                    this.state = Task.State.FINISHED_SUCCESSFULLY;
                }
            }
            catch (Throwable t) {
                this.lastException = t;
                this.state = Task.State.FINISHED_WITH_ERROR;
            }
        }

        @Override
        public Set<String> getBackends() {
            return this.backendSet;
        }

        protected ArrayList<String> getCommandLineArguments() {
            ArrayList<String> args = new ArrayList<String>();
            args.add("--backupDirectory");
            args.add(this.dir);
            args.add("--backupID");
            args.add(this.backupID);
            if (this.verify) {
                args.add("--dry-run");
            }
            args.addAll(this.getConnectionCommandLineArguments());
            if (this.isServerRunning()) {
                args.addAll(this.getConfigCommandLineArguments());
            }
            args.add(this.getNoPropertiesFileArgument());
            return args;
        }

        @Override
        protected String getCommandLinePath() {
            return this.getCommandLinePath("restore");
        }
    }
}

