/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.opends.guitools.controlpanel.datamodel.Action;
import org.opends.guitools.controlpanel.datamodel.Category;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.components.CategoryButton;
import org.opends.messages.Message;

public class ActionButton
extends JButton {
    private static final long serialVersionUID = -1898192406268037714L;
    private Action action;
    private boolean isBeingPressed;
    private boolean hasMouseOver;
    private static Border buttonBorder;
    private static Border focusBorder;
    private static final Color defaultBackground;
    private static final Color defaultForeground;
    private static final Color mouseOverBackground;
    private static final Color mouseOverForeground;
    private static final Color pressedBackground;
    private static final Color pressedForeground;
    static final Font actionFont;

    public ActionButton(Action action) {
        this.action = action;
        this.setText(action.getName().toString());
        this.setIconTextGap(0);
        this.setHorizontalTextPosition(11);
        this.setHorizontalAlignment(10);
        this.setOpaque(true);
        this.setBorder(buttonBorder);
        this.setFont(actionFont);
        this.setFocusPainted(true);
        this.setContentAreaFilled(false);
        this.setToolTipText(action.getName().toString());
        this.setRolloverEnabled(false);
        Dimension d1 = this.getPreferredSize();
        this.setBorder(focusBorder);
        Dimension d2 = this.getPreferredSize();
        this.setPreferredSize(new Dimension(Math.max(d1.width, d2.width), Math.max(d1.height, d2.height)));
        this.setBorder(buttonBorder);
    }

    public void actionPerformed(ActionEvent ev) {
        this.isBeingPressed = true;
        final boolean[] hadMouseOver = new boolean[]{this.hasMouseOver};
        this.hasMouseOver = true;
        this.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ActionButton.this.isBeingPressed = false;
                ActionButton.this.hasMouseOver = hadMouseOver[0];
                ActionButton.this.repaint();
            }
        });
    }

    public void mousePressed(MouseEvent e) {
        this.isBeingPressed = true;
    }

    public void mouseReleased(MouseEvent e) {
        this.isBeingPressed = false;
    }

    public void mouseExited(MouseEvent e) {
        this.hasMouseOver = false;
        this.repaint();
    }

    public void mouseEntered(MouseEvent e) {
        this.hasMouseOver = true;
        this.repaint();
    }

    public void updateUI() {
        super.updateUI();
        this.setBorder(buttonBorder);
    }

    protected void paintComponent(Graphics g) {
        this.setBorder(this.hasFocus() ? focusBorder : buttonBorder);
        if (this.isBeingPressed && this.hasMouseOver) {
            this.setBackground(pressedBackground);
            g.setColor(pressedBackground);
            Dimension size = this.getSize();
            g.fillRect(0, 0, size.width, size.height);
            this.setForeground(pressedForeground);
        } else if (this.hasMouseOver) {
            this.setBackground(mouseOverBackground);
            g.setColor(mouseOverBackground);
            Dimension size = this.getSize();
            g.fillRect(0, 0, size.width, size.height);
            this.setForeground(mouseOverForeground);
        } else {
            this.setBackground(defaultBackground);
            g.setColor(defaultBackground);
            Dimension size = this.getSize();
            g.fillRect(0, 0, size.width, size.height);
            this.setForeground(defaultForeground);
        }
        super.paintComponent(g);
    }

    public Action getActionObject() {
        return this.action;
    }

    static {
        Category cat = new Category();
        cat.setName(Message.EMPTY);
        CategoryButton b = new CategoryButton(cat);
        int n = b.getIconTextGap() + b.getIcon().getIconWidth() + b.getBorder().getBorderInsets((Component)b).left;
        buttonBorder = new EmptyBorder(5, n, 5, 25);
        focusBorder = BorderFactory.createCompoundBorder(UIManager.getBorder("List.focusCellHighlightBorder"), buttonBorder);
        defaultBackground = ColorAndFontConstants.background;
        defaultForeground = ColorAndFontConstants.foreground;
        mouseOverBackground = ColorAndFontConstants.mouseOverBackground;
        mouseOverForeground = ColorAndFontConstants.mouseOverForeground;
        pressedBackground = ColorAndFontConstants.pressedBackground;
        pressedForeground = ColorAndFontConstants.pressedForeground;
        actionFont = ColorAndFontConstants.defaultFont;
    }
}

