/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.installer.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.event.MinimumSizeComponentListener;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.ui.Utilities;

public class SelectAliasDialog
extends JDialog {
    private JButton okButton;
    private JComboBox comboAliases;
    private boolean isCancelled;
    private static final long serialVersionUID = -8140704273612764046L;

    public SelectAliasDialog(JDialog parent) {
        super(parent);
        this.setTitle(QuickSetupMessages.INFO_SELECT_ALIAS_TITLE.get().toString());
        this.getContentPane().add(this.createPanel());
        this.pack();
        int minWidth = (int)this.getPreferredSize().getWidth();
        int minHeight = (int)this.getPreferredSize().getHeight();
        this.addComponentListener(new MinimumSizeComponentListener(this, minWidth, minHeight));
        this.getRootPane().setDefaultButton(this.okButton);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SelectAliasDialog.this.cancelClicked();
            }
        });
        this.setDefaultCloseOperation(0);
        Utilities.centerOnComponent(this, parent);
        this.setModal(true);
    }

    public void display(String[] aliases) {
        if (aliases == null || aliases.length == 0) {
            throw new IllegalArgumentException("The provided aliases are null or empty.");
        }
        this.isCancelled = true;
        TreeSet<String> s = new TreeSet<String>();
        for (int i = 0; i < aliases.length; ++i) {
            s.add(aliases[i]);
        }
        String[] orderedAliases = new String[s.size()];
        s.toArray(orderedAliases);
        this.comboAliases.setModel(new DefaultComboBoxModel<String>(orderedAliases));
        this.comboAliases.setSelectedIndex(0);
        this.setVisible(true);
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public String getSelectedAlias() {
        return (String)this.comboAliases.getSelectedItem();
    }

    private JPanel createPanel() {
        JPanel p1 = new JPanel(new GridBagLayout());
        p1.setBackground(UIFactory.CURRENT_STEP_PANEL_BACKGROUND);
        p1.setBorder(UIFactory.DIALOG_PANEL_BORDER);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = -1;
        gbc.anchor = 18;
        Insets currentStepInsets = UIFactory.getCurrentStepPanelInsets();
        gbc.insets.top = currentStepInsets.top;
        gbc.insets.left = currentStepInsets.left;
        p1.add((Component)UIFactory.makeJLabel(UIFactory.IconType.INFORMATION_LARGE, null, UIFactory.TextStyle.NO_STYLE), gbc);
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.insets.left = 5;
        gbc.fill = 1;
        Message msg = QuickSetupMessages.INFO_SELECT_ALIAS_MSG.get();
        JEditorPane tf = UIFactory.makeHtmlPane(msg, UIFactory.INSTRUCTIONS_FONT);
        tf.setOpaque(false);
        tf.setEditable(false);
        p1.add((Component)tf, gbc);
        gbc.insets.top = 5;
        gbc.insets.left = currentStepInsets.left;
        gbc.insets.right = currentStepInsets.right;
        gbc.insets.bottom = currentStepInsets.bottom;
        this.comboAliases = new JComboBox();
        this.comboAliases.setPrototypeDisplayValue("The prototype alias name");
        gbc.fill = 0;
        p1.add((Component)this.comboAliases, gbc);
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.weighty = 1.0;
        gbc.fill = 3;
        p1.add(Box.createVerticalGlue(), gbc);
        JPanel p2 = new JPanel(new GridBagLayout());
        p2.setOpaque(false);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 3;
        p2.add(Box.createHorizontalGlue(), gbc);
        this.okButton = UIFactory.makeJButton(QuickSetupMessages.INFO_OK_BUTTON_LABEL.get(), QuickSetupMessages.INFO_SELECT_ALIAS_OK_BUTTON_TOOLTIP.get());
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                SelectAliasDialog.this.okClicked();
            }
        });
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = -1;
        p2.add((Component)this.okButton, gbc);
        JButton cancelButton = UIFactory.makeJButton(QuickSetupMessages.INFO_CANCEL_BUTTON_LABEL.get(), QuickSetupMessages.INFO_SELECT_ALIAS_CANCEL_BUTTON_TOOLTIP.get());
        gbc.gridwidth = 0;
        gbc.insets.left = 5;
        p2.add((Component)cancelButton, gbc);
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                SelectAliasDialog.this.cancelClicked();
            }
        });
        JPanel p = new JPanel(new GridBagLayout());
        p.setBackground(UIFactory.DEFAULT_BACKGROUND);
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        p.add((Component)p1, gbc);
        gbc.weighty = 0.0;
        gbc.insets = UIFactory.getButtonsPanelInsets();
        p.add((Component)p2, gbc);
        return p;
    }

    private void cancelClicked() {
        this.isCancelled = true;
        this.dispose();
    }

    private void okClicked() {
        this.isCancelled = false;
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            SelectAliasDialog dlg = new SelectAliasDialog(new JDialog());
            dlg.display(new String[]{"test1", "test2"});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

