/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.BuildInformation;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.util.OperationOutput;
import org.opends.quicksetup.util.StandardOutputSuppressor;
import org.opends.quicksetup.util.Utils;
import org.opends.server.api.AccessLogPublisher;
import org.opends.server.api.DebugLogPublisher;
import org.opends.server.api.ErrorLogPublisher;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.CompareOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyOperation;
import org.opends.server.loggers.AccessLogger;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.TextAccessLogPublisher;
import org.opends.server.loggers.TextErrorLogPublisher;
import org.opends.server.loggers.TextWriter;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.TextDebugLogPublisher;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.types.Attribute;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringFactory;
import org.opends.server.types.InitializationException;
import org.opends.server.types.Modification;
import org.opends.server.types.RawAttribute;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;
import org.opends.server.util.AddChangeRecordEntry;
import org.opends.server.util.ChangeRecordEntry;
import org.opends.server.util.LDIFException;
import org.opends.server.util.ModifyChangeRecordEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InProcessServerController {
    private static final Logger LOG = Logger.getLogger(InProcessServerController.class.getName());
    private static boolean serverHasBeenStarted = false;
    private static ErrorLogPublisher startupErrorPublisher;
    private static AccessLogPublisher startupAccessPublisher;
    private static DebugLogPublisher startupDebugPublisher;
    private static ServerControllerTextWriter debugWriter;
    private static ServerControllerTextWriter errorWriter;
    private static ServerControllerTextWriter accessWriter;
    private Installation installation;

    public InProcessServerController(Installation installation) throws IllegalStateException {
        BuildInformation currentBi;
        BuildInformation installBi;
        try {
            installBi = installation.getBuildInformation();
            currentBi = BuildInformation.getCurrent();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to verify the build version of the " + installation + " matches the currently executing " + "version.");
        }
        if (!currentBi.equals(installBi)) {
            throw new IllegalStateException("The build version of the installation " + installation + " is " + installBi + " and does not match the currently executing version " + currentBi);
        }
        this.installation = installation;
    }

    public OperationOutput startServer(boolean disableConnectionHandlers) throws InitializationException, ConfigException {
        LOG.log(Level.INFO, "Starting in process server with connection handlers " + (disableConnectionHandlers ? "disabled" : "enabled"));
        System.setProperty("org.opends.server.DisableConnectionHandlers", disableConnectionHandlers ? "true" : "false");
        return this.startServer();
    }

    public static void disableConnectionHandlers(boolean disable) {
        System.setProperty("org.opends.server.DisableConnectionHandlers", disable ? "true" : "false");
    }

    public static void disableSynchronization(boolean disable) {
        System.setProperty("org.opends.server.DisableSynchronization", disable ? "true" : "false");
    }

    public static void disableAdminDataSynchronization(boolean disable) {
        System.setProperty("org.opends.server.DisableAdminDataSynchronization", disable ? "true" : "false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer() {
        LOG.log(Level.INFO, "Shutting down in process server");
        StandardOutputSuppressor.suppress();
        try {
            DirectoryServer.shutDown(this.getClass().getName(), Message.raw("quicksetup requests shutdown", new Object[0]));
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        finally {
            StandardOutputSuppressor.unsuppress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized OperationOutput startServer() throws InitializationException, ConfigException {
        OperationOutput output = new OperationOutput();
        InProcessServerController.setOutputForWriters(output);
        StandardOutputSuppressor.suppress();
        try {
            DirectoryServer directoryServer;
            if (!serverHasBeenStarted) {
                DirectoryServer.getEnvironmentConfig().setServerRoot(this.installation.getRootDirectory());
                directoryServer = DirectoryServer.getInstance();
                LOG.log(Level.FINER, "Bootstrapping directory server");
                directoryServer.bootstrapServer();
                LOG.log(Level.FINER, "Initializing configuration");
                String configClass = "org.opends.server.extensions.ConfigFileHandler";
                String configPath = Utils.getPath(this.installation.getCurrentConfigurationFile());
                directoryServer.initializeConfiguration(configClass, configPath);
            } else {
                LOG.log(Level.FINER, "Reinitializing the server");
                DirectoryServer.reinitialize();
            }
            InProcessServerController.registerListenersForOuput();
            LOG.log(Level.FINER, "Invoking server start");
            directoryServer = DirectoryServer.getInstance();
            directoryServer.startServer();
            serverHasBeenStarted = true;
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        finally {
            StandardOutputSuppressor.unsuppress();
            InProcessServerController.setOutputForWriters(null);
        }
        return output;
    }

    public void modify(ChangeRecordEntry cre) throws IOException, LDIFException, ApplicationException {
        InternalClientConnection cc = InternalClientConnection.getRootConnection();
        ByteString dnByteString = ByteStringFactory.create(cre.getDN().toString());
        switch (cre.getChangeOperationType()) {
            case MODIFY: {
                LOG.log(Level.INFO, "proparing to modify " + dnByteString);
                ModifyChangeRecordEntry mcre = (ModifyChangeRecordEntry)cre;
                ModifyOperation op = cc.processModify(dnByteString, mcre.getModifications());
                ResultCode rc = op.getResultCode();
                if (rc.equals((Object)ResultCode.SUCCESS)) {
                    LOG.log(Level.INFO, "processed server modification " + this.modListToString(op.getModifications()));
                    break;
                }
                if (rc.equals((Object)ResultCode.ATTRIBUTE_OR_VALUE_EXISTS)) {
                    LOG.log(Level.INFO, "ignoring attribute that already exists: " + this.modListToString(op.getModifications()));
                    break;
                }
                if (rc.equals((Object)ResultCode.NO_SUCH_ATTRIBUTE)) {
                    LOG.log(Level.INFO, "Ignoring attribute not found: " + this.modListToString(op.getModifications()));
                    break;
                }
                MessageBuilder error = op.getErrorMessage();
                throw new ApplicationException(ReturnCode.IMPORT_ERROR, QuickSetupMessages.INFO_ERROR_APPLY_LDIF_MODIFY.get(((Object)dnByteString).toString(), error != null ? error.toString() : ""), null);
            }
            case ADD: {
                LOG.log(Level.INFO, "preparing to add " + dnByteString);
                AddChangeRecordEntry acre = (AddChangeRecordEntry)cre;
                List<Attribute> attrs = acre.getAttributes();
                ArrayList<RawAttribute> rawAttrs = new ArrayList<RawAttribute>(attrs.size());
                for (Attribute a : attrs) {
                    rawAttrs.add(new LDAPAttribute(a));
                }
                AddOperation addOp = cc.processAdd(dnByteString, rawAttrs);
                ResultCode rc = addOp.getResultCode();
                if (rc.equals((Object)ResultCode.SUCCESS)) {
                    LOG.log(Level.INFO, "processed server add " + addOp.getEntryDN());
                    break;
                }
                if (rc.equals((Object)ResultCode.ENTRY_ALREADY_EXISTS)) {
                    boolean ignore = true;
                    block8: for (RawAttribute attr : rawAttrs) {
                        ArrayList<ASN1OctetString> values = attr.getValues();
                        for (ASN1OctetString value : values) {
                            CompareOperation compOp = cc.processCompare(dnByteString, attr.getAttributeType(), (ByteString)value);
                            if (!ResultCode.ASSERTION_FAILED.equals((Object)compOp.getResultCode())) continue;
                            ignore = false;
                            continue block8;
                        }
                    }
                    if (ignore) break;
                    MessageBuilder error = addOp.getErrorMessage();
                    throw new ApplicationException(ReturnCode.IMPORT_ERROR, QuickSetupMessages.INFO_ERROR_APPLY_LDIF_ADD.get(((Object)dnByteString).toString(), error != null ? error.toString() : ""), null);
                }
                boolean ignore = false;
                if (rc.equals((Object)ResultCode.ENTRY_ALREADY_EXISTS)) {
                    try {
                        InternalSearchOperation searchOp = cc.processSearch(cre.getDN(), SearchScope.BASE_OBJECT, SearchFilter.createFilterFromString("objectclass=*"));
                        LinkedList<SearchResultEntry> se = searchOp.getSearchEntries();
                        if (se.size() > 0) {
                            SearchResultEntry e = se.get(0);
                            ArrayList<Attribute> eAttrs = new ArrayList<Attribute>();
                            eAttrs.addAll(e.getAttributes());
                            eAttrs.add(e.getObjectClassAttribute());
                            if (this.compareUserAttrs(attrs, eAttrs)) {
                                LOG.log(Level.INFO, "Ignoring failure to add " + dnByteString + " since the existing entry's " + "attributes are identical");
                                ignore = true;
                            }
                        }
                    }
                    catch (Exception e) {
                        LOG.log(Level.INFO, "Error attempting to compare rejected add entry with existing entry", e);
                    }
                }
                if (ignore) break;
                MessageBuilder error = addOp.getErrorMessage();
                throw new ApplicationException(ReturnCode.IMPORT_ERROR, QuickSetupMessages.INFO_ERROR_APPLY_LDIF_ADD.get(((Object)dnByteString).toString(), error != null ? error.toString() : ""), null);
            }
            case DELETE: {
                LOG.log(Level.INFO, "preparing to delete " + dnByteString);
                DeleteOperation delOp = cc.processDelete(dnByteString);
                ResultCode rc = delOp.getResultCode();
                if (rc.equals((Object)ResultCode.SUCCESS)) {
                    LOG.log(Level.INFO, "processed server delete " + delOp.getEntryDN());
                    break;
                }
                MessageBuilder error = delOp.getErrorMessage();
                throw new ApplicationException(ReturnCode.IMPORT_ERROR, QuickSetupMessages.INFO_ERROR_APPLY_LDIF_DELETE.get(((Object)dnByteString).toString(), error != null ? error.toString() : ""), null);
            }
            default: {
                LOG.log(Level.SEVERE, "Unexpected record type " + cre.getClass());
                throw new ApplicationException(ReturnCode.BUG, QuickSetupMessages.INFO_BUG_MSG.get(), null);
            }
        }
    }

    private String modListToString(List<Modification> modifications) {
        StringBuilder modsMsg = new StringBuilder();
        for (int i = 0; i < modifications.size(); ++i) {
            modsMsg.append(modifications.get(i).toString());
            if (i >= modifications.size() - 1) continue;
            modsMsg.append(" ");
        }
        return modsMsg.toString();
    }

    private static void setOutputForWriters(OperationOutput output) {
        debugWriter.setOutput(output);
        errorWriter.setOutput(output);
        accessWriter.setOutput(output);
    }

    private static void registerListenersForOuput() {
        try {
            startupDebugPublisher = TextDebugLogPublisher.getStartupTextDebugPublisher(debugWriter);
            DebugLogger.addDebugLogPublisher(startupDebugPublisher);
            startupErrorPublisher = TextErrorLogPublisher.getStartupTextErrorPublisher(errorWriter);
            ErrorLogger.addErrorLogPublisher(startupErrorPublisher);
            startupAccessPublisher = TextAccessLogPublisher.getStartupTextAccessPublisher(accessWriter, true);
            AccessLogger.addAccessLogPublisher(startupAccessPublisher);
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Error installing test log publishers: " + e.toString());
        }
    }

    private static void unregisterListenersForOutput() {
        DebugLogger.removeDebugLogPublisher(startupDebugPublisher);
        ErrorLogger.removeErrorLogPublisher(startupErrorPublisher);
        AccessLogger.removeAccessLogPublisher(startupAccessPublisher);
    }

    private boolean compareUserAttrs(List<Attribute> l1, List<Attribute> l2) {
        return this.compareUserAttrsInternal(l1, l2) && this.compareUserAttrsInternal(l2, l1);
    }

    private boolean compareUserAttrsInternal(List<Attribute> l1, List<Attribute> l2) {
        for (Attribute l1Attr : l1) {
            if (l1Attr.getAttributeType().isOperational()) continue;
            Attribute l2Attr = null;
            String name = l1Attr.getName();
            if (name != null) {
                for (Attribute tmpl2Attr : l2) {
                    if (!name.equals(tmpl2Attr.getName())) continue;
                    l2Attr = tmpl2Attr;
                    break;
                }
                if (l2Attr != null && (l2Attr.getAttributeType().isOperational() || ((Object)l1Attr).equals(l2Attr))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    static {
        debugWriter = new ServerControllerTextWriter(){

            void storeRecord(String record, OperationOutput output) {
                LOG.log(Level.INFO, "server start (debug log): " + record);
                output.addDebugMessage(Message.raw(record, new Object[0]));
            }
        };
        errorWriter = new ServerControllerTextWriter(){

            void storeRecord(String record, OperationOutput output) {
                LOG.log(Level.INFO, "server start (error log): " + record);
                output.addErrorMessage(Message.raw(record, new Object[0]));
            }
        };
        accessWriter = new ServerControllerTextWriter(){

            void storeRecord(String record, OperationOutput output) {
                LOG.log(Level.INFO, "server start (access log): " + record);
                output.addAccessMessage(Message.raw(record, new Object[0]));
            }
        };
    }

    private static abstract class ServerControllerTextWriter
    implements TextWriter {
        private int bytesWritten = 0;
        private OperationOutput output = null;

        abstract void storeRecord(String var1, OperationOutput var2);

        ServerControllerTextWriter() {
        }

        ServerControllerTextWriter(OperationOutput output) {
            this.setOutput(output);
        }

        public void setOutput(OperationOutput ouput) {
            this.output = ouput;
        }

        public void writeRecord(String record) {
            if (record != null) {
                this.bytesWritten += this.bytesWritten;
                if (this.output != null) {
                    this.storeRecord(record, this.output);
                }
            }
        }

        public void flush() {
        }

        public void shutdown() {
        }

        public long getBytesWritten() {
            return this.bytesWritten;
        }
    }
}

