/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.EnvironmentConfig;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.DurationPropertyDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.std.meta.LocalDBBackendCfgDefn;
import org.opends.server.admin.std.server.LocalDBBackendCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableEnvironment {
    private static final DebugTracer TRACER;
    public static final String ATTR_DATABASE_CACHE_PERCENT = "ds-cfg-db-cache-percent";
    public static final String ATTR_DATABASE_CACHE_SIZE = "ds-cfg-db-cache-size";
    public static final String ATTR_DATABASE_TXN_NO_SYNC = "ds-cfg-db-txn-no-sync";
    public static final String ATTR_DATABASE_TXN_WRITE_NO_SYNC = "ds-cfg-db-txn-write-no-sync";
    public static final String ATTR_DATABASE_RUN_CLEANER = "ds-cfg-db-run-cleaner";
    public static final String ATTR_CLEANER_MIN_UTILIZATION = "ds-cfg-db-cleaner-min-utilization";
    public static final String ATTR_DATABASE_LOG_FILE_MAX = "ds-cfg-db-log-file-max";
    public static final String ATTR_EVICTOR_LRU_ONLY = "ds-cfg-db-evictor-lru-only";
    public static final String ATTR_EVICTOR_NODES_PER_SCAN = "ds-cfg-db-evictor-nodes-per-scan";
    public static final String ATTR_LOGGING_FILE_HANDLER_ON = "ds-cfg-db-logging-file-handler-on";
    public static final String ATTR_LOGGING_LEVEL = "ds-cfg-db-logging-level";
    public static final String ATTR_CHECKPOINTER_BYTES_INTERVAL = "ds-cfg-db-checkpointer-bytes-interval";
    public static final String ATTR_CHECKPOINTER_WAKEUP_INTERVAL = "ds-cfg-db-checkpointer-wakeup-interval";
    public static final String ATTR_NUM_LOCK_TABLES = "ds-cfg-db-num-lock-tables";
    public static final String ATTR_NUM_CLEANER_THREADS = "ds-cfg-db-num-cleaner-threads";
    public static final String ATTR_JE_PROPERTY = "ds-cfg-je-property";
    private static HashMap<String, String> attrMap;
    private static HashMap<String, Method> methodMap;
    private static HashMap<String, PropertyDefinition> defnMap;
    private static final List<String> ABBREVIATIONS;

    private static String propNametoCamlCase(String hyphenated) {
        String[] components = hyphenated.split("\\-");
        StringBuilder buffer = new StringBuilder();
        for (String component : components) {
            if (ABBREVIATIONS.contains(component)) {
                buffer.append(component.toUpperCase());
                continue;
            }
            buffer.append(component.substring(0, 1).toUpperCase() + component.substring(1));
        }
        return buffer.toString();
    }

    private static void registerProp(String propertyName, String attrName) throws Exception {
        String baseName = attrName.substring(7);
        String methodBaseName = ConfigurableEnvironment.propNametoCamlCase(baseName);
        Class<LocalDBBackendCfg> configClass = LocalDBBackendCfg.class;
        LocalDBBackendCfgDefn defn = LocalDBBackendCfgDefn.getInstance();
        Class<?> defClass = defn.getClass();
        PropertyDefinition propDefn = (PropertyDefinition)defClass.getMethod("get" + methodBaseName + "PropertyDefinition", new Class[0]).invoke((Object)defn, new Object[0]);
        String methodName = propDefn instanceof BooleanPropertyDefinition ? "is" + methodBaseName : "get" + methodBaseName;
        defnMap.put(attrName, propDefn);
        methodMap.put(attrName, configClass.getMethod(methodName, new Class[0]));
        attrMap.put(propertyName, attrName);
    }

    public static String getAttributeForProperty(String jeProperty) {
        return attrMap.get(jeProperty);
    }

    private static String getPropertyValue(LocalDBBackendCfg cfg, String attrName) {
        try {
            PropertyDefinition propDefn = defnMap.get(attrName);
            Method method = methodMap.get(attrName);
            if (propDefn instanceof DurationPropertyDefinition) {
                Long value = (Long)method.invoke((Object)cfg, new Object[0]);
                DurationPropertyDefinition durationPropDefn = (DurationPropertyDefinition)propDefn;
                value = 1000L * durationPropDefn.getBaseUnit().toMilliSeconds(value.longValue());
                return String.valueOf(value);
            }
            Object value = method.invoke((Object)cfg, new Object[0]);
            return String.valueOf(value);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return "";
        }
    }

    public static EnvironmentConfig defaultConfig() {
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setTransactional(true);
        envConfig.setAllowCreate(true);
        envConfig.setConfigParam("je.env.sharedLatches", "true");
        envConfig.setConfigParam("je.cleaner.expunge", "true");
        return envConfig;
    }

    public static EnvironmentConfig parseConfigEntry(LocalDBBackendCfg cfg) throws ConfigException {
        EnvironmentConfig envConfig = ConfigurableEnvironment.defaultConfig();
        envConfig.setTxnNoSync(cfg.isDBTxnNoSync());
        envConfig.setTxnWriteNoSync(cfg.isDBTxnWriteNoSync());
        for (Map.Entry<String, String> mapEntry : attrMap.entrySet()) {
            String jeProperty = mapEntry.getKey();
            String attrName = mapEntry.getValue();
            String value = ConfigurableEnvironment.getPropertyValue(cfg, attrName);
            envConfig.setConfigParam(jeProperty, value);
        }
        SortedSet<String> jeProperties = cfg.getJEProperty();
        envConfig = ConfigurableEnvironment.setJEProperties(envConfig, jeProperties, attrMap);
        return envConfig;
    }

    public static EnvironmentConfig setJEProperties(EnvironmentConfig envConfig, SortedSet<String> jeProperties, HashMap<String, String> configAttrMap) throws ConfigException {
        if (jeProperties.isEmpty()) {
            return envConfig;
        }
        HashSet<String> uniqueJEProperties = new HashSet<String>();
        for (String jeEntry : jeProperties) {
            StringTokenizer st = new StringTokenizer(jeEntry, "=");
            if (st.countTokens() == 2) {
                String jePropertyName = st.nextToken();
                String jePropertyValue = st.nextToken();
                if (uniqueJEProperties.contains(jePropertyName)) {
                    Message message = ConfigMessages.ERR_CONFIG_JE_DUPLICATE_PROPERTY.get(jePropertyName);
                    throw new ConfigException(message);
                }
                try {
                    envConfig.setConfigParam(jePropertyName, jePropertyValue);
                    if (jePropertyName.equals("java.util.logging.level")) {
                        Level.parse(jePropertyValue);
                    }
                    if (configAttrMap.containsKey(jePropertyName)) {
                        Message message = ConfigMessages.ERR_CONFIG_JE_PROPERTY_SHADOWS_CONFIG.get(jePropertyName, attrMap.get(jePropertyName));
                        throw new ConfigException(message);
                    }
                    uniqueJEProperties.add(jePropertyName);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = ConfigMessages.ERR_CONFIG_JE_PROPERTY_INVALID.get(jeEntry, e.getMessage());
                    throw new ConfigException(message, e.getCause());
                }
            }
            Message message = ConfigMessages.ERR_CONFIG_JE_PROPERTY_INVALID_FORM.get(jeEntry);
            throw new ConfigException(message);
        }
        return envConfig;
    }

    static {
        block2: {
            TRACER = DebugLogger.getTracer();
            attrMap = new HashMap();
            methodMap = new HashMap();
            defnMap = new HashMap();
            ABBREVIATIONS = Arrays.asList("aci", "ip", "ssl", "dn", "rdn", "jmx", "smtp", "http", "https", "ldap", "ldaps", "ldif", "jdbc", "tcp", "tls", "pkcs11", "sasl", "gssapi", "md5", "je", "dse", "fifo", "vlv", "uuid", "md5", "sha1", "sha256", "sha384", "sha512", "tls", "db");
            try {
                ConfigurableEnvironment.registerProp("je.maxMemoryPercent", ATTR_DATABASE_CACHE_PERCENT);
                ConfigurableEnvironment.registerProp("je.maxMemory", ATTR_DATABASE_CACHE_SIZE);
                ConfigurableEnvironment.registerProp("je.cleaner.minUtilization", ATTR_CLEANER_MIN_UTILIZATION);
                ConfigurableEnvironment.registerProp("je.env.runCleaner", ATTR_DATABASE_RUN_CLEANER);
                ConfigurableEnvironment.registerProp("je.evictor.lruOnly", ATTR_EVICTOR_LRU_ONLY);
                ConfigurableEnvironment.registerProp("je.evictor.nodesPerScan", ATTR_EVICTOR_NODES_PER_SCAN);
                ConfigurableEnvironment.registerProp("je.log.fileMax", ATTR_DATABASE_LOG_FILE_MAX);
                ConfigurableEnvironment.registerProp("java.util.logging.FileHandler.on", ATTR_LOGGING_FILE_HANDLER_ON);
                ConfigurableEnvironment.registerProp("java.util.logging.level", ATTR_LOGGING_LEVEL);
                ConfigurableEnvironment.registerProp("je.checkpointer.bytesInterval", ATTR_CHECKPOINTER_BYTES_INTERVAL);
                ConfigurableEnvironment.registerProp("je.checkpointer.wakeupInterval", ATTR_CHECKPOINTER_WAKEUP_INTERVAL);
                ConfigurableEnvironment.registerProp("je.lock.nLockTables", ATTR_NUM_LOCK_TABLES);
                ConfigurableEnvironment.registerProp("je.cleaner.threads", ATTR_NUM_CLEANER_THREADS);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block2;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }
}

