/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb.importLDIF;

import com.sleepycat.je.dbi.MemoryBudget;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.JebFormat;
import org.opends.server.backends.jeb.importLDIF.ImportIDSet;
import org.opends.server.util.RuntimeInformation;

public class LongImportIDSet
implements ImportIDSet {
    private boolean dirty = true;
    private static final int LONGS_OVERHEAD = RuntimeInformation.is64Bit() ? 25 : 25;
    private static final int LONGS_OVERHEAD_32 = 25;
    private static final int LONGS_OVERHEAD_64 = 25;
    private long[] array = null;
    private int count = 0;
    boolean isDefined = true;
    private long undefinedSize = 0L;

    public LongImportIDSet() {
    }

    public LongImportIDSet(EntryID id) {
        this.array = new long[1];
        this.array[0] = id.longValue();
        this.count = 1;
    }

    public void setEntryID(EntryID id) {
        if (this.array == null) {
            this.array = new long[1];
        }
        this.reset();
        this.array[0] = id.longValue();
        this.count = 1;
    }

    public void reset() {
        this.count = 0;
        this.isDefined = true;
        this.undefinedSize = 0L;
        this.dirty = true;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDefined() {
        return this.isDefined;
    }

    public void setUndefined() {
        this.array = null;
        this.isDefined = false;
    }

    public long getUndefinedSize() {
        return this.undefinedSize;
    }

    public int getMemorySize() {
        if (this.array != null) {
            return LONGS_OVERHEAD + MemoryBudget.byteArraySize((int)(this.array.length * 8));
        }
        return LONGS_OVERHEAD;
    }

    public void merge(ImportIDSet importIDSet, int limit, boolean maintainCount) {
        if (!this.isDefined()) {
            if (maintainCount) {
                this.undefinedSize = importIDSet.isDefined() ? (this.undefinedSize += (long)importIDSet.size()) : (this.undefinedSize += importIDSet.getUndefinedSize());
            }
            return;
        }
        if (this.isDefined() && this.count + importIDSet.size() > limit) {
            this.isDefined = false;
            this.undefinedSize = maintainCount ? (long)(this.size() + importIDSet.size()) : Long.MAX_VALUE;
            this.array = null;
            this.count = 0;
        } else {
            this.addAll((LongImportIDSet)importIDSet);
        }
    }

    public boolean merge(byte[] DBbytes, ImportIDSet importIdSet, int limit, boolean maintainCount) {
        boolean dbUndefined;
        boolean incrLimitCount = false;
        boolean bl = dbUndefined = (DBbytes[0] & 0x80) == 128;
        if (dbUndefined) {
            this.isDefined = false;
            this.undefinedSize = Long.MAX_VALUE;
        } else if (!importIdSet.isDefined()) {
            this.isDefined = false;
            incrLimitCount = true;
            this.undefinedSize = Long.MAX_VALUE;
        } else {
            this.array = JebFormat.entryIDListFromDatabase(DBbytes);
            if (this.array.length + importIdSet.size() > limit) {
                this.isDefined = false;
                incrLimitCount = true;
                importIdSet.setUndefined();
                this.undefinedSize = Long.MAX_VALUE;
            } else {
                this.count = this.array.length;
                this.addAll((LongImportIDSet)importIdSet);
            }
        }
        return incrLimitCount;
    }

    public void addEntryID(EntryID entryID, int limit, boolean maintainCount) {
        if (!this.isDefined()) {
            if (maintainCount) {
                ++this.undefinedSize;
            }
            return;
        }
        if (this.isDefined() && this.count + 1 > limit) {
            this.isDefined = false;
            this.array = null;
            this.undefinedSize = maintainCount ? (long)(this.count + 1) : Long.MAX_VALUE;
            this.count = 0;
        } else {
            this.add(entryID.longValue());
        }
    }

    public byte[] toDatabase() {
        if (this.isDefined()) {
            return this.encode(null);
        }
        return JebFormat.entryIDUndefinedSizeToDatabase(this.undefinedSize);
    }

    void decode(byte[] bytes) {
        if (bytes == null) {
            this.count = 0;
            return;
        }
        int count = bytes.length / 8;
        this.resize(count);
        int pos = 0;
        for (int i = 0; i < count; ++i) {
            long v = 0L;
            v |= ((long)bytes[pos++] & 0xFFL) << 56;
            v |= ((long)bytes[pos++] & 0xFFL) << 48;
            v |= ((long)bytes[pos++] & 0xFFL) << 40;
            v |= ((long)bytes[pos++] & 0xFFL) << 32;
            v |= ((long)bytes[pos++] & 0xFFL) << 24;
            v |= ((long)bytes[pos++] & 0xFFL) << 16;
            v |= ((long)bytes[pos++] & 0xFFL) << 8;
            this.array[i] = v |= (long)bytes[pos++] & 0xFFL;
        }
        this.count = count;
    }

    byte[] encode(byte[] bytes) {
        int encodedSize = this.count * 8;
        if (bytes == null || bytes.length < encodedSize) {
            bytes = new byte[encodedSize];
        }
        int pos = 0;
        for (int i = 0; i < this.count; ++i) {
            long v = this.array[i];
            bytes[pos++] = (byte)(v >>> 56 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 48 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 40 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 32 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 24 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 16 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 8 & 0xFFL);
            bytes[pos++] = (byte)(v & 0xFFL);
        }
        return bytes;
    }

    private static int binarySearch(long[] a, int count, long key) {
        int low = 0;
        int high = count - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            long midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private boolean add(long v) {
        this.resize(this.count + 1);
        if (this.count == 0 || v > this.array[this.count - 1]) {
            this.array[this.count++] = v;
            return true;
        }
        int pos = LongImportIDSet.binarySearch(this.array, this.count, v);
        if (pos >= 0) {
            return false;
        }
        pos = -(pos + 1);
        System.arraycopy(this.array, pos, this.array, pos + 1, this.count - pos);
        this.array[pos] = v;
        ++this.count;
        return true;
    }

    private void addAll(LongImportIDSet that) {
        int bRemain;
        this.resize(this.count + that.count);
        if (that.count == 0) {
            return;
        }
        if (this.count == 0 || that.array[0] > this.array[this.count - 1]) {
            System.arraycopy(that.array, 0, this.array, this.count, that.count);
            this.count += that.count;
            return;
        }
        if (this.array[0] > that.array[that.count - 1]) {
            System.arraycopy(this.array, 0, this.array, that.count, this.count);
            System.arraycopy(that.array, 0, this.array, 0, that.count);
            this.count += that.count;
            return;
        }
        int destPos = LongImportIDSet.binarySearch(this.array, this.count, that.array[0]);
        if (destPos < 0) {
            destPos = -(destPos + 1);
        }
        int aCount = this.count - destPos;
        int aPos = destPos + that.count;
        int aEnd = aPos + aCount;
        System.arraycopy(this.array, destPos, this.array, aPos, aCount);
        if (this.array[aPos] > that.array[that.count - 1]) {
            System.arraycopy(that.array, 0, this.array, destPos, that.count);
            this.count += that.count;
            return;
        }
        int bPos = 0;
        while (aPos < aEnd && bPos < that.count) {
            if (this.array[aPos] < that.array[bPos]) {
                this.array[destPos++] = this.array[aPos++];
                continue;
            }
            if (this.array[aPos] > that.array[bPos]) {
                this.array[destPos++] = that.array[bPos++];
                continue;
            }
            this.array[destPos++] = this.array[aPos++];
            ++bPos;
        }
        int aRemain = aEnd - aPos;
        if (aRemain > 0) {
            System.arraycopy(this.array, aPos, this.array, destPos, aRemain);
            destPos += aRemain;
        }
        if ((bRemain = that.count - bPos) > 0) {
            System.arraycopy(that.array, bPos, this.array, destPos, bRemain);
            destPos += bRemain;
        }
        this.count = destPos;
    }

    public int size() {
        return this.count;
    }

    private void resize(int size) {
        if (this.array == null) {
            this.array = new long[size];
        } else if (this.array.length < size) {
            int newSize;
            int n = newSize = this.array.length == 0 ? 1 : this.array.length;
            while ((newSize *= 2) < size) {
            }
            long[] newBytes = new long[newSize];
            System.arraycopy(this.array, 0, newBytes, 0, this.count);
            this.array = newBytes;
        }
    }
}

