/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core.networkgroups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.opends.server.admin.std.meta.NetworkGroupCriteriaCfgDefn;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.networkgroups.NetworkGroupCriterion;
import org.opends.server.types.AuthenticationType;
import org.opends.server.types.DN;

public class AuthMethodCriteria
implements NetworkGroupCriterion {
    private Collection<NetworkGroupCriteriaCfgDefn.AllowedAuthMethod> authMethods = new TreeSet<NetworkGroupCriteriaCfgDefn.AllowedAuthMethod>();

    public void addAuthMethod(NetworkGroupCriteriaCfgDefn.AllowedAuthMethod method) {
        this.authMethods.add(method);
    }

    public boolean match(ClientConnection connection) {
        ArrayList<AuthenticationType> authTypes = new ArrayList<AuthenticationType>();
        for (NetworkGroupCriteriaCfgDefn.AllowedAuthMethod method : this.authMethods) {
            if (method == NetworkGroupCriteriaCfgDefn.AllowedAuthMethod.ANONYMOUS) {
                if (connection.getAuthenticationInfo().isAuthenticated()) continue;
                return true;
            }
            if (method == NetworkGroupCriteriaCfgDefn.AllowedAuthMethod.SASL) {
                authTypes.add(AuthenticationType.SASL);
                continue;
            }
            if (method != NetworkGroupCriteriaCfgDefn.AllowedAuthMethod.SIMPLE) continue;
            authTypes.add(AuthenticationType.SIMPLE);
        }
        return connection.getAuthenticationInfo().hasAnyAuthenticationType(authTypes);
    }

    public boolean matchAfterBind(ClientConnection connection, DN bindDN, AuthenticationType authType, boolean isSecure) {
        for (NetworkGroupCriteriaCfgDefn.AllowedAuthMethod method : this.authMethods) {
            if (method == NetworkGroupCriteriaCfgDefn.AllowedAuthMethod.ANONYMOUS && bindDN.toNormalizedString().equals("")) {
                return true;
            }
            if (method == NetworkGroupCriteriaCfgDefn.AllowedAuthMethod.SASL && authType == AuthenticationType.SASL) {
                return true;
            }
            if (method != NetworkGroupCriteriaCfgDefn.AllowedAuthMethod.SIMPLE || authType != AuthenticationType.SIMPLE || bindDN.toNormalizedString().equals("")) continue;
            return true;
        }
        return false;
    }
}

