/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core.networkgroups;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.server.NetworkGroupCfg;
import org.opends.server.admin.std.server.NetworkGroupCriteriaCfg;
import org.opends.server.admin.std.server.NetworkGroupRequestFilteringPolicyCfg;
import org.opends.server.admin.std.server.NetworkGroupResourceLimitsCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.WorkflowImpl;
import org.opends.server.core.networkgroups.NetworkGroup;
import org.opends.server.core.networkgroups.NetworkGroupCriteria;
import org.opends.server.core.networkgroups.RequestFilteringPolicy;
import org.opends.server.core.networkgroups.ResourceLimits;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkGroupConfigManager
implements ConfigurationChangeListener<NetworkGroupCfg>,
ConfigurationAddListener<NetworkGroupCfg>,
ConfigurationDeleteListener<NetworkGroupCfg> {
    private ConcurrentHashMap<DN, NetworkGroup> networkGroups = new ConcurrentHashMap();

    public void initializeNetworkGroups() throws ConfigException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addNetworkGroupAddListener(this);
        rootConfiguration.addNetworkGroupDeleteListener(this);
        for (String networkGroupName : rootConfiguration.listNetworkGroups()) {
            NetworkGroupCfg networkGroupConfiguration = rootConfiguration.getNetworkGroup(networkGroupName);
            networkGroupConfiguration.addChangeListener(this);
            if (!networkGroupConfiguration.isEnabled()) continue;
            try {
                this.createAndRegisterNetworkGroup(networkGroupConfiguration);
            }
            catch (DirectoryException de) {
                throw new ConfigException(de.getMessageObject());
            }
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(NetworkGroupCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(NetworkGroupCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        configuration.addChangeListener(this);
        if (configuration.isEnabled()) {
            try {
                this.createAndRegisterNetworkGroup(configuration);
            }
            catch (DirectoryException de) {
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
                messages.add(de.getMessageObject());
            }
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(NetworkGroupCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(NetworkGroupCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        NetworkGroup networkGroup = this.networkGroups.remove(configuration.dn());
        if (networkGroup != null) {
            networkGroup.deregister();
            networkGroup.finalizeNetworkGroup();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(NetworkGroupCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(NetworkGroupCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        ConfigChangeResult configChangeResult = new ConfigChangeResult(resultCode, adminActionRequired, messages);
        NetworkGroup existingNetworkGroup = this.networkGroups.get(configuration.dn());
        if (!configuration.isEnabled()) {
            if (existingNetworkGroup != null) {
                this.networkGroups.remove(configuration.dn());
                existingNetworkGroup.deregister();
                existingNetworkGroup.finalizeNetworkGroup();
            }
            return configChangeResult;
        }
        if (existingNetworkGroup == null) {
            try {
                this.createAndRegisterNetworkGroup(configuration);
            }
            catch (DirectoryException de) {
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
                messages.add(de.getMessageObject());
            }
        } else {
            existingNetworkGroup.setNetworkGroupPriority(configuration.getPriority());
            SortedSet<String> configWorkflows = configuration.getWorkflow();
            for (String id : existingNetworkGroup.getRegisteredWorkflows()) {
                if (configWorkflows.contains(id)) continue;
                existingNetworkGroup.deregisterWorkflow(id);
            }
            List<String> ngWorkflows = existingNetworkGroup.getRegisteredWorkflows();
            for (String id : configuration.getWorkflow()) {
                if (ngWorkflows.contains(id)) continue;
                WorkflowImpl workflowImpl = (WorkflowImpl)WorkflowImpl.getWorkflow(id);
                try {
                    existingNetworkGroup.registerWorkflow(workflowImpl);
                }
                catch (DirectoryException de) {
                    if (resultCode == ResultCode.SUCCESS) {
                        resultCode = de.getResultCode();
                    }
                    messages.add(de.getMessageObject());
                }
            }
        }
        configChangeResult = new ConfigChangeResult(resultCode, adminActionRequired, messages);
        return configChangeResult;
    }

    private void createAndRegisterNetworkGroup(NetworkGroupCfg networkGroupCfg) throws DirectoryException {
        NetworkGroupRequestFilteringPolicyCfg policyCfg;
        NetworkGroupResourceLimitsCfg limitsCfg;
        NetworkGroupCriteriaCfg criteriaCfg;
        String networkGroupId = networkGroupCfg.getNetworkGroupId();
        NetworkGroup networkGroup = new NetworkGroup(networkGroupId);
        for (String workflowID : networkGroupCfg.getWorkflow()) {
            WorkflowImpl workflowImpl = (WorkflowImpl)WorkflowImpl.getWorkflow(workflowID);
            if (workflowImpl == null) {
                Message message = CoreMessages.INFO_ERR_WORKFLOW_DOES_NOT_EXIST.get(workflowID, networkGroupId);
                ErrorLogger.logError(message);
                continue;
            }
            networkGroup.registerWorkflow(workflowImpl);
        }
        WorkflowImpl rootDSEworkflow = (WorkflowImpl)WorkflowImpl.getWorkflow("__root.dse__#");
        networkGroup.registerWorkflow(rootDSEworkflow);
        this.networkGroups.put(networkGroupCfg.dn(), networkGroup);
        networkGroup.register();
        networkGroup.setNetworkGroupPriority(networkGroupCfg.getPriority());
        try {
            criteriaCfg = networkGroupCfg.getNetworkGroupCriteria();
        }
        catch (ConfigException ce) {
            criteriaCfg = null;
        }
        NetworkGroupCriteria criteria = new NetworkGroupCriteria(criteriaCfg);
        networkGroup.setCriteria(criteria);
        try {
            networkGroupCfg.addNetworkGroupCriteriaAddListener(criteria);
            networkGroupCfg.addNetworkGroupCriteriaDeleteListener(criteria);
        }
        catch (ConfigException ex) {
            throw new DirectoryException(ResultCode.UNDEFINED, ex.getMessageObject());
        }
        try {
            limitsCfg = networkGroupCfg.getNetworkGroupResourceLimits();
        }
        catch (ConfigException ex) {
            limitsCfg = null;
        }
        ResourceLimits limits = new ResourceLimits(limitsCfg);
        networkGroup.setResourceLimits(limits);
        try {
            networkGroupCfg.addNetworkGroupResourceLimitsAddListener(limits);
            networkGroupCfg.addNetworkGroupResourceLimitsDeleteListener(limits);
        }
        catch (ConfigException ex) {
            throw new DirectoryException(ResultCode.UNDEFINED, ex.getMessageObject());
        }
        try {
            policyCfg = networkGroupCfg.getNetworkGroupRequestFilteringPolicy();
        }
        catch (ConfigException ex) {
            policyCfg = null;
        }
        RequestFilteringPolicy policy = new RequestFilteringPolicy(policyCfg);
        networkGroup.setRequestFilteringPolicy(policy);
        try {
            networkGroupCfg.addNetworkGroupRequestFilteringPolicyAddListener(policy);
            networkGroupCfg.addNetworkGroupRequestFilteringPolicyDeleteListener(policy);
        }
        catch (ConfigException ex) {
            throw new DirectoryException(ResultCode.UNDEFINED, ex.getMessageObject());
        }
    }
}

