/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core.networkgroups;

import java.util.ArrayList;
import java.util.List;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.std.meta.NetworkGroupCriteriaCfgDefn;
import org.opends.server.admin.std.server.NetworkGroupCriteriaCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.networkgroups.AuthMethodCriteria;
import org.opends.server.core.networkgroups.BindDnCriteria;
import org.opends.server.core.networkgroups.IpFilterCriteria;
import org.opends.server.core.networkgroups.NetworkGroupCriterion;
import org.opends.server.core.networkgroups.PortCriteria;
import org.opends.server.core.networkgroups.SecurityCriteria;
import org.opends.server.types.AddressMask;
import org.opends.server.types.AuthenticationType;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkGroupCriteria
implements ConfigurationAddListener<NetworkGroupCriteriaCfg>,
ConfigurationDeleteListener<NetworkGroupCriteriaCfg>,
ConfigurationChangeListener<NetworkGroupCriteriaCfg>,
NetworkGroupCriterion {
    private boolean isConfigured = false;
    private AuthMethodCriteria authMethodCriteria;
    private BindDnCriteria bindDnCriteria;
    private IpFilterCriteria ipFilterCriteria;
    private PortCriteria portCriteria;
    private SecurityCriteria securityCriteria;
    private NetworkGroupCriteriaCfg config;

    public NetworkGroupCriteria(NetworkGroupCriteriaCfg criteriaCfg) throws DirectoryException {
        this.createCriteria(criteriaCfg);
    }

    private void resetCriteria() {
        this.authMethodCriteria = null;
        this.bindDnCriteria = null;
        this.ipFilterCriteria = null;
        this.portCriteria = null;
        this.securityCriteria = null;
        this.isConfigured = false;
        if (this.config != null) {
            this.config.removeChangeListener(this);
            this.config = null;
        }
    }

    private void createCriteria(NetworkGroupCriteriaCfg criteriaCfg) throws DirectoryException {
        if (criteriaCfg != null) {
            if (!criteriaCfg.getAllowedAuthMethod().isEmpty()) {
                this.authMethodCriteria = new AuthMethodCriteria();
                for (NetworkGroupCriteriaCfgDefn.AllowedAuthMethod allowedAuthMethod : criteriaCfg.getAllowedAuthMethod()) {
                    this.authMethodCriteria.addAuthMethod(allowedAuthMethod);
                }
            } else {
                this.authMethodCriteria = null;
            }
            if (!criteriaCfg.getBindDNFilter().isEmpty()) {
                this.bindDnCriteria = new BindDnCriteria();
                for (String string : criteriaCfg.getBindDNFilter()) {
                    this.bindDnCriteria.addBindDnFilter(string);
                }
            } else {
                this.bindDnCriteria = null;
            }
            if (!criteriaCfg.getIPAddressFilter().isEmpty()) {
                this.ipFilterCriteria = new IpFilterCriteria();
                for (AddressMask addressMask : criteriaCfg.getIPAddressFilter()) {
                    this.ipFilterCriteria.addIpFilter(addressMask);
                }
            } else {
                this.ipFilterCriteria = null;
            }
            if (!criteriaCfg.getAllowedLDAPPort().isEmpty()) {
                this.portCriteria = new PortCriteria();
                for (NetworkGroupCriteriaCfgDefn.AllowedLDAPPort allowedLDAPPort : criteriaCfg.getAllowedLDAPPort()) {
                    this.portCriteria.addPort(allowedLDAPPort);
                }
            } else {
                this.portCriteria = null;
            }
            this.securityCriteria = criteriaCfg.isIsSecurityMandatory() ? new SecurityCriteria(true) : null;
            this.isConfigured = true;
            if (this.config == null) {
                criteriaCfg.addChangeListener(this);
            }
            this.config = criteriaCfg;
        } else {
            this.resetCriteria();
        }
    }

    public void setAuthMethodCriteria(AuthMethodCriteria criteria) {
        this.authMethodCriteria = criteria;
        this.isConfigured = true;
    }

    public void setBindDnCriteria(BindDnCriteria criteria) {
        this.bindDnCriteria = criteria;
        this.isConfigured = true;
    }

    public void setIpFilterCriteria(IpFilterCriteria criteria) {
        this.ipFilterCriteria = criteria;
        this.isConfigured = true;
    }

    public void setPortCriteria(PortCriteria criteria) {
        this.portCriteria = criteria;
        this.isConfigured = true;
    }

    public void setSecurityCriteria(SecurityCriteria criteria) {
        this.securityCriteria = criteria;
        this.isConfigured = true;
    }

    @Override
    public boolean match(ClientConnection connection) {
        if (this.authMethodCriteria != null && !this.authMethodCriteria.match(connection)) {
            return false;
        }
        if (this.bindDnCriteria != null && !this.bindDnCriteria.match(connection)) {
            return false;
        }
        if (this.ipFilterCriteria != null && !this.ipFilterCriteria.match(connection)) {
            return false;
        }
        if (this.portCriteria != null && !this.portCriteria.match(connection)) {
            return false;
        }
        return this.securityCriteria == null || this.securityCriteria.match(connection);
    }

    @Override
    public boolean matchAfterBind(ClientConnection connection, DN bindDN, AuthenticationType authType, boolean isSecure) {
        if (this.authMethodCriteria != null && !this.authMethodCriteria.matchAfterBind(connection, bindDN, authType, isSecure)) {
            return false;
        }
        if (this.bindDnCriteria != null && !this.bindDnCriteria.matchAfterBind(connection, bindDN, authType, isSecure)) {
            return false;
        }
        if (this.ipFilterCriteria != null && !this.ipFilterCriteria.matchAfterBind(connection, bindDN, authType, isSecure)) {
            return false;
        }
        if (this.portCriteria != null && !this.portCriteria.matchAfterBind(connection, bindDN, authType, isSecure)) {
            return false;
        }
        return this.securityCriteria == null || this.securityCriteria.matchAfterBind(connection, bindDN, authType, isSecure);
    }

    @Override
    public boolean isConfigurationAddAcceptable(NetworkGroupCriteriaCfg configuration, List<Message> unacceptableReasons) {
        return !this.isConfigured;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(NetworkGroupCriteriaCfg cfg) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        ConfigChangeResult configChangeResult = new ConfigChangeResult(resultCode, adminActionRequired, messages);
        try {
            this.createCriteria(cfg);
        }
        catch (DirectoryException de) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(de.getMessageObject());
        }
        return configChangeResult;
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(NetworkGroupCriteriaCfg configuration, List<Message> unacceptableReasons) {
        return this.isConfigured;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(NetworkGroupCriteriaCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        ConfigChangeResult configChangeResult = new ConfigChangeResult(resultCode, adminActionRequired, messages);
        this.resetCriteria();
        return configChangeResult;
    }

    @Override
    public boolean isConfigurationChangeAcceptable(NetworkGroupCriteriaCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(NetworkGroupCriteriaCfg cfg) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        ConfigChangeResult configChangeResult = new ConfigChangeResult(resultCode, adminActionRequired, messages);
        try {
            this.createCriteria(cfg);
        }
        catch (DirectoryException de) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(de.getMessageObject());
        }
        return configChangeResult;
    }
}

