/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core.networkgroups;

import java.util.ArrayList;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.networkgroups.NetworkGroup;
import org.opends.server.core.networkgroups.RequestFilteringPolicyStat;
import org.opends.server.core.networkgroups.ResourceLimitsStat;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.types.Attribute;
import org.opends.server.types.Attributes;
import org.opends.server.types.InitializationException;
import org.opends.server.types.SearchScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkGroupStatistics
extends MonitorProvider<MonitorProviderCfg> {
    private String instanceName;
    private NetworkGroup networkGroup;
    private Object lock = new Object();
    private long abandonRequests = 0L;
    private long addRequests = 0L;
    private long bindRequests = 0L;
    private long compareRequests = 0L;
    private long deleteRequests = 0L;
    private long extendedRequests = 0L;
    private long modifyRequests = 0L;
    private long modifyDNRequests = 0L;
    private long searchOneRequests = 0L;
    private long searchSubRequests = 0L;
    private long unbindRequests = 0L;

    public NetworkGroupStatistics(NetworkGroup networkGroup, String instanceName) {
        super("LDAP Statistics Monitor Provider");
        this.instanceName = instanceName;
        this.networkGroup = networkGroup;
        DirectoryServer.registerMonitorProvider(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMessageRead(LDAPMessage message) {
        Object object = this.lock;
        synchronized (object) {
            switch (message.getProtocolOp().getType()) {
                case 80: {
                    ++this.abandonRequests;
                    break;
                }
                case 104: {
                    ++this.addRequests;
                    break;
                }
                case 96: {
                    ++this.bindRequests;
                    break;
                }
                case 110: {
                    ++this.compareRequests;
                    break;
                }
                case 74: {
                    ++this.deleteRequests;
                    break;
                }
                case 119: {
                    ++this.extendedRequests;
                    break;
                }
                case 102: {
                    ++this.modifyRequests;
                    break;
                }
                case 108: {
                    ++this.modifyDNRequests;
                    break;
                }
                case 99: {
                    SearchScope scope = message.getSearchRequestProtocolOp().getScope();
                    if (scope == SearchScope.BASE_OBJECT || scope == SearchScope.SINGLE_LEVEL) {
                        ++this.searchOneRequests;
                        break;
                    }
                    ++this.searchSubRequests;
                    break;
                }
                case 66: {
                    ++this.unbindRequests;
                }
            }
        }
    }

    @Override
    public void initializeMonitorProvider(MonitorProviderCfg configuration) throws ConfigException, InitializationException {
        Message message = ProtocolMessages.ERR_LDAP_STATS_INVALID_MONITOR_INITIALIZATION.get(String.valueOf(configuration.dn()));
        throw new ConfigException(message);
    }

    @Override
    public String getMonitorInstanceName() {
        return this.instanceName;
    }

    @Override
    public long getUpdateInterval() {
        return -1L;
    }

    @Override
    public void updateMonitorData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Attribute> getMonitorData() {
        ResourceLimitsStat resLimitStat;
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        RequestFilteringPolicyStat requestFilteringPolicyStat = this.networkGroup.getRequestFilteringPolicyStat();
        if (requestFilteringPolicyStat != null) {
            attrs.add(Attributes.create("ds-mon-rejected-attributes-total-count", String.valueOf(requestFilteringPolicyStat.getRejectedAttributes())));
            attrs.add(Attributes.create("ds-mon-rejected-operations-total-count", String.valueOf(requestFilteringPolicyStat.getRejectedOperations())));
            attrs.add(Attributes.create("ds-mon-rejected-search-scopes-total-count", String.valueOf(requestFilteringPolicyStat.getRejectedScopes())));
            attrs.add(Attributes.create("ds-mon-rejected-subtrees-total-count", String.valueOf(requestFilteringPolicyStat.getRejectedSubtrees())));
        }
        if ((resLimitStat = this.networkGroup.getResourceLimitStat()) != null) {
            attrs.add(Attributes.create("ds-mon-client-connection-count", String.valueOf(resLimitStat.getClientConnections())));
            attrs.add(Attributes.create("ds-mon-client-connection-max-count", String.valueOf(resLimitStat.getMaxClientConnections())));
            attrs.add(Attributes.create("ds-mon-client-connection-total-count", String.valueOf(resLimitStat.getTotalClientConnections())));
        }
        Object object = this.lock;
        synchronized (object) {
            attrs.add(Attributes.create("ds-mon-abandon-operations-total-count", String.valueOf(this.abandonRequests)));
            attrs.add(Attributes.create("ds-mon-add-operations-total-count", String.valueOf(this.addRequests)));
            attrs.add(Attributes.create("ds-mon-bind-operations-total-count", String.valueOf(this.bindRequests)));
            attrs.add(Attributes.create("ds-mon-compare-operations-total-count", String.valueOf(this.compareRequests)));
            attrs.add(Attributes.create("ds-mon-delete-operations-total-count", String.valueOf(this.deleteRequests)));
            attrs.add(Attributes.create("ds-mon-extended-operations-total-count", String.valueOf(this.extendedRequests)));
            attrs.add(Attributes.create("ds-mon-mod-operations-total-count", String.valueOf(this.modifyRequests)));
            attrs.add(Attributes.create("ds-mon-moddn-operations-total-count", String.valueOf(this.modifyDNRequests)));
            attrs.add(Attributes.create("ds-mon-searchonelevel-operations-total-count", String.valueOf(this.searchOneRequests)));
            attrs.add(Attributes.create("ds-mon-searchsubtree-operations-total-count", String.valueOf(this.searchSubRequests)));
            attrs.add(Attributes.create("ds-mon-unbind-operations-total-count", String.valueOf(this.unbindRequests)));
        }
        attrs.add(Attributes.create("ds-mon-discarded-referrals-total-count", "Not implemented"));
        attrs.add(Attributes.create("ds-mon-forwarded-referrals-total-count", "Not implemented"));
        attrs.add(Attributes.create("ds-mon-followed-referrals-total-count", "Not implemented"));
        attrs.add(Attributes.create("ds-mon-failed-referrals-total-count", "Not implemented"));
        attrs.add(Attributes.create("ds-mon-violations-schema-total-count", "Not implemented"));
        attrs.add(Attributes.create("ds-mon-persistent-searchs-count", "Not implemented"));
        return attrs;
    }
}

