/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.List;
import java.util.Set;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.LengthBasedPasswordValidatorCfg;
import org.opends.server.admin.std.server.PasswordValidatorCfg;
import org.opends.server.api.PasswordValidator;
import org.opends.server.config.ConfigException;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.Operation;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LengthBasedPasswordValidator
extends PasswordValidator<LengthBasedPasswordValidatorCfg>
implements ConfigurationChangeListener<LengthBasedPasswordValidatorCfg> {
    private LengthBasedPasswordValidatorCfg currentConfig;

    @Override
    public void initializePasswordValidator(LengthBasedPasswordValidatorCfg configuration) throws ConfigException, InitializationException {
        configuration.addLengthBasedChangeListener(this);
        this.currentConfig = configuration;
        int maxLength = configuration.getMaxPasswordLength();
        int minLength = configuration.getMinPasswordLength();
        if (maxLength > 0 && minLength > 0 && minLength > maxLength) {
            Message message = ExtensionMessages.ERR_PWLENGTHVALIDATOR_MIN_GREATER_THAN_MAX.get(minLength, maxLength);
            throw new ConfigException(message);
        }
    }

    @Override
    public void finalizePasswordValidator() {
        this.currentConfig.removeLengthBasedChangeListener(this);
    }

    @Override
    public boolean passwordIsAcceptable(ByteString newPassword, Set<ByteString> currentPasswords, Operation operation, Entry userEntry, MessageBuilder invalidReason) {
        LengthBasedPasswordValidatorCfg config = this.currentConfig;
        int numChars = newPassword.stringValue().length();
        int minLength = config.getMinPasswordLength();
        if (minLength > 0 && numChars < minLength) {
            invalidReason.append(ExtensionMessages.ERR_PWLENGTHVALIDATOR_TOO_SHORT.get(minLength));
            return false;
        }
        int maxLength = config.getMaxPasswordLength();
        if (maxLength > 0 && numChars > maxLength) {
            invalidReason.append(ExtensionMessages.ERR_PWLENGTHVALIDATOR_TOO_LONG.get(maxLength));
            return false;
        }
        return true;
    }

    @Override
    public boolean isConfigurationAcceptable(PasswordValidatorCfg configuration, List<Message> unacceptableReasons) {
        LengthBasedPasswordValidatorCfg config = (LengthBasedPasswordValidatorCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(LengthBasedPasswordValidatorCfg configuration, List<Message> unacceptableReasons) {
        int maxLength = configuration.getMaxPasswordLength();
        int minLength = configuration.getMinPasswordLength();
        if (maxLength > 0 && minLength > 0 && minLength > maxLength) {
            Message message = ExtensionMessages.ERR_PWLENGTHVALIDATOR_MIN_GREATER_THAN_MAX.get(minLength, maxLength);
            unacceptableReasons.add(message);
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(LengthBasedPasswordValidatorCfg configuration) {
        this.currentConfig = configuration;
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }
}

