/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.opends.messages.Message;
import org.opends.messages.PluginMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.PluginCfgDefn;
import org.opends.server.admin.std.server.NetworkGroupPluginCfg;
import org.opends.server.admin.std.server.PluginCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.plugin.DirectoryServerPlugin;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.config.ConfigException;
import org.opends.server.core.networkgroups.NetworkGroup;
import org.opends.server.types.AuthenticationType;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PostResponseBindOperation;
import org.opends.server.types.operation.PostResponseExtendedOperation;
import org.opends.server.types.operation.PreParseAddOperation;
import org.opends.server.types.operation.PreParseBindOperation;
import org.opends.server.types.operation.PreParseCompareOperation;
import org.opends.server.types.operation.PreParseDeleteOperation;
import org.opends.server.types.operation.PreParseExtendedOperation;
import org.opends.server.types.operation.PreParseModifyDNOperation;
import org.opends.server.types.operation.PreParseModifyOperation;
import org.opends.server.types.operation.PreParseOperation;
import org.opends.server.types.operation.PreParseSearchOperation;
import org.opends.server.types.operation.PreParseUnbindOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NetworkGroupPlugin
extends DirectoryServerPlugin<NetworkGroupPluginCfg>
implements ConfigurationChangeListener<NetworkGroupPluginCfg> {
    private NetworkGroupPluginCfg currentConfig;

    @Override
    public final void initializePlugin(Set<PluginType> pluginTypes, NetworkGroupPluginCfg configuration) throws ConfigException {
        this.currentConfig = configuration;
        block3: for (PluginType t : pluginTypes) {
            switch (t) {
                case POST_CONNECT: 
                case PRE_PARSE_ADD: 
                case PRE_PARSE_BIND: 
                case PRE_PARSE_COMPARE: 
                case PRE_PARSE_DELETE: 
                case PRE_PARSE_EXTENDED: 
                case PRE_PARSE_MODIFY: 
                case PRE_PARSE_MODIFY_DN: 
                case PRE_PARSE_SEARCH: 
                case PRE_PARSE_UNBIND: 
                case POST_RESPONSE_BIND: 
                case POST_RESPONSE_EXTENDED: {
                    continue block3;
                }
            }
            Message message = PluginMessages.ERR_PLUGIN_NETWORKGROUP_INVALID_PLUGIN_TYPE.get(t.toString());
            throw new ConfigException(message);
        }
    }

    @Override
    public final void finalizePlugin() {
    }

    private boolean checkNetworkGroup(ClientConnection connection, PreParseOperation operation, boolean fullCheck, ArrayList<Message> messages) {
        if (!connection.getNetworkGroup().checkResourceLimits(connection, operation, fullCheck, messages)) {
            return false;
        }
        return operation == null || connection.getNetworkGroup().checkRequestFilteringPolicy(operation, messages);
    }

    private boolean setAndCheckNetworkGroup(ClientConnection connection, PreParseOperation operation, ArrayList<Message> messages) {
        boolean fullCheck = false;
        if (connection.mustEvaluateNetworkGroup(operation)) {
            NetworkGroup ng = NetworkGroup.findMatchingNetworkGroup(connection);
            if (ng != connection.getNetworkGroup()) {
                connection.setNetworkGroup(ng);
                fullCheck = true;
            }
            connection.mustEvaluateNetworkGroup(false);
        }
        return this.checkNetworkGroup(connection, operation, fullCheck, messages);
    }

    @Override
    public final PluginResult.PostConnect doPostConnect(ClientConnection clientConnection) {
        ArrayList<Message> messages = new ArrayList<Message>();
        if (this.setAndCheckNetworkGroup(clientConnection, null, messages)) {
            return PluginResult.PostConnect.continueConnectProcessing();
        }
        return PluginResult.PostConnect.disconnectClient(DisconnectReason.ADMIN_LIMIT_EXCEEDED, true, messages.get(0));
    }

    @Override
    public PluginResult.PreParse doPreParse(PreParseAddOperation addOperation) {
        ArrayList<Message> messages = new ArrayList<Message>();
        ClientConnection connection = addOperation.getClientConnection();
        if (this.setAndCheckNetworkGroup(connection, addOperation, messages)) {
            return PluginResult.PreParse.continueOperationProcessing();
        }
        return PluginResult.PreParse.stopProcessing(ResultCode.ADMIN_LIMIT_EXCEEDED, messages.get(0));
    }

    @Override
    public PluginResult.PreParse doPreParse(PreParseBindOperation bindOperation) {
        ArrayList<Message> messages = new ArrayList<Message>();
        ClientConnection connection = bindOperation.getClientConnection();
        boolean fullCheck = false;
        if (connection.mustEvaluateNetworkGroup(bindOperation)) {
            DN dn;
            try {
                dn = DN.decode(bindOperation.getRawBindDN());
            }
            catch (DirectoryException ex) {
                return PluginResult.PreParse.stopProcessing(ResultCode.OPERATIONS_ERROR, ex.getMessageObject());
            }
            AuthenticationType authType = bindOperation.getAuthenticationType();
            NetworkGroup ng = NetworkGroup.findBindMatchingNetworkGroup(connection, dn, authType, connection.isSecure());
            if (ng != connection.getNetworkGroup()) {
                connection.setNetworkGroup(ng);
                fullCheck = true;
            }
            connection.mustEvaluateNetworkGroup(false);
        }
        if (!this.checkNetworkGroup(connection, bindOperation, fullCheck, messages)) {
            return PluginResult.PreParse.stopProcessing(ResultCode.ADMIN_LIMIT_EXCEEDED, messages.get(0));
        }
        return PluginResult.PreParse.continueOperationProcessing();
    }

    @Override
    public PluginResult.PreParse doPreParse(PreParseCompareOperation compareOperation) {
        ArrayList<Message> messages = new ArrayList<Message>();
        ClientConnection connection = compareOperation.getClientConnection();
        if (this.setAndCheckNetworkGroup(connection, compareOperation, messages)) {
            return PluginResult.PreParse.continueOperationProcessing();
        }
        return PluginResult.PreParse.stopProcessing(ResultCode.ADMIN_LIMIT_EXCEEDED, messages.get(0));
    }

    @Override
    public PluginResult.PreParse doPreParse(PreParseDeleteOperation deleteOperation) {
        ArrayList<Message> messages = new ArrayList<Message>();
        ClientConnection connection = deleteOperation.getClientConnection();
        if (this.setAndCheckNetworkGroup(connection, deleteOperation, messages)) {
            return PluginResult.PreParse.continueOperationProcessing();
        }
        return PluginResult.PreParse.stopProcessing(ResultCode.ADMIN_LIMIT_EXCEEDED, messages.get(0));
    }

    @Override
    public PluginResult.PreParse doPreParse(PreParseExtendedOperation extendedOperation) {
        ArrayList<Message> messages = new ArrayList<Message>();
        ClientConnection connection = extendedOperation.getClientConnection();
        if (this.setAndCheckNetworkGroup(connection, extendedOperation, messages)) {
            return PluginResult.PreParse.continueOperationProcessing();
        }
        return PluginResult.PreParse.stopProcessing(ResultCode.ADMIN_LIMIT_EXCEEDED, messages.get(0));
    }

    @Override
    public PluginResult.PreParse doPreParse(PreParseModifyOperation modifyOperation) {
        ArrayList<Message> messages = new ArrayList<Message>();
        ClientConnection connection = modifyOperation.getClientConnection();
        if (this.setAndCheckNetworkGroup(connection, modifyOperation, messages)) {
            return PluginResult.PreParse.continueOperationProcessing();
        }
        return PluginResult.PreParse.stopProcessing(ResultCode.ADMIN_LIMIT_EXCEEDED, messages.get(0));
    }

    @Override
    public PluginResult.PreParse doPreParse(PreParseModifyDNOperation modifyDNOperation) {
        ArrayList<Message> messages = new ArrayList<Message>();
        ClientConnection connection = modifyDNOperation.getClientConnection();
        if (this.setAndCheckNetworkGroup(connection, modifyDNOperation, messages)) {
            return PluginResult.PreParse.continueOperationProcessing();
        }
        return PluginResult.PreParse.stopProcessing(ResultCode.ADMIN_LIMIT_EXCEEDED, messages.get(0));
    }

    @Override
    public PluginResult.PreParse doPreParse(PreParseSearchOperation searchOperation) {
        ArrayList<Message> messages = new ArrayList<Message>();
        ClientConnection connection = searchOperation.getClientConnection();
        if (this.setAndCheckNetworkGroup(connection, searchOperation, messages)) {
            return PluginResult.PreParse.continueOperationProcessing();
        }
        return PluginResult.PreParse.stopProcessing(ResultCode.ADMIN_LIMIT_EXCEEDED, messages.get(0));
    }

    @Override
    public PluginResult.PreParse doPreParse(PreParseUnbindOperation unbindOperation) {
        ClientConnection connection = unbindOperation.getClientConnection();
        connection.mustEvaluateNetworkGroup(true);
        return PluginResult.PreParse.continueOperationProcessing();
    }

    @Override
    public PluginResult.PostResponse doPostResponse(PostResponseBindOperation bindOperation) {
        if (bindOperation.getResultCode() != ResultCode.SUCCESS) {
            bindOperation.getClientConnection().mustEvaluateNetworkGroup(true);
        }
        return PluginResult.PostResponse.continueOperationProcessing();
    }

    @Override
    public PluginResult.PostResponse doPostResponse(PostResponseExtendedOperation extendedOperation) {
        if (extendedOperation.getRequestOID().equals("1.3.6.1.4.1.1466.20037") && extendedOperation.getResultCode() == ResultCode.SUCCESS) {
            extendedOperation.getClientConnection().mustEvaluateNetworkGroup(true);
        }
        return PluginResult.PostResponse.continueOperationProcessing();
    }

    @Override
    public boolean isConfigurationAcceptable(PluginCfg configuration, List<Message> unacceptableReasons) {
        NetworkGroupPluginCfg cfg = (NetworkGroupPluginCfg)configuration;
        return this.isConfigurationChangeAcceptable(cfg, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(NetworkGroupPluginCfg configuration, List<Message> unacceptableReasons) {
        boolean configAcceptable = true;
        block3: for (PluginCfgDefn.PluginType pluginType : configuration.getPluginType()) {
            switch (pluginType) {
                case POSTCONNECT: 
                case PREPARSEADD: 
                case PREPARSEBIND: 
                case PREPARSECOMPARE: 
                case PREPARSEDELETE: 
                case PREPARSEEXTENDED: 
                case PREPARSEMODIFY: 
                case PREPARSEMODIFYDN: 
                case PREPARSESEARCH: 
                case PREPARSEUNBIND: 
                case POSTRESPONSEBIND: 
                case POSTRESPONSEEXTENDED: {
                    continue block3;
                }
            }
            Message message = PluginMessages.ERR_PLUGIN_NETWORKGROUP_INVALID_PLUGIN_TYPE.get(pluginType.toString());
            unacceptableReasons.add(message);
            configAcceptable = false;
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(NetworkGroupPluginCfg configuration) {
        this.currentConfig = configuration;
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }
}

