/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPStatistics
extends MonitorProvider<MonitorProviderCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private long abandonRequests;
    private long addRequests;
    private long addResponses;
    private long bindRequests;
    private long bindResponses;
    private long bytesRead;
    private long bytesWritten;
    private long compareRequests;
    private long compareResponses;
    private long connectionsClosed;
    private long connectionsEstablished;
    private long deleteRequests;
    private long deleteResponses;
    private long extendedRequests;
    private long extendedResponses;
    private long messagesRead;
    private long messagesWritten;
    private long modifyRequests;
    private long modifyResponses;
    private long modifyDNRequests;
    private long modifyDNResponses;
    private long operationsAbandoned;
    private long operationsCompleted;
    private long operationsInitiated;
    private long searchRequests;
    private long searchResultEntries;
    private long searchResultReferences;
    private long searchResultsDone;
    private long unbindRequests;
    private LDAPStatistics parent;
    private Object abandonLock;
    private Object connectLock;
    private Object disconnectLock;
    private Object readLock;
    private Object writeLock;
    private String instanceName;

    public LDAPStatistics(String instanceName) {
        this(instanceName, null);
        DirectoryServer.registerMonitorProvider(this);
    }

    public LDAPStatistics(String instanceName, LDAPStatistics parent) {
        super("LDAP Statistics Monitor Provider");
        this.instanceName = instanceName;
        this.parent = parent;
        this.abandonLock = new Object();
        this.connectLock = new Object();
        this.disconnectLock = new Object();
        this.readLock = new Object();
        this.writeLock = new Object();
        this.abandonRequests = 0L;
        this.addRequests = 0L;
        this.addResponses = 0L;
        this.bindRequests = 0L;
        this.bindResponses = 0L;
        this.bytesRead = 0L;
        this.bytesWritten = 0L;
        this.compareRequests = 0L;
        this.compareResponses = 0L;
        this.connectionsClosed = 0L;
        this.connectionsEstablished = 0L;
        this.deleteRequests = 0L;
        this.deleteResponses = 0L;
        this.extendedRequests = 0L;
        this.extendedResponses = 0L;
        this.messagesRead = 0L;
        this.messagesWritten = 0L;
        this.modifyRequests = 0L;
        this.modifyResponses = 0L;
        this.modifyDNRequests = 0L;
        this.modifyDNResponses = 0L;
        this.operationsAbandoned = 0L;
        this.operationsCompleted = 0L;
        this.operationsInitiated = 0L;
        this.searchRequests = 0L;
        this.searchResultEntries = 0L;
        this.searchResultReferences = 0L;
        this.searchResultsDone = 0L;
        this.unbindRequests = 0L;
    }

    @Override
    public void initializeMonitorProvider(MonitorProviderCfg configuration) throws ConfigException {
        Message message = ProtocolMessages.ERR_LDAP_STATS_INVALID_MONITOR_INITIALIZATION.get(String.valueOf(configuration.dn()));
        throw new ConfigException(message);
    }

    @Override
    public String getMonitorInstanceName() {
        return this.instanceName;
    }

    @Override
    public long getUpdateInterval() {
        return -1L;
    }

    @Override
    public void updateMonitorData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Attribute> getMonitorData() {
        long tmpUnbindRequests;
        long tmpSearchResultsDone;
        long tmpSearchReferences;
        long tmpSearchEntries;
        long tmpSearchRequests;
        long tmpOperationsInitiated;
        long tmpOperationsCompleted;
        long tmpOperationsAbandoned;
        long tmpModifyDNResponses;
        long tmpModifyDNRequests;
        long tmpModifyResponses;
        long tmpModifyRequests;
        long tmpMessagesWritten;
        long tmpMessagesRead;
        long tmpExtendedResponses;
        long tmpExtendedRequests;
        long tmpDeleteResponses;
        long tmpDeleteRequests;
        long tmpConnectionsEstablished;
        long tmpConnectionsClosed;
        long tmpCompareResponses;
        long tmpCompareRequests;
        long tmpBytesWritten;
        long tmpBytesRead;
        long tmpBindResponses;
        long tmpBindRequests;
        long tmpAddResponses;
        long tmpAddRequests;
        long tmpAbandonRequests;
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(29);
        Object object = this.abandonLock;
        synchronized (object) {
            Object object2 = this.connectLock;
            synchronized (object2) {
                Object object3 = this.disconnectLock;
                synchronized (object3) {
                    Object object4 = this.writeLock;
                    synchronized (object4) {
                        Object object5 = this.readLock;
                        synchronized (object5) {
                            tmpAbandonRequests = this.abandonRequests;
                            tmpAddRequests = this.addRequests;
                            tmpAddResponses = this.addResponses;
                            tmpBindRequests = this.bindRequests;
                            tmpBindResponses = this.bindResponses;
                            tmpBytesRead = this.bytesRead;
                            tmpBytesWritten = this.bytesWritten;
                            tmpCompareRequests = this.compareRequests;
                            tmpCompareResponses = this.compareResponses;
                            tmpConnectionsClosed = this.connectionsClosed;
                            tmpConnectionsEstablished = this.connectionsEstablished;
                            tmpDeleteRequests = this.deleteRequests;
                            tmpDeleteResponses = this.deleteResponses;
                            tmpExtendedRequests = this.extendedRequests;
                            tmpExtendedResponses = this.extendedResponses;
                            tmpMessagesRead = this.messagesRead;
                            tmpMessagesWritten = this.messagesWritten;
                            tmpModifyRequests = this.modifyRequests;
                            tmpModifyResponses = this.modifyResponses;
                            tmpModifyDNRequests = this.modifyDNRequests;
                            tmpModifyDNResponses = this.modifyDNResponses;
                            tmpOperationsAbandoned = this.operationsAbandoned;
                            tmpOperationsCompleted = this.operationsCompleted;
                            tmpOperationsInitiated = this.operationsInitiated;
                            tmpSearchRequests = this.searchRequests;
                            tmpSearchEntries = this.searchResultEntries;
                            tmpSearchReferences = this.searchResultReferences;
                            tmpSearchResultsDone = this.searchResultsDone;
                            tmpUnbindRequests = this.unbindRequests;
                        }
                    }
                }
            }
        }
        attrs.add(this.createAttribute("connectionsEstablished", String.valueOf(tmpConnectionsEstablished)));
        attrs.add(this.createAttribute("connectionsClosed", String.valueOf(tmpConnectionsClosed)));
        attrs.add(this.createAttribute("bytesRead", String.valueOf(tmpBytesRead)));
        attrs.add(this.createAttribute("bytesWritten", String.valueOf(tmpBytesWritten)));
        attrs.add(this.createAttribute("ldapMessagesRead", String.valueOf(tmpMessagesRead)));
        attrs.add(this.createAttribute("ldapMessagesWritten", String.valueOf(tmpMessagesWritten)));
        attrs.add(this.createAttribute("operationsAbandoned", String.valueOf(tmpOperationsAbandoned)));
        attrs.add(this.createAttribute("operationsInitiated", String.valueOf(tmpOperationsInitiated)));
        attrs.add(this.createAttribute("operationsCompleted", String.valueOf(tmpOperationsCompleted)));
        attrs.add(this.createAttribute("abandonRequests", String.valueOf(tmpAbandonRequests)));
        attrs.add(this.createAttribute("addRequests", String.valueOf(tmpAddRequests)));
        attrs.add(this.createAttribute("addResponses", String.valueOf(tmpAddResponses)));
        attrs.add(this.createAttribute("bindRequests", String.valueOf(tmpBindRequests)));
        attrs.add(this.createAttribute("bindResponses", String.valueOf(tmpBindResponses)));
        attrs.add(this.createAttribute("compareRequests", String.valueOf(tmpCompareRequests)));
        attrs.add(this.createAttribute("compareResponses", String.valueOf(tmpCompareResponses)));
        attrs.add(this.createAttribute("deleteRequests", String.valueOf(tmpDeleteRequests)));
        attrs.add(this.createAttribute("deleteResponses", String.valueOf(tmpDeleteResponses)));
        attrs.add(this.createAttribute("extendedRequests", String.valueOf(tmpExtendedRequests)));
        attrs.add(this.createAttribute("extendedResponses", String.valueOf(tmpExtendedResponses)));
        attrs.add(this.createAttribute("modifyRequests", String.valueOf(tmpModifyRequests)));
        attrs.add(this.createAttribute("modifyResponses", String.valueOf(tmpModifyResponses)));
        attrs.add(this.createAttribute("modifyDNRequests", String.valueOf(tmpModifyDNRequests)));
        attrs.add(this.createAttribute("modifyDNResponses", String.valueOf(tmpModifyDNResponses)));
        attrs.add(this.createAttribute("searchRequests", String.valueOf(tmpSearchRequests)));
        attrs.add(this.createAttribute("searchResultEntries", String.valueOf(tmpSearchEntries)));
        attrs.add(this.createAttribute("searchResultReferences", String.valueOf(tmpSearchReferences)));
        attrs.add(this.createAttribute("searchResultsDone", String.valueOf(tmpSearchResultsDone)));
        attrs.add(this.createAttribute("unbindRequests", String.valueOf(tmpUnbindRequests)));
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStatistics() {
        Object object = this.abandonLock;
        synchronized (object) {
            Object object2 = this.connectLock;
            synchronized (object2) {
                Object object3 = this.disconnectLock;
                synchronized (object3) {
                    Object object4 = this.writeLock;
                    synchronized (object4) {
                        Object object5 = this.readLock;
                        synchronized (object5) {
                            this.abandonRequests = 0L;
                            this.addRequests = 0L;
                            this.addResponses = 0L;
                            this.bindRequests = 0L;
                            this.bindResponses = 0L;
                            this.bytesRead = 0L;
                            this.bytesWritten = 0L;
                            this.compareRequests = 0L;
                            this.compareResponses = 0L;
                            this.connectionsClosed = 0L;
                            this.connectionsEstablished = 0L;
                            this.deleteRequests = 0L;
                            this.deleteResponses = 0L;
                            this.extendedRequests = 0L;
                            this.extendedResponses = 0L;
                            this.messagesRead = 0L;
                            this.messagesWritten = 0L;
                            this.modifyRequests = 0L;
                            this.modifyResponses = 0L;
                            this.modifyDNRequests = 0L;
                            this.modifyDNResponses = 0L;
                            this.operationsAbandoned = 0L;
                            this.operationsCompleted = 0L;
                            this.operationsInitiated = 0L;
                            this.searchRequests = 0L;
                            this.searchResultEntries = 0L;
                            this.searchResultReferences = 0L;
                            this.searchResultsDone = 0L;
                            this.unbindRequests = 0L;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConnect() {
        Object object = this.connectLock;
        synchronized (object) {
            ++this.connectionsEstablished;
        }
        if (this.parent != null) {
            this.parent.updateConnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDisconnect() {
        Object object = this.disconnectLock;
        synchronized (object) {
            ++this.connectionsClosed;
        }
        if (this.parent != null) {
            this.parent.updateDisconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBytesRead(int bytesRead) {
        Object object = this.readLock;
        synchronized (object) {
            this.bytesRead += (long)bytesRead;
        }
        if (this.parent != null) {
            this.parent.updateBytesRead(bytesRead);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMessageRead(LDAPMessage message) {
        Object object = this.readLock;
        synchronized (object) {
            ++this.messagesRead;
            ++this.operationsInitiated;
            switch (message.getProtocolOp().getType()) {
                case 80: {
                    ++this.abandonRequests;
                    break;
                }
                case 104: {
                    ++this.addRequests;
                    break;
                }
                case 96: {
                    ++this.bindRequests;
                    break;
                }
                case 110: {
                    ++this.compareRequests;
                    break;
                }
                case 74: {
                    ++this.deleteRequests;
                    break;
                }
                case 119: {
                    ++this.extendedRequests;
                    break;
                }
                case 102: {
                    ++this.modifyRequests;
                    break;
                }
                case 108: {
                    ++this.modifyDNRequests;
                    break;
                }
                case 99: {
                    ++this.searchRequests;
                    break;
                }
                case 66: {
                    ++this.unbindRequests;
                }
            }
        }
        if (this.parent != null) {
            this.parent.updateMessageRead(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMessageWritten(LDAPMessage message, int bytesWritten) {
        Object object = this.writeLock;
        synchronized (object) {
            this.bytesWritten += (long)bytesWritten;
            ++this.messagesWritten;
            switch (message.getProtocolOp().getType()) {
                case 105: {
                    ++this.addResponses;
                    ++this.operationsCompleted;
                    break;
                }
                case 97: {
                    ++this.bindResponses;
                    ++this.operationsCompleted;
                    break;
                }
                case 111: {
                    ++this.compareResponses;
                    ++this.operationsCompleted;
                    break;
                }
                case 107: {
                    ++this.deleteResponses;
                    ++this.operationsCompleted;
                    break;
                }
                case 120: {
                    ++this.extendedResponses;
                    if (message.getMessageID() <= 0) break;
                    ++this.operationsCompleted;
                    break;
                }
                case 103: {
                    ++this.modifyResponses;
                    ++this.operationsCompleted;
                    break;
                }
                case 109: {
                    ++this.modifyDNResponses;
                    ++this.operationsCompleted;
                    break;
                }
                case 100: {
                    ++this.searchResultEntries;
                    break;
                }
                case 115: {
                    ++this.searchResultReferences;
                    break;
                }
                case 101: {
                    ++this.searchResultsDone;
                    ++this.operationsCompleted;
                }
            }
        }
        if (this.parent != null) {
            this.parent.updateMessageWritten(message, bytesWritten);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAbandonedOperation() {
        Object object = this.abandonLock;
        synchronized (object) {
            ++this.operationsAbandoned;
        }
        if (this.parent != null) {
            this.parent.updateAbandonedOperation();
        }
    }

    private Attribute createAttribute(String name, String value) {
        AttributeType attrType = DirectoryServer.getDefaultAttributeType(name);
        ASN1OctetString encodedValue = new ASN1OctetString(value);
        AttributeBuilder builder = new AttributeBuilder(attrType, name);
        try {
            builder.add(new AttributeValue(encodedValue, attrType.normalize(encodedValue)));
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            builder.add(new AttributeValue(encodedValue, (ByteString)encodedValue));
        }
        return builder.toAttribute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getConnectionsEstablished() {
        Object object = this.connectLock;
        synchronized (object) {
            return this.connectionsEstablished;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getConnectionsClosed() {
        Object object = this.disconnectLock;
        synchronized (object) {
            return this.connectionsClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBytesRead() {
        Object object = this.readLock;
        synchronized (object) {
            return this.bytesRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBytesWritten() {
        Object object = this.writeLock;
        synchronized (object) {
            return this.bytesWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMessagesRead() {
        Object object = this.readLock;
        synchronized (object) {
            return this.messagesRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMessagesWritten() {
        Object object = this.writeLock;
        synchronized (object) {
            return this.messagesWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOperationsInitiated() {
        Object object = this.readLock;
        synchronized (object) {
            return this.operationsInitiated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOperationsCompleted() {
        Object object = this.writeLock;
        synchronized (object) {
            return this.operationsCompleted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOperationsAbandoned() {
        Object object = this.abandonLock;
        synchronized (object) {
            return this.operationsAbandoned;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAbandonRequests() {
        Object object = this.readLock;
        synchronized (object) {
            return this.abandonRequests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAddRequests() {
        Object object = this.readLock;
        synchronized (object) {
            return this.addRequests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAddResponses() {
        Object object = this.writeLock;
        synchronized (object) {
            return this.addResponses;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBindRequests() {
        Object object = this.readLock;
        synchronized (object) {
            return this.bindRequests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBindResponses() {
        Object object = this.writeLock;
        synchronized (object) {
            return this.bindResponses;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCompareRequests() {
        Object object = this.readLock;
        synchronized (object) {
            return this.compareRequests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCompareResponses() {
        Object object = this.writeLock;
        synchronized (object) {
            return this.compareResponses;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDeleteRequests() {
        Object object = this.readLock;
        synchronized (object) {
            return this.deleteRequests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDeleteResponses() {
        Object object = this.writeLock;
        synchronized (object) {
            return this.deleteResponses;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getExtendedRequests() {
        Object object = this.readLock;
        synchronized (object) {
            return this.extendedRequests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getExtendedResponses() {
        Object object = this.writeLock;
        synchronized (object) {
            return this.extendedResponses;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getModifyRequests() {
        Object object = this.readLock;
        synchronized (object) {
            return this.modifyRequests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getModifyResponses() {
        Object object = this.writeLock;
        synchronized (object) {
            return this.modifyResponses;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getModifyDNRequests() {
        Object object = this.readLock;
        synchronized (object) {
            return this.modifyDNRequests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getModifyDNResponses() {
        Object object = this.writeLock;
        synchronized (object) {
            return this.modifyDNResponses;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSearchRequests() {
        Object object = this.readLock;
        synchronized (object) {
            return this.searchRequests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSearchResultEntries() {
        Object object = this.writeLock;
        synchronized (object) {
            return this.searchResultEntries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSearchResultReferences() {
        Object object = this.writeLock;
        synchronized (object) {
            return this.searchResultReferences;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSearchResultsDone() {
        Object object = this.writeLock;
        synchronized (object) {
            return this.searchResultsDone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUnbindRequests() {
        Object object = this.readLock;
        synchronized (object) {
            return this.unbindRequests;
        }
    }

    public LDAPStatistics getParent() {
        return this.parent;
    }
}

