/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.plugin.ReplicationDomain;
import org.opends.server.replication.plugin.UpdateToReplay;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplayThread
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private BlockingQueue<UpdateToReplay> updateToReplayQueue = null;
    private boolean shutdown = false;
    private boolean done = false;
    private static int count = 0;

    public ReplayThread(BlockingQueue<UpdateToReplay> updateToReplayQueue) {
        super("Replication Replay thread " + count++);
        this.updateToReplayQueue = updateToReplayQueue;
    }

    public void shutdown() {
        this.shutdown = true;
    }

    @Override
    public void run() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Replication Replay thread starting.");
        }
        UpdateToReplay updateToreplay = null;
        while (!this.shutdown) {
            try {
                while (!this.shutdown && (updateToreplay = this.updateToReplayQueue.poll(1L, TimeUnit.SECONDS)) != null) {
                    UpdateMsg updateMsg = updateToreplay.getUpdateMessage();
                    ReplicationDomain domain = updateToreplay.getReplicationDomain();
                    domain.replay(updateMsg);
                }
            }
            catch (Exception e) {
                Message message = ReplicationMessages.ERR_EXCEPTION_REPLAYING_REPLICATION_MESSAGE.get(StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
            }
        }
        this.done = true;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Replication Replay thread stopping.");
        }
    }

    public void waitForShutdown() {
        try {
            while (!this.done && this.isAlive()) {
                Thread.sleep(50L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

