/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.util.SortedMap;
import java.util.TreeMap;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.UpdateMsg;

public class MsgQueue {
    private SortedMap<ChangeNumber, UpdateMsg> map = new TreeMap<ChangeNumber, UpdateMsg>();
    private int bytesCount = 0;

    public UpdateMsg first() {
        return (UpdateMsg)this.map.get(this.map.firstKey());
    }

    public UpdateMsg last() {
        return (UpdateMsg)this.map.get(this.map.lastKey());
    }

    public int count() {
        return this.map.size();
    }

    public int bytesCount() {
        return this.bytesCount;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void add(UpdateMsg update) {
        this.map.put(update.getChangeNumber(), update);
        this.bytesCount += update.size();
    }

    public UpdateMsg removeFirst() {
        UpdateMsg msg = (UpdateMsg)this.map.get(this.map.firstKey());
        this.map.remove(msg.getChangeNumber());
        this.bytesCount -= msg.size();
        return msg;
    }

    public boolean contains(UpdateMsg msg) {
        return this.map.containsKey(msg.getChangeNumber());
    }

    public void clear() {
        this.map.clear();
        this.bytesCount = 0;
    }
}

