/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ByteString;
import org.opends.server.types.DITStructureRule;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.NameForm;
import org.opends.server.types.ResultCode;
import org.opends.server.types.Schema;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DITStructureRuleSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException, InitializationException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_EQUALITY_MATCHING_RULE.get("2.5.13.2", "DITStructureRuleDescription");
            throw new InitializationException(message);
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_ORDERING_MATCHING_RULE.get("2.5.13.3", "DITStructureRuleDescription");
            throw new InitializationException(message);
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_SUBSTRING_MATCHING_RULE.get("2.5.13.4", "DITStructureRuleDescription");
            throw new InitializationException(message);
        }
    }

    @Override
    public String getSyntaxName() {
        return "DITStructureRuleDescription";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.17";
    }

    @Override
    public String getDescription() {
        return "DIT Structure Rule Description";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString value, MessageBuilder invalidReason) {
        try {
            DITStructureRuleSyntax.decodeDITStructureRule(value, DirectoryServer.getSchema(), true);
            return true;
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            invalidReason.append(de.getMessageObject());
            return false;
        }
    }

    public static DITStructureRule decodeDITStructureRule(ByteString value, Schema schema, boolean allowUnknownElements) throws DirectoryException {
        char c;
        int pos;
        String valueStr = value.stringValue();
        String lowerStr = StaticUtils.toLowerCase(valueStr);
        int length = valueStr.length();
        for (pos = 0; pos < length && valueStr.charAt(pos) == ' '; ++pos) {
        }
        if (pos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DSR_EMPTY_VALUE.get();
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if ((c = valueStr.charAt(pos++)) != '(') {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DSR_EXPECTED_OPEN_PARENTHESIS.get(valueStr, pos - 1, String.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        while (pos < length && (c = valueStr.charAt(pos)) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DSR_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        int ruleIDStartPos = pos;
        while (pos < length && (c = valueStr.charAt(pos++)) != ' ') {
            if (StaticUtils.isDigit(c)) continue;
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DSR_ILLEGAL_CHAR_IN_RULE_ID.get(valueStr, String.valueOf(c), pos - 1);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if (pos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DSR_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        int ruleID = Integer.parseInt(valueStr.substring(ruleIDStartPos, pos - 1));
        while (pos < length && (c = valueStr.charAt(pos)) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DSR_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        LinkedHashMap<String, String> names = new LinkedHashMap<String, String>();
        String description = null;
        boolean isObsolete = false;
        NameForm nameForm = null;
        boolean nameFormGiven = false;
        LinkedHashSet superiorRules = null;
        LinkedHashMap<String, List<String>> extraProperties = new LinkedHashMap<String, List<String>>();
        block4: while (true) {
            Message message;
            StringBuilder tokenNameBuffer = new StringBuilder();
            pos = DITStructureRuleSyntax.readTokenName(valueStr, tokenNameBuffer, pos);
            String tokenName = tokenNameBuffer.toString();
            String lowerTokenName = StaticUtils.toLowerCase(tokenName);
            if (tokenName.equals(")")) {
                if (pos >= length) break;
                message = SchemaMessages.ERR_ATTR_SYNTAX_DSR_UNEXPECTED_CLOSE_PARENTHESIS.get(valueStr, pos - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            if (lowerTokenName.equals("name")) {
                StringBuilder userBuffer;
                if ((c = valueStr.charAt(pos++)) == '\'') {
                    userBuffer = new StringBuilder();
                    StringBuilder lowerBuffer = new StringBuilder();
                    pos = DITStructureRuleSyntax.readQuotedString(valueStr, lowerStr, userBuffer, lowerBuffer, pos - 1);
                    names.put(lowerBuffer.toString(), userBuffer.toString());
                    continue;
                }
                if (c == '(') {
                    userBuffer = new StringBuilder();
                    StringBuilder lowerBuffer = new StringBuilder();
                    pos = DITStructureRuleSyntax.readQuotedString(valueStr, lowerStr, userBuffer, lowerBuffer, pos);
                    names.put(lowerBuffer.toString(), userBuffer.toString());
                    while (true) {
                        if (valueStr.charAt(pos) == ')') {
                            ++pos;
                            while (true) {
                                if (pos >= length || (c = valueStr.charAt(pos)) != ' ') continue block4;
                                ++pos;
                            }
                        }
                        userBuffer = new StringBuilder();
                        lowerBuffer = new StringBuilder();
                        pos = DITStructureRuleSyntax.readQuotedString(valueStr, lowerStr, userBuffer, lowerBuffer, pos);
                        names.put(lowerBuffer.toString(), userBuffer.toString());
                    }
                }
                message = SchemaMessages.ERR_ATTR_SYNTAX_DSR_ILLEGAL_CHAR.get(valueStr, String.valueOf(c), pos - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            if (lowerTokenName.equals("desc")) {
                StringBuilder descriptionBuffer = new StringBuilder();
                pos = DITStructureRuleSyntax.readQuotedString(valueStr, descriptionBuffer, pos);
                description = descriptionBuffer.toString();
                continue;
            }
            if (lowerTokenName.equals("obsolete")) {
                isObsolete = true;
                continue;
            }
            if (lowerTokenName.equals("form")) {
                StringBuilder woidBuffer = new StringBuilder();
                pos = DITStructureRuleSyntax.readWOID(lowerStr, woidBuffer, pos);
                nameFormGiven = true;
                nameForm = schema.getNameForm(woidBuffer.toString());
                if (nameForm != null || allowUnknownElements) continue;
                Message message2 = SchemaMessages.ERR_ATTR_SYNTAX_DSR_UNKNOWN_NAME_FORM.get(valueStr, woidBuffer.toString());
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message2);
            }
            if (lowerTokenName.equals("sup")) {
                DITStructureRule superiorRule;
                int supRuleID;
                Message message3;
                LinkedList<DITStructureRule> superiorList = new LinkedList<DITStructureRule>();
                if ((c = valueStr.charAt(pos++)) == '(') {
                    while (true) {
                        if (pos < length && (c = valueStr.charAt(pos)) == ' ') {
                            ++pos;
                            continue;
                        }
                        if (pos >= length) {
                            Message message4 = SchemaMessages.ERR_ATTR_SYNTAX_DSR_TRUNCATED_VALUE.get(lowerStr);
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message4);
                        }
                        ruleIDStartPos = pos;
                        while (pos < length && (c = valueStr.charAt(pos++)) != ' ') {
                            if (StaticUtils.isDigit(c)) continue;
                            Message message5 = SchemaMessages.ERR_ATTR_SYNTAX_DSR_ILLEGAL_CHAR_IN_RULE_ID.get(valueStr, String.valueOf(c), pos - 1);
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message5);
                        }
                        if (pos >= length) {
                            message3 = SchemaMessages.ERR_ATTR_SYNTAX_DSR_TRUNCATED_VALUE.get(valueStr);
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message3);
                        }
                        supRuleID = Integer.parseInt(valueStr.substring(ruleIDStartPos, pos - 1));
                        superiorRule = schema.getDITStructureRule(supRuleID);
                        if (superiorRule == null) {
                            if (!allowUnknownElements) {
                                Message message6 = SchemaMessages.ERR_ATTR_SYNTAX_DSR_UNKNOWN_RULE_ID.get(valueStr, supRuleID);
                                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message6);
                            }
                        } else {
                            superiorList.add(superiorRule);
                        }
                        while (pos < length && (c = valueStr.charAt(pos)) == ' ') {
                            ++pos;
                        }
                        if (pos >= length) {
                            Message message7 = SchemaMessages.ERR_ATTR_SYNTAX_DSR_TRUNCATED_VALUE.get(lowerStr);
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message7);
                        }
                        if (c == ')') break;
                    }
                    ++pos;
                    while (pos < length && (c = valueStr.charAt(pos)) == ' ') {
                        ++pos;
                    }
                    if (pos >= length) {
                        Message message8 = SchemaMessages.ERR_ATTR_SYNTAX_DSR_TRUNCATED_VALUE.get(lowerStr);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message8);
                    }
                } else {
                    if (pos >= length) {
                        Message message9 = SchemaMessages.ERR_ATTR_SYNTAX_DSR_TRUNCATED_VALUE.get(lowerStr);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message9);
                    }
                    ruleIDStartPos = pos - 1;
                    while (pos < length && (c = valueStr.charAt(pos++)) != ' ') {
                        if (StaticUtils.isDigit(c)) continue;
                        Message message10 = SchemaMessages.ERR_ATTR_SYNTAX_DSR_ILLEGAL_CHAR_IN_RULE_ID.get(valueStr, String.valueOf(c), pos - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message10);
                    }
                    if (pos >= length) {
                        message3 = SchemaMessages.ERR_ATTR_SYNTAX_DSR_TRUNCATED_VALUE.get(valueStr);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message3);
                    }
                    supRuleID = Integer.parseInt(valueStr.substring(ruleIDStartPos, pos - 1));
                    superiorRule = schema.getDITStructureRule(supRuleID);
                    if (superiorRule == null) {
                        if (!allowUnknownElements) {
                            Message message11 = SchemaMessages.ERR_ATTR_SYNTAX_DSR_UNKNOWN_RULE_ID.get(valueStr, supRuleID);
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message11);
                        }
                    } else {
                        superiorList.add(superiorRule);
                    }
                    while (pos < length && (c = valueStr.charAt(pos)) == ' ') {
                        ++pos;
                    }
                    if (pos >= length) {
                        Message message12 = SchemaMessages.ERR_ATTR_SYNTAX_DSR_TRUNCATED_VALUE.get(lowerStr);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message12);
                    }
                }
                superiorRules = new LinkedHashSet(superiorList);
                continue;
            }
            LinkedList<String> valueList = new LinkedList<String>();
            pos = DITStructureRuleSyntax.readExtraParameterValues(valueStr, valueList, pos);
            extraProperties.put(tokenName, valueList);
        }
        if (nameForm == null && !nameFormGiven) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DSR_NO_NAME_FORM.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        return new DITStructureRule(value.stringValue(), names, ruleID, description, isObsolete, nameForm, superiorRules, extraProperties);
    }

    private static int readTokenName(String valueStr, StringBuilder tokenName, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = valueStr.length();
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DSR_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        while (startPos < length && (c = valueStr.charAt(startPos++)) != ' ') {
            tokenName.append(c);
        }
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        return startPos;
    }

    private static int readQuotedString(String valueStr, StringBuilder valueBuffer, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = valueStr.length();
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DSR_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if (c != '\'') {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DSR_EXPECTED_QUOTE_AT_POS.get(valueStr, startPos, String.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        ++startPos;
        while (startPos < length && (c = valueStr.charAt(startPos)) != '\'') {
            valueBuffer.append(c);
            ++startPos;
        }
        ++startPos;
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DSR_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        return startPos;
    }

    private static int readQuotedString(String valueStr, String lowerStr, StringBuilder userBuffer, StringBuilder lowerBuffer, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = lowerStr.length();
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DSR_TRUNCATED_VALUE.get(lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if (c != '\'') {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DSR_EXPECTED_QUOTE_AT_POS.get(valueStr, startPos, String.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        ++startPos;
        while (startPos < length && (c = lowerStr.charAt(startPos)) != '\'') {
            lowerBuffer.append(c);
            userBuffer.append(valueStr.charAt(startPos));
            ++startPos;
        }
        ++startPos;
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DSR_TRUNCATED_VALUE.get(lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        return startPos;
    }

    private static int readWOID(String lowerStr, StringBuilder woidBuffer, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = lowerStr.length();
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DSR_TRUNCATED_VALUE.get(lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if (StaticUtils.isDigit(c)) {
            boolean lastWasPeriod = false;
            while (startPos < length && (c = lowerStr.charAt(startPos++)) != ' ') {
                if (c == '.') {
                    if (lastWasPeriod) {
                        Message message = SchemaMessages.ERR_ATTR_SYNTAX_DSR_DOUBLE_PERIOD_IN_NUMERIC_OID.get(lowerStr, startPos - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                    }
                    woidBuffer.append(c);
                    lastWasPeriod = true;
                    continue;
                }
                if (!StaticUtils.isDigit(c)) {
                    if (c == ')') {
                        return startPos - 1;
                    }
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_DSR_ILLEGAL_CHAR_IN_NUMERIC_OID.get(lowerStr, String.valueOf(c), startPos - 1);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                woidBuffer.append(c);
                lastWasPeriod = false;
            }
        } else if (StaticUtils.isAlpha(c)) {
            while (startPos < length && (c = lowerStr.charAt(startPos++)) != ' ') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) {
                    woidBuffer.append(c);
                    continue;
                }
                if (c == ')') {
                    return startPos - 1;
                }
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_DSR_ILLEGAL_CHAR_IN_STRING_OID.get(lowerStr, String.valueOf(c), startPos - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
        } else {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DSR_ILLEGAL_CHAR.get(lowerStr, String.valueOf(c), startPos);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DSR_TRUNCATED_VALUE.get(lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        return startPos;
    }

    private static int readExtraParameterValues(String valueStr, List<String> valueList, int startPos) throws DirectoryException {
        StringBuilder valueBuffer;
        int length = valueStr.length();
        char c = valueStr.charAt(startPos++);
        while (startPos < length && c == ' ') {
            c = valueStr.charAt(startPos++);
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DSR_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if (c == '\'') {
            valueBuffer = new StringBuilder();
            while (startPos < length && (c = valueStr.charAt(startPos++)) != '\'') {
                valueBuffer.append(c);
            }
            valueList.add(valueBuffer.toString());
        } else if (c == '(') {
            while (true) {
                ++startPos;
                while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
                    ++startPos;
                }
                if (startPos >= length) {
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_DSR_TRUNCATED_VALUE.get(valueStr);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                if (c != ')') {
                    if (c == '(') {
                        Message message = SchemaMessages.ERR_ATTR_SYNTAX_DSR_ILLEGAL_CHAR.get(valueStr, String.valueOf(c), startPos);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                    }
                    startPos = DITStructureRuleSyntax.readExtraParameterValues(valueStr, valueList, startPos);
                    continue;
                }
                break;
            }
        } else {
            valueBuffer = new StringBuilder();
            while (startPos < length && (c = valueStr.charAt(startPos++)) != ' ') {
                valueBuffer.append(c);
            }
            valueList.add(valueBuffer.toString());
        }
        while (startPos < length && valueStr.charAt(startPos) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_DSR_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        return startPos;
    }

    @Override
    public boolean isBinary() {
        return false;
    }
}

