/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.DirectoryStringAttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.AttributeValueDecoder;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryStringSyntax
extends AttributeSyntax<DirectoryStringAttributeSyntaxCfg>
implements ConfigurationChangeListener<DirectoryStringAttributeSyntaxCfg> {
    private ApproximateMatchingRule defaultApproximateMatchingRule;
    private boolean allowZeroLengthValues;
    private DirectoryStringAttributeSyntaxCfg currentConfig;
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;
    public static final AttributeValueDecoder<String> DECODER = new AttributeValueDecoder<String>(){

        @Override
        public String decode(AttributeValue value) throws DirectoryException {
            value.getNormalizedValue();
            return value.getStringValue();
        }
    };

    @Override
    public void initializeSyntax(DirectoryStringAttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultApproximateMatchingRule = DirectoryServer.getApproximateMatchingRule("1.3.6.1.4.1.26027.1.4.1");
        if (this.defaultApproximateMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_APPROXIMATE_MATCHING_RULE.get("1.3.6.1.4.1.26027.1.4.1", "DirectoryString"));
        }
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_EQUALITY_MATCHING_RULE.get("2.5.13.2", "DirectoryString"));
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_ORDERING_MATCHING_RULE.get("2.5.13.3", "DirectoryString"));
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_SUBSTRING_MATCHING_RULE.get("2.5.13.4", "DirectoryString"));
        }
        if (configuration == null) {
            return;
        }
        this.currentConfig = configuration;
        this.currentConfig.addDirectoryStringChangeListener(this);
        this.allowZeroLengthValues = this.currentConfig.isAllowZeroLengthValues();
    }

    @Override
    public void finalizeSyntax() {
        this.currentConfig.removeDirectoryStringChangeListener(this);
    }

    @Override
    public String getSyntaxName() {
        return "DirectoryString";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.15";
    }

    @Override
    public String getDescription() {
        return "Directory String";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return this.defaultApproximateMatchingRule;
    }

    @Override
    public boolean valueIsAcceptable(ByteString value, MessageBuilder invalidReason) {
        if (this.allowZeroLengthValues || value.value().length > 0) {
            return true;
        }
        invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_DIRECTORYSTRING_INVALID_ZEROLENGTH_VALUE.get());
        return false;
    }

    public boolean allowZeroLengthValues() {
        return this.allowZeroLengthValues;
    }

    @Override
    public boolean isConfigurationChangeAcceptable(DirectoryStringAttributeSyntaxCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(DirectoryStringAttributeSyntaxCfg configuration) {
        this.currentConfig = configuration;
        this.allowZeroLengthValues = configuration.isAllowZeroLengthValues();
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    @Override
    public boolean isBinary() {
        return false;
    }
}

