/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.messages.MessageBuilder;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.ByteString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstringAssertionSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_EQUALITY_MATCHING_RULE.get("2.5.13.2", "SubstringAssertion"));
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_ORDERING_MATCHING_RULE.get("2.5.13.3", "SubstringAssertion"));
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_SUBSTRING_MATCHING_RULE.get("2.5.13.4", "SubstringAssertion"));
        }
    }

    @Override
    public String getSyntaxName() {
        return "SubstringAssertion";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.58";
    }

    @Override
    public String getDescription() {
        return "Substring Assertion";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString value, MessageBuilder invalidReason) {
        String valueString = value.stringValue();
        int valueLength = valueString.length();
        if (valueLength == 0) {
            return true;
        }
        if (valueLength == 1) {
            if (valueString.charAt(0) == '*') {
                invalidReason.append(SchemaMessages.WARN_ATTR_SYNTAX_SUBSTRING_ONLY_WILDCARD.get());
                return false;
            }
            return true;
        }
        for (int i = 1; i < valueLength; ++i) {
            if (valueString.charAt(i) != '*' || valueString.charAt(i - 1) != '*') continue;
            invalidReason.append(SchemaMessages.WARN_ATTR_SYNTAX_SUBSTRING_CONSECUTIVE_WILDCARDS.get(valueString, i));
            return false;
        }
        return true;
    }

    @Override
    public boolean isBinary() {
        return false;
    }
}

