/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.messages.Message;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.std.server.OrderingMatchingRuleCfg;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;

public class UUIDOrderingMatchingRule
extends OrderingMatchingRule {
    private static final long serialVersionUID = -3877941142853469687L;

    public void initializeMatchingRule(OrderingMatchingRuleCfg configuration) throws ConfigException, InitializationException {
    }

    public String getName() {
        return "uuidOrderingMatch";
    }

    public String getOID() {
        return "1.3.6.1.1.16.3";
    }

    public String getDescription() {
        return null;
    }

    public String getSyntaxOID() {
        return "1.3.6.1.1.16.1";
    }

    public ByteString normalizeValue(ByteString value) throws DirectoryException {
        byte[] valueBytes = value.value();
        if (valueBytes.length != 36) {
            Message message = SchemaMessages.WARN_ATTR_SYNTAX_UUID_INVALID_LENGTH.get(value.stringValue(), valueBytes.length);
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                case WARN: {
                    ErrorLogger.logError(message);
                    return new ASN1OctetString(valueBytes);
                }
            }
            return new ASN1OctetString(valueBytes);
        }
        byte[] normBytes = new byte[36];
        System.arraycopy(valueBytes, 0, normBytes, 0, 36);
        block24: for (int i = 0; i < 36; ++i) {
            switch (i) {
                case 8: 
                case 13: 
                case 18: 
                case 23: {
                    if (normBytes[i] == 45) continue block24;
                    Message message = SchemaMessages.WARN_ATTR_SYNTAX_UUID_EXPECTED_DASH.get(value.stringValue(), i, String.valueOf(normBytes[i]));
                    switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                        case REJECT: {
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                        }
                        case WARN: {
                            ErrorLogger.logError(message);
                            return new ASN1OctetString(valueBytes);
                        }
                    }
                    return new ASN1OctetString(valueBytes);
                }
                default: {
                    switch (normBytes[i]) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: {
                            continue block24;
                        }
                        case 65: {
                            normBytes[i] = 97;
                            continue block24;
                        }
                        case 66: {
                            normBytes[i] = 98;
                            continue block24;
                        }
                        case 67: {
                            normBytes[i] = 99;
                            continue block24;
                        }
                        case 68: {
                            normBytes[i] = 100;
                            continue block24;
                        }
                        case 69: {
                            normBytes[i] = 101;
                            continue block24;
                        }
                        case 70: {
                            normBytes[i] = 102;
                            continue block24;
                        }
                    }
                    Message message = SchemaMessages.WARN_ATTR_SYNTAX_UUID_EXPECTED_HEX.get(value.stringValue(), i, String.valueOf(normBytes[i]));
                    switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                        case REJECT: {
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                        }
                        case WARN: {
                            ErrorLogger.logError(message);
                            return new ASN1OctetString(valueBytes);
                        }
                    }
                    return new ASN1OctetString(valueBytes);
                }
            }
        }
        return new ASN1OctetString(normBytes);
    }

    public int compareValues(ByteString value1, ByteString value2) {
        return this.compare(value1.value(), value2.value());
    }

    public int compare(byte[] b1, byte[] b2) {
        int minLength = Math.min(b1.length, b2.length);
        for (int i = 0; i < minLength; ++i) {
            if (b1[i] == b2[i]) continue;
            if (b1[i] < b2[i]) {
                return -1;
            }
            if (b1[i] <= b2[i]) continue;
            return 1;
        }
        if (b1.length == b2.length) {
            return 0;
        }
        if (b1.length < b2.length) {
            return -1;
        }
        return 1;
    }
}

