/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.servicetag;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.servicetag.ServiceTag;
import org.opends.server.servicetag.Util;
import org.opends.server.types.DebugLogLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Registry {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String STCLIENT_SOLARIS = "/usr/bin/stclient";
    private static final String STCLIENT_LINUX = "/opt/sun/servicetag/bin/stclient";
    private static final int ST_ERR_NOT_AUTH = 245;
    private static final int ST_ERR_REC_NOT_FOUND = 225;
    private static final String INSTANCE_URN_DESC = "Product instance URN=";
    private static File stclient = null;
    private static String stclientPath = null;
    private static Registry registry = null;

    private Registry() {
    }

    public static Registry getSystemRegistry() throws UnsupportedOperationException {
        if (registry != null || !Registry.isSupported()) {
            throw new UnsupportedOperationException("Registry class is not supported");
        }
        registry = new Registry();
        return registry;
    }

    public static boolean isSupported() {
        return Registry.getSTclientPath() != null;
    }

    public boolean existServiceTag(String productUrn, String installedLocation) {
        boolean found;
        block3: {
            found = false;
            try {
                Set<ServiceTag> tags = this.findServiceTags(productUrn);
                for (ServiceTag svcTag : tags) {
                    if (!svcTag.getProductDefinedInstanceID().equals(installedLocation)) continue;
                    found = true;
                    break;
                }
            }
            catch (IOException ex) {
                if (!DebugLogger.debugEnabled()) break block3;
                TRACER.debugCaught(DebugLogLevel.WARNING, ex);
            }
        }
        return found;
    }

    public boolean existServiceTag(String instanceUrn) {
        try {
            ServiceTag svcTag = this.getServiceTag(instanceUrn);
            return svcTag != null;
        }
        catch (IOException ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.WARNING, ex);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceTag addServiceTag(ServiceTag st) throws IOException {
        if (st == null) {
            throw new NullPointerException("st parameter cannot be null");
        }
        if (this.existServiceTag(st.getInstanceURN())) {
            throw new IOException("Instance_urn = " + st.getInstanceURN() + " already exists");
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(Registry.getSTclientPath());
        command.add("-a");
        command.add("-i");
        command.add(st.getInstanceURN());
        command.add("-p");
        command.add(st.getProductName());
        command.add("-e");
        command.add(st.getProductVersion());
        command.add("-t");
        command.add(st.getProductURN());
        if (st.getProductParentURN().length() > 0) {
            command.add("-F");
            command.add(st.getProductParentURN());
        }
        command.add("-P");
        command.add(st.getProductParent());
        if (st.getProductDefinedInstanceID().length() > 0) {
            command.add("-I");
            command.add(st.getProductDefinedInstanceID());
        }
        command.add("-m");
        command.add(st.getProductVendor());
        command.add("-A");
        command.add(st.getPlatformArch());
        command.add("-z");
        command.add(st.getContainer());
        command.add("-S");
        command.add(st.getSource());
        BufferedReader in = null;
        try {
            ProcessBuilder pb = new ProcessBuilder(command);
            Process p = pb.start();
            String output = Util.commandOutput(p);
            String urn = "";
            if (p.exitValue() == 0) {
                in = new BufferedReader(new StringReader(output));
                String line = null;
                while ((line = in.readLine()) != null) {
                    if (!(line = line.trim()).startsWith(INSTANCE_URN_DESC)) continue;
                    urn = line.substring(INSTANCE_URN_DESC.length());
                    break;
                }
                if (urn.length() == 0) {
                    throw new IOException("Error in creating service tag:\n" + output);
                }
                ServiceTag serviceTag = this.getServiceTag(urn);
                return serviceTag;
            }
            ServiceTag serviceTag = Registry.checkReturnError(p.exitValue(), output, st);
            return serviceTag;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public ServiceTag removeServiceTag(String instanceURN) throws IOException {
        ServiceTag st = this.getServiceTag(instanceURN);
        if (st == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(Registry.getSTclientPath());
        command.add("-d");
        command.add("-i");
        command.add(instanceURN);
        ProcessBuilder pb = new ProcessBuilder(command);
        Process p = pb.start();
        String output = Util.commandOutput(p);
        if (p.exitValue() == 0) {
            return st;
        }
        return Registry.checkReturnError(p.exitValue(), output, st);
    }

    public ServiceTag getServiceTag(String instanceURN) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(Registry.getSTclientPath());
        command.add("-g");
        command.add("-i");
        command.add(instanceURN);
        ProcessBuilder pb = new ProcessBuilder(command);
        Process p = pb.start();
        String output = Util.commandOutput(p);
        if (p.exitValue() == 0) {
            return this.parseServiceTag(output);
        }
        return Registry.checkReturnError(p.exitValue(), output, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ServiceTag> findServiceTags(String productURN) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(Registry.getSTclientPath());
        command.add("-f");
        command.add("-t");
        command.add(productURN);
        BufferedReader in = null;
        try {
            ProcessBuilder pb = new ProcessBuilder(command);
            Process p = pb.start();
            String output = Util.commandOutput(p);
            HashSet<ServiceTag> instances = new HashSet<ServiceTag>();
            if (p.exitValue() == 0) {
                in = new BufferedReader(new StringReader(output));
                String line = null;
                while ((line = in.readLine()) != null) {
                    String s = line.trim();
                    if (!s.startsWith("urn:st:")) continue;
                    instances.add(this.getServiceTag(s));
                }
            } else {
                Registry.checkReturnError(p.exitValue(), output, null);
            }
            HashSet<ServiceTag> hashSet = instances;
            return hashSet;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private static ServiceTag checkReturnError(int exitValue, String output, ServiceTag st) throws IOException {
        switch (exitValue) {
            case 225: {
                return null;
            }
            case 245: {
                if (st != null) {
                    throw new IOException("Not authorized to access " + st.getInstanceURN() + " installer_uid=" + st.getInstallerUID());
                }
                throw new IOException("Not authorized:" + output);
            }
        }
        throw new IOException("stclient exits with error (" + exitValue + ")\n" + output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceTag parseServiceTag(String output) throws IOException {
        BufferedReader in = null;
        try {
            Properties props = new Properties();
            in = new BufferedReader(new StringReader(output));
            String line = null;
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                String[] ss = line.trim().split("=", 2);
                if (ss.length == 2) {
                    props.setProperty(ss[0].trim(), ss[1].trim());
                    continue;
                }
                props.setProperty(ss[0].trim(), "");
            }
            String urn = props.getProperty("instance_urn");
            String productName = props.getProperty("product_name");
            String productVersion = props.getProperty("product_version");
            String productURN = props.getProperty("product_urn");
            String productParent = props.getProperty("product_parent");
            String productParentURN = props.getProperty("product_parent_urn");
            String productDefinedInstanceID = props.getProperty("product_defined_inst_id");
            String productVendor = props.getProperty("product_vendor");
            String platformArch = props.getProperty("platform_arch");
            String container = props.getProperty("container");
            String source = props.getProperty("source");
            int installerUID = Util.getIntValue(props.getProperty("installer_uid"));
            Date timestamp = Util.parseTimestamp(props.getProperty("timestamp"));
            ServiceTag serviceTag = new ServiceTag(urn, productName, productVersion, productURN, productParent, productParentURN, productDefinedInstanceID, productVendor, platformArch, container, source, installerUID, timestamp);
            return serviceTag;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private static String getSTclientPath() {
        if (stclientPath == null) {
            String os = System.getProperty("os.name");
            if (os.equals("SunOS")) {
                stclient = new File(STCLIENT_SOLARIS);
            } else if (os.equals("Linux")) {
                stclient = new File(STCLIENT_LINUX);
            } else if (os.startsWith("Windows")) {
                stclient = Util.getWindowsStClientFile();
            }
        }
        if (stclientPath == null && stclient != null && stclient.exists()) {
            stclientPath = stclient.getAbsolutePath();
        }
        return stclientPath;
    }
}

