/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.File;
import java.io.StringReader;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import javax.crypto.Cipher;
import org.opends.messages.ConfigMessages;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.DefaultBehaviorProvider;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.admin.std.meta.CryptoManagerCfgDefn;
import org.opends.server.api.ConfigHandler;
import org.opends.server.config.BooleanConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.DNConfigAttribute;
import org.opends.server.config.IntegerConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.extensions.SaltedSHA512PasswordStorageScheme;
import org.opends.server.tools.ToolConstants;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryEnvironmentConfig;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.SetupUtils;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

public class ConfigureDS {
    private static final String CLASS_NAME = "org.opends.server.tools.ConfigureDS";
    private static final String DN_JE_BACKEND = "ds-cfg-backend-id=userRoot,cn=Backends,cn=config";
    private static final String DN_LDAP_CONNECTION_HANDLER = "cn=LDAP Connection Handler,cn=Connection Handlers,cn=config";
    private static final String DN_ADMIN_CONNECTOR = "cn=Administration Connector,cn=config";
    private static final String DN_LDAPS_CONNECTION_HANDLER = "cn=LDAPS Connection Handler,cn=Connection Handlers,cn=config";
    private static final String DN_JMX_CONNECTION_HANDLER = "cn=JMX Connection Handler,cn=Connection Handlers,cn=config";
    private static final String DN_ROOT_USER = "cn=Directory Manager,cn=Root DNs,cn=config";
    private static final String DN_CRYPTO_MANAGER = "cn=Crypto Manager,cn=config";

    public static void main(String[] args) {
        int exitCode = ConfigureDS.configMain(args);
        if (exitCode != 0) {
            System.exit(StaticUtils.filterExitCode(exitCode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int configMain(String[] args) {
        StringArgument serverRoot;
        FileBasedArgument rootPasswordFile;
        StringArgument rootPassword;
        StringArgument rootDNString;
        StringArgument baseDNString;
        StringArgument certNickName;
        StringArgument keyManagerPath;
        StringArgument trustManagerProviderDN;
        StringArgument keyManagerProviderDN;
        IntegerArgument jmxPort;
        BooleanArgument enableStartTLS;
        IntegerArgument ldapsPort;
        IntegerArgument adminConnectorPort;
        IntegerArgument ldapPort;
        StringArgument configClass;
        StringArgument configFile;
        Message toolDescription = ToolMessages.INFO_CONFIGDS_TOOL_DESCRIPTION.get();
        ArgumentParser argParser = new ArgumentParser(CLASS_NAME, toolDescription, false);
        try {
            configFile = new StringArgument("configfile", Character.valueOf('c'), "configFile", true, false, true, ToolMessages.INFO_CONFIGFILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_CONFIG_FILE.get());
            configFile.setHidden(true);
            argParser.addArgument(configFile);
            configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", false, false, true, ToolMessages.INFO_CONFIGCLASS_PLACEHOLDER.get(), ConfigFileHandler.class.getName(), null, ToolMessages.INFO_DESCRIPTION_CONFIG_CLASS.get());
            configClass.setHidden(true);
            argParser.addArgument(configClass);
            ldapPort = new IntegerArgument("ldapport", Character.valueOf('p'), "ldapPort", false, false, true, ToolMessages.INFO_LDAPPORT_PLACEHOLDER.get(), 389, null, true, 1, true, 65535, ToolMessages.INFO_CONFIGDS_DESCRIPTION_LDAP_PORT.get());
            argParser.addArgument(ldapPort);
            adminConnectorPort = new IntegerArgument("adminConnectorPort".toLowerCase(), null, "adminConnectorPort", false, false, true, ToolMessages.INFO_PORT_PLACEHOLDER.get(), 4444, "adminConnectorPort", true, 1, true, 65535, ToolMessages.INFO_INSTALLDS_DESCRIPTION_ADMINCONNECTORPORT.get());
            argParser.addArgument(adminConnectorPort);
            ldapsPort = new IntegerArgument("ldapsPort", Character.valueOf('P'), "ldapsPort", false, false, true, ToolMessages.INFO_LDAPPORT_PLACEHOLDER.get(), 636, null, true, 1, true, 65535, ToolMessages.INFO_CONFIGDS_DESCRIPTION_LDAPS_PORT.get());
            argParser.addArgument(ldapsPort);
            enableStartTLS = new BooleanArgument("enableStartTLS", Character.valueOf('q'), "enableStartTLS", ToolMessages.INFO_CONFIGDS_DESCRIPTION_ENABLE_START_TLS.get());
            argParser.addArgument(enableStartTLS);
            jmxPort = new IntegerArgument("jmxport", Character.valueOf('x'), "jmxPort", false, false, true, ToolMessages.INFO_JMXPORT_PLACEHOLDER.get(), SetupUtils.getDefaultJMXPort(), null, true, 1, true, 65535, ToolMessages.INFO_CONFIGDS_DESCRIPTION_JMX_PORT.get());
            argParser.addArgument(jmxPort);
            keyManagerProviderDN = new StringArgument("keymanagerproviderdn", Character.valueOf('k'), "keyManagerProviderDN", false, false, true, ToolMessages.INFO_KEY_MANAGER_PROVIDER_DN_PLACEHOLDER.get(), null, null, ToolMessages.INFO_CONFIGDS_DESCRIPTION_KEYMANAGER_PROVIDER_DN.get());
            argParser.addArgument(keyManagerProviderDN);
            trustManagerProviderDN = new StringArgument("trustmanagerproviderdn", Character.valueOf('t'), "trustManagerProviderDN", false, false, true, ToolMessages.INFO_TRUST_MANAGER_PROVIDER_DN_PLACEHOLDER.get(), null, null, ToolMessages.INFO_CONFIGDS_DESCRIPTION_TRUSTMANAGER_PROVIDER_DN.get());
            argParser.addArgument(trustManagerProviderDN);
            keyManagerPath = new StringArgument("keymanagerpath", Character.valueOf('m'), "keyManagerPath", false, false, true, ToolMessages.INFO_KEY_MANAGER_PATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_CONFIGDS_DESCRIPTION_KEYMANAGER_PATH.get());
            argParser.addArgument(keyManagerPath);
            certNickName = new StringArgument("certnickname", Character.valueOf('a'), "certNickName", false, false, true, ToolMessages.INFO_NICKNAME_PLACEHOLDER.get(), null, null, ToolMessages.INFO_CONFIGDS_DESCRIPTION_CERTNICKNAME.get());
            argParser.addArgument(certNickName);
            baseDNString = new StringArgument("basedn", Character.valueOf('b'), "baseDN", false, true, true, ToolMessages.INFO_BASEDN_PLACEHOLDER.get(), "dc=example,dc=com", null, ToolMessages.INFO_CONFIGDS_DESCRIPTION_BASE_DN.get());
            argParser.addArgument(baseDNString);
            rootDNString = new StringArgument("rootdn", Character.valueOf('D'), "rootUserDN", false, false, true, ToolMessages.INFO_ROOT_USER_DN_PLACEHOLDER.get(), "cn=Directory Manager", null, ToolMessages.INFO_CONFIGDS_DESCRIPTION_ROOT_DN.get());
            argParser.addArgument(rootDNString);
            rootPassword = new StringArgument("rootpw", Character.valueOf('w'), "rootPassword", false, false, true, ToolMessages.INFO_ROOT_USER_PWD_PLACEHOLDER.get(), null, null, ToolMessages.INFO_CONFIGDS_DESCRIPTION_ROOT_PW.get());
            argParser.addArgument(rootPassword);
            rootPasswordFile = new FileBasedArgument("rootpwfile", Character.valueOf('j'), "rootPasswordFile", false, false, ToolMessages.INFO_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_CONFIGDS_DESCRIPTION_ROOT_PW_FILE.get());
            argParser.addArgument(rootPasswordFile);
            BooleanArgument showUsage = new BooleanArgument("showusage", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_USAGE.get());
            argParser.addArgument(showUsage);
            argParser.setUsageArgument(showUsage);
            serverRoot = new StringArgument("serverRoot", ToolConstants.OPTION_SHORT_SERVER_ROOT, "serverRoot", false, false, true, ToolMessages.INFO_SERVER_ROOT_DIR_PLACEHOLDER.get(), null, null, null);
            serverRoot.setHidden(true);
            argParser.addArgument(serverRoot);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            System.err.println(argParser.getUsage());
            return 89;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        if (!(baseDNString.isPresent() || ldapPort.isPresent() || jmxPort.isPresent() || rootDNString.isPresent())) {
            Message message = ToolMessages.ERR_CONFIGDS_NO_CONFIG_CHANGES.get();
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            System.err.println(argParser.getUsage());
            return 1;
        }
        try {
            HashSet<Integer> ports = new HashSet<Integer>();
            if (ldapPort.isPresent()) {
                ports.add(ldapPort.getIntValue());
            }
            if (adminConnectorPort.isPresent()) {
                if (ports.contains(adminConnectorPort.getIntValue())) {
                    Message message = ToolMessages.ERR_CONFIGDS_PORT_ALREADY_SPECIFIED.get(String.valueOf(adminConnectorPort.getIntValue()));
                    System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    System.err.println(argParser.getUsage());
                    return 1;
                }
                ports.add(adminConnectorPort.getIntValue());
            }
            if (ldapsPort.isPresent()) {
                if (ports.contains(ldapsPort.getIntValue())) {
                    Message message = ToolMessages.ERR_CONFIGDS_PORT_ALREADY_SPECIFIED.get(String.valueOf(ldapsPort.getIntValue()));
                    System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    System.err.println(argParser.getUsage());
                    return 1;
                }
                ports.add(ldapsPort.getIntValue());
            }
            if (jmxPort.isPresent()) {
                if (ports.contains(jmxPort.getIntValue())) {
                    Message message = ToolMessages.ERR_CONFIGDS_PORT_ALREADY_SPECIFIED.get(String.valueOf(jmxPort.getIntValue()));
                    System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    System.err.println(argParser.getUsage());
                    return 1;
                }
                ports.add(jmxPort.getIntValue());
            }
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (serverRoot.isPresent()) {
            DirectoryEnvironmentConfig env = DirectoryServer.getEnvironmentConfig();
            String root = serverRoot.getValue();
            try {
                env.setServerRoot(new File(serverRoot.getValue()));
            }
            catch (InitializationException e) {
                ToolMessages.ERR_INITIALIZE_SERVER_ROOT.get(root, e.getMessageObject());
            }
        }
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        directoryServer.bootstrapClient();
        try {
            directoryServer.initializeJMX();
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_CONFIGDS_CANNOT_INITIALIZE_JMX.get(String.valueOf(configFile.getValue()), e.getMessage());
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            directoryServer.initializeConfiguration(configClass.getValue(), configFile.getValue());
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_CONFIGDS_CANNOT_INITIALIZE_CONFIG.get(String.valueOf(configFile.getValue()), e.getMessage());
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            directoryServer.initializeSchema();
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_CONFIGDS_CANNOT_INITIALIZE_SCHEMA.get(String.valueOf(configFile.getValue()), e.getMessage());
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        String serverLockFileName = LockFileManager.getServerLockFileName();
        StringBuilder failureReason = new StringBuilder();
        if (!LockFileManager.acquireExclusiveLock(serverLockFileName, failureReason)) {
            Message message = ToolMessages.ERR_CONFIGDS_CANNOT_ACQUIRE_SERVER_LOCK.get(String.valueOf(serverLockFileName), String.valueOf(failureReason));
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            ConfigHandler configHandler;
            block136: {
                Collection<String> defaultValues;
                DN ldapsListenerDN;
                BooleanConfigAttribute enableAttr2;
                BooleanConfigAttribute enablePortAttr;
                IntegerConfigAttribute portAttr2;
                DN ldapListenerDN;
                CharSequence message;
                ConfigEntry configEntry;
                LDIFReader reader2;
                LDIFImportConfig ldifImportConfig;
                String ldif;
                DN dn;
                LinkedList<DN> baseDNs = null;
                if (baseDNString.isPresent()) {
                    baseDNs = new LinkedList<DN>();
                    for (String dnString : baseDNString.getValues()) {
                        try {
                            baseDNs.add(DN.decode(dnString));
                        }
                        catch (DirectoryException de) {
                            Message message2 = ToolMessages.ERR_CONFIGDS_CANNOT_PARSE_BASE_DN.get(String.valueOf(dnString), de.getMessageObject());
                            System.err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
                            int n = 1;
                            LockFileManager.releaseLock(serverLockFileName, failureReason);
                            return n;
                        }
                    }
                }
                DN rootDN = null;
                String rootPW = null;
                if (rootDNString.isPresent()) {
                    try {
                        rootDN = DN.decode(rootDNString.getValue());
                    }
                    catch (DirectoryException de) {
                        Message message3 = ToolMessages.ERR_CONFIGDS_CANNOT_PARSE_ROOT_DN.get(String.valueOf(rootDNString.getValue()), de.getMessageObject());
                        System.err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
                        int n = 1;
                        LockFileManager.releaseLock(serverLockFileName, failureReason);
                        return n;
                    }
                    if (rootPassword.isPresent()) {
                        rootPW = rootPassword.getValue();
                    } else if (rootPasswordFile.isPresent()) {
                        rootPW = rootPasswordFile.getValue();
                    } else {
                        Message message4 = ToolMessages.ERR_CONFIGDS_NO_ROOT_PW.get();
                        System.err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
                        int message3 = 1;
                        return message3;
                    }
                }
                configHandler = directoryServer.getConfigHandler();
                if (keyManagerProviderDN.isPresent()) {
                    dn = null;
                    DN JCEKSProviderDN = null;
                    try {
                        dn = DN.decode(keyManagerProviderDN.getValue());
                        JCEKSProviderDN = DN.decode("cn=JCEKS,cn=Key Manager Providers,cn=config");
                    }
                    catch (DirectoryException de) {
                        Message message5 = ToolMessages.ERR_CONFIGDS_CANNOT_PARSE_KEYMANAGER_PROVIDER_DN.get(keyManagerProviderDN.getValue(), de.getMessageObject());
                        System.err.println(StaticUtils.wrapText(message5, ServerConstants.MAX_LINE_WIDTH));
                        int n = 1;
                        LockFileManager.releaseLock(serverLockFileName, failureReason);
                        return n;
                    }
                    if (dn.equals(JCEKSProviderDN)) {
                        try {
                            Entry providerConfigEntry;
                            ldif = "dn: cn=JCEKS,cn=Key Manager Providers,cn=config\nobjectClass: top\nobjectClass: ds-cfg-key-manager-provider\nobjectClass: ds-cfg-file-based-key-manager-provider\ncn: JCEKS\nds-cfg-java-class: org.opends.server.extensions.FileBasedKeyManagerProvider\nds-cfg-enabled: true\nds-cfg-key-store-type: JCEKS\nds-cfg-key-store-file: config/keystore.jceks\nds-cfg-key-store-pin-file: config/keystore.pin";
                            ldifImportConfig = new LDIFImportConfig(new StringReader(ldif));
                            reader2 = new LDIFReader(ldifImportConfig);
                            while ((providerConfigEntry = reader2.readEntry()) != null) {
                                configHandler.addEntry(providerConfigEntry, null);
                            }
                        }
                        catch (Exception e) {
                            Message message6 = ToolMessages.ERR_CONFIG_KEYMANAGER_CANNOT_CREATE_JCEKS_PROVIDER.get(String.valueOf(e));
                            System.err.println(StaticUtils.wrapText(message6, ServerConstants.MAX_LINE_WIDTH));
                            int reader2 = 1;
                            LockFileManager.releaseLock(serverLockFileName, failureReason);
                            return reader2;
                        }
                    }
                    try {
                        configHandler.getConfigEntry(dn);
                    }
                    catch (Exception e) {
                        Message message7 = ConfigMessages.ERR_CONFIG_KEYMANAGER_CANNOT_GET_BASE.get(String.valueOf(e));
                        System.err.println(StaticUtils.wrapText(message7, ServerConstants.MAX_LINE_WIDTH));
                        int reader2 = 1;
                        LockFileManager.releaseLock(serverLockFileName, failureReason);
                        return reader2;
                    }
                }
                if (trustManagerProviderDN.isPresent()) {
                    Message message8;
                    dn = null;
                    DN JCEKSTrustManagerDN = null;
                    try {
                        dn = DN.decode(trustManagerProviderDN.getValue());
                        JCEKSTrustManagerDN = DN.decode("cn=JCEKS,cn=Trust Manager Providers,cn=config");
                    }
                    catch (DirectoryException de) {
                        message8 = ToolMessages.ERR_CONFIGDS_CANNOT_PARSE_TRUSTMANAGER_PROVIDER_DN.get(trustManagerProviderDN.getValue(), de.getMessageObject());
                        System.err.println(StaticUtils.wrapText(message8, ServerConstants.MAX_LINE_WIDTH));
                        int reader2 = 1;
                        LockFileManager.releaseLock(serverLockFileName, failureReason);
                        return reader2;
                    }
                    if (dn.equals(JCEKSTrustManagerDN)) {
                        try {
                            Entry trustManagerConfigEntry;
                            ldif = "dn: cn=JCEKS,cn=Trust Manager Providers,cn=config\nobjectClass: top\nobjectClass: ds-cfg-trust-manager-provider\nobjectClass: ds-cfg-file-based-trust-manager-provider\ncn: JKS\nds-cfg-java-class: org.opends.server.extensions.FileBasedTrustManagerProvider\nds-cfg-enabled: false\nds-cfg-trust-store-type: JCEKS\nds-cfg-trust-store-file: config/truststore\n";
                            ldifImportConfig = new LDIFImportConfig(new StringReader(ldif));
                            reader2 = new LDIFReader(ldifImportConfig);
                            while ((trustManagerConfigEntry = reader2.readEntry()) != null) {
                                configHandler.addEntry(trustManagerConfigEntry, null);
                            }
                        }
                        catch (Exception e) {
                            message8 = ConfigMessages.ERR_CONFIG_KEYMANAGER_CANNOT_GET_BASE.get(String.valueOf(e));
                            System.err.println(StaticUtils.wrapText(message8, ServerConstants.MAX_LINE_WIDTH));
                            int reader3 = 1;
                            LockFileManager.releaseLock(serverLockFileName, failureReason);
                            return reader3;
                        }
                    }
                    try {
                        configHandler.getConfigEntry(dn);
                    }
                    catch (Exception e) {
                        message8 = ConfigMessages.ERR_CONFIG_TRUSTMANAGER_CANNOT_GET_BASE.get(String.valueOf(e));
                        System.err.println(StaticUtils.wrapText(message8, ServerConstants.MAX_LINE_WIDTH));
                        int reader3 = 1;
                        LockFileManager.releaseLock(serverLockFileName, failureReason);
                        return reader3;
                    }
                }
                if (keyManagerPath.isPresent() && !keyManagerProviderDN.isPresent()) {
                    Message message9 = ToolMessages.ERR_CONFIGDS_KEYMANAGER_PROVIDER_DN_REQUIRED.get(keyManagerProviderDN.getLongIdentifier(), keyManagerPath.getLongIdentifier());
                    System.err.println(StaticUtils.wrapText(message9, ServerConstants.MAX_LINE_WIDTH));
                    int JCEKSTrustManagerDN = 1;
                    return JCEKSTrustManagerDN;
                }
                if (baseDNs != null) {
                    try {
                        DN jeBackendDN = DN.decode(DN_JE_BACKEND);
                        configEntry = configHandler.getConfigEntry(jeBackendDN);
                        DNConfigAttribute baseDNAttr = new DNConfigAttribute("ds-cfg-base-dn", ConfigMessages.INFO_CONFIG_BACKEND_ATTR_DESCRIPTION_BASE_DNS.get(), true, true, false, baseDNs);
                        configEntry.putConfigAttribute(baseDNAttr);
                    }
                    catch (Exception e) {
                        message = ToolMessages.ERR_CONFIGDS_CANNOT_UPDATE_BASE_DN.get(String.valueOf(e));
                        System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                        int baseDNAttr = 1;
                        LockFileManager.releaseLock(serverLockFileName, failureReason);
                        return baseDNAttr;
                    }
                }
                if (ldapPort.isPresent()) {
                    try {
                        ldapListenerDN = DN.decode(DN_LDAP_CONNECTION_HANDLER);
                        configEntry = configHandler.getConfigEntry(ldapListenerDN);
                        portAttr2 = new IntegerConfigAttribute("ds-cfg-listen-port", ProtocolMessages.INFO_LDAP_CONNHANDLER_DESCRIPTION_LISTEN_PORT.get(), true, false, true, true, 1L, true, 65535L, ldapPort.getIntValue());
                        configEntry.putConfigAttribute(portAttr2);
                    }
                    catch (Exception e) {
                        message = ToolMessages.ERR_CONFIGDS_CANNOT_UPDATE_LDAP_PORT.get(String.valueOf(e));
                        System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                        int portAttr2 = 1;
                        LockFileManager.releaseLock(serverLockFileName, failureReason);
                        return portAttr2;
                    }
                }
                if (adminConnectorPort.isPresent()) {
                    try {
                        DN adminConnectorDN = DN.decode(DN_ADMIN_CONNECTOR);
                        configEntry = configHandler.getConfigEntry(adminConnectorDN);
                        portAttr2 = new IntegerConfigAttribute("ds-cfg-listen-port", ProtocolMessages.INFO_LDAP_CONNHANDLER_DESCRIPTION_LISTEN_PORT.get(), true, false, true, true, 1L, true, 65535L, adminConnectorPort.getIntValue());
                        configEntry.putConfigAttribute(portAttr2);
                    }
                    catch (Exception e) {
                        message = ToolMessages.ERR_CONFIGDS_CANNOT_UPDATE_ADMIN_CONNECTOR_PORT.get(String.valueOf(e));
                        System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                        int portAttr3 = 1;
                        LockFileManager.releaseLock(serverLockFileName, failureReason);
                        return portAttr3;
                    }
                }
                if (ldapsPort.isPresent()) {
                    try {
                        ldapListenerDN = DN.decode(DN_LDAPS_CONNECTION_HANDLER);
                        configEntry = configHandler.getConfigEntry(ldapListenerDN);
                        portAttr2 = new IntegerConfigAttribute("ds-cfg-listen-port", ProtocolMessages.INFO_LDAP_CONNHANDLER_DESCRIPTION_LISTEN_PORT.get(), true, false, true, true, 1L, true, 65535L, ldapsPort.getIntValue());
                        configEntry.putConfigAttribute(portAttr2);
                        enablePortAttr = new BooleanConfigAttribute("ds-cfg-enabled", ProtocolMessages.INFO_LDAPS_CONNHANDLER_DESCRIPTION_ENABLE.get(), true, true);
                        configEntry.putConfigAttribute(enablePortAttr);
                    }
                    catch (Exception e) {
                        message = ToolMessages.ERR_CONFIGDS_CANNOT_UPDATE_LDAPS_PORT.get(String.valueOf(e));
                        System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                        int portAttr4 = 1;
                        LockFileManager.releaseLock(serverLockFileName, failureReason);
                        return portAttr4;
                    }
                }
                if (jmxPort.isPresent()) {
                    try {
                        DN jmxListenerDN = DN.decode(DN_JMX_CONNECTION_HANDLER);
                        configEntry = configHandler.getConfigEntry(jmxListenerDN);
                        portAttr2 = new IntegerConfigAttribute("ds-cfg-listen-port", ProtocolMessages.INFO_JMX_CONNHANDLER_DESCRIPTION_LISTEN_PORT.get(), true, false, true, true, 1L, true, 65535L, jmxPort.getIntValue());
                        configEntry.putConfigAttribute(portAttr2);
                        enablePortAttr = new BooleanConfigAttribute("ds-cfg-enabled", ProtocolMessages.INFO_JMX_CONNHANDLER_DESCRIPTION_ENABLE.get(), true, true);
                        configEntry.putConfigAttribute(enablePortAttr);
                    }
                    catch (Exception e) {
                        message = ToolMessages.ERR_CONFIGDS_CANNOT_UPDATE_JMX_PORT.get(String.valueOf(e));
                        System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                        int portAttr5 = 1;
                        LockFileManager.releaseLock(serverLockFileName, failureReason);
                        return portAttr5;
                    }
                }
                if (enableStartTLS.isPresent()) {
                    try {
                        ldapListenerDN = DN.decode(DN_LDAP_CONNECTION_HANDLER);
                        configEntry = configHandler.getConfigEntry(ldapListenerDN);
                        BooleanConfigAttribute startTLS = new BooleanConfigAttribute("ds-cfg-allow-start-tls", ProtocolMessages.INFO_LDAP_CONNHANDLER_DESCRIPTION_ALLOW_STARTTLS.get(), true, true);
                        configEntry.putConfigAttribute(startTLS);
                    }
                    catch (Exception e) {
                        message = ToolMessages.ERR_CONFIGDS_CANNOT_ENABLE_STARTTLS.get(String.valueOf(e));
                        System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                        int startTLS = 1;
                        LockFileManager.releaseLock(serverLockFileName, failureReason);
                        return startTLS;
                    }
                }
                if (keyManagerProviderDN.isPresent()) {
                    if (enableStartTLS.isPresent() || ldapsPort.isPresent()) {
                        try {
                            dn = DN.decode(keyManagerProviderDN.getValue());
                            configEntry = configHandler.getConfigEntry(dn);
                            enableAttr2 = new BooleanConfigAttribute("ds-cfg-enabled", ConfigMessages.INFO_CONFIG_KEYMANAGER_DESCRIPTION_ENABLED.get(), true, true);
                            configEntry.putConfigAttribute(enableAttr2);
                        }
                        catch (Exception e) {
                            message = ToolMessages.ERR_CONFIGDS_CANNOT_ENABLE_KEYMANAGER.get(String.valueOf(e));
                            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                            int enableAttr2 = 1;
                            LockFileManager.releaseLock(serverLockFileName, failureReason);
                            return enableAttr2;
                        }
                    }
                    try {
                        StringConfigAttribute keyManagerProviderAttr;
                        if (enableStartTLS.isPresent()) {
                            ldapListenerDN = DN.decode(DN_LDAP_CONNECTION_HANDLER);
                            configEntry = configHandler.getConfigEntry(ldapListenerDN);
                            keyManagerProviderAttr = new StringConfigAttribute("ds-cfg-key-manager-provider", ProtocolMessages.INFO_LDAP_CONNHANDLER_DESCRIPTION_KEYMANAGER_DN.get(), false, false, true, keyManagerProviderDN.getValue());
                            configEntry.putConfigAttribute(keyManagerProviderAttr);
                        }
                        if (ldapsPort.isPresent()) {
                            ldapsListenerDN = DN.decode(DN_LDAPS_CONNECTION_HANDLER);
                            configEntry = configHandler.getConfigEntry(ldapsListenerDN);
                            keyManagerProviderAttr = new StringConfigAttribute("ds-cfg-key-manager-provider", ProtocolMessages.INFO_LDAP_CONNHANDLER_DESCRIPTION_KEYMANAGER_DN.get(), false, false, true, keyManagerProviderDN.getValue());
                            configEntry.putConfigAttribute(keyManagerProviderAttr);
                        }
                    }
                    catch (Exception e) {
                        message = ToolMessages.ERR_CONFIGDS_CANNOT_UPDATE_KEYMANAGER_REFERENCE.get(String.valueOf(e));
                        System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                        int keyManagerProviderAttr = 1;
                        LockFileManager.releaseLock(serverLockFileName, failureReason);
                        return keyManagerProviderAttr;
                    }
                    if (keyManagerPath.isPresent()) {
                        try {
                            dn = DN.decode(keyManagerProviderDN.getValue());
                            configEntry = configHandler.getConfigEntry(dn);
                            StringConfigAttribute pathAttr = new StringConfigAttribute("ds-cfg-key-store-file", ExtensionMessages.INFO_FILE_KEYMANAGER_DESCRIPTION_FILE.get(), true, true, true, keyManagerPath.getValue());
                            configEntry.putConfigAttribute(pathAttr);
                        }
                        catch (Exception e) {
                            message = String.valueOf(e);
                            System.err.println(StaticUtils.wrapText((String)message, ServerConstants.MAX_LINE_WIDTH));
                            int pathAttr = 1;
                            LockFileManager.releaseLock(serverLockFileName, failureReason);
                            return pathAttr;
                        }
                    }
                }
                if (trustManagerProviderDN.isPresent()) {
                    if (enableStartTLS.isPresent() || ldapsPort.isPresent()) {
                        try {
                            dn = DN.decode(trustManagerProviderDN.getValue());
                            configEntry = configHandler.getConfigEntry(dn);
                            enableAttr2 = new BooleanConfigAttribute("ds-cfg-enabled", ConfigMessages.ERR_CONFIG_TRUSTMANAGER_DESCRIPTION_ENABLED.get(), true, true);
                            configEntry.putConfigAttribute(enableAttr2);
                        }
                        catch (Exception e) {
                            message = ToolMessages.ERR_CONFIGDS_CANNOT_ENABLE_TRUSTMANAGER.get(String.valueOf(e));
                            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                            int enableAttr3 = 1;
                            LockFileManager.releaseLock(serverLockFileName, failureReason);
                            return enableAttr3;
                        }
                    }
                    try {
                        StringConfigAttribute trustManagerProviderAttr;
                        if (enableStartTLS.isPresent()) {
                            ldapListenerDN = DN.decode(DN_LDAP_CONNECTION_HANDLER);
                            configEntry = configHandler.getConfigEntry(ldapListenerDN);
                            trustManagerProviderAttr = new StringConfigAttribute("ds-cfg-trust-manager-provider", ProtocolMessages.INFO_LDAP_CONNHANDLER_DESCRIPTION_TRUSTMANAGER_DN.get(), false, false, true, trustManagerProviderDN.getValue());
                            configEntry.putConfigAttribute(trustManagerProviderAttr);
                        }
                        if (ldapsPort.isPresent()) {
                            ldapsListenerDN = DN.decode(DN_LDAPS_CONNECTION_HANDLER);
                            configEntry = configHandler.getConfigEntry(ldapsListenerDN);
                            trustManagerProviderAttr = new StringConfigAttribute("ds-cfg-trust-manager-provider", ProtocolMessages.INFO_LDAP_CONNHANDLER_DESCRIPTION_TRUSTMANAGER_DN.get(), false, false, true, trustManagerProviderDN.getValue());
                            configEntry.putConfigAttribute(trustManagerProviderAttr);
                        }
                    }
                    catch (Exception e) {
                        message = ToolMessages.ERR_CONFIGDS_CANNOT_UPDATE_TRUSTMANAGER_REFERENCE.get(String.valueOf(e));
                        System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                        int trustManagerProviderAttr = 1;
                        LockFileManager.releaseLock(serverLockFileName, failureReason);
                        return trustManagerProviderAttr;
                    }
                }
                if (certNickName.isPresent()) {
                    try {
                        ConfigEntry configEntry2;
                        StringConfigAttribute certNickNameAttr = new StringConfigAttribute("ds-cfg-ssl-cert-nickname", ProtocolMessages.INFO_LDAP_CONNHANDLER_DESCRIPTION_SSL_CERT_NICKNAME.get(), false, false, true, certNickName.getValue());
                        if (ldapPort.isPresent()) {
                            DN ldapListenerDN2 = DN.decode(DN_LDAP_CONNECTION_HANDLER);
                            configEntry2 = configHandler.getConfigEntry(ldapListenerDN2);
                            configEntry2.putConfigAttribute(certNickNameAttr);
                        }
                        if (ldapsPort.isPresent()) {
                            DN ldapsListenerDN2 = DN.decode(DN_LDAPS_CONNECTION_HANDLER);
                            configEntry2 = configHandler.getConfigEntry(ldapsListenerDN2);
                            configEntry2.putConfigAttribute(certNickNameAttr);
                        }
                        if (jmxPort.isPresent()) {
                            certNickNameAttr = new StringConfigAttribute("ds-cfg-ssl-cert-nickname", ProtocolMessages.INFO_JMX_CONNHANDLER_DESCRIPTION_SSL_CERT_NICKNAME.get(), false, false, true, certNickName.getValue());
                            DN jmxListenerDN = DN.decode(DN_JMX_CONNECTION_HANDLER);
                            configEntry2 = configHandler.getConfigEntry(jmxListenerDN);
                            configEntry2.putConfigAttribute(certNickNameAttr);
                        }
                    }
                    catch (Exception e) {
                        message = ToolMessages.ERR_CONFIGDS_CANNOT_UPDATE_CERT_NICKNAME.get(String.valueOf(e));
                        System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                        int configEntry3 = 1;
                        LockFileManager.releaseLock(serverLockFileName, failureReason);
                        return configEntry3;
                    }
                }
                if (rootDN != null) {
                    try {
                        DN rootUserDN = DN.decode(DN_ROOT_USER);
                        configEntry = configHandler.getConfigEntry(rootUserDN);
                        DNConfigAttribute bindDNAttr = new DNConfigAttribute("ds-cfg-alternate-bind-dn", ConfigMessages.INFO_CONFIG_ROOTDN_DESCRIPTION_ALTERNATE_BIND_DN.get(), false, true, false, rootDN);
                        configEntry.putConfigAttribute(bindDNAttr);
                        byte[] rootPWBytes = StaticUtils.getBytes(rootPW);
                        String encodedPassword = SaltedSHA512PasswordStorageScheme.encodeOffline(rootPWBytes);
                        StringConfigAttribute bindPWAttr = new StringConfigAttribute("userpassword", Message.EMPTY, false, false, false, encodedPassword);
                        configEntry.putConfigAttribute(bindPWAttr);
                    }
                    catch (Exception e) {
                        message = ToolMessages.ERR_CONFIGDS_CANNOT_UPDATE_ROOT_USER.get(String.valueOf(e));
                        System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                        int bindDNAttr = 1;
                        LockFileManager.releaseLock(serverLockFileName, failureReason);
                        return bindDNAttr;
                    }
                }
                CryptoManagerCfgDefn cryptoManager = CryptoManagerCfgDefn.getInstance();
                StringPropertyDefinition prop = cryptoManager.getKeyWrappingTransformationPropertyDefinition();
                String defaultCipher = null;
                DefaultBehaviorProvider p = prop.getDefaultBehaviorProvider();
                if (p instanceof DefinedDefaultBehaviorProvider && !(defaultValues = ((DefinedDefaultBehaviorProvider)p).getDefaultValues()).isEmpty()) {
                    defaultCipher = defaultValues.iterator().next().toString();
                }
                if (defaultCipher != null) {
                    try {
                        Cipher.getInstance(defaultCipher);
                    }
                    catch (GeneralSecurityException ex) {
                        String alternativeCipher = ConfigureDS.getAlternativeCipher();
                        if (alternativeCipher == null) break block136;
                        try {
                            DN cipherDN = DN.decode(DN_CRYPTO_MANAGER);
                            ConfigEntry configEntry4 = configHandler.getConfigEntry(cipherDN);
                            StringConfigAttribute keyWrappingTransformation = new StringConfigAttribute("ds-cfg-key-wrapping-transformation", Message.EMPTY, false, false, true, alternativeCipher);
                            configEntry4.putConfigAttribute(keyWrappingTransformation);
                        }
                        catch (Exception e) {
                            Message message10 = ToolMessages.ERR_CONFIGDS_CANNOT_UPDATE_CRYPTO_MANAGER.get(String.valueOf(e));
                            System.err.println(StaticUtils.wrapText(message10, ServerConstants.MAX_LINE_WIDTH));
                            int n = 1;
                            LockFileManager.releaseLock(serverLockFileName, failureReason);
                            return n;
                        }
                    }
                }
            }
            try {
                configHandler.writeUpdatedConfig();
                Message message = ToolMessages.INFO_CONFIGDS_WROTE_UPDATED_CONFIG.get();
                System.out.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            }
            catch (DirectoryException de) {
                Message message = ToolMessages.ERR_CONFIGDS_CANNOT_WRITE_UPDATED_CONFIG.get(de.getMessageObject());
                System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                int n = 1;
                LockFileManager.releaseLock(serverLockFileName, failureReason);
                return n;
            }
        }
        finally {
            LockFileManager.releaseLock(serverLockFileName, failureReason);
        }
        return 0;
    }

    private static String getAlternativeCipher() {
        String[] preferredAlternativeCiphers = new String[]{"RSA/ECB/OAEPWITHSHA1ANDMGF1PADDING", "RSA/ECB/PKCS1Padding"};
        String alternativeCipher = null;
        for (String cipher : preferredAlternativeCiphers) {
            try {
                Cipher.getInstance(cipher);
                alternativeCipher = cipher;
                break;
            }
            catch (Throwable t) {
            }
        }
        return alternativeCipher;
    }
}

