/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLException;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.controls.ProxiedAuthV2Control;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.ldap.AddRequestProtocolOp;
import org.opends.server.protocols.ldap.AddResponseProtocolOp;
import org.opends.server.protocols.ldap.ExtendedResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.tasks.ShutdownTask;
import org.opends.server.tools.LDAPConnection;
import org.opends.server.tools.LDAPConnectionException;
import org.opends.server.tools.LDAPConnectionOptions;
import org.opends.server.tools.LDAPReader;
import org.opends.server.tools.LDAPWriter;
import org.opends.server.tools.SSLConnectionException;
import org.opends.server.tools.SSLConnectionFactory;
import org.opends.server.tools.ToolConstants;
import org.opends.server.types.LDAPException;
import org.opends.server.types.NullOutputStream;
import org.opends.server.types.RawAttribute;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.LDAPConnectionArgumentParser;
import org.opends.server.util.args.StringArgument;

public class StopDS {
    private static final String CLASS_NAME = "org.opends.server.tools.StopDS";
    private static int SERVER_ALREADY_STOPPED = 98;
    private static int START_SERVER = 99;
    private static int STOP_USING_SYSTEM_CALL = 100;
    private static int RESTART_USING_SYSTEM_CALL = 101;
    private static int STOP_USING_PROTOCOL = 102;
    private static int STOP_AS_WINDOW_SERVICE = 103;
    private static int RESTART_AS_WINDOW_SERVICE = 104;
    private static int START_SERVER_QUIET = 105;
    private static int RESTART_USING_SYSTEM_CALL_QUIET = 106;

    public static void main(String[] args) {
        int result = StopDS.stopDS(args, System.out, System.err);
        if (result != 0) {
            System.exit(StaticUtils.filterExitCode(result));
        }
    }

    public static int stopDS(String[] args) {
        return StopDS.stopDS(args, System.out, System.err);
    }

    public static int stopDS(String[] args, OutputStream outStream, OutputStream errStream) {
        LDAPMessage responseMessage;
        Message message;
        LDAPConnection connection;
        String timeStr;
        BooleanArgument quietMode;
        FileBasedArgument trustStorePWFile;
        StringArgument trustStorePW;
        StringArgument trustStoreFile;
        StringArgument certNickname;
        FileBasedArgument keyStorePWFile;
        StringArgument keyStorePW;
        StringArgument keyStoreFile;
        BooleanArgument trustAll;
        StringArgument stopTimeStr;
        BooleanArgument restart;
        BooleanArgument checkStoppability;
        StringArgument stopReason;
        StringArgument proxyAuthzID;
        StringArgument saslOption;
        FileBasedArgument bindPWFile;
        StringArgument bindPW;
        StringArgument bindDN;
        IntegerArgument port;
        StringArgument host;
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        Message toolDescription = ToolMessages.INFO_STOPDS_TOOL_DESCRIPTION.get();
        ArgumentParser argParser = new ArgumentParser(CLASS_NAME, toolDescription, false);
        try {
            StringArgument propertiesFileArgument = new StringArgument("propertiesFilePath", null, "propertiesFilePath", false, false, true, ToolMessages.INFO_PROP_FILE_PATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_PROP_FILE_PATH.get());
            argParser.addArgument(propertiesFileArgument);
            argParser.setFilePropertiesArgument(propertiesFileArgument);
            BooleanArgument noPropertiesFileArgument = new BooleanArgument("noPropertiesFileArgument", null, "noPropertiesFile", ToolMessages.INFO_DESCRIPTION_NO_PROP_FILE.get());
            argParser.addArgument(noPropertiesFileArgument);
            argParser.setNoPropertiesFileArgument(noPropertiesFileArgument);
            host = new StringArgument("host", Character.valueOf('h'), "hostname", false, false, true, ToolMessages.INFO_HOST_PLACEHOLDER.get(), "127.0.0.1", null, ToolMessages.INFO_STOPDS_DESCRIPTION_HOST.get());
            host.setPropertyName("hostname");
            argParser.addArgument(host);
            port = new IntegerArgument("port", Character.valueOf('p'), "port", false, false, true, ToolMessages.INFO_PORT_PLACEHOLDER.get(), 389, null, true, 1, true, 65535, ToolMessages.INFO_STOPDS_DESCRIPTION_PORT.get());
            port.setPropertyName("port");
            argParser.addArgument(port);
            bindDN = new StringArgument("binddn", Character.valueOf('D'), "bindDN", false, false, true, ToolMessages.INFO_BINDDN_PLACEHOLDER.get(), null, null, ToolMessages.INFO_STOPDS_DESCRIPTION_BINDDN.get());
            bindDN.setPropertyName("bindDN");
            argParser.addArgument(bindDN);
            bindPW = new StringArgument("bindpw", Character.valueOf('w'), "bindPassword", false, false, true, ToolMessages.INFO_BINDPWD_PLACEHOLDER.get(), null, null, ToolMessages.INFO_STOPDS_DESCRIPTION_BINDPW.get());
            bindPW.setPropertyName("bindPassword");
            argParser.addArgument(bindPW);
            bindPWFile = new FileBasedArgument("bindpwfile", Character.valueOf('j'), "bindPasswordFile", false, false, ToolMessages.INFO_BINDPWD_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_STOPDS_DESCRIPTION_BINDPWFILE.get());
            bindPWFile.setPropertyName("bindPasswordFile");
            argParser.addArgument(bindPWFile);
            saslOption = new StringArgument("sasloption", Character.valueOf('o'), "saslOption", false, true, true, ToolMessages.INFO_SASL_OPTION_PLACEHOLDER.get(), null, null, ToolMessages.INFO_STOPDS_DESCRIPTION_SASLOPTIONS.get());
            saslOption.setPropertyName("saslOption");
            argParser.addArgument(saslOption);
            proxyAuthzID = new StringArgument("proxyauthzid", Character.valueOf('Y'), "proxyAs", false, false, true, ToolMessages.INFO_PROXYAUTHID_PLACEHOLDER.get(), null, null, ToolMessages.INFO_STOPDS_DESCRIPTION_PROXYAUTHZID.get());
            proxyAuthzID.setPropertyName("proxyAs");
            argParser.addArgument(proxyAuthzID);
            stopReason = new StringArgument("stopreason", Character.valueOf('r'), "stopReason", false, false, true, ToolMessages.INFO_STOP_REASON_PLACEHOLDER.get(), null, null, ToolMessages.INFO_STOPDS_DESCRIPTION_STOP_REASON.get());
            stopReason.setPropertyName("stopReason");
            argParser.addArgument(stopReason);
            checkStoppability = new BooleanArgument("checkstoppability", null, "checkStoppability", ToolMessages.INFO_STOPDS_CHECK_STOPPABILITY.get());
            checkStoppability.setHidden(true);
            argParser.addArgument(checkStoppability);
            BooleanArgument windowsNetStop = new BooleanArgument("windowsnetstop", null, "windowsNetStop", ToolMessages.INFO_STOPDS_DESCRIPTION_WINDOWS_NET_STOP.get());
            windowsNetStop.setHidden(true);
            argParser.addArgument(windowsNetStop);
            restart = new BooleanArgument("restart", Character.valueOf('R'), "restart", ToolMessages.INFO_STOPDS_DESCRIPTION_RESTART.get());
            restart.setPropertyName("restart");
            argParser.addArgument(restart);
            stopTimeStr = new StringArgument("stoptime", Character.valueOf('t'), "stopTime", false, false, true, ToolMessages.INFO_STOP_TIME_PLACEHOLDER.get(), null, null, ToolMessages.INFO_STOPDS_DESCRIPTION_STOP_TIME.get());
            stopTimeStr.setPropertyName("stopTime");
            argParser.addArgument(stopTimeStr);
            trustAll = new BooleanArgument("trustall", Character.valueOf('X'), "trustAll", ToolMessages.INFO_STOPDS_DESCRIPTION_TRUST_ALL.get());
            trustAll.setPropertyName("trustAll");
            argParser.addArgument(trustAll);
            keyStoreFile = new StringArgument("keystorefile", Character.valueOf('K'), "keyStorePath", false, false, true, ToolMessages.INFO_KEYSTOREPATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_STOPDS_DESCRIPTION_KSFILE.get());
            keyStoreFile.setPropertyName("keyStorePath");
            argParser.addArgument(keyStoreFile);
            keyStorePW = new StringArgument("keystorepw", Character.valueOf('W'), "keyStorePassword", false, false, true, ToolMessages.INFO_KEYSTORE_PWD_PLACEHOLDER.get(), null, null, ToolMessages.INFO_STOPDS_DESCRIPTION_KSPW.get());
            keyStorePW.setPropertyName("keyStorePassword");
            argParser.addArgument(keyStorePW);
            keyStorePWFile = new FileBasedArgument("keystorepwfile", Character.valueOf('u'), "keyStorePasswordFile", false, false, ToolMessages.INFO_KEYSTORE_PWD_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_STOPDS_DESCRIPTION_KSPWFILE.get());
            keyStorePWFile.setPropertyName("keyStorePasswordFile");
            argParser.addArgument(keyStorePWFile);
            certNickname = new StringArgument("certnickname", Character.valueOf('N'), "certNickname", false, false, true, ToolMessages.INFO_NICKNAME_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_CERT_NICKNAME.get());
            certNickname.setPropertyName("certNickname");
            argParser.addArgument(certNickname);
            trustStoreFile = new StringArgument("truststorefile", Character.valueOf('P'), "trustStorePath", false, false, true, ToolMessages.INFO_TRUSTSTOREPATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_STOPDS_DESCRIPTION_TSFILE.get());
            trustStoreFile.setPropertyName("trustStorePath");
            argParser.addArgument(trustStoreFile);
            trustStorePW = new StringArgument("truststorepw", Character.valueOf('T'), "trustStorePassword", false, false, true, ToolMessages.INFO_TRUSTSTORE_PWD_PLACEHOLDER.get(), null, null, ToolMessages.INFO_STOPDS_DESCRIPTION_TSPW.get());
            trustStorePW.setPropertyName("trustStorePassword");
            argParser.addArgument(trustStorePW);
            trustStorePWFile = new FileBasedArgument("truststorepwfile", Character.valueOf('U'), "trustStorePasswordFile", false, false, ToolMessages.INFO_TRUSTSTORE_PWD_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_STOPDS_DESCRIPTION_TSPWFILE.get());
            trustStorePWFile.setPropertyName("trustStorePasswordFile");
            argParser.addArgument(trustStorePWFile);
            quietMode = new BooleanArgument("quiet", ToolConstants.OPTION_SHORT_QUIET, "quiet", ToolMessages.INFO_DESCRIPTION_QUIET.get());
            quietMode.setPropertyName("quiet");
            argParser.addArgument(quietMode);
            BooleanArgument showUsage = new BooleanArgument("showusage", Character.valueOf('H'), "help", ToolMessages.INFO_STOPDS_DESCRIPTION_SHOWUSAGE.get());
            argParser.addArgument(showUsage);
            argParser.setUsageArgument(showUsage, out);
        }
        catch (ArgumentException ae) {
            Message message2 = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            Message message3 = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 89;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        if (quietMode.isPresent()) {
            out = NullOutputStream.printStream();
        }
        if (checkStoppability.isPresent()) {
            System.exit(StopDS.checkStoppability(argParser, out, err));
        }
        if (bindPW.isPresent() && bindPWFile.isPresent()) {
            Message message4 = ToolMessages.ERR_STOPDS_MUTUALLY_EXCLUSIVE_ARGUMENTS.get(bindPW.getLongIdentifier(), bindPWFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        if (keyStorePW.isPresent() && keyStorePWFile.isPresent()) {
            Message message5 = ToolMessages.ERR_STOPDS_MUTUALLY_EXCLUSIVE_ARGUMENTS.get(keyStorePW.getLongIdentifier(), keyStorePWFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message5, ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        if (trustStorePW.isPresent() && trustStorePWFile.isPresent()) {
            Message message6 = ToolMessages.ERR_STOPDS_MUTUALLY_EXCLUSIVE_ARGUMENTS.get(trustStorePW.getLongIdentifier(), trustStorePWFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message6, ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        Date stopTime = new Date();
        if (stopTimeStr.isPresent() && !"0".equals(timeStr = stopTimeStr.getValue())) {
            try {
                stopTime = StaticUtils.parseDateTimeString(timeStr);
            }
            catch (Exception e) {
                Message message7 = ToolMessages.ERR_STOPDS_CANNOT_DECODE_STOP_TIME.get();
                err.println(StaticUtils.wrapText(message7, ServerConstants.MAX_LINE_WIDTH));
                return 89;
            }
        }
        LDAPConnectionOptions connectionOptions = new LDAPConnectionOptions();
        connectionOptions.setVersionNumber(3);
        try {
            String clientAlias = certNickname.isPresent() ? certNickname.getValue() : null;
            SSLConnectionFactory sslConnectionFactory = new SSLConnectionFactory();
            sslConnectionFactory.init(trustAll.isPresent(), keyStoreFile.getValue(), keyStorePW.getValue(), clientAlias, trustStoreFile.getValue(), trustStorePW.getValue());
            connectionOptions.setSSLConnectionFactory(sslConnectionFactory);
        }
        catch (SSLConnectionException sce) {
            Message message8 = ToolMessages.ERR_STOPDS_CANNOT_INITIALIZE_SSL.get(sce.getMessage());
            err.println(StaticUtils.wrapText(message8, ServerConstants.MAX_LINE_WIDTH));
            return 82;
        }
        if (saslOption.isPresent()) {
            String mechanism = null;
            LinkedList<String> options = new LinkedList<String>();
            for (String s : saslOption.getValues()) {
                int equalPos = s.indexOf(61);
                if (equalPos <= 0) {
                    Message message9 = ToolMessages.ERR_STOPDS_CANNOT_PARSE_SASL_OPTION.get(s);
                    err.println(StaticUtils.wrapText(message9, ServerConstants.MAX_LINE_WIDTH));
                    return 89;
                }
                String name = s.substring(0, equalPos);
                if (name.equalsIgnoreCase("mech")) {
                    mechanism = s;
                    continue;
                }
                options.add(s);
            }
            if (mechanism == null) {
                Message message10 = ToolMessages.ERR_STOPDS_NO_SASL_MECHANISM.get();
                err.println(StaticUtils.wrapText(message10, ServerConstants.MAX_LINE_WIDTH));
                return 89;
            }
            connectionOptions.setSASLMechanism(mechanism);
            for (String option : options) {
                connectionOptions.addSASLProperty(option);
            }
        }
        AtomicInteger nextMessageID = new AtomicInteger(1);
        try {
            connection = new LDAPConnection(host.getValue(), port.getIntValue(), connectionOptions, out, err);
            connection.connectToHost(bindDN.getValue(), LDAPConnectionArgumentParser.getPasswordValue(bindPW, bindPWFile), nextMessageID);
        }
        catch (ArgumentException ae) {
            message = ToolMessages.ERR_STOPDS_CANNOT_DETERMINE_PORT.get(port.getLongIdentifier(), ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 89;
        }
        catch (LDAPConnectionException lce) {
            message = null;
            if (lce.getCause() != null && lce.getCause().getCause() != null && lce.getCause().getCause() instanceof SSLException) {
                message = ToolMessages.ERR_STOPDS_CANNOT_CONNECT_SSL.get(host.getValue(), port.getValue());
            } else {
                String hostPort = host.getValue() + ":" + port.getValue();
                message = ToolMessages.ERR_STOPDS_CANNOT_CONNECT.get(hostPort, lce.getMessage());
            }
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 91;
        }
        LDAPReader reader = connection.getLDAPReader();
        LDAPWriter writer = connection.getLDAPWriter();
        String taskID = UUID.randomUUID().toString();
        ASN1OctetString entryDN = new ASN1OctetString("ds-task-id=" + taskID + "," + "cn=Scheduled Tasks" + "," + "cn=Tasks");
        ArrayList<RawAttribute> attributes = new ArrayList<RawAttribute>();
        ArrayList<ASN1OctetString> ocValues = new ArrayList<ASN1OctetString>(3);
        ocValues.add(new ASN1OctetString("top"));
        ocValues.add(new ASN1OctetString("ds-task"));
        ocValues.add(new ASN1OctetString("ds-task-shutdown"));
        attributes.add(new LDAPAttribute("objectClass", ocValues));
        ArrayList<ASN1OctetString> taskIDValues = new ArrayList<ASN1OctetString>(1);
        taskIDValues.add(new ASN1OctetString(taskID));
        attributes.add(new LDAPAttribute("ds-task-id", taskIDValues));
        ArrayList<ASN1OctetString> classValues = new ArrayList<ASN1OctetString>(1);
        classValues.add(new ASN1OctetString(ShutdownTask.class.getName()));
        attributes.add(new LDAPAttribute("ds-task-class-name", classValues));
        if (restart.isPresent()) {
            ArrayList<ASN1OctetString> restartValues = new ArrayList<ASN1OctetString>(1);
            restartValues.add(new ASN1OctetString("true"));
            attributes.add(new LDAPAttribute("ds-task-restart-server", restartValues));
        }
        if (stopReason.isPresent()) {
            ArrayList<ASN1OctetString> stopReasonValues = new ArrayList<ASN1OctetString>(1);
            stopReasonValues.add(new ASN1OctetString(stopReason.getValue()));
            attributes.add(new LDAPAttribute("ds-task-shutdown-message", stopReasonValues));
        }
        if (stopTime != null) {
            ArrayList<ASN1OctetString> stopTimeValues = new ArrayList<ASN1OctetString>(1);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            stopTimeValues.add(new ASN1OctetString(dateFormat.format(stopTime)));
            attributes.add(new LDAPAttribute("ds-task-scheduled-start-time", stopTimeValues));
        }
        ArrayList<LDAPControl> controls = new ArrayList<LDAPControl>();
        if (proxyAuthzID.isPresent()) {
            ProxiedAuthV2Control c = new ProxiedAuthV2Control(new ASN1OctetString(proxyAuthzID.getValue()));
            controls.add(new LDAPControl(c));
        }
        AddRequestProtocolOp addRequest = new AddRequestProtocolOp(entryDN, attributes);
        LDAPMessage requestMessage = new LDAPMessage(nextMessageID.getAndIncrement(), addRequest, controls);
        try {
            writer.writeMessage(requestMessage);
            responseMessage = reader.readMessage();
            if (responseMessage == null) {
                Message message11 = ToolMessages.ERR_STOPDS_UNEXPECTED_CONNECTION_CLOSURE.get();
                err.println(StaticUtils.wrapText(message11, ServerConstants.MAX_LINE_WIDTH));
                return 81;
            }
        }
        catch (IOException ioe) {
            Message message12 = ToolMessages.ERR_STOPDS_IO_ERROR.get(String.valueOf(ioe));
            err.println(StaticUtils.wrapText(message12, ServerConstants.MAX_LINE_WIDTH));
            return 81;
        }
        catch (ASN1Exception ae) {
            Message message13 = ToolMessages.ERR_STOPDS_DECODE_ERROR.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message13, ServerConstants.MAX_LINE_WIDTH));
            return 84;
        }
        catch (LDAPException le) {
            Message message14 = ToolMessages.ERR_STOPDS_DECODE_ERROR.get(le.getMessage());
            err.println(StaticUtils.wrapText(message14, ServerConstants.MAX_LINE_WIDTH));
            return 84;
        }
        if (responseMessage.getProtocolOpType() != 105) {
            ExtendedResponseProtocolOp extendedResponse;
            String responseOID;
            if (responseMessage.getProtocolOpType() == 120 && (responseOID = (extendedResponse = responseMessage.getExtendedResponseProtocolOp()).getOID()) != null && responseOID.equals("1.3.6.1.4.1.1466.20036")) {
                Message message15 = extendedResponse.getErrorMessage();
                if (message15 != null) {
                    err.println(StaticUtils.wrapText(message15, ServerConstants.MAX_LINE_WIDTH));
                }
                return extendedResponse.getResultCode();
            }
            Message message16 = ToolMessages.ERR_STOPDS_INVALID_RESPONSE_TYPE.get(responseMessage.getProtocolOpName());
            err.println(StaticUtils.wrapText(message16, ServerConstants.MAX_LINE_WIDTH));
            return 82;
        }
        AddResponseProtocolOp addResponse = responseMessage.getAddResponseProtocolOp();
        Message errorMessage = addResponse.getErrorMessage();
        if (errorMessage != null) {
            err.println(StaticUtils.wrapText(errorMessage, ServerConstants.MAX_LINE_WIDTH));
        }
        return addResponse.getResultCode();
    }

    private static int checkStoppability(ArgumentParser argParser, PrintStream out, PrintStream err) {
        int returnValue;
        boolean quietMode = false;
        Argument quietArg = argParser.getArgumentForLongID("quiet");
        if (quietArg != null && quietArg.isPresent()) {
            quietMode = true;
        }
        BooleanArgument restart = (BooleanArgument)argParser.getArgumentForLongID("restart");
        boolean restartPresent = restart.isPresent();
        BooleanArgument windowsNetStop = (BooleanArgument)argParser.getArgumentForLongID("windowsnetstop");
        boolean windowsNetStopPresent = windowsNetStop.isPresent();
        LinkedList<Argument> list = argParser.getArgumentList();
        boolean stopThroughProtocol = false;
        for (Argument arg : list) {
            if ("restart".equals(arg.getName()) || "quiet".equals(arg.getName()) || "showusage".equals(arg.getName()) || "checkstoppability".equals(arg.getName()) || "windowsnetstop".equals(arg.getName())) continue;
            stopThroughProtocol |= arg.isPresent();
        }
        if (stopThroughProtocol) {
            returnValue = STOP_USING_PROTOCOL;
        } else {
            boolean isServerRunning;
            Message message;
            String lockFile = LockFileManager.getServerLockFileName();
            try {
                StringBuilder failureReason = new StringBuilder();
                if (LockFileManager.acquireExclusiveLock(lockFile, failureReason)) {
                    message = ToolMessages.INFO_STOPDS_SERVER_ALREADY_STOPPED.get();
                    out.println(message);
                    LockFileManager.releaseLock(lockFile, failureReason);
                    isServerRunning = false;
                } else {
                    isServerRunning = true;
                }
            }
            catch (Exception e) {
                isServerRunning = true;
            }
            boolean configuredAsService = DirectoryServer.isRunningAsWindowsService();
            if (!isServerRunning) {
                returnValue = configuredAsService && !windowsNetStopPresent ? (restartPresent ? RESTART_AS_WINDOW_SERVICE : STOP_AS_WINDOW_SERVICE) : (restartPresent ? (quietMode ? START_SERVER_QUIET : START_SERVER) : SERVER_ALREADY_STOPPED);
            } else if (configuredAsService) {
                if (windowsNetStopPresent) {
                    returnValue = restartPresent ? (quietMode ? RESTART_USING_SYSTEM_CALL_QUIET : RESTART_USING_SYSTEM_CALL) : STOP_USING_SYSTEM_CALL;
                } else {
                    returnValue = restartPresent ? RESTART_AS_WINDOW_SERVICE : STOP_AS_WINDOW_SERVICE;
                    message = ToolMessages.INFO_STOPDS_GOING_TO_STOP.get();
                    out.println(message);
                }
            } else {
                message = ToolMessages.INFO_STOPDS_GOING_TO_STOP.get();
                out.println(message);
                returnValue = restartPresent ? (quietMode ? RESTART_USING_SYSTEM_CALL_QUIET : RESTART_USING_SYSTEM_CALL) : STOP_USING_SYSTEM_CALL;
            }
        }
        return returnValue;
    }
}

