/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.configurator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.messages.ToolMessages;
import org.opends.quicksetup.BuildInformation;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.QuickSetupLog;
import org.opends.quicksetup.ReturnCode;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;

public class CheckInstance {
    private static final Logger LOG = Logger.getLogger(CheckInstance.class.getName());
    public static final String LOG_FILE_PREFIX = "opends-checkinstance-";
    private static String installRootFromSystem;
    private static String instanceRootFromSystem;
    public static final String CURRENT_USER_OPTION_LONG = "currentUser";
    public static final Character CURRENT_USER_OPTION_SHORT;
    public static final String CHECK_VERSION_OPTION_LONG = "checkVersion";
    public static final Character CHECK_VERSION_OPTION_SHORT;
    private static StringArgument currentUserArg;
    private static BooleanArgument checkVersionArg;
    private static String currentUser;
    private static String instanceOwner;
    private static int SUCCESS;
    private static int ARGS_ERROR;
    private static int USER_ERROR;
    private static int VERSION_ERROR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            QuickSetupLog.initLogFileHandler(File.createTempFile(LOG_FILE_PREFIX, ".log"));
        }
        catch (Throwable t) {
            System.err.println(QuickSetupMessages.INFO_ERROR_INITIALIZING_LOG.get());
            t.printStackTrace();
        }
        Message toolDescription = ToolMessages.INFO_CHECK_DESCRIPTION.get();
        ArgumentParser argParser = new ArgumentParser(CheckInstance.class.getName(), toolDescription, false);
        installRootFromSystem = System.getProperty("INSTALL_ROOT");
        if (installRootFromSystem == null) {
            System.err.println("INSTALL_ROOT property not specified");
            System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
        }
        if ((instanceRootFromSystem = System.getProperty("INSTANCE_ROOT")) == null) {
            System.err.println("INSTANCE_ROOT property not specified");
            System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
        }
        try {
            currentUserArg = new StringArgument(CURRENT_USER_OPTION_LONG, CURRENT_USER_OPTION_SHORT, CURRENT_USER_OPTION_LONG, true, true, ToolMessages.INFO_CURRENT_USER_PLACEHOLDER.get(), ToolMessages.INFO_CHECK_DESCRIPTION_CURRENT_USER.get());
            argParser.addArgument(currentUserArg);
            checkVersionArg = new BooleanArgument(CHECK_VERSION_OPTION_LONG, CHECK_VERSION_OPTION_SHORT, CHECK_VERSION_OPTION_LONG, ToolMessages.INFO_CHECK_DESCRIPTION_CHECK_VERSION.get());
            argParser.addArgument(checkVersionArg);
        }
        catch (ArgumentException ae) {
            System.err.println(ae.getMessageObject());
            System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            System.err.println(ae.getMessageObject());
            System.exit(ARGS_ERROR);
        }
        Installation installation = new Installation(installRootFromSystem, instanceRootFromSystem);
        File conf = installation.getCurrentConfigurationFile();
        String cmd = null;
        Process proc = null;
        int exit = 0;
        InputStreamReader reader = null;
        StringBuffer sb = new StringBuffer();
        cmd = "ls -l " + conf.getAbsolutePath();
        try {
            int c;
            proc = Runtime.getRuntime().exec(cmd);
            proc.waitFor();
            reader = new InputStreamReader(proc.getInputStream());
            while ((c = reader.read()) != -1) {
                sb.append((char)c);
            }
            exit = proc.exitValue();
            if (exit != 0) {
                LOG.log(Level.FINEST, cmd + " error= " + exit);
                System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
            }
        }
        catch (InterruptedException ex) {
            LOG.log(Level.SEVERE, "InterruptedException" + ex.getMessage());
            System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, "IOException" + ex.getMessage());
            System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
        }
        LOG.log(Level.FINEST, cmd + " returns [" + sb.toString() + "]");
        StringTokenizer tok = new StringTokenizer(sb.toString());
        if (tok.hasMoreTokens()) {
            tok.nextToken();
            if (tok.hasMoreTokens()) {
                tok.nextToken();
                if (tok.hasMoreTokens()) {
                    instanceOwner = tok.nextToken();
                    LOG.log(Level.FINEST, "instanceOwner=[" + instanceOwner + "]");
                } else {
                    LOG.log(Level.SEVERE, "no instanceOwner");
                    System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
                }
            } else {
                LOG.log(Level.SEVERE, "no inode");
                System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
            }
        } else {
            LOG.log(Level.SEVERE, "no access rights");
            System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
        }
        currentUser = currentUserArg.getValue();
        LOG.log(Level.FINEST, "currentUser=[" + currentUser + "]");
        if (currentUser != null && !currentUser.equals(instanceOwner)) {
            System.err.println(ToolMessages.ERR_CHECK_USER_ERROR.get(instanceOwner));
            System.exit(USER_ERROR);
        }
        if (checkVersionArg.isPresent()) {
            BuildInformation instanceBi;
            BuildInformation installBi;
            block32: {
                instanceBi = installBi = BuildInformation.fromBuildString("1.2.0.4920");
                try {
                    File bif = new File(installation.getConfigurationDirectory(), "buildinfo");
                    if (!bif.exists()) break block32;
                    BufferedReader breader = new BufferedReader(new FileReader(bif));
                    try {
                        String line = breader.readLine();
                        instanceBi = BuildInformation.fromBuildString(line);
                    }
                    finally {
                        try {
                            breader.close();
                        }
                        catch (Exception e) {}
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "error getting build information for current instance", e);
                }
            }
            if (!installBi.equals(instanceBi)) {
                System.err.println(ToolMessages.ERR_CHECK_VERSION_NOT_MATCH.get());
                System.exit(VERSION_ERROR);
            }
        } else {
            LOG.log(Level.FINEST, "checkVersion not specified");
        }
        System.exit(SUCCESS);
    }

    static {
        CURRENT_USER_OPTION_SHORT = null;
        CHECK_VERSION_OPTION_SHORT = null;
        SUCCESS = 0;
        ARGS_ERROR = 1;
        USER_ERROR = 2;
        VERSION_ERROR = 3;
    }
}

