/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsconfig;

import java.util.LinkedHashSet;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.admin.ads.util.OpendsCertificateException;
import org.opends.messages.DSConfigMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.client.AuthenticationException;
import org.opends.server.admin.client.AuthenticationNotSupportedException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.client.cli.DsFrameworkCliReturnCode;
import org.opends.server.admin.client.cli.SecureConnectionCliArgs;
import org.opends.server.admin.client.ldap.JNDIDirContextAdaptor;
import org.opends.server.admin.client.ldap.LDAPManagementContext;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.dsconfig.ManagementContextFactory;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.SubCommandArgumentParser;
import org.opends.server.util.cli.CommandBuilder;
import org.opends.server.util.cli.ConsoleApplication;
import org.opends.server.util.cli.LDAPConnectionConsoleInteraction;

public final class LDAPManagementContextFactory
implements ManagementContextFactory {
    private SecureConnectionCliArgs secureArgsList = null;
    private ManagementContext context = null;
    private CommandBuilder contextCommandBuilder;
    private boolean alwaysSSL = false;

    public LDAPManagementContextFactory(boolean alwaysSSL) {
        this.alwaysSSL = alwaysSSL;
    }

    public ManagementContext getManagementContext(ConsoleApplication app) throws ArgumentException, ClientException {
        if (this.context == null) {
            LDAPConnectionConsoleInteraction ci = new LDAPConnectionConsoleInteraction(app, this.secureArgsList);
            ci.run();
            this.context = this.getManagementContext(app, ci);
            this.contextCommandBuilder = ci.getCommandBuilder();
        }
        return this.context;
    }

    public void close() {
        if (this.context != null) {
            this.context.close();
        }
    }

    public CommandBuilder getContextCommandBuilder() {
        return this.contextCommandBuilder;
    }

    public ManagementContext getManagementContext(ConsoleApplication app, LDAPConnectionConsoleInteraction ci) throws ArgumentException, ClientException {
        if (this.context == null) {
            JNDIDirContextAdaptor conn;
            block24: {
                String hostName = ConnectionUtils.getHostNameForLdapUrl(ci.getHostName());
                Integer portNumber = ci.getPortNumber();
                String bindDN = ci.getBindDN();
                String bindPassword = ci.getBindPassword();
                ApplicationTrustManager trustManager = ci.getTrustManager();
                KeyManager keyManager = ci.getKeyManager();
                if (ci.useSSL()) {
                    String ldapsUrl = "ldaps://" + hostName + ":" + portNumber;
                    while (true) {
                        try {
                            InitialLdapContext ctx = ConnectionUtils.createLdapsContext(ldapsUrl, bindDN, bindPassword, ConnectionUtils.getDefaultLDAPTimeout(), null, trustManager, keyManager);
                            ctx.reconnect(null);
                            conn = JNDIDirContextAdaptor.adapt(ctx);
                            break block24;
                        }
                        catch (NamingException e) {
                            Message message;
                            if (app.isInteractive() && ci.isTrustStoreInMemory() && e.getRootCause() != null && e.getRootCause().getCause() instanceof OpendsCertificateException) {
                                OpendsCertificateException oce = (OpendsCertificateException)e.getRootCause().getCause();
                                String authType = null;
                                if (trustManager instanceof ApplicationTrustManager) {
                                    ApplicationTrustManager appTrustManager = trustManager;
                                    authType = appTrustManager.getLastRefusedAuthType();
                                }
                                if (ci.checkServerCertificate(oce.getChain(), authType, hostName)) {
                                    trustManager = ci.getTrustManager();
                                    continue;
                                }
                            }
                            if (e.getRootCause() != null) {
                                if (e.getRootCause().getCause() != null && (e.getRootCause().getCause() instanceof OpendsCertificateException || e.getRootCause() instanceof SSLHandshakeException)) {
                                    message = DSConfigMessages.ERR_DSCFG_ERROR_LDAP_FAILED_TO_CONNECT_NOT_TRUSTED.get(hostName, String.valueOf(portNumber));
                                    throw new ClientException(91, message);
                                }
                                if (e.getRootCause() instanceof SSLException) {
                                    message = DSConfigMessages.ERR_DSCFG_ERROR_LDAP_FAILED_TO_CONNECT_WRONG_PORT.get(hostName, String.valueOf(portNumber));
                                    throw new ClientException(91, message);
                                }
                            }
                            message = DSConfigMessages.ERR_DSCFG_ERROR_LDAP_FAILED_TO_CONNECT.get(hostName, String.valueOf(portNumber));
                            throw new ClientException(91, message);
                        }
                        break;
                    }
                }
                if (ci.useStartTLS()) {
                    String ldapUrl = "ldap://" + hostName + ":" + portNumber;
                    while (true) {
                        try {
                            InitialLdapContext ctx = ConnectionUtils.createStartTLSContext(ldapUrl, bindDN, bindPassword, ConnectionUtils.getDefaultLDAPTimeout(), null, trustManager, keyManager, null);
                            ctx.reconnect(null);
                            conn = JNDIDirContextAdaptor.adapt(ctx);
                            break block24;
                        }
                        catch (NamingException e) {
                            Message message;
                            if (app.isInteractive() && ci.isTrustStoreInMemory()) {
                                if (e.getRootCause() != null && e.getRootCause().getCause() instanceof OpendsCertificateException) {
                                    OpendsCertificateException oce;
                                    String authType = null;
                                    if (trustManager instanceof ApplicationTrustManager) {
                                        ApplicationTrustManager appTrustManager = trustManager;
                                        authType = appTrustManager.getLastRefusedAuthType();
                                    }
                                    if (ci.checkServerCertificate((oce = (OpendsCertificateException)e.getRootCause().getCause()).getChain(), authType, hostName)) {
                                        trustManager = ci.getTrustManager();
                                        continue;
                                    }
                                } else {
                                    message = DSConfigMessages.ERR_DSCFG_ERROR_LDAP_FAILED_TO_CONNECT.get(hostName, String.valueOf(portNumber));
                                    throw new ClientException(91, message);
                                }
                            }
                            message = DSConfigMessages.ERR_DSCFG_ERROR_LDAP_FAILED_TO_CONNECT.get(hostName, String.valueOf(portNumber));
                            throw new ClientException(91, message);
                        }
                        break;
                    }
                }
                try {
                    conn = JNDIDirContextAdaptor.simpleBind(hostName, portNumber, bindDN, bindPassword);
                }
                catch (AuthenticationNotSupportedException e) {
                    Message message = DSConfigMessages.ERR_DSCFG_ERROR_LDAP_SIMPLE_BIND_NOT_SUPPORTED.get();
                    throw new ClientException(7, message);
                }
                catch (AuthenticationException e) {
                    Message message = DSConfigMessages.ERR_DSCFG_ERROR_LDAP_SIMPLE_BIND_FAILED.get(bindDN);
                    throw new ClientException(49, message);
                }
                catch (CommunicationException e) {
                    Message message = DSConfigMessages.ERR_DSCFG_ERROR_LDAP_FAILED_TO_CONNECT.get(hostName, String.valueOf(portNumber));
                    throw new ClientException(91, message);
                }
            }
            this.context = LDAPManagementContext.createFromContext(conn);
        }
        return this.context;
    }

    public void registerGlobalArguments(SubCommandArgumentParser parser) throws ArgumentException {
        this.secureArgsList = new SecureConnectionCliArgs(this.alwaysSSL);
        LinkedHashSet<Argument> args = this.secureArgsList.createGlobalArguments();
        for (Argument arg : args) {
            parser.addGlobalArgument(arg);
        }
    }

    public void validateGlobalArguments() throws ArgumentException {
        MessageBuilder buf = new MessageBuilder();
        int v = this.secureArgsList.validateGlobalOptions(buf);
        if (v != DsFrameworkCliReturnCode.SUCCESSFUL_NOP.getReturnCode()) {
            throw new ArgumentException(buf.toMessage());
        }
    }
}

