/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsreplication;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ToolMessages;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.util.Utils;
import org.opends.server.admin.client.cli.SecureConnectionCliArgs;
import org.opends.server.admin.client.cli.SecureConnectionCliParser;
import org.opends.server.tools.ToolConstants;
import org.opends.server.tools.dsreplication.ReplicationCliReturnCode;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationCliArgumentParser
extends SecureConnectionCliParser {
    private SubCommand enableReplicationSubCmd;
    private SubCommand disableReplicationSubCmd;
    private SubCommand initializeReplicationSubCmd;
    private SubCommand initializeAllReplicationSubCmd;
    private SubCommand postExternalInitializationSubCmd;
    private SubCommand preExternalInitializationSubCmd;
    private SubCommand statusReplicationSubCmd;
    private BooleanArgument noPromptArg;
    private String defaultLocalHostValue;
    private StringArgument hostName1Arg = null;
    private IntegerArgument port1Arg = null;
    private StringArgument bindDn1Arg = null;
    private FileBasedArgument bindPasswordFile1Arg = null;
    private StringArgument bindPassword1Arg = null;
    private IntegerArgument replicationPort1Arg = null;
    private BooleanArgument secureReplication1Arg = null;
    private StringArgument hostName2Arg = null;
    private IntegerArgument port2Arg = null;
    private StringArgument bindDn2Arg = null;
    private FileBasedArgument bindPasswordFile2Arg = null;
    private StringArgument bindPassword2Arg = null;
    private IntegerArgument replicationPort2Arg = null;
    private BooleanArgument secureReplication2Arg = null;
    private BooleanArgument skipPortCheckArg;
    private BooleanArgument noSchemaReplicationArg;
    private BooleanArgument useSecondServerAsSchemaSourceArg;
    private StringArgument hostNameSourceArg = null;
    private IntegerArgument portSourceArg = null;
    private StringArgument hostNameDestinationArg = null;
    private IntegerArgument portDestinationArg = null;
    private StringArgument baseDNsArg = null;
    private BooleanArgument externalInitializationLocalOnlyArg;
    private BooleanArgument quietArg;
    private BooleanArgument scriptFriendlyArg;
    public static final String ENABLE_REPLICATION_SUBCMD_NAME = "enable";
    public static final String DISABLE_REPLICATION_SUBCMD_NAME = "disable";
    public static final String INITIALIZE_REPLICATION_SUBCMD_NAME = "initialize";
    public static final String INITIALIZE_ALL_REPLICATION_SUBCMD_NAME = "initialize-all";
    public static final String PRE_EXTERNAL_INITIALIZATION_SUBCMD_NAME = "pre-external-initialization";
    public static final String POST_EXTERNAL_INITIALIZATION_SUBCMD_NAME = "post-external-initialization";
    public static final String STATUS_REPLICATION_SUBCMD_NAME = "status";
    private final boolean alwaysSSL = true;

    public ReplicationCliArgumentParser(String mainClassName) {
        super(mainClassName, AdminToolMessages.INFO_REPLICATION_TOOL_DESCRIPTION.get(ENABLE_REPLICATION_SUBCMD_NAME, INITIALIZE_REPLICATION_SUBCMD_NAME), false);
    }

    public void initializeParser(OutputStream outStream) throws ArgumentException {
        this.initializeGlobalArguments(outStream);
        this.createEnableReplicationSubCommand();
        this.createDisableReplicationSubCommand();
        this.createInitializeReplicationSubCommand();
        this.createInitializeAllReplicationSubCommand();
        this.createPreExternalInitializationSubCommand();
        this.createPostExternalInitializationSubCommand();
        this.createStatusReplicationSubCommand();
    }

    public void validateOptions(MessageBuilder buf) {
        this.validateGlobalOptions(buf);
        this.validateSubcommandOptions(buf);
    }

    @Override
    public int validateGlobalOptions(MessageBuilder buf) {
        super.validateGlobalOptions(buf);
        ArrayList<Message> errors = new ArrayList<Message>();
        if (this.secureArgsList.bindPasswordArg.isPresent() && this.secureArgsList.bindPasswordFileArg.isPresent()) {
            Message message = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(this.secureArgsList.bindPasswordArg.getLongIdentifier(), this.secureArgsList.bindPasswordFileArg.getLongIdentifier());
            errors.add(message);
        }
        if (!this.isInteractive()) {
            if (!this.baseDNsArg.isPresent() && !this.isStatusReplicationSubcommand()) {
                errors.add(AdminToolMessages.ERR_REPLICATION_NO_BASE_DN_PROVIDED.get());
            }
            if (this.getBindPasswordAdmin() == null) {
                errors.add(AdminToolMessages.ERR_REPLICATION_NO_ADMINISTRATOR_PASSWORD_PROVIDED.get("--" + this.secureArgsList.bindPasswordArg.getLongIdentifier(), "--" + this.secureArgsList.bindPasswordFileArg.getLongIdentifier()));
            }
        }
        if (this.baseDNsArg.isPresent()) {
            LinkedList<String> baseDNs = this.baseDNsArg.getValues();
            for (String dn : baseDNs) {
                if (Utils.isDn(dn)) continue;
                errors.add(AdminToolMessages.ERR_REPLICATION_NOT_A_VALID_BASEDN.get(dn));
            }
        }
        if (errors.size() > 0) {
            for (Message error : errors) {
                this.addMessage(buf, error);
            }
        }
        int returnValue = buf.length() > 0 ? ReplicationCliReturnCode.CONFLICTING_ARGS.getReturnCode() : ReplicationCliReturnCode.SUCCESSFUL_NOP.getReturnCode();
        return returnValue;
    }

    private void initializeGlobalArguments(OutputStream outStream) throws ArgumentException {
        ArrayList<Argument> defaultArgs = new ArrayList<Argument>(this.createGlobalArguments(outStream, true));
        Argument[] argsToRemove = new Argument[]{this.secureArgsList.hostNameArg, this.secureArgsList.portArg, this.secureArgsList.bindDnArg, this.secureArgsList.bindPasswordFileArg, this.secureArgsList.bindPasswordArg};
        for (int i = 0; i < argsToRemove.length; ++i) {
            defaultArgs.remove(argsToRemove[i]);
        }
        defaultArgs.remove(this.noPropertiesFileArg);
        defaultArgs.remove(this.propertiesFileArg);
        defaultArgs.remove(this.secureArgsList.adminUidArg);
        int index = 0;
        this.baseDNsArg = new StringArgument("baseDNs", Character.valueOf('b'), "baseDN", false, true, true, ToolMessages.INFO_BASEDN_PLACEHOLDER.get(), null, null, AdminToolMessages.INFO_DESCRIPTION_REPLICATION_BASEDNS.get());
        this.baseDNsArg.setPropertyName("baseDN");
        defaultArgs.add(index++, this.baseDNsArg);
        this.secureArgsList.adminUidArg = new StringArgument("adminUID", Character.valueOf('I'), "adminUID", false, false, true, ToolMessages.INFO_ADMINUID_PLACEHOLDER.get(), "admin", null, AdminToolMessages.INFO_DESCRIPTION_REPLICATION_ADMIN_UID.get(ENABLE_REPLICATION_SUBCMD_NAME));
        this.secureArgsList.adminUidArg.setPropertyName("adminUID");
        this.secureArgsList.adminUidArg.setHidden(false);
        defaultArgs.add(index++, this.secureArgsList.adminUidArg);
        this.secureArgsList.bindPasswordArg = new StringArgument("adminPassword", Character.valueOf('w'), "adminPassword", false, false, true, ToolMessages.INFO_BINDPWD_PLACEHOLDER.get(), null, null, AdminToolMessages.INFO_DESCRIPTION_REPLICATION_ADMIN_BINDPASSWORD.get());
        defaultArgs.add(index++, this.secureArgsList.bindPasswordArg);
        this.secureArgsList.bindPasswordFileArg = new FileBasedArgument("adminPasswordFile", Character.valueOf('j'), "adminPasswordFile", false, false, ToolMessages.INFO_BINDPWD_FILE_PLACEHOLDER.get(), null, null, AdminToolMessages.INFO_DESCRIPTION_REPLICATION_ADMIN_BINDPASSWORDFILE.get());
        defaultArgs.add(index++, this.secureArgsList.bindPasswordFileArg);
        defaultArgs.remove(this.verboseArg);
        this.noPromptArg = new BooleanArgument("no-prompt", ToolConstants.OPTION_SHORT_NO_PROMPT, "no-prompt", ToolMessages.INFO_DESCRIPTION_NO_PROMPT.get());
        defaultArgs.add(index++, this.noPromptArg);
        for (int i = 0; i < index; ++i) {
            Argument arg = defaultArgs.get(i);
            arg.setPropertyName(arg.getLongIdentifier());
        }
        this.quietArg = new BooleanArgument("quiet", ToolConstants.OPTION_SHORT_QUIET, "quiet", AdminToolMessages.INFO_REPLICATION_DESCRIPTION_QUIET.get());
        this.quietArg.setPropertyName("quiet");
        defaultArgs.add(this.quietArg);
        StringArgument propertiesFileArgument = new StringArgument("propertiesFilePath", null, "propertiesFilePath", false, false, true, ToolMessages.INFO_PROP_FILE_PATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_PROP_FILE_PATH.get());
        defaultArgs.add(propertiesFileArgument);
        this.setFilePropertiesArgument(propertiesFileArgument);
        BooleanArgument noPropertiesFileArgument = new BooleanArgument("noPropertiesFileArgument", null, "noPropertiesFile", ToolMessages.INFO_DESCRIPTION_NO_PROP_FILE.get());
        defaultArgs.add(noPropertiesFileArgument);
        this.setNoPropertiesFileArgument(noPropertiesFileArgument);
        this.initializeGlobalArguments(defaultArgs);
    }

    private void createEnableReplicationSubCommand() throws ArgumentException {
        this.hostName1Arg = new StringArgument("host1", Character.valueOf('h'), "host1", false, false, true, ToolMessages.INFO_HOST_PLACEHOLDER.get(), this.getDefaultHostValue(), null, AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_HOST1.get());
        this.port1Arg = new IntegerArgument("port1", Character.valueOf('p'), "port1", false, false, true, ToolMessages.INFO_PORT_PLACEHOLDER.get(), 389, null, AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_SERVER_PORT1.get());
        this.bindDn1Arg = new StringArgument("bindDN1", Character.valueOf('D'), "bindDN1", false, false, true, ToolMessages.INFO_BINDDN_PLACEHOLDER.get(), "cn=Directory Manager", null, AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_BINDDN1.get());
        this.bindPassword1Arg = new StringArgument("bindPassword1", null, "bindPassword1", false, false, true, ToolMessages.INFO_BINDPWD_PLACEHOLDER.get(), null, null, AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_BINDPASSWORD1.get());
        this.bindPasswordFile1Arg = new FileBasedArgument("bindPasswordFile1", null, "bindPasswordFile1", false, false, ToolMessages.INFO_BINDPWD_FILE_PLACEHOLDER.get(), null, null, AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_BINDPASSWORDFILE1.get());
        this.replicationPort1Arg = new IntegerArgument("replicationPort1", Character.valueOf('r'), "replicationPort1", false, false, true, ToolMessages.INFO_PORT_PLACEHOLDER.get(), 8989, null, AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_PORT1.get());
        this.secureReplication1Arg = new BooleanArgument("secureReplication1", null, "secureReplication1", AdminToolMessages.INFO_DESCRIPTION_ENABLE_SECURE_REPLICATION1.get());
        this.hostName2Arg = new StringArgument("host2", Character.valueOf('O'), "host2", false, false, true, ToolMessages.INFO_HOST_PLACEHOLDER.get(), this.getDefaultHostValue(), null, AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_HOST2.get());
        this.port2Arg = new IntegerArgument("port2", null, "port2", false, false, true, ToolMessages.INFO_PORT_PLACEHOLDER.get(), 389, null, AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_SERVER_PORT2.get());
        this.bindDn2Arg = new StringArgument("bindDN2", null, "bindDN2", false, false, true, ToolMessages.INFO_BINDDN_PLACEHOLDER.get(), "cn=Directory Manager", null, AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_BINDDN2.get());
        this.bindPassword2Arg = new StringArgument("bindPassword2", null, "bindPassword2", false, false, true, ToolMessages.INFO_BINDPWD_PLACEHOLDER.get(), null, null, AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_BINDPASSWORD2.get());
        this.bindPasswordFile2Arg = new FileBasedArgument("bindPasswordFile2", Character.valueOf('F'), "bindPasswordFile2", false, false, ToolMessages.INFO_BINDPWD_FILE_PLACEHOLDER.get(), null, null, AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_BINDPASSWORDFILE2.get());
        this.replicationPort2Arg = new IntegerArgument("replicationPort2", Character.valueOf('R'), "replicationPort2", false, false, true, ToolMessages.INFO_PORT_PLACEHOLDER.get(), 8989, null, AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_PORT2.get());
        this.secureReplication2Arg = new BooleanArgument("secureReplication2", null, "secureReplication2", AdminToolMessages.INFO_DESCRIPTION_ENABLE_SECURE_REPLICATION2.get());
        this.skipPortCheckArg = new BooleanArgument("skipportcheck", Character.valueOf('S'), "skipPortCheck", AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_SKIPPORT.get());
        this.noSchemaReplicationArg = new BooleanArgument("noschemareplication", null, "noSchemaReplication", AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_NO_SCHEMA_REPLICATION.get());
        this.useSecondServerAsSchemaSourceArg = new BooleanArgument("usesecondserverasschemasource", null, "useSecondServerAsSchemaSource", AdminToolMessages.INFO_DESCRIPTION_ENABLE_REPLICATION_USE_SECOND_AS_SCHEMA_SOURCE.get("--" + this.noSchemaReplicationArg.getLongIdentifier()));
        this.enableReplicationSubCmd = new SubCommand(this, ENABLE_REPLICATION_SUBCMD_NAME, AdminToolMessages.INFO_DESCRIPTION_SUBCMD_ENABLE_REPLICATION.get());
        Argument[] argsToAdd = new Argument[]{this.hostName1Arg, this.port1Arg, this.bindDn1Arg, this.bindPassword1Arg, this.bindPasswordFile1Arg, this.replicationPort1Arg, this.secureReplication1Arg, this.hostName2Arg, this.port2Arg, this.bindDn2Arg, this.bindPassword2Arg, this.bindPasswordFile2Arg, this.replicationPort2Arg, this.secureReplication2Arg, this.skipPortCheckArg, this.noSchemaReplicationArg, this.useSecondServerAsSchemaSourceArg};
        for (int i = 0; i < argsToAdd.length; ++i) {
            argsToAdd[i].setPropertyName(argsToAdd[i].getLongIdentifier());
            this.enableReplicationSubCmd.addArgument(argsToAdd[i]);
        }
    }

    private void createDisableReplicationSubCommand() throws ArgumentException {
        this.disableReplicationSubCmd = new SubCommand(this, DISABLE_REPLICATION_SUBCMD_NAME, AdminToolMessages.INFO_DESCRIPTION_SUBCMD_DISABLE_REPLICATION.get());
        this.secureArgsList.hostNameArg.setDefaultValue(this.getDefaultHostValue());
        this.secureArgsList.bindDnArg = new StringArgument("bindDN", Character.valueOf('D'), "bindDN", false, false, true, ToolMessages.INFO_BINDDN_PLACEHOLDER.get(), "cn=Directory Manager", "bindDN", AdminToolMessages.INFO_DESCRIPTION_DISABLE_REPLICATION_BINDDN.get());
        Argument[] argsToAdd = new Argument[]{this.secureArgsList.hostNameArg, this.secureArgsList.portArg, this.secureArgsList.bindDnArg};
        for (int i = 0; i < argsToAdd.length; ++i) {
            this.disableReplicationSubCmd.addArgument(argsToAdd[i]);
        }
    }

    private void createInitializeReplicationSubCommand() throws ArgumentException {
        this.hostNameSourceArg = new StringArgument("hostSource", Character.valueOf('h'), "hostSource", false, false, true, ToolMessages.INFO_HOST_PLACEHOLDER.get(), this.getDefaultHostValue(), null, AdminToolMessages.INFO_DESCRIPTION_INITIALIZE_REPLICATION_HOST_SOURCE.get());
        this.portSourceArg = new IntegerArgument("portSource", Character.valueOf('p'), "portSource", false, false, true, ToolMessages.INFO_PORT_PLACEHOLDER.get(), 389, null, AdminToolMessages.INFO_DESCRIPTION_INITIALIZE_REPLICATION_SERVER_PORT_SOURCE.get());
        this.hostNameDestinationArg = new StringArgument("hostDestination", Character.valueOf('O'), "hostDestination", false, false, true, ToolMessages.INFO_HOST_PLACEHOLDER.get(), this.getDefaultHostValue(), null, AdminToolMessages.INFO_DESCRIPTION_INITIALIZE_REPLICATION_HOST_DESTINATION.get());
        this.portDestinationArg = new IntegerArgument("portDestination", null, "portDestination", false, false, true, ToolMessages.INFO_PORT_PLACEHOLDER.get(), 389, null, AdminToolMessages.INFO_DESCRIPTION_INITIALIZE_REPLICATION_SERVER_PORT_DESTINATION.get());
        this.initializeReplicationSubCmd = new SubCommand(this, INITIALIZE_REPLICATION_SUBCMD_NAME, AdminToolMessages.INFO_DESCRIPTION_SUBCMD_INITIALIZE_REPLICATION.get(INITIALIZE_ALL_REPLICATION_SUBCMD_NAME));
        Argument[] argsToAdd = new Argument[]{this.hostNameSourceArg, this.portSourceArg, this.hostNameDestinationArg, this.portDestinationArg};
        for (int i = 0; i < argsToAdd.length; ++i) {
            argsToAdd[i].setPropertyName(argsToAdd[i].getLongIdentifier());
            this.initializeReplicationSubCmd.addArgument(argsToAdd[i]);
        }
    }

    private void createInitializeAllReplicationSubCommand() throws ArgumentException {
        this.initializeAllReplicationSubCmd = new SubCommand(this, INITIALIZE_ALL_REPLICATION_SUBCMD_NAME, AdminToolMessages.INFO_DESCRIPTION_SUBCMD_INITIALIZE_ALL_REPLICATION.get(INITIALIZE_REPLICATION_SUBCMD_NAME));
        this.secureArgsList.hostNameArg.setDefaultValue(this.getDefaultHostValue());
        Argument[] argsToAdd = new Argument[]{this.secureArgsList.hostNameArg, this.secureArgsList.portArg};
        for (int i = 0; i < argsToAdd.length; ++i) {
            this.initializeAllReplicationSubCmd.addArgument(argsToAdd[i]);
        }
    }

    private void createPreExternalInitializationSubCommand() throws ArgumentException {
        this.preExternalInitializationSubCmd = new SubCommand(this, PRE_EXTERNAL_INITIALIZATION_SUBCMD_NAME, AdminToolMessages.INFO_DESCRIPTION_SUBCMD_PRE_EXTERNAL_INITIALIZATION.get(POST_EXTERNAL_INITIALIZATION_SUBCMD_NAME));
        this.secureArgsList.hostNameArg.setDefaultValue(this.getDefaultHostValue());
        this.externalInitializationLocalOnlyArg = new BooleanArgument("local-only", Character.valueOf('l'), "local-only", AdminToolMessages.INFO_DESCRIPTION_EXTERNAL_INITIALIZATION_LOCAL.get());
        this.externalInitializationLocalOnlyArg.setPropertyName(this.externalInitializationLocalOnlyArg.getLongIdentifier());
        Argument[] argsToAdd = new Argument[]{this.secureArgsList.hostNameArg, this.secureArgsList.portArg, this.externalInitializationLocalOnlyArg};
        for (int i = 0; i < argsToAdd.length; ++i) {
            this.preExternalInitializationSubCmd.addArgument(argsToAdd[i]);
        }
    }

    private void createPostExternalInitializationSubCommand() throws ArgumentException {
        this.postExternalInitializationSubCmd = new SubCommand(this, POST_EXTERNAL_INITIALIZATION_SUBCMD_NAME, AdminToolMessages.INFO_DESCRIPTION_SUBCMD_POST_EXTERNAL_INITIALIZATION.get(PRE_EXTERNAL_INITIALIZATION_SUBCMD_NAME));
        this.secureArgsList.hostNameArg.setDefaultValue(this.getDefaultHostValue());
        this.externalInitializationLocalOnlyArg.setPropertyName(this.externalInitializationLocalOnlyArg.getLongIdentifier());
        Argument[] argsToAdd = new Argument[]{this.secureArgsList.hostNameArg, this.secureArgsList.portArg};
        for (int i = 0; i < argsToAdd.length; ++i) {
            this.postExternalInitializationSubCmd.addArgument(argsToAdd[i]);
        }
    }

    private void createStatusReplicationSubCommand() throws ArgumentException {
        this.statusReplicationSubCmd = new SubCommand(this, STATUS_REPLICATION_SUBCMD_NAME, AdminToolMessages.INFO_DESCRIPTION_SUBCMD_STATUS_REPLICATION.get());
        this.scriptFriendlyArg = new BooleanArgument("script-friendly", Character.valueOf('s'), "script-friendly", ToolMessages.INFO_DESCRIPTION_SCRIPT_FRIENDLY.get());
        this.scriptFriendlyArg.setPropertyName(this.scriptFriendlyArg.getLongIdentifier());
        this.secureArgsList.hostNameArg.setDefaultValue(this.getDefaultHostValue());
        Argument[] argsToAdd = new Argument[]{this.secureArgsList.hostNameArg, this.secureArgsList.portArg, this.scriptFriendlyArg};
        for (int i = 0; i < argsToAdd.length; ++i) {
            this.statusReplicationSubCmd.addArgument(argsToAdd[i]);
        }
    }

    public boolean isInteractive() {
        return !this.noPromptArg.isPresent();
    }

    public boolean isQuiet() {
        return this.quietArg.isPresent();
    }

    public boolean isScriptFriendly() {
        return this.scriptFriendlyArg.isPresent();
    }

    public String getBindPassword1() {
        return this.getBindPassword(this.bindPassword1Arg, this.bindPasswordFile1Arg);
    }

    public String getBindPassword2() {
        return this.getBindPassword(this.bindPassword2Arg, this.bindPasswordFile2Arg);
    }

    public String getBindPasswordAdmin() {
        return this.getBindPassword(this.secureArgsList.bindPasswordArg, this.secureArgsList.bindPasswordFileArg);
    }

    public String getBindPassword1(String dn, OutputStream out, OutputStream err) {
        return this.getBindPassword(dn, out, err, this.bindPassword1Arg, this.bindPasswordFile1Arg);
    }

    public String getBindPassword2(String dn, OutputStream out, OutputStream err) {
        return this.getBindPassword(dn, out, err, this.bindPassword2Arg, this.bindPasswordFile2Arg);
    }

    public String getBindPasswordAdmin(String dn, OutputStream out, OutputStream err) {
        return this.getBindPassword(dn, out, err, this.secureArgsList.bindPasswordArg, this.secureArgsList.bindPasswordFileArg);
    }

    @Override
    public String getAdministratorUID() {
        return this.getValue(this.secureArgsList.adminUidArg);
    }

    public String getDefaultAdministratorUID() {
        return this.getDefaultValue(this.secureArgsList.adminUidArg);
    }

    public String getHostName1() {
        return this.getValue(this.hostName1Arg);
    }

    public String getDefaultHostName1() {
        return this.getDefaultValue(this.hostName1Arg);
    }

    public int getPort1() {
        return this.getValue(this.port1Arg);
    }

    public int getDefaultPort1() {
        return this.getDefaultValue(this.port1Arg);
    }

    public String getBindDn1() {
        return this.getValue(this.bindDn1Arg);
    }

    public String getDefaultBindDn1() {
        return this.getDefaultValue(this.bindDn1Arg);
    }

    public int getReplicationPort1() {
        return this.getValue(this.replicationPort1Arg);
    }

    public int getDefaultReplicationPort1() {
        return this.getDefaultValue(this.replicationPort1Arg);
    }

    public boolean isSecureReplication1() {
        return this.secureReplication1Arg.isPresent();
    }

    public String getHostName2() {
        return this.getValue(this.hostName2Arg);
    }

    public String getDefaultHostName2() {
        return this.getDefaultValue(this.hostName2Arg);
    }

    public int getPort2() {
        return this.getValue(this.port2Arg);
    }

    public int getDefaultPort2() {
        return this.getDefaultValue(this.port2Arg);
    }

    public String getBindDn2() {
        return this.getValue(this.bindDn2Arg);
    }

    public String getDefaultBindDn2() {
        return this.getDefaultValue(this.bindDn2Arg);
    }

    public int getReplicationPort2() {
        return this.getValue(this.replicationPort2Arg);
    }

    public int getDefaultReplicationPort2() {
        return this.getDefaultValue(this.replicationPort2Arg);
    }

    public boolean isSecureReplication2() {
        return this.secureReplication2Arg.isPresent();
    }

    public boolean skipReplicationPortCheck() {
        return this.skipPortCheckArg.isPresent();
    }

    public boolean noSchemaReplication() {
        return this.noSchemaReplicationArg.isPresent();
    }

    public boolean useSecondServerAsSchemaSource() {
        return this.useSecondServerAsSchemaSourceArg.isPresent();
    }

    public String getHostNameToDisable() {
        return this.getValue(this.secureArgsList.hostNameArg);
    }

    public String getDefaultHostNameToDisable() {
        return this.getDefaultValue(this.secureArgsList.hostNameArg);
    }

    public String getBindDNToDisable() {
        return this.getValue(this.secureArgsList.bindDnArg);
    }

    public String getDefaultBindDnToDisable() {
        return this.getDefaultValue(this.secureArgsList.bindDnArg);
    }

    public String getHostNameToStatus() {
        return this.getValue(this.secureArgsList.hostNameArg);
    }

    public String getDefaultHostNameToStatus() {
        return this.getDefaultValue(this.secureArgsList.hostNameArg);
    }

    public String getHostNameToInitializeAll() {
        return this.getValue(this.secureArgsList.hostNameArg);
    }

    public String getDefaultHostNameToInitializeAll() {
        return this.getDefaultValue(this.secureArgsList.hostNameArg);
    }

    public String getHostNameToPreExternalInitialization() {
        return this.getValue(this.secureArgsList.hostNameArg);
    }

    public String getDefaultHostNameToPreExternalInitialization() {
        return this.getDefaultValue(this.secureArgsList.hostNameArg);
    }

    public String getHostNameToPostExternalInitialization() {
        return this.getValue(this.secureArgsList.hostNameArg);
    }

    public String getDefaultHostNameToPostExternalInitialization() {
        return this.getDefaultValue(this.secureArgsList.hostNameArg);
    }

    public String getHostNameSource() {
        return this.getValue(this.hostNameSourceArg);
    }

    public String getDefaultHostNameSource() {
        return this.getDefaultValue(this.hostNameSourceArg);
    }

    public String getHostNameDestination() {
        return this.getValue(this.hostNameDestinationArg);
    }

    public String getDefaultHostNameDestination() {
        return this.getDefaultValue(this.hostNameDestinationArg);
    }

    public int getPortSource() {
        return this.getValue(this.portSourceArg);
    }

    public int getDefaultPortSource() {
        return this.getDefaultValue(this.portSourceArg);
    }

    public int getPortDestination() {
        return this.getValue(this.portDestinationArg);
    }

    public int getDefaultPortDestination() {
        return this.getDefaultValue(this.portDestinationArg);
    }

    public int getPortToDisable() {
        return this.getValue(this.secureArgsList.portArg);
    }

    public int getDefaultPortToDisable() {
        return this.getDefaultValue(this.secureArgsList.portArg);
    }

    public int getPortToInitializeAll() {
        return this.getValue(this.secureArgsList.portArg);
    }

    public int getDefaultPortToInitializeAll() {
        return this.getDefaultValue(this.secureArgsList.portArg);
    }

    public int getPortToPreExternalInitialization() {
        return this.getValue(this.secureArgsList.portArg);
    }

    public int getDefaultPortToPreExternalInitialization() {
        return this.getDefaultValue(this.secureArgsList.portArg);
    }

    public int getPortToPostExternalInitialization() {
        return this.getValue(this.secureArgsList.portArg);
    }

    public int getDefaultPortToPostExternalInitialization() {
        return this.getDefaultValue(this.secureArgsList.portArg);
    }

    public int getPortToStatus() {
        return this.getValue(this.secureArgsList.portArg);
    }

    public int getDefaultPortToStatus() {
        return this.getDefaultValue(this.secureArgsList.portArg);
    }

    public LinkedList<String> getBaseDNs() {
        return this.baseDNsArg.getValues();
    }

    private String getValue(StringArgument arg) {
        String v = null;
        if (arg.isPresent()) {
            v = arg.getValue();
        }
        return v;
    }

    private String getDefaultValue(StringArgument arg) {
        return arg.getDefaultValue();
    }

    private int getValue(IntegerArgument arg) {
        int v = -1;
        if (arg.isPresent()) {
            try {
                v = arg.getIntValue();
            }
            catch (ArgumentException ae) {
                throw new IllegalStateException("There was an argument exception calling ReplicationCliParser.getValue().  This appears to be a bug because this method should be called after calling parseArguments which should result in an error.", ae);
            }
        }
        return v;
    }

    private int getDefaultValue(IntegerArgument arg) {
        int returnValue = -1;
        String defaultValue = arg.getDefaultValue();
        if (defaultValue != null) {
            returnValue = Integer.parseInt(arg.getDefaultValue());
        }
        return returnValue;
    }

    public void validateSubcommandOptions(MessageBuilder buf) {
        if (this.isEnableReplicationSubcommand()) {
            this.validateEnableReplicationOptions(buf);
        } else if (this.isDisableReplicationSubcommand()) {
            this.validateDisableReplicationOptions(buf);
        } else if (this.isStatusReplicationSubcommand()) {
            this.validateStatusReplicationOptions(buf);
        } else if (this.isInitializeReplicationSubcommand()) {
            this.validateInitializeReplicationOptions(buf);
        } else if (this.isInitializeAllReplicationSubcommand()) {
            this.validateInitializeAllReplicationOptions(buf);
        } else if (this.isPreExternalInitializationSubcommand()) {
            this.validatePreExternalInitializationOptions(buf);
        } else if (this.isPostExternalInitializationSubcommand()) {
            this.validatePostExternalInitializationOptions(buf);
        }
    }

    public boolean isEnableReplicationSubcommand() {
        return this.isSubcommand(ENABLE_REPLICATION_SUBCMD_NAME);
    }

    public boolean isDisableReplicationSubcommand() {
        return this.isSubcommand(DISABLE_REPLICATION_SUBCMD_NAME);
    }

    public boolean isStatusReplicationSubcommand() {
        return this.isSubcommand(STATUS_REPLICATION_SUBCMD_NAME);
    }

    public boolean isInitializeAllReplicationSubcommand() {
        return this.isSubcommand(INITIALIZE_ALL_REPLICATION_SUBCMD_NAME);
    }

    public boolean isPreExternalInitializationSubcommand() {
        return this.isSubcommand(PRE_EXTERNAL_INITIALIZATION_SUBCMD_NAME);
    }

    public boolean isPostExternalInitializationSubcommand() {
        return this.isSubcommand(POST_EXTERNAL_INITIALIZATION_SUBCMD_NAME);
    }

    public boolean isInitializeReplicationSubcommand() {
        return this.isSubcommand(INITIALIZE_REPLICATION_SUBCMD_NAME);
    }

    public boolean isExternalInitializationLocalOnly() {
        return this.externalInitializationLocalOnlyArg.isPresent();
    }

    private boolean isSubcommand(String name) {
        boolean isSubcommand = false;
        SubCommand subCommand = this.getSubCommand();
        if (subCommand != null) {
            isSubcommand = subCommand.getName().equalsIgnoreCase(name);
        }
        return isSubcommand;
    }

    private void validateEnableReplicationOptions(MessageBuilder buf) {
        Argument[][] conflictingPairs = new Argument[][]{{this.bindPassword1Arg, this.bindPasswordFile1Arg}, {this.bindPassword2Arg, this.bindPasswordFile2Arg}, {this.noSchemaReplicationArg, this.useSecondServerAsSchemaSourceArg}};
        for (int i = 0; i < conflictingPairs.length; ++i) {
            Argument arg1 = conflictingPairs[i][0];
            Argument arg2 = conflictingPairs[i][1];
            if (!arg1.isPresent() || !arg2.isPresent()) continue;
            Message message = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(arg1.getLongIdentifier(), arg2.getLongIdentifier());
            this.addMessage(buf, message);
        }
        if (this.hostName1Arg.getValue().equalsIgnoreCase(this.hostName2Arg.getValue()) && !this.isInteractive() && this.port1Arg.getValue() == this.port2Arg.getValue()) {
            Message message = AdminToolMessages.ERR_REPLICATION_ENABLE_SAME_SERVER_PORT.get(this.hostName1Arg.getValue(), this.port1Arg.getValue());
            this.addMessage(buf, message);
        }
    }

    private void validateDisableReplicationOptions(MessageBuilder buf) {
        Argument[][] conflictingPairs = new Argument[][]{{this.secureArgsList.adminUidArg, this.secureArgsList.bindDnArg}};
        for (int i = 0; i < conflictingPairs.length; ++i) {
            Argument arg1 = conflictingPairs[i][0];
            Argument arg2 = conflictingPairs[i][1];
            if (!arg1.isPresent() || !arg2.isPresent()) continue;
            Message message = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(arg1.getLongIdentifier(), arg2.getLongIdentifier());
            this.addMessage(buf, message);
        }
    }

    private void validateInitializeAllReplicationOptions(MessageBuilder buf) {
    }

    private void validatePreExternalInitializationOptions(MessageBuilder buf) {
        this.validateInitializeAllReplicationOptions(buf);
    }

    private void validatePostExternalInitializationOptions(MessageBuilder buf) {
        this.validateInitializeAllReplicationOptions(buf);
    }

    private void validateStatusReplicationOptions(MessageBuilder buf) {
        if (this.quietArg.isPresent()) {
            Message message = AdminToolMessages.ERR_REPLICATION_STATUS_QUIET.get(STATUS_REPLICATION_SUBCMD_NAME, "--" + this.quietArg.getLongIdentifier());
            this.addMessage(buf, message);
        }
    }

    private void validateInitializeReplicationOptions(MessageBuilder buf) {
        if (this.hostNameSourceArg.getValue().equalsIgnoreCase(this.hostNameDestinationArg.getValue()) && !this.isInteractive() && this.portSourceArg.getValue() == this.portDestinationArg.getValue()) {
            Message message = AdminToolMessages.ERR_REPLICATION_INITIALIZE_SAME_SERVER_PORT.get(this.hostNameSourceArg.getValue(), this.portSourceArg.getValue());
            this.addMessage(buf, message);
        }
    }

    private void addMessage(MessageBuilder buf, Message message) {
        if (buf.length() > 0) {
            buf.append(EOL);
        }
        buf.append(message);
    }

    private String getDefaultHostValue() {
        if (this.defaultLocalHostValue == null) {
            this.defaultLocalHostValue = UserData.getDefaultHostName();
            if (this.defaultLocalHostValue == null) {
                this.defaultLocalHostValue = "localhost";
            }
        }
        return this.defaultLocalHostValue;
    }

    SecureConnectionCliArgs getSecureArgsList() {
        return this.secureArgsList;
    }
}

