/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.opends.server.api.VirtualAttributeProvider;
import org.opends.server.types.AbstractAttribute;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.Entry;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.types.VirtualAttributeRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public final class VirtualAttribute
extends AbstractAttribute
implements Attribute {
    private final AttributeType attributeType;
    private final Entry entry;
    private final VirtualAttributeProvider<?> provider;
    private final VirtualAttributeRule rule;

    public VirtualAttribute(AttributeType attributeType, Entry entry, VirtualAttributeRule rule) {
        this.attributeType = attributeType;
        this.entry = entry;
        this.rule = rule;
        this.provider = rule.getProvider();
    }

    @Override
    public ConditionResult approximatelyEqualTo(AttributeValue value) {
        return this.provider.approximatelyEqualTo(this.entry, this.rule, value);
    }

    @Override
    public boolean contains(AttributeValue value) {
        return this.provider.hasValue(this.entry, this.rule, value);
    }

    @Override
    public boolean containsAll(Collection<AttributeValue> values) {
        return this.provider.hasAllValues(this.entry, this.rule, values);
    }

    @Override
    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public Entry getEntry() {
        return this.entry;
    }

    @Override
    public String getNameWithOptions() {
        return this.getName();
    }

    @Override
    public Set<String> getOptions() {
        return Collections.emptySet();
    }

    public VirtualAttributeRule getVirtualAttributeRule() {
        return this.rule;
    }

    @Override
    public ConditionResult greaterThanOrEqualTo(AttributeValue value) {
        return this.provider.greaterThanOrEqualTo(this.entry, this.rule, value);
    }

    @Override
    public boolean hasAllOptions(Collection<String> options) {
        return options == null || options.isEmpty();
    }

    @Override
    public boolean hasOption(String option) {
        return false;
    }

    @Override
    public boolean hasOptions() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return !this.provider.hasValue(this.entry, this.rule);
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    public Iterator<AttributeValue> iterator() {
        LinkedHashSet<AttributeValue> values = this.provider.getValues(this.entry, this.rule);
        return Collections.unmodifiableSet(values).iterator();
    }

    @Override
    public ConditionResult lessThanOrEqualTo(AttributeValue value) {
        return this.provider.lessThanOrEqualTo(this.entry, this.rule, value);
    }

    @Override
    public ConditionResult matchesSubstring(ByteString subInitial, List<ByteString> subAny, ByteString subFinal) {
        return this.provider.matchesSubstring(this.entry, this.rule, subInitial, subAny, subFinal);
    }

    @Override
    public boolean optionsEqual(Set<String> options) {
        return options == null || options.isEmpty();
    }

    @Override
    public int size() {
        return this.provider.getValues(this.entry, this.rule).size();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("VirtualAttribute(");
        buffer.append(this.getAttributeType().getNameOrOID());
        buffer.append(", {");
        boolean firstValue = true;
        for (AttributeValue value : this) {
            if (!firstValue) {
                buffer.append(", ");
            }
            value.toString(buffer);
            firstValue = false;
        }
        buffer.append("})");
    }
}

