/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.cli;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.opends.server.util.SetupUtils;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandBuilder {
    private String commandName;
    private String subcommandName;
    private ArrayList<Argument> args = new ArrayList();
    private HashSet<Argument> obfuscatedArgs = new HashSet();
    private static final String OBFUSCATED_VALUE = "******";
    private static final char[] charsToEscape = new char[]{' ', '\t', '\n', '|', ';', '<', '>', '(', ')', '$', '`', '\\', '\"', '\''};

    public CommandBuilder(String commandName) {
        this(commandName, null);
    }

    public CommandBuilder(String commandName, String subcommandName) {
        this.commandName = commandName;
        this.subcommandName = subcommandName;
    }

    public void addArgument(Argument argument) {
        if (!this.args.contains(argument)) {
            this.args.add(argument);
        }
    }

    public void addObfuscatedArgument(Argument argument) {
        this.addArgument(argument);
        this.obfuscatedArgs.add(argument);
    }

    public boolean removeArgument(Argument argument) {
        this.obfuscatedArgs.remove(argument);
        return this.args.remove(argument);
    }

    public void append(CommandBuilder builder) {
        for (Argument arg : builder.args) {
            if (builder.isObfuscated(arg)) {
                this.addObfuscatedArgument(arg);
                continue;
            }
            this.addArgument(arg);
        }
    }

    public String toString() {
        return this.toString(false);
    }

    private String toString(boolean showObfuscated) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.commandName);
        if (this.subcommandName != null) {
            builder.append(" " + this.subcommandName);
        }
        for (Argument arg : this.args) {
            if (arg.getName().equals("useSSL")) continue;
            String argName = arg.getLongIdentifier() != null ? "--" + arg.getLongIdentifier() : "-" + arg.getShortIdentifier();
            String separator = SetupUtils.isWindows() ? " " : " \\\n          ";
            if (arg instanceof BooleanArgument) {
                builder.append(separator + argName);
                continue;
            }
            if (arg instanceof FileBasedArgument) {
                for (String value : ((FileBasedArgument)arg).getNameToValueMap().keySet()) {
                    builder.append(separator + argName + " ");
                    value = this.isObfuscated(arg) && !showObfuscated ? OBFUSCATED_VALUE : CommandBuilder.escapeValue(value);
                    builder.append(value);
                }
                continue;
            }
            for (String value : arg.getValues()) {
                builder.append(separator + argName + " ");
                value = this.isObfuscated(arg) && !showObfuscated ? OBFUSCATED_VALUE : CommandBuilder.escapeValue(value);
                builder.append(value);
            }
        }
        return builder.toString();
    }

    public void clearArguments() {
        this.args.clear();
        this.obfuscatedArgs.clear();
    }

    public List<Argument> getArguments() {
        return this.args;
    }

    private boolean isObfuscated(Argument argument) {
        return this.obfuscatedArgs.contains(argument);
    }

    public static String escapeValue(String value) {
        StringBuilder b = new StringBuilder();
        if (SetupUtils.isUnix()) {
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                boolean charToEscapeFound = false;
                for (int j = 0; j < charsToEscape.length && !charToEscapeFound; ++j) {
                    charToEscapeFound = c == charsToEscape[j];
                }
                if (charToEscapeFound) {
                    b.append('\\');
                }
                b.append(c);
            }
        } else {
            b.append('\"').append(value).append('\"');
        }
        return b.toString();
    }
}

