/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.BuddyLocker;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.WriteLockInfo;

public class ReadCommittedLocker
extends BuddyLocker {
    private ReadCommittedLocker(EnvironmentImpl env, Locker buddy) throws DatabaseException {
        super(env, buddy instanceof ReadCommittedLocker ? ((ReadCommittedLocker)buddy).getBuddy() : buddy);
        assert (this.getBuddy().isTransactional());
    }

    public static ReadCommittedLocker createReadCommittedLocker(EnvironmentImpl env, Locker buddy) throws DatabaseException {
        BasicLocker ret = null;
        try {
            ret = new ReadCommittedLocker(env, buddy);
            ret.initApiReadLock();
        }
        catch (DatabaseException DE) {
            ret.operationEnd(false);
            throw DE;
        }
        return ret;
    }

    public Locker newNonTxnLocker() throws DatabaseException {
        return ReadCommittedLocker.createReadCommittedLocker(this.envImpl, this.getBuddy().newNonTxnLocker());
    }

    LockResult lockInternal(long nodeId, LockType lockType, boolean noWait, DatabaseImpl database) throws DatabaseException {
        if (lockType.isWriteLock()) {
            return this.getBuddy().lockInternal(nodeId, lockType, noWait, database);
        }
        return super.lockInternal(nodeId, lockType, noWait, database);
    }

    public boolean releaseLock(long nodeId) throws DatabaseException {
        boolean ret = true;
        if (!this.lockManager.release(nodeId, this)) {
            ret = this.lockManager.release(nodeId, this.getBuddy());
        }
        this.removeLock(nodeId);
        return ret;
    }

    public boolean createdNode(long nodeId) throws DatabaseException {
        return this.getBuddy().createdNode(nodeId);
    }

    public long getAbortLsn(long nodeId) throws DatabaseException {
        return this.getBuddy().getAbortLsn(nodeId);
    }

    public WriteLockInfo getWriteLockInfo(long nodeId) throws DatabaseException {
        return this.getBuddy().getWriteLockInfo(nodeId);
    }

    public void addDeleteInfo(BIN bin, Key deletedKey) throws DatabaseException {
        this.getBuddy().addDeleteInfo(bin, deletedKey);
    }

    public void registerCursor(CursorImpl cursor) throws DatabaseException {
        this.getBuddy().registerCursor(cursor);
    }

    public void unRegisterCursor(CursorImpl cursor) throws DatabaseException {
        this.getBuddy().unRegisterCursor(cursor);
    }

    public boolean isTransactional() {
        return true;
    }

    public boolean isReadCommittedIsolation() {
        return true;
    }
}

