/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.snmp;

import com.sun.management.snmp.SnmpInt;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.agent.SnmpIndex;
import com.sun.management.snmp.agent.SnmpMib;
import com.sun.management.snmp.agent.SnmpMibSubRequest;
import com.sun.management.snmp.agent.SnmpMibTable;
import com.sun.management.snmp.agent.SnmpTableSupport;
import java.io.Serializable;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.opends.server.snmp.DsApplIfOpsEntry;
import org.opends.server.snmp.DsApplIfOpsEntryMBean;

public class TableDsApplIfOpsTable
extends SnmpTableSupport
implements Serializable {
    protected MBeanServer server;

    public TableDsApplIfOpsTable(SnmpMib myMib) {
        super(myMib);
    }

    public TableDsApplIfOpsTable(SnmpMib myMib, MBeanServer server) {
        this(myMib);
        this.server = server;
    }

    public void createNewEntry(SnmpMibSubRequest req, SnmpOid rowOid, int depth, SnmpMibTable meta) throws SnmpStatusException {
        SnmpIndex index = this.buildSnmpIndex(rowOid);
        Vector v = index.getComponents();
        try {
            SnmpOid oid0 = (SnmpOid)v.elementAt(0);
            SnmpOid oid1 = (SnmpOid)v.elementAt(1);
            ObjectName objname = null;
            if (this.server != null) {
                objname = this.buildNameFromIndex(index);
            }
            Object entry = this.createDsApplIfOpsEntryMBean(req, rowOid, depth, objname, meta, oid0.toInteger(), oid1.toInteger());
            if (this.server != null) {
                this.server.registerMBean(entry, objname);
            }
            meta.addEntry(rowOid, objname, entry);
        }
        catch (SnmpStatusException e) {
            throw e;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpStatusException(10);
        }
        catch (Exception e) {
            throw new SnmpStatusException(e.getMessage());
        }
    }

    protected SnmpMibTable getRegisteredTableMeta(SnmpMib mib) {
        return mib.getRegisteredTableMeta("DsApplIfOpsTable");
    }

    public void removeEntryCb(int pos, SnmpOid row, ObjectName name, Object entry, SnmpMibTable meta) throws SnmpStatusException {
        try {
            super.removeEntryCb(pos, row, name, entry, meta);
            if (this.server != null && name != null) {
                this.server.unregisterMBean(name);
            }
        }
        catch (Exception x) {
            // empty catch block
        }
    }

    public synchronized void addEntry(DsApplIfOpsEntryMBean entry) throws SnmpStatusException {
        SnmpIndex index = this.buildSnmpIndex(entry);
        super.addEntry(index, (Object)entry);
    }

    public synchronized void addEntry(DsApplIfOpsEntryMBean entry, ObjectName name) throws SnmpStatusException {
        SnmpIndex index = this.buildSnmpIndex(entry);
        super.addEntry(index, name, (Object)entry);
    }

    public synchronized DsApplIfOpsEntryMBean[] getEntries() {
        Object[] array = this.getBasicEntries();
        DsApplIfOpsEntryMBean[] result = new DsApplIfOpsEntryMBean[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public void removeEntry(DsApplIfOpsEntryMBean entry) throws SnmpStatusException {
        SnmpIndex index = this.buildSnmpIndex(entry);
        super.removeEntry(index, (Object)entry);
    }

    public ObjectName buildNameFromIndex(SnmpIndex index) throws SnmpStatusException {
        Vector v = index.getComponents();
        try {
            SnmpOid oid = (SnmpOid)v.elementAt(0);
            String _keyApplIndex = oid.toInteger().toString();
            oid = (SnmpOid)v.elementAt(1);
            String _keyDsApplIfProtocolIndex = oid.toInteger().toString();
            return new ObjectName("TableDsApplIfOpsTable:name=org.opends.server.snmp.DsApplIfOpsEntry,ApplIndex=" + _keyApplIndex + ",DsApplIfProtocolIndex=" + _keyDsApplIfProtocolIndex);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpStatusException(10);
        }
        catch (Exception e) {
            throw new SnmpStatusException(e.getMessage());
        }
    }

    public SnmpIndex buildSnmpIndex(DsApplIfOpsEntryMBean entry) throws SnmpStatusException {
        SnmpOid[] oids = new SnmpOid[2];
        SnmpInt val = null;
        val = new SnmpInt(entry.getApplIndex());
        oids[0] = val.toOid();
        val = new SnmpInt(entry.getDsApplIfProtocolIndex());
        oids[1] = val.toOid();
        return new SnmpIndex(oids);
    }

    public SnmpOid buildOidFromIndex(SnmpIndex index) throws SnmpStatusException {
        SnmpOid oid = new SnmpOid();
        if (index.getNbComponents() != 2) {
            throw new SnmpStatusException(224);
        }
        try {
            Vector v = index.getComponents();
            SnmpInt.appendToOid((SnmpOid)((SnmpOid)v.elementAt(0)), (SnmpOid)oid);
            SnmpInt.appendToOid((SnmpOid)((SnmpOid)v.elementAt(1)), (SnmpOid)oid);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpStatusException(224);
        }
        return oid;
    }

    public SnmpOid buildOidFromIndexVal(Integer aApplIndex, Integer aDsApplIfProtocolIndex) throws SnmpStatusException {
        SnmpOid oid = new SnmpOid();
        try {
            SnmpInt.appendToOid((SnmpOid)new SnmpInt(aApplIndex).toOid(), (SnmpOid)oid);
            SnmpInt.appendToOid((SnmpOid)new SnmpInt(aDsApplIfProtocolIndex).toOid(), (SnmpOid)oid);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpStatusException(224);
        }
        return oid;
    }

    public SnmpIndex buildSnmpIndex(long[] index, int start) throws SnmpStatusException {
        SnmpOid[] oids = new SnmpOid[2];
        int pos = start;
        oids[0] = SnmpInt.toOid((long[])index, (int)pos);
        pos = SnmpInt.nextOid((long[])index, (int)pos);
        oids[1] = SnmpInt.toOid((long[])index, (int)pos);
        return new SnmpIndex(oids);
    }

    public Object createDsApplIfOpsEntryMBean(SnmpMibSubRequest req, SnmpOid rowOid, int depth, ObjectName entryObjName, SnmpMibTable meta, Integer aApplIndex, Integer aDsApplIfProtocolIndex) throws SnmpStatusException {
        DsApplIfOpsEntry entry = new DsApplIfOpsEntry(this.theMib);
        entry.ApplIndex = aApplIndex;
        entry.DsApplIfProtocolIndex = aDsApplIfProtocolIndex;
        return entry;
    }
}

