/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads.util;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.opends.admin.ads.util.OpendsCertificateException;

public class ApplicationTrustManager
implements X509TrustManager {
    private static final Logger LOG = Logger.getLogger(ApplicationTrustManager.class.getName());
    private X509TrustManager sunJSSEX509TrustManager;
    private String lastRefusedAuthType;
    private X509Certificate[] lastRefusedChain;
    private Cause lastRefusedCause = null;
    private KeyStore keystore = null;
    private ArrayList<X509Certificate[]> acceptedChains = new ArrayList();
    private ArrayList<String> acceptedAuthTypes = new ArrayList();
    private ArrayList<String> acceptedHosts = new ArrayList();
    private String host;

    public ApplicationTrustManager(KeyStore keyStore) {
        TrustManagerFactory trustManagerFactory = null;
        String string = "SunX509";
        String string2 = "SunJSSE";
        this.keystore = keyStore;
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(string, string2);
            trustManagerFactory.init(keyStore);
            this.sunJSSEX509TrustManager = (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOG.log(Level.WARNING, "Error with the algorithm", noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            LOG.log(Level.WARNING, "Error with the provider", noSuchProviderException);
        }
        catch (KeyStoreException keyStoreException) {
            LOG.log(Level.WARNING, "Error with the keystore", keyStoreException);
        }
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        boolean bl = false;
        try {
            if (this.sunJSSEX509TrustManager != null) {
                try {
                    this.sunJSSEX509TrustManager.checkClientTrusted(x509CertificateArray, string);
                }
                catch (CertificateException certificateException) {
                    this.verifyAcceptedCertificates(x509CertificateArray, string);
                    bl = true;
                }
            } else {
                this.verifyAcceptedCertificates(x509CertificateArray, string);
                bl = true;
            }
        }
        catch (CertificateException certificateException) {
            this.lastRefusedChain = x509CertificateArray;
            this.lastRefusedAuthType = string;
            this.lastRefusedCause = Cause.NOT_TRUSTED;
            OpendsCertificateException opendsCertificateException = new OpendsCertificateException(x509CertificateArray);
            opendsCertificateException.initCause(certificateException);
            throw opendsCertificateException;
        }
        if (!bl) {
            try {
                this.verifyHostName(x509CertificateArray, string);
            }
            catch (CertificateException certificateException) {
                this.lastRefusedChain = x509CertificateArray;
                this.lastRefusedAuthType = string;
                this.lastRefusedCause = Cause.HOST_NAME_MISMATCH;
                OpendsCertificateException opendsCertificateException = new OpendsCertificateException(x509CertificateArray);
                opendsCertificateException.initCause(certificateException);
                throw opendsCertificateException;
            }
        }
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        boolean bl = false;
        try {
            if (this.sunJSSEX509TrustManager != null) {
                try {
                    this.sunJSSEX509TrustManager.checkServerTrusted(x509CertificateArray, string);
                }
                catch (CertificateException certificateException) {
                    this.verifyAcceptedCertificates(x509CertificateArray, string);
                    bl = true;
                }
            } else {
                this.verifyAcceptedCertificates(x509CertificateArray, string);
                bl = true;
            }
        }
        catch (CertificateException certificateException) {
            this.lastRefusedChain = x509CertificateArray;
            this.lastRefusedAuthType = string;
            this.lastRefusedCause = Cause.NOT_TRUSTED;
            OpendsCertificateException opendsCertificateException = new OpendsCertificateException(x509CertificateArray);
            opendsCertificateException.initCause(certificateException);
            throw opendsCertificateException;
        }
        if (!bl) {
            try {
                this.verifyHostName(x509CertificateArray, string);
            }
            catch (CertificateException certificateException) {
                this.lastRefusedChain = x509CertificateArray;
                this.lastRefusedAuthType = string;
                this.lastRefusedCause = Cause.HOST_NAME_MISMATCH;
                OpendsCertificateException opendsCertificateException = new OpendsCertificateException(x509CertificateArray);
                opendsCertificateException.initCause(certificateException);
                throw opendsCertificateException;
            }
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        if (this.sunJSSEX509TrustManager != null) {
            return this.sunJSSEX509TrustManager.getAcceptedIssuers();
        }
        return new X509Certificate[0];
    }

    public void acceptCertificate(X509Certificate[] x509CertificateArray, String string, String string2) {
        this.acceptedChains.add(x509CertificateArray);
        this.acceptedAuthTypes.add(string);
        this.acceptedHosts.add(string2);
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void resetLastRefusedItems() {
        this.lastRefusedAuthType = null;
        this.lastRefusedChain = null;
        this.lastRefusedCause = null;
    }

    public ApplicationTrustManager createCopy() {
        ApplicationTrustManager applicationTrustManager = new ApplicationTrustManager(this.keystore);
        applicationTrustManager.lastRefusedAuthType = this.lastRefusedAuthType;
        applicationTrustManager.lastRefusedChain = this.lastRefusedChain;
        applicationTrustManager.lastRefusedCause = this.lastRefusedCause;
        applicationTrustManager.acceptedChains.addAll(this.acceptedChains);
        applicationTrustManager.acceptedAuthTypes.addAll(this.acceptedAuthTypes);
        applicationTrustManager.acceptedHosts.addAll(this.acceptedHosts);
        applicationTrustManager.host = this.host;
        return applicationTrustManager;
    }

    private void verifyAcceptedCertificates(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        boolean bl = false;
        for (int i = 0; i < this.acceptedChains.size() && !bl; ++i) {
            if (!string.equals(this.acceptedAuthTypes.get(i))) continue;
            X509Certificate[] x509CertificateArray2 = this.acceptedChains.get(i);
            bl = x509CertificateArray2.length == x509CertificateArray.length;
            for (int j = 0; j < x509CertificateArray.length && bl; ++j) {
                bl = x509CertificateArray[j].equals(x509CertificateArray2[j]);
            }
        }
        if (!bl) {
            throw new OpendsCertificateException("Certificate not in list of accepted certificates", x509CertificateArray);
        }
    }

    private void verifyHostName(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        if (this.host != null) {
            boolean bl = false;
            try {
                LdapName ldapName = new LdapName(x509CertificateArray[0].getSubjectX500Principal().getName());
                Rdn rdn = ldapName.getRdn(ldapName.getRdns().size() - 1);
                String string2 = rdn.getValue().toString();
                bl = this.host.equalsIgnoreCase(string2);
                if (!bl) {
                    LOG.log(Level.WARNING, "Subject DN RDN value is: " + string2 + " and does not match host value: " + this.host);
                    for (int i = 0; i < this.acceptedHosts.size() && !bl; ++i) {
                        if (!this.host.equalsIgnoreCase(this.acceptedHosts.get(i))) continue;
                        X509Certificate[] x509CertificateArray2 = this.acceptedChains.get(i);
                        bl = x509CertificateArray2.length == x509CertificateArray.length;
                        for (int j = 0; j < x509CertificateArray.length && bl; ++j) {
                            bl = x509CertificateArray[j].equals(x509CertificateArray2[j]);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                LOG.log(Level.WARNING, "Error parsing subject dn: " + x509CertificateArray[0].getSubjectX500Principal(), throwable);
            }
            if (!bl) {
                throw new OpendsCertificateException("Hostname mismatch between host name " + this.host + " and subject DN: " + x509CertificateArray[0].getSubjectX500Principal(), x509CertificateArray);
            }
        }
    }

    public String getLastRefusedAuthType() {
        return this.lastRefusedAuthType;
    }

    public Cause getLastRefusedCause() {
        return this.lastRefusedCause;
    }

    public X509Certificate[] getLastRefusedChain() {
        return this.lastRefusedChain;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Cause {
        NOT_TRUSTED,
        HOST_NAME_MISMATCH;

    }
}

