/*
 * Decompiled with CFR 0.152.
 */
package org.opends.messages;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public enum Category {
    CORE(0),
    EXTENSIONS(0x100000),
    PROTOCOL(0x200000),
    CONFIG(0x300000),
    LOG(0x400000),
    UTIL(0x500000),
    SCHEMA(0x600000),
    PLUGIN(0x700000),
    JEB(0x800000),
    BACKEND(0x900000),
    TOOLS(0xA00000),
    TASK(0xB00000),
    ACCESS_CONTROL(0xC00000),
    ADMIN(0xD00000),
    SYNC(0xE00000),
    VERSION(0xF00000),
    QUICKSETUP(0x1000000),
    ADMIN_TOOL(0x1100000),
    DSCONFIG(0x1200000),
    RUNTIME_INFORMATION(0x1300000),
    SERVICETAG(0x1400000),
    THIRD_PARTY(Integer.MIN_VALUE),
    USER_DEFINED(-1048576);

    private static Map<Integer, Category> MASK_VALUE_MAP;
    private final int mask;

    public static Category parseMessageId(int msgId) {
        return Category.parseMask(msgId & 0xFFF00000);
    }

    public static Category parseMask(int mask) {
        return MASK_VALUE_MAP.get(mask);
    }

    public int getMask() {
        return this.mask;
    }

    private Category(int intValue) {
        this.mask = intValue;
    }

    static {
        MASK_VALUE_MAP = new HashMap<Integer, Category>();
        for (Category c : EnumSet.allOf(Category.class)) {
            MASK_VALUE_MAP.put(c.mask, c);
        }
    }
}

