/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.LinkedHashSet;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.opends.messages.Message;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.WizardStep;
import org.opends.quicksetup.ui.GuiApplication;
import org.opends.quicksetup.ui.QuickSetup;
import org.opends.quicksetup.ui.QuickSetupPanel;
import org.opends.quicksetup.ui.UIFactory;

public class StepsPanel
extends QuickSetupPanel {
    private static final long serialVersionUID = -2003945907121690657L;
    HashMap<WizardStep, JLabel> hmLabels = new HashMap();
    HashMap<WizardStep, JLabel> hmIcons = new HashMap();
    HashMap<WizardStep, JPanel> hmSubPanels = new HashMap();

    public StepsPanel(GuiApplication app) {
        super(app);
        this.createLayout(app);
    }

    public void setDisplayedStep(WizardStep step, UserData userData) {
        for (WizardStep wizardStep : this.getApplication().getWizardSteps()) {
            if (wizardStep.equals(step)) {
                this.getIcon(wizardStep).setVisible(true);
                UIFactory.setTextStyle(this.getLabel(wizardStep), UIFactory.TextStyle.CURRENT_STEP);
            } else {
                if (this.getIcon(wizardStep) != null) {
                    this.getIcon(wizardStep).setVisible(false);
                }
                if (this.getLabel(wizardStep) != null) {
                    UIFactory.setTextStyle(this.getLabel(wizardStep), UIFactory.TextStyle.NOT_CURRENT_STEP);
                }
            }
            this.setStepVisible(wizardStep, this.getApplication().isVisible(wizardStep, userData));
        }
    }

    public void updateStepVisibility(QuickSetup qs) {
        for (WizardStep wizardStep : this.getApplication().getWizardSteps()) {
            this.setStepVisible(wizardStep, this.getApplication().isVisible(wizardStep, qs));
        }
    }

    private void createLayout(GuiApplication app) {
        this.setLayout(new GridBagLayout());
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        HashMap<WizardStep, Message> hmText = new HashMap<WizardStep, Message>();
        LinkedHashSet<WizardStep> orderedSteps = app.getOrderedSteps();
        boolean first = true;
        for (WizardStep s : orderedSteps) {
            hmText.put(s, s.getDisplayMessage());
            JPanel subPanel = new JPanel(new GridBagLayout());
            subPanel.setOpaque(false);
            if (!first) {
                gbc.insets.top = 15;
            }
            GridBagConstraints gbcAux = new GridBagConstraints();
            gbcAux.gridwidth = 0;
            gbcAux.fill = 2;
            JPanel auxPanel = new JPanel(new GridBagLayout());
            auxPanel.setOpaque(false);
            JLabel iconLabel = UIFactory.makeJLabel(UIFactory.IconType.CURRENT_STEP, null, UIFactory.TextStyle.NO_STYLE);
            gbcAux.insets.left = 0;
            auxPanel.add((Component)iconLabel, gbcAux);
            int width = (int)iconLabel.getPreferredSize().getWidth();
            if (this.getApplication().isSubStep(s)) {
                width += 20;
            }
            gbcAux.insets.left = 0;
            auxPanel.add(Box.createHorizontalStrut(width), gbcAux);
            this.hmIcons.put(s, iconLabel);
            gbc.gridwidth = 3;
            gbc.weightx = 0.0;
            subPanel.add((Component)auxPanel, gbc);
            JLabel stepLabel = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, (Message)hmText.get(s), UIFactory.TextStyle.CURRENT_STEP);
            this.hmLabels.put(s, stepLabel);
            gbc.insets.left = 5;
            gbc.gridwidth = -1;
            subPanel.add((Component)stepLabel, gbc);
            gbc.insets = UIFactory.getEmptyInsets();
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            subPanel.add(Box.createHorizontalGlue(), gbc);
            mainPanel.add((Component)subPanel, gbc);
            this.hmSubPanels.put(s, subPanel);
            stepLabel.setLabelFor(this);
            iconLabel.setLabelFor(stepLabel);
            first = false;
        }
        gbc.insets.left = 0;
        gbc.insets.top = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        this.add((Component)mainPanel, gbc);
        int mainWidth = (int)mainPanel.getPreferredSize().getWidth();
        this.add(Box.createHorizontalStrut(mainWidth), gbc);
        gbc.fill = 3;
        gbc.weighty = 1.0;
        this.add(Box.createVerticalGlue(), gbc);
    }

    private JLabel getLabel(WizardStep step) {
        return this.hmLabels.get(step);
    }

    private JLabel getIcon(WizardStep step) {
        return this.hmIcons.get(step);
    }

    private JPanel getSubPanel(WizardStep step) {
        return this.hmSubPanels.get(step);
    }

    private void setStepVisible(WizardStep step, boolean visible) {
        JPanel subPanel = this.getSubPanel(step);
        if (visible != subPanel.isVisible()) {
            subPanel.setVisible(visible);
        }
    }
}

