/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads.util;

import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;

public class ApplicationKeyManager
implements X509KeyManager {
    private static final Logger LOG = Logger.getLogger(ApplicationKeyManager.class.getName());
    private X509KeyManager sunJSSEX509KeyManager = null;

    public ApplicationKeyManager(KeyStore keyStore, char[] cArray) {
        KeyManagerFactory keyManagerFactory = null;
        String string = "SunX509";
        String string2 = "SunJSSE";
        try {
            keyManagerFactory = KeyManagerFactory.getInstance(string, string2);
            keyManagerFactory.init(keyStore, cArray);
            KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
            for (int i = 0; i < keyManagerArray.length; ++i) {
                if (!(keyManagerArray[i] instanceof X509KeyManager)) continue;
                this.sunJSSEX509KeyManager = (X509KeyManager)keyManagerArray[i];
                break;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOG.log(Level.WARNING, "Error with the algorithm", noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            LOG.log(Level.WARNING, "Error with the provider", noSuchProviderException);
        }
        catch (KeyStoreException keyStoreException) {
            LOG.log(Level.WARNING, "Error with the keystore", keyStoreException);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            LOG.log(Level.WARNING, "Error with the key", unrecoverableKeyException);
        }
    }

    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        if (this.sunJSSEX509KeyManager != null) {
            return this.sunJSSEX509KeyManager.chooseClientAlias(stringArray, principalArray, socket);
        }
        return null;
    }

    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        if (this.sunJSSEX509KeyManager != null) {
            return this.sunJSSEX509KeyManager.chooseServerAlias(string, principalArray, socket);
        }
        return null;
    }

    public X509Certificate[] getCertificateChain(String string) {
        if (this.sunJSSEX509KeyManager != null) {
            return this.sunJSSEX509KeyManager.getCertificateChain(string);
        }
        return null;
    }

    public String[] getClientAliases(String string, Principal[] principalArray) {
        if (this.sunJSSEX509KeyManager != null) {
            return this.sunJSSEX509KeyManager.getClientAliases(string, principalArray);
        }
        return null;
    }

    public PrivateKey getPrivateKey(String string) {
        if (this.sunJSSEX509KeyManager != null) {
            return this.sunJSSEX509KeyManager.getPrivateKey(string);
        }
        return null;
    }

    public String[] getServerAliases(String string, Principal[] principalArray) {
        if (this.sunJSSEX509KeyManager != null) {
            return this.sunJSSEX509KeyManager.getServerAliases(string, principalArray);
        }
        return null;
    }
}

